<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
if (!isset($_SESSION['S_ID'])) {
    header('Location: ../index.php');
}
$id_usuario = $_SESSION['S_ID'];

include_once '../config/conexion_ip.php';

//$cedula =$_SESSION['S_USU']; almacena la cedula de la session,  borrar lo de abajo despues

$cedula = $_SESSION['S_USU'];

$conexion = new newonexionBD();
$pdo = $conexion->newconexionPDO();

if ($pdo) {
    $sql = "SELECT estudiante.NombresEstudiante, estudiante.ApellidoPaternoEstudiante, estudiante.ApellidoMaternoEstudiante, estudiante.TelefonoEstudiante, estudiante.CorreoEstudiante, estudiante.CedulaEstudiante, estudiante.DireccionEstudiante, carrera.NombreCarrera, carrera.SiglaCarrera, periodolectivo.DescripPeriodoLect FROM estudiante JOIN carrera ON estudiante.idcarrera = carrera.IdCarrera JOIN recorddetalle ON recorddetalle.IdEstudiante = estudiante.IdEstudiante JOIN recordcabecera ON recorddetalle.IdRecordCabecera = recordcabecera.IdRecordCabecera JOIN periodolectivo ON periodolectivo.IdPeriodoLectivo = recordcabecera.IdPeriodoLectivo WHERE estudiante.CedulaEstudiante = '".$cedula."' ORDER BY periodolectivo.DescripPeriodoLect desc LIMIT 1;";

    try {
        $query = $pdo->prepare($sql);
        $query->execute();

        $resultados = $query->fetch(PDO::FETCH_ASSOC);

        if ($resultados) {
            $nombre = isset($resultados['NombresEstudiante']) ? $resultados['NombresEstudiante'] : '[NO REGISTRA]';
            $apellidoPaterno = isset($resultados['ApellidoPaternoEstudiante']) ? $resultados['ApellidoPaternoEstudiante'] : '[NO REGISTRA]';
            $apellidoMaterno = isset($resultados['ApellidoMaternoEstudiante']) ? $resultados['ApellidoMaternoEstudiante'] : '[NO REGISTRA]';
            $celular = isset($resultados['TelefonoEstudiante']) ? $resultados['TelefonoEstudiante'] : '[NO REGISTRA]';
            $correo = isset($resultados['CorreoEstudiante']) ? $resultados['CorreoEstudiante'] : '[NO REGISTRA]';
            $cedula = isset($resultados['CedulaEstudiante']) ? $resultados['CedulaEstudiante'] : '[NO REGISTRA]';
            $direccion = isset($resultados['DireccionEstudiante']) ? $resultados['DireccionEstudiante'] : '[NO REGISTRA]';
            $carrera = isset($resultados['NombreCarrera']) ? $resultados['NombreCarrera'] : '[NO REGISTRA]';
           // $periodo = isset($resultados['DescripPeriodoLect']) ? $resultados['DescripPeriodoLect']:'[NO REGISTRA]';
            $nome = isset($resultados['SiglaCarrera']) ? $resultados['SiglaCarrera']:'[NO REGISTRA]';
        } else {
          
        }
        
        $sql2="SELECT DescripPeriodoLect from periodolectivo";
        $query2 = $pdo -> prepare($sql2);
        $query2 -> execute();
        
        $periodo = $query2->fetchall(PDO::FETCH_ASSOC);
        
       $lectivo = []; // Inicializar $lectivo como un arreglo vacío

if ($periodo) {
    foreach ($periodo as $fila) {
        // Agregar cada valor de DescripPeriodoLect al arreglo $lectivo
        $lectivo[] = $fila['DescripPeriodoLect'];
    }
}
    } catch (PDOException $e) {
        echo "Error al ejecutar la consulta: " . $e->getMessage();
    }
} else {
}

$conexion->cerrar_conexion();
?>
<style>
    #loading-screen {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(255, 255, 255, 0.8);
        /* Fondo blanco semi-transparente */
        z-index: 9999;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        border: 16px solid #f3f3f3;
        border-top: 16px solid #17285e;
        border-radius: 50%;
        width: 120px;
        height: 120px;
        animation: spin 2s linear infinite;
    }

    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }
</style>

<div id="loading-screen">
    <div class="spinner"></div>
</div>

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">REGISTRAR PRACTICA</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Inicio</a></li>
                    <li class="breadcrumb-item active">DOC.</li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>

<!-- Formulario -->
<div class="col-12">
    <div class="row">
        <div class="col-md-6">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title"><b>Datos del Estudiante</b></h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6">
                            <label for="">CEDULA</label>
                            <div class="input-group col-12">
                                <input type="text" class="form-control" id="txt_dni" maxlength="10" value="<?php echo $cedula;
                                                                                                            ?>" readonly>
                            </div>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">NOMBRE</label>
                            <input type="text" class="form-control" id="txt_nom" value="<?php echo $nombre??'[NO REGISTRA]'; ?>" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">APELLIDO PATERNO</label>
                            <input type="text" class="form-control" id="txt_apepat" value="<?php echo $apellidoPaterno??'[NO REGISTRA]'; ?>" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">APELLIDO MATERNO</label>
                            <input type="text" class="form-control" id="txt_apemat" value="<?php echo $apellidoMaterno??'[NO REGISTRA]'; ?>" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">CELULAR</label>
                            <input type="text" class="form-control" id="txt_celular" value="<?php echo $celular??'[NO REGISTRA]'; ?>" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">EMAIL</label>
                            <input type="text" class="form-control" id="txt_email" value="<?php echo $correo??'[NO REGISTRA]'; ?>" readonly>
                        </div>
                        <div class="col-6">
                            <label for="" style="font-size:small;">DIRECCIÓN</label>
                            <input type="text" class="form-control" id="txt_dire" value="<?php echo $direccion??'[NO REGISTRA]'; ?>" readonly>
                        </div>
                        <div class="col-6">
                            <label for="" style="font-size:small;">CARRERA</label>
                            <input type="text" class="form-control" id="txt_carrera" value="<?php echo $carrera??'[NO REGISTRA]'; ?>" readonly>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title"><b>Datos del Documento</b></h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">INSTITUCIÓN/EMPRESA RECEPTORA</label>
                            <input class="form-control" id="txt_nombre" style="width:100%" placeholder="Nombre de la Institución">
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">RESPONSABLE DE LA EMPRESA</label>
                            <input class="form-control" id="txt_responsable" style="width:100%" placeholder="Responsable">
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">CARGO</label>
                            <input class="form-control" id="txt_cargo" style="width:100%" placeholder="Cargo">
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">PERÍODO</label>
                            <select type="text" class="form-control" id="select_periodo">
                                <option value="" selected disabled>Seleccione el Periodo</option>
                                <?php 
                                foreach($lectivo as $per){
                                echo "<option value='$per'>$per</option>";
                                }
                                ?>
                            </select>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">FECHA INICIO</label>
                            <input id="txt_fInicio" class="form-control" type="date">
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">FECHA FINAL</label>
                            <input type="date" class="form-control" id="txt_fFinal">
                        </div>
                        <div class="col-4 form-group">
                            <label for="" style="font-size:small;">HORAS DE PRÁCTICAS A CUMPLIR</label>
                            <input type="text" class="form-control" id="txt_horas">
                        </div>
                        <div class="col-12"><br></div>
                        <div class="col-12" style="text-align:left">
                            <button class="btn btn-success btn-lg" id="btn_registro">INGRESAR SOLICITUD</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
     $('#loading-screen').hide();
    window.addEventListener('load', function() {
        document.getElementById('loading-screen').style.display = 'none';
    });

    // Forzar la desaparición de la pantalla de carga después de 5 segundos
    setTimeout(function() {
        document.getElementById('loading-screen').style.display = 'none';
    }, 3000);

    $(document).ready(function() {
        $('#btn_registro').on('click', function() {
            let cedula = $('#txt_dni').val();
            let nombree = $('#txt_nom').val();
            let apellido1 = $('#txt_apepat').val();
            let apellido2 = $('#txt_apemat').val();
            let telefono = $('#txt_celular').val();
            let correo = $('#txt_email').val();
            let nombre = $('#txt_nombre').val();
            let responsable = $('#txt_responsable').val();
            let cargo = $('#txt_cargo').val();
            let periodo = $('#select_periodo').val();
            let fechaInicio = $('#txt_fInicio').val();
            let fechaFinal = $('#txt_fFinal').val();
            let horas = $('#txt_horas').val();
            let idcarrera = $('#txt_carrera').val();
            let nome = <?php echo json_encode($nome); ?>;
            if (cedula === '' || nombre === '' || responsable === '' || cargo === '' || periodo === '' || fechaInicio === '' || fechaFinal === '' || horas === '' || idcarrera === '') {
                Swal.fire({
                    icon: 'warning',
                    title: 'Campos vacíos',
                    text: 'Por favor, complete todos los campos',
                    confirmButtonText: 'Aceptar'
                });
            } else {
                console.log('Datos a enviar:', {
                    cedula: cedula,
                    nombree: nombree,
                    apellido1: apellido1,
                    apellido2: apellido2,
                    telefono: telefono,
                    correo: correo,
                    nombre: nombre,
                    responsable: responsable,
                    cargo: cargo,
                    periodo: periodo,
                    fechaInicio: fechaInicio,
                    fechaFinal: fechaFinal,
                    horas: horas,
                    idcarrera: idcarrera,
                    nome: nome
                });

                $.ajax({
                    url: 'ingreso/registro_practica.php',
                    type: 'POST',
                    data: {
                        cedula: cedula,
                        nombree: nombree,
                        apellido1: apellido1,
                        apellido2: apellido2,
                        telefono: telefono,
                        correo: correo,
                        nombre: nombre,
                        responsable: responsable,
                        cargo: cargo,
                        periodo: periodo,
                        fechaInicio: fechaInicio,
                        fechaFinal: fechaFinal,
                        horas: horas,
                        idcarrera: idcarrera,
                        nome: nome
                    },
                    success: function(response) {
                        var data = JSON.parse(response);
                        if (data.status === 'success') {
                            Swal.fire({
                                icon: 'success',
                                title: '¡Éxito!',
                                text: data.message,
                                confirmButtonText: 'Aceptar'
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: data.message,
                                confirmButtonText: 'Aceptar'
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Error al ingresar la solicitud',
                            confirmButtonText: 'Aceptar'
                        });
                    }
                });

            }
        });
    });
</script>