<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['S_ID'])) {
    header('Location: ../index.php');
}

$id_usuario = $_SESSION['S_ID'];
include_once '../../model/model_conexion.php';

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

$solicitudes = [];

if ($pdo) {
    $sql = "SELECT cedulaEstudiante, Carrera, Periodo, fInicio, fFin, horas, estado FROM solicitud";
    
    try {
        $query = $pdo->prepare($sql);
        $query->execute();
        $resultados = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($resultados) {
            foreach ($resultados as $row) {
                $solicitudes[] = [
                    'cedulaEstudiante' => $row['cedulaEstudiante'] ?? 'NO REGISTRA',
                    'Carrera' => $row['Carrera'] ?? 'NO REGISTRA',
                    'Periodo' => $row['Periodo'] ?? 'NO REGISTRA',
                    'fInicio' => $row['fInicio'] ?? 'NO REGISTRA',
                    'fFin' => $row['fFin'] ?? 'NO REGISTRA',
                    'horas' => $row['horas'] ?? 'NO REGISTRA',
                    'estado' => $row['estado'] ?? 'NO REGISTRA',
                    'accion' => "<a href='#' class='btn btn-primary btn-sm' data-bs-toggle='modal' data-bs-target='#modalEditarEstado' onclick='editarEstado(\"" . $row['cedulaEstudiante'] . "\")'><i class='fas fa-pencil-square-o' aria-hidden='true'></i> Cambiar Estado</a>"
                ];
            }
        }
    } catch (PDOException $e) {
        error_log("Error al ejecutar la consulta: " . $e->getMessage());
    }
} else {
    echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>

<!-- Incluir los recursos necesarios para Bootstrap y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css"/>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>

<style>
  tbody {
    text-align: center;
    align-items: center;
  }
</style>

<!-- Cabecera -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0">LISTA DE SOLICITUDES DE PRACTICAS</h1>
      </div>
    </div>
  </div>
</div>

<!-- Main content -->
<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">
            <div class="col-12 table-responsive">
              <table id="tabla_tramites" class="display" style="width:100%">
                <thead>
                  <tr>
                      <th class="text-center">Cedula Estudiante</th>
                      <th class="text-center">Carrera</th>
                      <th class="text-center">Periodo</th>
                      <th class="text-center">Fecha Inicio</th>
                      <th class="text-center">Fecha Fin</th>
                      <th class="text-center">Horas</th>
                      <th class="text-center">Estado</th>
                      <th class="text-center">Accion</th>
                  </tr>
                </thead>
                <tbody>
                    <?php foreach ($solicitudes as $solicitud): ?>
                        <tr>
                            <td><?php echo $solicitud['cedulaEstudiante']; ?></td>
                            <td><?php echo $solicitud['Carrera']; ?></td>
                            <td><?php echo $solicitud['Periodo']; ?></td>
                            <td><?php echo $solicitud['fInicio']; ?></td>
                            <td><?php echo $solicitud['fFin']; ?></td>
                            <td><?php echo $solicitud['horas']; ?></td>
                            <td><?php echo $solicitud['estado']; ?></td>
                            <td><?php echo $solicitud['accion']; ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal de Edición con Bootstrap -->
<div class="modal fade" id="modalEditarEstado" tabindex="-1" aria-labelledby="modalEditarEstadoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalEditarEstadoLabel">Cambiar Estado del Trámite</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="formEditarEstado">
          <div class="mb-3">
            <label for="estado" class="form-label">Estado del Trámite</label>
            <select class="form-control" id="estado" name="estado">
              <option value="NO REGISTRA">No Registra</option>
              <option value="PENDIENTE">Pendiente</option>
              <option value="APROBADO">Aprobado</option>
              <option value="EN PROCESO">En Proceso</option>
            </select>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" id="guardarBtn" onclick="guardarEstado()">Guardar</button>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function() {
    // Inicializar la tabla DataTable
    $('#tabla_tramites').DataTable();
  });

  // Función para abrir el modal de edición
  function editarEstado(cedulaEstudiante) {
    console.log("Editando estado para el estudiante con cédula: " + cedulaEstudiante);
    // Aquí puedes cargar el estado actual del estudiante si lo deseas.
    // Se abrirá el modal automáticamente gracias a Bootstrap.
  }

  // Función para guardar el estado
  function guardarEstado() {
    var estado = document.getElementById("estado").value;
    M.toast({html: 'Estado actualizado a: ' + estado, classes: 'green'}); 
    // Aquí puedes agregar la lógica para guardar el estado en la base de datos si es necesario.
    // Cerrar el modal después de guardar.
    var modal = bootstrap.Modal.getInstance(document.getElementById('modalEditarEstado'));
    modal.hide();
  }
</script>
