<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
if (!isset($_SESSION['S_ID'])) {
    header('Location: ../index.php');
}

// $cedula = $_SESSION['S_USU'];

$cedula =  $_SESSION['S_USU'];
?>
<script src="../js/console_tramite.js?rev=<?php echo time(); ?>"></script>
<link rel="stylesheet" href="../plantilla/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<?php
// Initialize variables

include_once '../../model/model_conexion.php';

$nempresa = '';
$rempresa = '';
$cempresa = '';

// Create a connection to the database
$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

if ($pdo) {
    // Prepare the SQL query
    $sql = "SELECT so.cedulaEstudiante, pe.nEmpresa, pe.responsable, pe.cargo_empresa 
            FROM solicitud AS so 
            JOIN prac_empresa AS pe ON so.cedulaEstudiante = pe.cedulaEstudiante 
            WHERE so.estado = 'PENDIENTE' AND pe.estado= 'PENDIENTE' AND so.cedulaEstudiante = :cedula";

    try {
        // Prepare the query
        $query = $pdo->prepare($sql);

        // Bind the parameter
        $query->bindParam(':cedula', $cedula);

        // Execute the query
        $query->execute();

        // Fetch the results
        $resultados = $query->fetch(PDO::FETCH_ASSOC);

        if ($resultados) {
            // Assign the values to the variables
            $cedula = isset($resultados['cedulaEstudiante']) ? $resultados['cedulaEstudiante'] : '';
            $nempresa = isset($resultados['nEmpresa']) ? $resultados['nEmpresa'] : '';
            $rempresa = isset($resultados['responsable']) ? $resultados['responsable'] : '';
            $cempresa = isset($resultados['cargo_empresa']) ? $resultados['cargo_empresa'] : '';
        } else {
            // Display an error message if no results are found
            echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>";
            echo "<script>
                Swal.fire({
                    icon: 'error',
                    title: '¡Error!',
                    text: 'Debe ingresar una solicitud de inicio de practicas para llenar los datos de la Institucion Receptora',
                });
            </script>";
        }
    } catch (PDOException $e) {
        // Display an error message if the query fails
        echo "Error al ejecutar la consulta: " . $e->getMessage();
    }
} else {
    // Display an error message if the connection fails
    echo "No se pudo conectar a la base de datos.";
}

// Close the connection
$conexion->cerrar_conexion();
?>

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">REGISTRAR INSTITUCION</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Inicio</a></li>
                    <li class="breadcrumb-item active">DOC.</li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<?php
include_once '../../model/model_conexion.php';

$nempresa='';
$rempresa='';
$cempresa='';

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

if ($pdo) {
    $sql = "SELECT so.cedulaEstudiante, pe.nEmpresa, pe.responsable, pe.cargo_empresa FROM solicitud AS so JOIN prac_empresa AS pe ON so.cedulaEstudiante = pe.cedulaEstudiante WHERE so.estado = 'PENDIENTE' AND pe.estado= 'PENDIENTE' AND so.cedulaEstudiante = '".$cedula."'";

    try {
        $query = $pdo->prepare($sql);
        $query->execute();

        $resultados = $query->fetch(PDO::FETCH_ASSOC);

        if ($resultados) {
            $cedula = isset($resultados['cedulaEstudiante']) ? $resultados['cedulaEstudiante'] : '';
            $nempresa = isset($resultados['nEmpresa']) ? $resultados['nEmpresa'] : '';
            $rempresa = isset($resultados['responsable']) ? $resultados['responsable'] : '';
            $cempresa = isset($resultados['cargo_empresa']) ? $resultados['cargo_empresa'] : '';
        } else {
            echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>";
            echo "<script>
                Swal.fire({
                    icon: 'error',
                    title: '¡Error!',
                    text: 'Debe ingresar una solicitud de inicio de practicas para llenar los datos de la Institucion Receptora',
                });
            </script>";
        }
    } catch (PDOException $e) {
        echo "Error al ejecutar la consulta: " . $e->getMessage();
    }
} else {
    echo "No se pudo conectar a la base de datos.";
}

$conexion->cerrar_conexion();
?>
<div class="col-12">
    <div class="row">
        <div class="col-md-6">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title"><b>Datos del Estudiante y la Institución Receptora</b></h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6">
                            <label for="">CI ESTUDIANTE</label>
                            <div class="input-group col-12">
                                <input type="text" class="form-control" id="txt_dni" maxlength="10" value="<?php echo $cedula;  ?>" readonly>
                                <!--  <div class="input-group-prepend">
                                <button type="button" class="btn btn-success" onclick="Buscar_reniec()"><i class="fa fa-search"></i></button>
                                </div>
                             ((/btn-group -->

                            </div>
                        </div>

                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">NOMBRE DE LA EMPRESA</label>
                            <input type="text" class="form-control" id="txt_nome" value="<?php echo $nempresa;  ?>" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">RESPONSABLE DE LA EMPRESA</label>
                            <input type="text" class="form-control" id="txt_respe" value="<?php echo $rempresa;  ?>" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">CARGO</label>
                            <input type="text" class="form-control" id="txt_cargoe" value="<?php echo $cempresa  ?>" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">RUC</label>
                            <input type="text" class="form-control" id="txt_ruce" value="" maxlength="13" placeholder="ruc">
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">TELEFONO</label>
                            <input type="text" class="form-control" id="txt_telefonoe" value="" maxlength="10" placeholder="telefono">
                        </div>
                        <div class="col-6">
                            <label for="" style="font-size:small;">DIRECCIÓN</label>
                            <input type="text" class="form-control" id="txt_dire" value="" placeholder="Dirección">
                        </div>
                        <div class="col-6">
                            <label for="" style="font-size:small;">CANTON/CIUDAD</label>
                            <input type="text" class="form-control" id="txt_can" value="" placeholder="Canton/Ciudad">
                        </div>
                        <div class="col-6">
                            <label for="" style="font-size:small;">CORREO</label>
                            <input type="email" class="form-control" id="txt_correoe" value="" placeholder="Correo">
                        </div>
                        
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <div class="col-md-6">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title"><b>Información referente a la Institución</h3><b>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">INSTITUCIÓN</label>
                            <select class="form-control" id="txt_emp" style="width:100%">
                                <option value="" selected disabled>Seleccione</option>
                                <option value="EMPRESA">EMPRESA</option>
                                <option value="MICROEMPRESA">MICROEMPRESA</option>
                                <option value="EMPRENDIMIENTO">EMPRENDIMIENTO</option>
                                <option value="ONG">ONG</option>
                            </select>
                        </div>
                         <div class="col-6 form-group">
                            <label for="" style="font-size:small;">TIPO DE INSTITUCIÓN</label>
                            <select class="form-control" id="txt_tipoemp" style="width:100%">
                                <option value="" selected disabled>Seleccione</option>
                                <option value="PÚBLICA">PÚBLICA</option>
                                <option value="PRIVADA">PRIVADA</option>
                            </select>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">ACTIVIDAD</label>
                            <select class="form-control" id="txt_act" style="width:100%">
                                <option value="" selected disabled>Seleccione</option>
                                <option value="SERVICIOS">SERVICIOS</option>
                                <option value="PRODUCCION">PRODUCCIÓN</option>
                                <option value="COMERCIALIZACION">COMERCIALIZACIÓN</option>
                                <option value="SALUD">SALUD</option>
                                <option value="EDUCACIÓN">EDUCACIÓN</option>
                            </select>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">DESCRIPCIÓN DE LA ACTIVIDAD ECONÓMICA</label>
                            <input class="form-control" id="txt_dedica" style="width:100%" placeholder="Responsable">
                        </div>

                        <div class="col-12 form-group">
                            <label for="" style="font-size:small;">AREAS DONDE SE REALIZARAN LAS PRACTICAS</label>
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Administrativo – financiero</th>
                                            <th class="text-center">Talento Humano</th>
                                            <th class="text-center">Producción</th>
                                            <th class="text-center">Mantenimiento</th>
                                            <th class="text-center">TIC</th>
                                            <th class="text-center">Atención al cliente</th>
                                             <th class="text-center">Servicios Especificos</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">
                                                <input name="areas[]" id="area1" value="ADMINISTRATIVO" type="checkbox">
                                            </td>
                                            <td class="text-center">
                                                <input name="areas[]" id="area2" value="TALENTO HUMANO" type="checkbox">
                                            </td>
                                            <td class="text-center">
                                                <input name="areas[]" id="area3" value="PRODUCCION" type="checkbox">
                                            </td>
                                            <td class="text-center">
                                                <input name="areas[]" id="area4" value="MANTENIMIENTO" type="checkbox">
                                            </td>
                                            <td class="text-center">
                                                <input name="areas[]" id="area5" value="TIC" type="checkbox">
                                            </td>
                                            <td class="text-center">
                                                <input name="areas[]" id="area6" value="ATENCION AL CLIENTE" type="checkbox">
                                            </td>
                                            <td class="text-center">
                                                <input name="areas[]" class="form-control" id="area7"  type="text">
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                       <div class="col-6 form-group">
    <label for="" style="font-size:small;">REQUIERE INDUMENTARIA O INSUMOS:</label>
    <select class="form-control" id="txt_ins" style="width:100%" onchange="controlarSelect()">
        <option value="" selected disabled>Seleccione</option>
        <option value="SI">SI</option>
        <option value="NO">NO</option>
    </select>
</div>

<div class="col-6 form-group" id="proveeContainer" style="display:none;">
    <label for="" style="font-size:small;">QUIEN PROVEE:</label>
    <select class="form-control" id="txt_provee" style="width:100%">
        <option value="" selected disabled>Seleccione</option>
        <option value="INSTITUCION">INSTITUCION</option>
        <option value="ESTUDIANTE">ESTUDIANTE</option>
    </select>
</div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">EXPERIENCIA COMO ENTIDAD FORMADORA</label>
                            <select class="form-control" id="txt_exp" style="width:100%">
                                <option value="" selected disabled>Seleccione</option>
                                <option value="SI">SI</option>
                                <option value="NO">NO</option>
                            </select>
                        </div>

                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">NECESIDAD DE PRACTICANTES(NUMERO)</label>
                            <input type="number" id="txt_nece" class="form-control" style="width:100%">
                        </div>
                        <div class="col-12 form-group">
                            <label for="" style="font-size:small;">OBSERVACIONES (opcional)</label>
                            <textarea class="form-control" id="txt_obs" style="width:100%"></textarea>
                        </div>
                        <div class="col-12"><br>
                        </div>
                        <div class="col-12" style="text-align:left">
                            <button class="btn  btn-success  btn-lg" onclick="Registrar_Tramite()" id="btn_registro">REGISTRAR DATOS</button>
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
   window.addEventListener('load', function () {
    document.getElementById('loading-screen').style.display = 'none';
});

function validarRUC(ruc) {
    // Verificar que el RUC tenga exactamente 13 dígitos
    return ruc.length === 13 && /^\d+$/.test(ruc);
}

function controlarSelect() {
    var ins = document.getElementById("txt_ins").value;
    var proveeContainer = document.getElementById("proveeContainer");
    var proveeSelect = document.getElementById("txt_provee");
    if (ins === "SI") {
        proveeContainer.style.display = "block";  
        localStorage.setItem("requiereInsumos", "SI");
    } else {
        proveeContainer.style.display = "none";  
        proveeSelect.value = "";  
        localStorage.setItem("requiereInsumos", "NO");
    }
}

document.getElementById("txt_ins").addEventListener("change", controlarSelect);

$(document).ready(function () {
    const checkboxes = document.querySelectorAll('input[type="checkbox"]');
    const textInput = document.getElementById('area7');

    // Manejo del cuadro de texto y checkboxes
    textInput.addEventListener('input', function () {
        if (textInput.value.trim() !== '') {
            checkboxes.forEach(checkbox => {
                checkbox.checked = false;
            });
        }
    });

    checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', function () {
            if (checkbox.checked) {
                textInput.value = '';
            }
        });
    });

    // Validación del RUC
    $('#txt_ruce').on('input', function () {
        const ruc = $(this).val();
        $(this).css('border-color', validarRUC(ruc) ? 'green' : 'red');
    });

    // Manejo del botón de registro
    $('#btn_registro').on('click', function () {
        const campos = {
            cedula: $('#txt_dni').val(),
            ruc: $('#txt_ruce').val(),
            telefono: $('#txt_telefonoe').val(),
            direccion: $('#txt_dire').val(),
            correo: $('#txt_correoe').val(),
            emp: $('#txt_emp').val(),
            tipoemp: $('#txt_tipoemp').val(),
            actividad: $('#txt_act').val(),
            dedica: $('#txt_dedica').val(),
            canton: $('#txt_can').val(),
            areas: $('input[name="areas[]"]:checked').length > 0 
                ? $('input[name="areas[]"]:checked').map(function () {
                    return $(this).val();
                }).get() 
                : [textInput.value.trim()], // Si no hay checkboxes seleccionados, usa el valor del cuadro de texto
            ins: $('#txt_ins').val(),
            provee: $('#txt_provee').val() || 'no', // Si no hay valor, se almacena como "ninguno"
            exp: $('#txt_exp').val(),
            necesidades: $('#txt_nece').val(),
            obs: $('#txt_obs').val() || 'ninguna' // Si no hay valor, se almacena como "ninguna"
        };

        // Validación del RUC
        if (!validarRUC(campos.ruc)) {
            Swal.fire({
                icon: 'error',
                title: 'RUC inválido',
                text: 'Por favor, ingrese un RUC válido',
                confirmButtonText: 'Aceptar'
            });
            return false;
        }

        // Validación de campos vacíos (excluyendo obs)
        const camposVacios = Object.entries(campos)
            .filter(([key, value]) => (key !== 'obs' && !value) || (Array.isArray(value) && value.length === 0))
            .map(([key]) => key.replace(/([A-Z])/g, ' $1').toUpperCase());

        if (camposVacios.length > 0) {
            Swal.fire({
                icon: 'warning',
                title: 'Campos vacíos',
                text: 'Por favor, complete los siguientes campos: ' + camposVacios.join(', '),
                confirmButtonText: 'Aceptar'
            });
            return false;
        }

        console.log(campos);
        $.ajax({
            url: 'ingreso/registro_practica_inst.php',
            type: 'POST',
            data: campos,
            success: function (response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Datos enviados',
                    text: 'La información se ha enviado correctamente',
                    confirmButtonText: 'Aceptar'
                });
            },
            error: function (error) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Hubo un problema al enviar la información',
                    confirmButtonText: 'Aceptar'
                });
                console.error('Error en la solicitud AJAX:', error);
            }
        });
    });
});
</script>