<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Verificar si hay sesión
if (!isset($_SESSION['S_ID'])) {
  header('Location: ../index.php');
  exit();
}

$id_usuario = $_SESSION['S_ID'];

// Conexión a la base de datos
include_once '../../model/model_conexion.php';
$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

if ($pdo) {
  $cedulaEstudiante = $_SESSION['S_USU'];  // Aquí debes cambiar la cédula según sea necesario

  // Codificar la cédula para encriptarla y pasarla por URL
  $cedulaEncriptada = base64_encode($cedulaEstudiante);

  // Consulta SQL para obtener los datos
  $sql = "SELECT estudiante_id, idsol, cedula_estudiante, cedula_tutor, fecha, visita FROM eval_docente";

  try {
    // Preparar y ejecutar la consulta
    $query = $pdo->prepare($sql);
     
    $query->execute();

    $resultados = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resultados) {
      // Pasar los datos directamente al frontend a través de JSON
      $solicitudes = [];
      $contador=1;
      foreach ($resultados as $row) {
        $solicitudes[] = [
          'id' => $contador,
          'cedula' => $row['cedula_estudiante'] ?? 'NO REGISTRA',
          'tutor' => $row['cedula_tutor'] ?? 'NO REGISTRA',
          'fecha' => $row['visita'] ?? 'NO REGISTRA',
          'accion' => "<a href='pdf/ficha_docente.php?id=".$row['idsol']."&ideval=".$row['estudiante_id']."' class='btn btn-primary btn-sm' target='_blank'><i class='fa fa-print' aria-hidden='true'></i></a>"
        ];
        $contador++;
      }

      // Aquí enviamos los datos a JavaScript para su uso en la tabla
      echo "<script>
                    var solicitudes = " . json_encode($solicitudes) . ";
                    cargarTabla(solicitudes);
                </script>";
    } else {
      // Si no se encuentran resultados, se pasa un array vacío
      echo "<script>
                    var solicitudes = [];
                    cargarTabla(solicitudes);
                </script>";
    }
  } catch (PDOException $e) {
    error_log("Error al ejecutar la consulta: " . $e->getMessage());
    echo "<script>console.error('Hubo un problema con la consulta.');</script>";
  }
} else {
  echo "<script>console.error('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>


 <link rel="stylesheet" href="../plantilla/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<style>
  tbody {
    text-align: center;
    align-items: center;
  }
  #loading-screen {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(255, 255, 255, 0.8); /* Fondo blanco semi-transparente */
        z-index: 9999;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        border: 16px solid #f3f3f3;
        border-top: 16px solid #17285e;
        border-radius: 50%;
        width: 120px;
        height: 120px;
        animation: spin 2s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
</style>
<div id="loading-screen">
    <div class="spinner"></div>
</div>
  <!-- Encabezado de la página -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">FICHAS DOCENTES</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#">Inicio</a></li>
            <li class="breadcrumb-item active">DOC.</li>
          </ol>
        </div>
      </div>
    </div>
  </div>

  <!-- Contenido Principal -->
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-12">
          <div class="card">
            <div class="card-body">
              <div class="col-12 table-responsive">
                <table id="tabla_tramites" class="display" style="width:100%">
                  <thead>
                    <tr>
                    <th class="text-center">Nº</th>
                      <th class="text-center">Cedula Estudiante</th>
                      <th class="text-center">Cedula Tutor</th>
                      <th class="text-center">Fecha</th>
                      <th class="text-center">Accion</th>
                    </tr>
                  </thead>
                  <tbody>
                    <!-- Los datos se cargarán aquí mediante JavaScript -->
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Script para manejar la tabla -->
  <script>
function eliminarSolicitud(id) {
    // Confirmación antes de eliminar
    if (!confirm('¿Estás seguro de eliminar este registro?')) {
        return; // Si el usuario cancela, no hace nada
    }

    // Usar fetch para llamar al PHP sin recargar la página
    fetch('ingreso/eliminar_solicitud.php?id='+ id)
        .then(response => response.json())  // Convertir la respuesta a JSON
        .then(data => {
            if (data.success) {
                // Mostrar un mensaje de éxito
                alert(data.message);

                // Recargar la sección específica sin recargar toda la página
                cargarSeccion();
            } else {
                // Mostrar un mensaje de error
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error al eliminar el registro:', error);
            alert('Ocurrió un error al intentar eliminar el registro.');
        });
}


function cargarSeccion() {
    // Mostrar el spinner mientras se está cargando
    $('#loading-screen').show();

    // Realiza una solicitud para obtener la sección nuevamente (por ejemplo, la tabla o contenido actualizado)
    fetch('index.php')
        .then(response => response.text())  // Obtener el contenido HTML
        .then(html => {
            // Aquí reemplazas el contenido de la sección específica con la nueva información
            document.getElementById('contenido_principal').innerHTML = html;
            
            // Después de actualizar la sección, recargar toda la página
            location.reload();  // Recargar toda la página
        })
        .catch(error => {
            console.error('Error al recargar la sección:', error);
            alert('Ocurrió un error al cargar los datos');
            $('#loading-screen').hide();  // Ocultar el spinner en caso de error
        });
}



   $(document).ready(function() {
  // Aseguramos que solo cargamos los datos cuando PHP nos los pasa correctamente
  <?php if ($resultados): ?>
    var solicitudes = <?php echo json_encode($solicitudes); ?>;
    if (solicitudes.length > 0) {
        $('#tabla_tramites').DataTable({
            data: solicitudes,
            destroy: true,
            columns: [
                { data: 'id' },
                { data: 'cedula' },
                { data: 'tutor' },
                { data: 'fecha' },
                { data: 'accion' }
            ],
            paging: true,
            searching: true,
            ordering: true,
            info: true,
            responsive: true,
            // Esta opción asegura que la tabla se redibuje correctamente
            initComplete: function() {
                document.getElementById('loading-screen').style.display = 'none'; // Ocultar la pantalla de carga después de cargar los datos
                $('#loading-screen').hide();
            }
        });
    } else {
        $('#tabla_tramites').DataTable().clear().draw(); // Limpiar la tabla si no hay resultados
        document.getElementById('loading-screen').style.display = 'none'; // Asegurarse de ocultar la pantalla de carga
        $('#loading-screen').hide();
    }
  <?php else: ?>
    // Si no hay resultados, limpiamos la tabla
    $('#tabla_tramites').DataTable().clear().draw();
    document.getElementById('loading-screen').style.display = 'none'; // Ocultar la pantalla de carga si no hay datos
    $('#loading-screen').hide();
  <?php endif; ?>
});

  </script>