<?php
ob_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require('pdf/fpdf.php');
require('pdf/font/FreeSans.php');
header('Content-Type: text/html; charset=utf-8');


include_once '../../model/model_conexion.php';

//}

// $conexion2->cerrar_conexion();

// $conexion->cerrar_conexion();

class PDF extends FPDF
{
    // Encabezado
    function Header()
    {
        // Imagen a la izquierda
        $this->Image('img/fondo.png', 1, 1, 295, 205); // Ruta de la imagen
        // Ajustar la posición X para el texto
        $this->SetX(10); // Cambia el valor según sea necesario para alinear el texto

        // Imagen a la derecha (ajusta la posición según necesites)
        // $this->Image('../img/header.png', 160, 10, 40); // Ruta de la imagen

        $text2 = 'DETALLE SEMANAL DE ACTIVIDADES DE PRÁCTICAS PREPROFESIONALES';
        $this->AddFont('FreeSans', '', 'FreeSans.php'); // Añade la fuente
        $this->SetFont('FreeSans', '', 12); // Usa la fuente
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(20); // Volver a establecer Y para el texto
        $this->Cell(260, 6, (mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8')), 0, 1, 'C'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);
    }

    // Cuerpo
    function Body()
    {
        $this->SetLeftMargin(20);
        $this->SetFont('FreeSans', '', 12);
        $this->SetY(40);

        $conexion1 = new conexionBD();
        $pdo1 = $conexion1->conexionPDO();
        $pdosemana1 = $conexion1->conexionPDO();
        $pdosemana2 = $conexion1->conexionPDO();
        $pdosemana3 = $conexion1->conexionPDO();
        $pdosemana4 = $conexion1->conexionPDO();

        $resultados1 = [];
        $resultados2 = [];


        if (isset($_GET['cedula'])) {
        $cedula = $_GET['cedula']?:'0';
        $entidadreceptora = '';
        $tutoracademico = '';
        $responsable = '';
        $cargotutor = '';

        if ($pdo1) {
            $sql1 = "SELECT ast.nombre_estudiante, ast.CedulaEstudiante, ast.nombre_tutor, ast.correo_estudiante, ast.promo, ast.Carrera, ast.per_acad_estudiante, pe.cargo_empresa, pe.nEmpresa, pe.ciudad_canton_empresa, pe.direccion_empresa, pe.responsable, pe.telefono_empresa FROM asig_tutor ast join prac_empresa pe on pe.cedulaEstudiante=ast.CedulaEstudiante where pe.estado='APROBADO' AND ast.CedulaEstudiante=:cedula ORDER BY per_acad_estudiante ASC LIMIT 1;
";
            try {
                $query1 = $pdo1->prepare($sql1);
                $query1->bindParam(':cedula', $cedula, PDO::PARAM_STR);
                $query1->execute();
                $resultados1 = $query1->fetchAll(PDO::FETCH_ASSOC);
            } catch (PDOException $e) {
                echo "Error al ejecutar la primera consulta: " . $e->getMessage();
            }
        }

        $this->Cell(250, 8, 'Datos del estudiante', 1, 1, 'C');
        $this->SetFont('FreeSans', '', 10);
        if (!empty($resultados1)) {
            foreach ($resultados1 as $estudiante) {
                $this->Cell(125, 8, 'Nombre y Apellidos: ', 1, 0, 'L');
                $this->Cell(125, 8, $estudiante['nombre_estudiante'] ?: 'N/A', 1, 1, 'C');
                $this->Cell(125, 8, 'Cedula: ', 1, 0, 'L');
                $this->Cell(125, 8, $estudiante['CedulaEstudiante'] ?: 'N/A', 1, 1, 'C');
                $this->Cell(125, 8, 'Correo: ', 1, 0, 'L');
                $this->Cell(125, 8, $estudiante['correo_estudiante'] ?: 'N/A', 1, 1, 'C');
                $this->Cell(125, 8, 'Carrera: ', 1, 0, 'L');
                $this->Cell(125, 8, mb_convert_encoding($estudiante['Carrera'] ?: 'N/A', 'ISO-8859-1', 'UTF-8'), 1, 1, 'C');
                $this->Cell(125, 8, 'Semestre: ', 1, 0, 'L');
                $this->Cell(125, 8, $estudiante['per_acad_estudiante'] ?: 'N/A', 1, 1, 'C');
                $this->Cell(125, 8, 'Promocion: ', 1, 0, 'L');
                $this->Cell(125, 8, $estudiante['promo'] ?: 'N/A', 1, 1, 'C');
            }
        } else {
            $this->Cell(125, 8, 'No data', 1, 0, 'C');
            $this->Cell(125, 8, 'No data', 1, 1, 'C');
        }

        $this->SetFont('FreeSans', '', 12);
        $this->Cell(250, 8, 'Datos de la entidad receptora', 1, 1, 'C');
        if (!empty($resultados1)) {
            foreach ($resultados1 as $empresa) {

                $entidadreceptora = mb_convert_encoding(isset($empresa['cargo_empresa']) ? $empresa['cargo_empresa'] : 'No Registra', 'ISO-8859-1', 'UTF-8');
                $responsable = mb_convert_encoding(isset($empresa['responsable']) ? $empresa['responsable'] : 'No Registra', 'ISO-8859-1', 'UTF-8');
                $tutoracademico = mb_convert_encoding(isset($empresa['nombre_tutor']) ? $empresa['nombre_tutor'] : 'No Registra', 'ISO-8859-1', 'UTF-8');
                $cargotutor = 'TUTOR ACADEMICO';

                $this->SetFont('FreeSans', '', 10);
                $this->Cell(125, 8, 'Nombre de la entidad receptora: ', 1, 0, 'L');
                $this->Cell(125, 8, $entidadreceptora, 1, 1, 'C');
                $ciudad = 'Ciudad/Cantón: ';
                $this->Cell(125, 8, (mb_convert_encoding($ciudad, 'ISO-8859-1', 'UTF-8')), 1, 0, 'L');
                $this->Cell(125, 8, isset($empresa['ciudad_canton_empresa']) ? $empresa['ciudad_canton_empresa'] : 'N/A', 1, 1, 'C');
                $direccion = 'Dirección: ';
                $this->Cell(125, 8, (mb_convert_encoding($direccion, 'ISO-8859-1', 'UTF-8')), 1, 0, 'L');
                $this->Cell(125, 8, isset($empresa['direccion_empresa']) ? $empresa['direccion_empresa'] : 'N/A', 1, 1, 'C');
                $this->Cell(125, 8, 'Responsable de la entidad receptora: ', 1, 0, 'L');
                $this->Cell(125, 8, $responsable, 1, 1, 'C');
                $ttel = 'Teléfono: ';
                $this->Cell(125, 8, (mb_convert_encoding($ttel, 'ISO-8859-1', 'UTF-8')), 1, 0, 'L');
                $this->Cell(125, 8, isset($empresa['telefono_empresa']) ? $empresa['telefono_empresa'] : 'N/A', 1, 1, 'C');
            }
        } else {
            $this->Cell(125, 8, 'No data', 1, 0, 'C');
            $this->Cell(125, 8, 'No data', 1, 1, 'C');
        }
        $this->AddPage();

        $text2 = 'Detalle Semanal de Actividades';
        $this->SetFont('FreeSans', '', 12);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(35);
        $this->Cell(260, 6, $text2, 0, 1, 'C');
        $this->Ln(5);

        $text2 = 'Semana 1';
        $this->SetFont('FreeSans', '', 12);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(40);
        $this->Cell(260, 6, $text2, 0, 1, 'C');
        $this->Ln(5);

        $widths = [40, 60, 60, 30, 30, 30, 30];  // Anchos de las columnas
        $columnNames = ['Fecha', 'Actividades realizadas', 'Detalle (aprendizaje alcanzado)', 'Hora de ingreso', 'Hora de salida', 'Horas efectivas', 'Firma estudiante'];

        $this->SetFillColor(255, 255, 255);
        $this->SetTextColor(0, 0, 0);

        // Calcular la posición X para centrar la tabla
        $totalWidth = array_sum($widths);
        $pageWidth = $this->GetPageWidth();
        $xStart = ($pageWidth - $totalWidth) / 2;

        if ($xStart < 0) {
            $xStart = 0;
        }

        $this->SetFont('FreeSans', '', 10);
        $this->SetX($xStart);

        // Cabecera de la tabla
        foreach ($columnNames as $key => $name) {
            $this->Cell($widths[$key], 10, $name, 1, 0, 'C', true);
        }

        $this->Ln(); // Después de la cabecera, pasamos a la siguiente línea

        // Recuperar datos de la base de datos
        $resultadossemana1 = [];
        if ($pdosemana1) {
            $sqlsemana1 = "SELECT ip.idSemana, ip.cedulaEstudiante, ip.fecha, ip.actividades, ip.detalle, ip.hIngreso, ip.hSalida, ip.hEfectiva, ip.fotos, ip.descima
                   FROM infopractica ip 
                   WHERE ip.cedulaEstudiante = :cedula and ip.idSemana = 1";
            try {
                $querysemana1 = $pdosemana1->prepare($sqlsemana1);
                $querysemana1->bindParam(':cedula', $cedula, PDO::PARAM_STR);
                $querysemana1->execute();
                $resultadossemana1 = $querysemana1->fetchAll(PDO::FETCH_ASSOC);
            } catch (PDOException $e) {
                echo "Error al ejecutar la consulta: " . $e->getMessage();
            }
        }

        // Definir la altura constante para las celdas
        $cellHeight = 15;  // Altura fija para todas las celdas
        $lineHeight = 4;  // Interlineado más apretado (puedes ajustarlo según sea necesario)
        $horasTotales = 0;
        $minutosTotales = 0;
        $alamceandor = '00:00';


        if (!empty($resultadossemana1)) {
            foreach ($resultadossemana1 as $row) {
                // Comenzar cada fila en la misma línea Y
                $currentY = $this->GetY();
                // Definir las coordenadas y las dimensiones de cada celda
                $this->SetXY($xStart, $currentY + 1);  // Desplazamos un poco hacia abajo para que no choque con la línea
                $this->Cell($widths[0], $cellHeight, $row['fecha'], 0, 0, 'C');
                $this->Rect($xStart, $currentY + 1, $widths[0], $cellHeight); // Rectángulo alrededor de la celda de fecha

                // Actividades - Usamos MultiCell para que el texto largo se ajuste
                $this->SetXY($xStart + $widths[0], $currentY + 1);
                $this->MultiCell($widths[1], $lineHeight, mb_convert_encoding($row['actividades'], 'ISO-8859-1', 'UTF-8'), 0, 'J');
                $this->Rect($xStart + $widths[0], $currentY + 1, $widths[1], 15); // Rectángulo alrededor de la celda de actividades

                // Detalle - Usamos MultiCell para que el texto largo se ajuste
                $this->SetXY($xStart + $widths[0] + $widths[1], $currentY + 1);
                $this->MultiCell($widths[2], $lineHeight, mb_convert_encoding($row['detalle'], 'ISO-8859-1', 'UTF-8'), 0, 'J');
                $this->Rect($xStart + $widths[0] + $widths[1], $currentY + 1, $widths[2], 15); // Rectángulo alrededor de la celda de detalle

                // Hora de ingreso
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2], $currentY + 1);
                $this->Cell($widths[3], $cellHeight, date("H:i", strtotime($row['hIngreso'])), 0, 0, 'C');
                $this->Rect($xStart + $widths[0] + $widths[1] + $widths[2], $currentY + 1, $widths[3], $cellHeight); // Rectángulo alrededor de la celda de hora de ingreso

                // Hora de salida
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3], $currentY + 1);
                $this->Cell($widths[4], $cellHeight, date("H:i", strtotime($row['hSalida'])), 0, 0, 'C');
                $this->Rect($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3], $currentY + 1, $widths[4], $cellHeight); // Rectángulo alrededor de la celda de hora de salida

                // Horas efectivas
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4], $currentY + 1);
                $this->Cell($widths[5], $cellHeight, date("H:i", strtotime($row['hEfectiva'])), 0, 0, 'C');
                $this->Rect($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4], $currentY + 1, $widths[5], $cellHeight); // Rectángulo alrededor de la celda de horas efectivas


                $horaEfectiva = $row['hEfectiva'];

                $fotos1[] = $row['fotos'];

                $descripcion1[] = mb_convert_encoding($row['descima'], 'ISO-8859-1', 'UTF-8');

                // Verificamos si el formato de la hora es correcto (HH:MM:SS)
                if (preg_match('/^(\d{2}):(\d{2}):(\d{2})$/', $horaEfectiva, $matches)) {
                    list($hora, $minuto) = array($matches[1], $matches[2], $matches[3]);

                    // Convertir a enteros para la suma
                    $horasEfectiva = (int)$hora;
                    $minutosEfectiva = (int)$minuto;

                    // Sumar las horas, minutos y segundos
                    $horasTotales += $horasEfectiva;
                    $minutosTotales += $minutosEfectiva;

                  

                    // Si los minutos totales son 60 o más, ajustamos a horas
                    if ($minutosTotales >= 60) {
                        $horasTotales += floor($minutosTotales / 60);
                        $minutosTotales = $minutosTotales % 60;
                    }
                }


                $alamceandor = sprintf('%02d h : %02d m', $horasTotales, $minutosTotales) ?: '00:00';

                // Firma estudiante
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4] + $widths[5], $currentY + 1);
                $this->Cell($widths[6], 15, '', 1, 0, 'C');

                // Mover a la siguiente línea, asegurando que todas las celdas tengan la misma altura
                $this->Ln($cellHeight);
            }
            
        } else {
            $this->SetX($xStart);
            $this->Cell(array_sum($widths), 10, 'No existen datos', 1, 0, 'C');
            $this->Ln(10);
        }

        // Verificar si queda espacio en la página, si no, agregar una nueva página
        $currentY = $this->GetY();
        $pageHeight = $this->GetPageHeight();
        $spaceToBottom = $pageHeight - $currentY;

        if ($spaceToBottom < 20) {
            $this->AddPage();
        }
        $text4 = 'Hora total semanal:  ' . $alamceandor;
        $this->SetFont('FreeSans', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY() + 10);
        $this->MultiCell(0, 6, $text4, 0, 'L');
        $this->Ln(6);

        $texta = $responsable;
        $textb = $tutoracademico;
        $this->SetFont('FreeSans', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY() + 10);
        $this->SetX(10);
        $this->Cell(90, 1, $texta, 0, 0, 'L');
        $this->SetX(-120);
        $this->Cell(90, 3, mb_convert_encoding($textb, 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');
        $this->Ln(1);

        $texta = $entidadreceptora;
        $textb = $cargotutor;
        $this->SetFont('FreeSans', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY());
        $this->SetX(10);
        $this->Cell(90, 1, $texta, 0, 0, 'L');
        $this->SetX(-120);
        $this->Cell(90, 3, $textb, 0, 1, 'R');
        $this->Ln(1);

        $this->AddPage();

        $text4 = 'Anexos:';
        $this->SetFont('FreeSans', '', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY() + 2);
        $this->MultiCell(0, 6, $text4, 0, 'L');
        $this->Ln(2);

        $widths = [60, 60, 60];  // Anchos de las celdas
        $heights = 60;           // Altura de las celdas
        $maxRows = 2;            // Número máximo de filas
        $maxCols = 3;            // Número máximo de columnas
        $spaceBetween = 10;      // Espacio adicional entre las celdas (en píxeles)

        // Configuración de la fuente y el color
        $this->SetFont('FreeSans', '', 12);
        $this->SetTextColor(0, 0, 0);

        // Calcular el ancho total y la posición inicial
        $totalWidth = array_sum($widths) + ($spaceBetween * ($maxCols - 1));  // Añadir espacio extra entre columnas
        $pageWidth = $this->GetPageWidth();
        $xStart = ($pageWidth - $totalWidth) / 2;

        $x = $xStart;
        $y = $this->GetY();

        // Decodificar las rutas de las imágenes y verificar errores
        // Verificar si hay fotos en el array
        if (empty($fotos1)) {
            // Si no hay imágenes, mostrar mensaje en el PDF
            $this->Cell(0, 10, mb_convert_encoding('No hay imágenes disponibles en Tipo 1.', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
        } else {
            // Limpiar y decodificar las rutas de las imágenes
            foreach ($fotos1 as &$foto1) {
                $foto1 = json_decode($foto1);  // Esto elimina los corchetes y las comillas extra
                // Si json_decode devuelve un arreglo, accedemos al primer elemento
                if (is_array($foto1)) {
                    $foto1 = $foto1[0];  // Obtener la ruta correcta
                }
            }

            // Dibujar las imágenes en una cuadrícula dinámica
            $imageIndex1 = 0;
            $imageFound = false; // Variable para verificar si encontramos imágenes válidas

    for ($row = 0; $row < $maxRows; $row++) {
    for ($col = 0; $col < $maxCols; $col++) {
        if (isset($fotos1[$imageIndex1])) {
            $ruta = $fotos1[$imageIndex1];
            $imagePath1 = '../ingreso/' . $ruta;

            if (file_exists($imagePath1)) {
                // Verificar si la imagen es un formato válido (JPEG, PNG, GIF)
                $imageInfo = getimagesize($imagePath1);
                if ($imageInfo !== false && in_array($imageInfo[2], [IMAGETYPE_JPEG, IMAGETYPE_PNG, IMAGETYPE_GIF])) {
                    // Verificar la extensión del archivo
                    $extension = strtolower(pathinfo($imagePath1, PATHINFO_EXTENSION));
                    if (in_array($extension, ['jpg', 'jpeg', 'png', 'gif'])) {
                        // Verificar si la imagen es un JPEG válido
                        if ($imageInfo[2] === IMAGETYPE_JPEG || $imageInfo[2] === IMAGETYPE_PNG || $imageInfo[2] === IMAGETYPE_GIF) {
                            // Establecer las coordenadas X y Y para cada celda, añadiendo espacio entre las imágenes
                            $this->SetXY(
                                $x + (($imageIndex1 % $maxCols) * ($widths[$imageIndex1 % $maxCols] + $spaceBetween)),
                                $y + (floor($imageIndex1 / $maxCols) * ($heights + $spaceBetween))
                            );

                            // Dibujar un rectángulo (opcional)
                            $this->Rect(
                                $x + (($imageIndex1 % $maxCols) * ($widths[$imageIndex1 % $maxCols] + $spaceBetween)),
                                $y + (floor($imageIndex1 / $maxCols) * ($heights + $spaceBetween)),
                                $widths[$imageIndex1 % $maxCols],
                                $heights
                            );

                            // Insertar la imagen en la celda
                            try {
                                $this->Image(
                                    $imagePath1,
                                    $x + (($imageIndex1 % $maxCols) * ($widths[$imageIndex1 % $maxCols] + $spaceBetween)),
                                    $y + (floor($imageIndex1 / $maxCols) * ($heights + $spaceBetween)),
                                    $widths[$imageIndex1 % $maxCols],
                                    $heights
                                );
                            } catch (Exception $e) {
                                $this->Cell(0, 10, 'Error al cargar la imagen: ' . $e->getMessage(), 0, 1, 'C');
                            }

                            // Descripción debajo de la imagen
                            $this->SetXY(
                                $x + (($imageIndex1 % $maxCols) * ($widths[$imageIndex1 % $maxCols] + $spaceBetween)),
                                $y + (floor($imageIndex1 / $maxCols) * ($heights + $spaceBetween)) +  61
                            );
                            $this->MultiCell($widths[$imageIndex1 % $maxCols], 3, $descripcion1[$imageIndex1] ?: 'S/D', 0, 'C');

                            // Indicamos que al menos una imagen fue encontrada y procesada
                            $imageFound = true;
                        } else {
                            $this->Cell(0, 10, 'La imagen no es un JPEG, PNG o GIF válido: ' . $imagePath1, 0, 1, 'C');
                        }
                    } else {
                        $this->Cell(0, 10, 'La extensión del archivo no es válida: ' . $imagePath1, 0, 1, 'C');
                    }
                } else {
                    $this->Cell(0, 10, 'La imagen no es válida o no es un formato soportado: ' . $imagePath1, 0, 1, 'C');
                }
            } else {
                $this->Cell(0, 10, 'El archivo de imagen no existe: ' . $imagePath1, 0, 1, 'C');
            }

            $imageIndex1++;
        }
    }
}

            // Si no se encontraron imágenes válidas, mostrar mensaje en el PDF
            if (!$imageFound) {
                $this->Cell(0, 10, mb_convert_encoding('No se pudieron cargar imágenes.', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
            }
        }


        $this->AddPage();

        $text2 = 'Detalle Semanal de Actividades';
        $this->SetFont('FreeSans', '', 12);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(35);
        $this->Cell(260, 6, $text2, 0, 1, 'C');
        $this->Ln(5);

        $text2 = 'Semana 2';
        $this->SetFont('FreeSans', '', 12);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(40);
        $this->Cell(260, 6, $text2, 0, 1, 'C');
        $this->Ln(5);

        $widths = [40, 60, 60, 30, 30, 30, 30];  // Anchos de las columnas
        $columnNames = ['Fecha', 'Actividades realizadas', 'Detalle (aprendizaje alcanzado)', 'Hora de ingreso', 'Hora de salida', 'Horas efectivas', 'Firma estudiante'];

        $this->SetFillColor(255, 255, 255);
        $this->SetTextColor(0, 0, 0);

        // Calcular la posición X para centrar la tabla
        $totalWidth = array_sum($widths);
        $pageWidth = $this->GetPageWidth();
        $xStart = ($pageWidth - $totalWidth) / 2;

        if ($xStart < 0) {
            $xStart = 0;
        }

        $this->SetFont('FreeSans', '', 10);
        $this->SetX($xStart);

        // Cabecera de la tabla
        foreach ($columnNames as $key => $name) {
            $this->Cell($widths[$key], 10, $name, 1, 0, 'C', true);
        }

        $this->Ln(); // Después de la cabecera, pasamos a la siguiente línea

        // Recuperar datos de la base de datos
        $resultadossemana1 = [];
        if ($pdosemana1) {
            $sqlsemana1 = "SELECT ip.idSemana, ip.cedulaEstudiante, ip.fecha, ip.actividades, ip.detalle, ip.hIngreso, ip.hSalida, ip.hEfectiva, ip.fotos, ip.descima 
                   FROM infopractica ip 
                   WHERE ip.cedulaEstudiante = :cedula and ip.idSemana = 2";
            try {
                $querysemana1 = $pdosemana1->prepare($sqlsemana1);
                $querysemana1->bindParam(':cedula', $cedula, PDO::PARAM_STR);
                $querysemana1->execute();
                $resultadossemana1 = $querysemana1->fetchAll(PDO::FETCH_ASSOC);
            } catch (PDOException $e) {
                echo "Error al ejecutar la consulta: " . $e->getMessage();
            }
        }

        // Definir la altura constante para las celdas
        $cellHeight = 15;  // Altura fija para todas las celdas
        $lineHeight = 4;  // Interlineado más apretado (puedes ajustarlo según sea necesario)
        $horasTotales2 = 0;
        $minutosTotales2 = 0;
        $alamceandor2 = '00:00';

        if (!empty($resultadossemana1)) {
            foreach ($resultadossemana1 as $row) {
                // Comenzar cada fila en la misma línea Y
                $currentY = $this->GetY();

                $this->SetXY($xStart, $currentY + 1);  // Desplazamos un poco hacia abajo para que no choque con la línea
                $this->Cell($widths[0], $cellHeight, $row['fecha'], 0, 0, 'C');
                $this->Rect($xStart, $currentY + 1, $widths[0], $cellHeight); // Rectángulo alrededor de la celda de fecha

                // Actividades - Usamos MultiCell para que el texto largo se ajuste
                $this->SetXY($xStart + $widths[0], $currentY + 1);
                $this->MultiCell($widths[1], $lineHeight, mb_convert_encoding($row['actividades'], 'ISO-8859-1', 'UTF-8'), 0, 'J');
                $this->Rect($xStart + $widths[0], $currentY + 1, $widths[1], 15); // Rectángulo alrededor de la celda de actividades

                // Detalle - Usamos MultiCell para que el texto largo se ajuste
                $this->SetXY($xStart + $widths[0] + $widths[1], $currentY + 1);
                $this->MultiCell($widths[2], $lineHeight, mb_convert_encoding($row['detalle'], 'ISO-8859-1', 'UTF-8'), 0, 'J');
                $this->Rect($xStart + $widths[0] + $widths[1], $currentY + 1, $widths[2], 15); // Rectángulo alrededor de la celda de detalle

                // Hora de ingreso
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2], $currentY + 1);
                $this->Cell($widths[3], $cellHeight, date("H:i", strtotime($row['hIngreso'])), 0, 0, 'C');
                $this->Rect($xStart + $widths[0] + $widths[1] + $widths[2], $currentY + 1, $widths[3], $cellHeight); // Rectángulo alrededor de la celda de hora de ingreso

                // Hora de salida
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3], $currentY + 1);
                $this->Cell($widths[4], $cellHeight, date("H:i", strtotime($row['hSalida'])), 0, 0, 'C');
                $this->Rect($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3], $currentY + 1, $widths[4], $cellHeight); // Rectángulo alrededor de la celda de hora de salida

                // Horas efectivas
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4], $currentY + 1);
                $this->Cell($widths[5], $cellHeight, date("H:i", strtotime($row['hEfectiva'])), 0, 0, 'C');
                $this->Rect($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4], $currentY + 1, $widths[5], $cellHeight); // Rectángulo alrededor de la celda de horas efectivas

                $horaEfectiva2 = $row['hEfectiva'];

                $fotos2[] = $row['fotos'];

                $descripcion2[] = mb_convert_encoding($row['descima'], 'ISO-8859-1', 'UTF-8');

                // Verificamos si el formato de la hora es correcto (HH:MM:SS)
                if (preg_match('/^(\d{2}):(\d{2}):(\d{2})$/', $horaEfectiva2, $matches2)) {
                    list($hora2, $minuto2) = array($matches2[1], $matches2[2], $matches2[3]);

                    // Convertir a enteros para la suma
                    $horasEfectiva2 = (int)$hora2;
                    $minutosEfectiva2 = (int)$minuto2;

                    // Sumar las horas, minutos y segundos
                    $horasTotales2 += $horasEfectiva2;
                    $minutosTotales2 += $minutosEfectiva2;

                    // Si los minutos totales son 60 o más, ajustamos a horas
                    if ($minutosTotales2 >= 60) {
                        $horasTotales2 += floor($minutosTotales2 / 60);
                        $minutosTotales2 = $minutosTotales2 % 60;
                    }
                }

                $alamceandor2 = sprintf('%02d h : %02d m', $horasTotales2, $minutosTotales2) ?: '00:00';

                // Firma estudiante
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4] + $widths[5], $currentY + 1);
                $this->Cell($widths[6], 15, '', 1, 0, 'C');

                // Mover a la siguiente línea, asegurando que todas las celdas tengan la misma altura
                $this->Ln($cellHeight);
            }
        } else {
            $this->SetX($xStart);
            $this->Cell(array_sum($widths), 10, 'No existen datos', 1, 0, 'C');
            $this->Ln(10);
        }

        // Verificar si queda espacio en la página, si no, agregar una nueva página
        $currentY = $this->GetY();
        $pageHeight = $this->GetPageHeight();
        $spaceToBottom = $pageHeight - $currentY;

        if ($spaceToBottom < 20) {
            $this->AddPage();
        }
        $text4 = 'Hora total semanal:  ' . $alamceandor2;
        $this->SetFont('FreeSans', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY() + 15);
        $this->MultiCell(0, 6, $text4, 0, 'L');
        $this->Ln(5);

       $texta = $responsable;
        $textb = $tutoracademico;
        $this->SetFont('FreeSans', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY() + 10);
        $this->SetX(10);
        $this->Cell(90, 1, $texta, 0, 0, 'L');
        $this->SetX(-120);
        $this->Cell(90, 3, mb_convert_encoding($textb, 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');
        $this->Ln(1);

        $texta = $entidadreceptora;
        $textb = $cargotutor;
        $this->SetFont('FreeSans', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY());
        $this->SetX(10);
        $this->Cell(90, 1, $texta, 0, 0, 'L');
        $this->SetX(-120);
        $this->Cell(90, 3, $textb, 0, 1, 'R');
        $this->Ln(1);

        $this->AddPage();

        $text4 = 'Anexos:';
        $this->SetFont('FreeSans', '', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY() + 5);
        $this->MultiCell(0, 6, $text4, 0, 'L');
        $this->Ln(5);

        $widths = [60, 60, 60];  // Anchos de las celdas
        $heights = 60;           // Altura de las celdas
        $maxRows = 2;            // Número máximo de filas
        $maxCols = 3;            // Número máximo de columnas
        $spaceBetween = 10;      // Espacio adicional entre las celdas (en píxeles)

        // Configuración de la fuente y el color
        $this->SetFont('FreeSans', '', 12);
        $this->SetTextColor(0, 0, 0);

        // Calcular el ancho total y la posición inicial
        $totalWidth = array_sum($widths) + ($spaceBetween * ($maxCols - 1));  // Añadir espacio extra entre columnas
        $pageWidth = $this->GetPageWidth();
        $xStart = ($pageWidth - $totalWidth) / 2;

        $x = $xStart;
        $y = $this->GetY();

        // Limpiar las rutas de las imágenes
        // Verificar si hay fotos en el array
        if (empty($fotos2)) {
            // Si no hay imágenes, mostrar mensaje en el PDF
            $this->Cell(0, 10, mb_convert_encoding('No hay imágenes disponibles en Tipo 2.', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
        } else {
            // Limpiar y decodificar las rutas de las imágenes
            foreach ($fotos2 as &$foto2) {
                $foto2 = json_decode($foto2);  // Esto elimina los corchetes y las comillas extra
                // Si json_decode devuelve un arreglo, accedemos al primer elemento
                if (is_array($foto2)) {
                    $foto2 = $foto2[0];  // Obtener la ruta correcta
                }
            }

            // Dibujar las imágenes en una cuadrícula dinámica
            $imageIndex2 = 0;
            $imageFound = false; // Variable para verificar si encontramos imágenes válidas

            for ($row = 0; $row < $maxRows; $row++) {
                for ($col = 0; $col < $maxCols; $col++) {
                    if (isset($fotos2[$imageIndex2])) {
                        $ruta = $fotos2[$imageIndex2];
                        $imagePath2 = '../ingreso/' . $ruta;

                        if (file_exists($imagePath2)) {
                            // Verificar si la imagen es un formato válido (JPEG, PNG, GIF)
                            $imageInfo = getimagesize($imagePath2);
                            if ($imageInfo !== false && in_array($imageInfo[2], [IMAGETYPE_JPEG, IMAGETYPE_PNG, IMAGETYPE_GIF])) {
                                // Establecer las coordenadas X y Y para cada celda, añadiendo espacio entre las imágenes
                                $this->SetXY(
                                    $x + (($imageIndex2 % $maxCols) * ($widths[$imageIndex2 % $maxCols] + $spaceBetween)),
                                    $y + (floor($imageIndex2 / $maxCols) * ($heights + $spaceBetween))
                                );

                                // Dibujar un rectángulo (opcional)
                                $this->Rect(
                                    $x + (($imageIndex2 % $maxCols) * ($widths[$imageIndex2 % $maxCols] + $spaceBetween)),
                                    $y + (floor($imageIndex2 / $maxCols) * ($heights + $spaceBetween)),
                                    $widths[$imageIndex2 % $maxCols],
                                    $heights
                                );

                                // Insertar la imagen en la celda
                                try {
                                    $this->Image(
                                        $imagePath2,
                                        $x + (($imageIndex2 % $maxCols) * ($widths[$imageIndex2 % $maxCols] + $spaceBetween)),
                                        $y + (floor($imageIndex2 / $maxCols) * ($heights + $spaceBetween)),
                                        $widths[$imageIndex2 % $maxCols],
                                        $heights
                                    );
                                } catch (Exception $e) {
                                    $this->Cell(0, 10, 'Error al cargar la imagen: ' . $e->getMessage(), 0, 1, 'C');
                                }

                                // Descripción debajo de la imagen
                                $this->SetXY(
                                    $x + (($imageIndex2 % $maxCols) * ($widths[$imageIndex2 % $maxCols] + $spaceBetween)),
                                    $y + (floor($imageIndex2 / $maxCols) * ($heights + $spaceBetween)) + 61
                                );
                                $this->MultiCell($widths[$imageIndex2 % $maxCols], 3, $descripcion2[$imageIndex2] ?: 'S/D', 0, 'C');

                                // Indicamos que al menos una imagen fue encontrada y procesada
                                $imageFound = true;
                            } else {
                                $this->Cell(0, 10, mb_convert_encoding('La imagen no es válida o no es un formato soportado: ', 'ISO-8859-1', 'UTF-8') . $imagePath2, 0, 1, 'C');
                            }
                        } else {
                            $this->Cell(0, 10, 'El archivo de imagen no existe: ' . $imagePath2, 0, 1, 'C');
                        }

                        $imageIndex2++;
                    }
                }
            }

            // Si no se encontraron imágenes válidas, mostrar mensaje en el PDF
            if (!$imageFound) {
                $this->Cell(0, 10, mb_convert_encoding('No se pudieron cargar imágenes válidas en Tipo 2.', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
            }
        }


        $this->AddPage();

        $text2 = 'Detalle Semanal de Actividades';
        $this->SetFont('FreeSans', '', 12);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(35);
        $this->Cell(260, 6, $text2, 0, 1, 'C');
        $this->Ln(5);

        $text2 = 'Semana 3';
        $this->SetFont('FreeSans', '', 12);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(40);
        $this->Cell(260, 6, $text2, 0, 1, 'C');
        $this->Ln(5);

        $widths = [40, 60, 60, 30, 30, 30, 30];  // Anchos de las columnas
        $columnNames = ['Fecha', 'Actividades realizadas', 'Detalle (aprendizaje alcanzado)', 'Hora de ingreso', 'Hora de salida', 'Horas efectivas', 'Firma estudiante'];

        $this->SetFillColor(255, 255, 255);
        $this->SetTextColor(0, 0, 0);

        // Calcular la posición X para centrar la tabla
        $totalWidth = array_sum($widths);
        $pageWidth = $this->GetPageWidth();
        $xStart = ($pageWidth - $totalWidth) / 2;

        if ($xStart < 0) {
            $xStart = 0;
        }

        $this->SetFont('FreeSans', '', 10);
        $this->SetX($xStart);

        // Cabecera de la tabla
        foreach ($columnNames as $key => $name) {
            $this->Cell($widths[$key], 10, $name, 1, 0, 'C', true);
        }

        $this->Ln(); // Después de la cabecera, pasamos a la siguiente línea

        // Recuperar datos de la base de datos
        $resultadossemana1 = [];
        if ($pdosemana1) {
            $sqlsemana1 = "SELECT ip.idSemana, ip.cedulaEstudiante, ip.fecha, ip.actividades, ip.detalle, ip.hIngreso, ip.hSalida, ip.hEfectiva, ip.fotos, ip.descima 
                   FROM infopractica ip 
                   WHERE ip.cedulaEstudiante = :cedula and ip.idSemana = 3";
            try {
                $querysemana1 = $pdosemana1->prepare($sqlsemana1);
                $querysemana1->bindParam(':cedula', $cedula, PDO::PARAM_STR);
                $querysemana1->execute();
                $resultadossemana1 = $querysemana1->fetchAll(PDO::FETCH_ASSOC);
            } catch (PDOException $e) {
                echo "Error al ejecutar la consulta: " . $e->getMessage();
            }
        }

        // Definir la altura constante para las celdas
        $cellHeight = 15;  // Altura fija para todas las celdas
        $lineHeight = 4;  // Interlineado más apretado (puedes ajustarlo según sea necesario)
        $horasTotales3 = 0;
        $minutosTotales3 = 0;
        $alamceandor3 = '00:00';

        if (!empty($resultadossemana1)) {
            foreach ($resultadossemana1 as $row) {
                // Comenzar cada fila en la misma línea Y
                $currentY = $this->GetY();

                $this->SetXY($xStart, $currentY + 1);  // Desplazamos un poco hacia abajo para que no choque con la línea
                $this->Cell($widths[0], $cellHeight, $row['fecha'], 0, 0, 'C');
                $this->Rect($xStart, $currentY + 1, $widths[0], $cellHeight); // Rectángulo alrededor de la celda de fecha

                // Actividades - Usamos MultiCell para que el texto largo se ajuste
                $this->SetXY($xStart + $widths[0], $currentY + 1);
                $this->MultiCell($widths[1], $lineHeight, mb_convert_encoding($row['actividades'], 'ISO-8859-1', 'UTF-8'), 0, 'J');
                $this->Rect($xStart + $widths[0], $currentY + 1, $widths[1], 15); // Rectángulo alrededor de la celda de actividades

                // Detalle - Usamos MultiCell para que el texto largo se ajuste
                $this->SetXY($xStart + $widths[0] + $widths[1], $currentY + 1);
                $this->MultiCell($widths[2], $lineHeight, mb_convert_encoding($row['detalle'], 'ISO-8859-1', 'UTF-8'), 0, 'J');
                $this->Rect($xStart + $widths[0] + $widths[1], $currentY + 1, $widths[2], 15); // Rectángulo alrededor de la celda de detalle

                // Hora de ingreso
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2], $currentY + 1);
                $this->Cell($widths[3], $cellHeight, date("H:i", strtotime($row['hIngreso'])), 0, 0, 'C');
                $this->Rect($xStart + $widths[0] + $widths[1] + $widths[2], $currentY + 1, $widths[3], $cellHeight); // Rectángulo alrededor de la celda de hora de ingreso

                // Hora de salida
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3], $currentY + 1);
                $this->Cell($widths[4], $cellHeight, date("H:i", strtotime($row['hSalida'])), 0, 0, 'C');
                $this->Rect($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3], $currentY + 1, $widths[4], $cellHeight); // Rectángulo alrededor de la celda de hora de salida

                // Horas efectivas
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4], $currentY + 1);
                $this->Cell($widths[5], $cellHeight, date("H:i", strtotime($row['hEfectiva'])), 0, 0, 'C');
                $this->Rect($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4], $currentY + 1, $widths[5], $cellHeight); // Rectángulo alrededor de la celda de horas efectivas

                $horaEfectiva3 = $row['hEfectiva'];

                $fotos3[] = $row['fotos'];

                $descripcion3[] = mb_convert_encoding($row['descima'], 'ISO-8859-1', 'UTF-8');

                // Verificamos si el formato de la hora es correcto (HH:MM:SS)
                if (preg_match('/^(\d{2}):(\d{2}):(\d{2})$/', $horaEfectiva3, $matches3)) {
                    list($hora3, $minuto3) = array($matches3[1], $matches3[2], $matches3[3]);

                    // Convertir a enteros para la suma
                    $horasEfectiva3 = (int)$hora3;
                    $minutosEfectiva3 = (int)$minuto3;

                    // Sumar las horas, minutos y segundos
                    $horasTotales3 += $horasEfectiva3;
                    $minutosTotales3 += $minutosEfectiva3;

                    // Si los minutos totales son 60 o más, ajustamos a horas
                    if ($minutosTotales3 >= 60) {
                        $horasTotales3 += floor($minutosTotales3 / 60);
                        $minutosTotales3 = $minutosTotales3 % 60;
                    }
                }

                $alamceandor3 = sprintf('%02d h : %02d m', $horasTotales3, $minutosTotales3) ?: '00:00';

                // Firma estudiante
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4] + $widths[5], $currentY + 1);
                $this->Cell($widths[6], 15, '', 1, 0, 'C');

                // Mover a la siguiente línea, asegurando que todas las celdas tengan la misma altura
                $this->Ln($cellHeight);
            }
        } else {
            $this->SetX($xStart);
            $this->Cell(array_sum($widths), 10, 'No existen datos', 1, 0, 'C');
            $this->Ln(10);
        }

        // Verificar si queda espacio en la página, si no, agregar una nueva página
        $currentY = $this->GetY();
        $pageHeight = $this->GetPageHeight();
        $spaceToBottom = $pageHeight - $currentY;

        if ($spaceToBottom < 20) {
            $this->AddPage();
        }
        $text4 = 'Hora total semanal:  ' . $alamceandor3;
        $this->SetFont('FreeSans', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY() + 15);
        $this->MultiCell(0, 6, $text4, 0, 'L');
        $this->Ln(5);

      $texta = $responsable;
        $textb = $tutoracademico;
        $this->SetFont('FreeSans', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY() + 10);
        $this->SetX(10);
        $this->Cell(90, 1, $texta, 0, 0, 'L');
        $this->SetX(-120);
        $this->Cell(90, 3, mb_convert_encoding($textb, 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');
        $this->Ln(1);

        $texta = $entidadreceptora;
        $textb = $cargotutor;
        $this->SetFont('FreeSans', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY());
        $this->SetX(10);
        $this->Cell(90, 1, $texta, 0, 0, 'L');
        $this->SetX(-120);
        $this->Cell(90, 3, $textb, 0, 1, 'R');
        $this->Ln(1);

        $this->AddPage();

        $text4 = 'Anexos:';
        $this->SetFont('FreeSans', '', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY() + 5);
        $this->MultiCell(0, 6, $text4, 0, 'L');
        $this->Ln(5);

        $widths = [60, 60, 60];  // Anchos de las celdas
        $heights = 60;           // Altura de las celdas
        $maxRows = 2;            // Número máximo de filas
        $maxCols = 3;            // Número máximo de columnas
        $spaceBetween = 10;      // Espacio adicional entre las celdas (en píxeles)

        // Configuración de la fuente y el color
        $this->SetFont('FreeSans', '', 12);
        $this->SetTextColor(0, 0, 0);

        // Calcular el ancho total y la posición inicial
        $totalWidth = array_sum($widths) + ($spaceBetween * ($maxCols - 1));  // Añadir espacio extra entre columnas
        $pageWidth = $this->GetPageWidth();
        $xStart = ($pageWidth - $totalWidth) / 2;

        $x = $xStart;
        $y = $this->GetY();

        // Verificar si hay fotos en el array
        if (empty($fotos3)) {
            // Si no hay imágenes, mostrar mensaje en el PDF
            $this->Cell(0, 10, mb_convert_encoding('No hay imágenes disponibles.', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
        } else {
            // Limpiar y decodificar las rutas de las imágenes
            foreach ($fotos3 as &$foto3) {
                $foto3 = json_decode($foto3);  // Esto elimina los corchetes y las comillas extra
                // Si json_decode devuelve un arreglo, accedemos al primer elemento
                if (is_array($foto3)) {
                    $foto3 = $foto3[0];  // Obtener la ruta correcta
                }
            }

            // Dibujar las imágenes en una cuadrícula dinámica
            $imageIndex3 = 0;
            $imageFound = false; // Variable para verificar si encontramos imágenes válidas

            for ($row = 0; $row < $maxRows; $row++) {
                for ($col = 0; $col < $maxCols; $col++) {
                    if (isset($fotos3[$imageIndex3])) {
                        $ruta = $fotos3[$imageIndex3];
                        $imagePath2 = '../ingreso/' . $ruta;

                        if (file_exists($imagePath2)) {
                            // Verificar si la imagen es un formato válido (JPEG, PNG, GIF)
                            $imageInfo = getimagesize($imagePath2);
                            if ($imageInfo !== false && in_array($imageInfo[2], [IMAGETYPE_JPEG, IMAGETYPE_PNG, IMAGETYPE_GIF])) {
                                // Establecer las coordenadas X y Y para cada celda, añadiendo espacio entre las imágenes
                                $this->SetXY(
                                    $x + (($imageIndex3 % $maxCols) * ($widths[$imageIndex3 % $maxCols] + $spaceBetween)),
                                    $y + (floor($imageIndex3 / $maxCols) * ($heights + $spaceBetween))
                                );

                                // Dibujar un rectángulo (opcional)
                                $this->Rect(
                                    $x + (($imageIndex3 % $maxCols) * ($widths[$imageIndex3 % $maxCols] + $spaceBetween)),
                                    $y + (floor($imageIndex3 / $maxCols) * ($heights + $spaceBetween)),
                                    $widths[$imageIndex3 % $maxCols],
                                    $heights
                                );

                                // Insertar la imagen en la celda
                                try {
                                    $this->Image(
                                        $imagePath2,
                                        $x + (($imageIndex3 % $maxCols) * ($widths[$imageIndex3 % $maxCols] + $spaceBetween)),
                                        $y + (floor($imageIndex3 / $maxCols) * ($heights + $spaceBetween)),
                                        $widths[$imageIndex3 % $maxCols],
                                        $heights
                                    );
                                } catch (Exception $e) {
                                    $this->Cell(0, 10, 'Error al cargar la imagen: ' . $e->getMessage(), 0, 1, 'C');
                                }

                                // Descripción debajo de la imagen
                                $this->SetXY(
                                    $x + (($imageIndex3 % $maxCols) * ($widths[$imageIndex3 % $maxCols] + $spaceBetween)),
                                    $y + (floor($imageIndex3 / $maxCols) * ($heights + $spaceBetween)) + 61
                                );
                                $this->MultiCell($widths[$imageIndex3 % $maxCols], 3, $descripcion3[$imageIndex3] ?: 'S/D', 0, 'C');

                                // Indicamos que al menos una imagen fue encontrada y procesada
                                $imageFound = true;
                            } else {
                                $this->Cell(0, 10, mb_convert_encoding('La imagen no es válida o no es un formato soportado: ', 'ISO-8859-1', 'UTF-8') . $imagePath2, 0, 1, 'C');
                            }
                        } else {
                            $this->Cell(0, 10, 'El archivo de imagen no existe: ' . $imagePath2, 0, 1, 'C');
                        }

                        $imageIndex3++;
                    }
                }
            }

            // Si no se encontraron imágenes válidas, mostrar mensaje en el PDF
            if (!$imageFound) {
                $this->Cell(0, 10, mb_convert_encoding('No se pudieron cargar imágenes válidas.', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
            }
        }


        $this->AddPage();

        $text2 = 'Detalle Semanal de Actividades';
        $this->SetFont('FreeSans', '', 12);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(30);
        $this->Cell(260, 6, $text2, 0, 1, 'C');
        $this->Ln(5);

        $text2 = 'Semana 4';
        $this->SetFont('FreeSans', '', 12);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(35);
        $this->Cell(260, 6, $text2, 0, 1, 'C');
        $this->Ln(5);

        $widths = [40, 60, 60, 30, 30, 30, 30];  // Anchos de las columnas
        $columnNames = ['Fecha', 'Actividades realizadas', 'Detalle (aprendizaje alcanzado)', 'Hora de ingreso', 'Hora de salida', 'Horas efectivas', 'Firma estudiante'];

        $this->SetFillColor(255, 255, 255);
        $this->SetTextColor(0, 0, 0);

        // Calcular la posición X para centrar la tabla
        $totalWidth = array_sum($widths);
        $pageWidth = $this->GetPageWidth();
        $xStart = ($pageWidth - $totalWidth) / 2;

        if ($xStart < 0) {
            $xStart = 0;
        }

        $this->SetFont('FreeSans', '', 10);
        $this->SetX($xStart);

        // Cabecera de la tabla
        foreach ($columnNames as $key => $name) {
            $this->Cell($widths[$key], 10, $name, 1, 0, 'C', true);
        }

        $this->Ln(); // Después de la cabecera, pasamos a la siguiente línea

        // Recuperar datos de la base de datos
        $resultadossemana1 = [];
        if ($pdosemana1) {
            $sqlsemana1 = "SELECT ip.idSemana, ip.cedulaEstudiante, ip.fecha, ip.actividades, ip.detalle, ip.hIngreso, ip.hSalida, ip.hEfectiva, ip.fotos, ip.descima 
                   FROM infopractica ip 
                   WHERE ip.cedulaEstudiante = :cedula and ip.idSemana = 4";
            try {
                $querysemana1 = $pdosemana1->prepare($sqlsemana1);
                $querysemana1->bindParam(':cedula', $cedula, PDO::PARAM_STR);
                $querysemana1->execute();
                $resultadossemana1 = $querysemana1->fetchAll(PDO::FETCH_ASSOC);
            } catch (PDOException $e) {
                echo "Error al ejecutar la consulta: " . $e->getMessage();
            }
        }

        // Definir la altura constante para las celdas
        $cellHeight = 15;  // Altura fija para todas las celdas
        $lineHeight = 4;  // Interlineado más apretado (puedes ajustarlo según sea necesario)
        $horasTotales4 = 0;
        $minutosTotales4 = 0;
        $alamceandor4 = '00:00';


        if (!empty($resultadossemana1)) {
            foreach ($resultadossemana1 as $row) {
                // Comenzar cada fila en la misma línea Y
                $currentY = $this->GetY();

                $this->SetXY($xStart, $currentY + 1);  // Desplazamos un poco hacia abajo para que no choque con la línea
                $this->Cell($widths[0], $cellHeight, $row['fecha'], 0, 0, 'C');
                $this->Rect($xStart, $currentY + 1, $widths[0], $cellHeight); // Rectángulo alrededor de la celda de fecha

                // Actividades - Usamos MultiCell para que el texto largo se ajuste
                $this->SetXY($xStart + $widths[0], $currentY + 1);
                $this->MultiCell($widths[1], $lineHeight, mb_convert_encoding($row['actividades'], 'ISO-8859-1', 'UTF-8'), 0, 'J');
                $this->Rect($xStart + $widths[0], $currentY + 1, $widths[1], 15); // Rectángulo alrededor de la celda de actividades

                // Detalle - Usamos MultiCell para que el texto largo se ajuste
                $this->SetXY($xStart + $widths[0] + $widths[1], $currentY + 1);
                $this->MultiCell($widths[2], $lineHeight, mb_convert_encoding($row['detalle'], 'ISO-8859-1', 'UTF-8'), 0, 'J');
                $this->Rect($xStart + $widths[0] + $widths[1], $currentY + 1, $widths[2], 15); // Rectángulo alrededor de la celda de detalle

                // Hora de ingreso
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2], $currentY + 1);
                $this->Cell($widths[3], $cellHeight, date("H:i", strtotime($row['hIngreso'])), 0, 0, 'C');
                $this->Rect($xStart + $widths[0] + $widths[1] + $widths[2], $currentY + 1, $widths[3], $cellHeight); // Rectángulo alrededor de la celda de hora de ingreso

                // Hora de salida
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3], $currentY + 1);
                $this->Cell($widths[4], $cellHeight, date("H:i", strtotime($row['hSalida'])), 0, 0, 'C');
                $this->Rect($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3], $currentY + 1, $widths[4], $cellHeight); // Rectángulo alrededor de la celda de hora de salida

                // Horas efectivas
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4], $currentY + 1);
                $this->Cell($widths[5], $cellHeight, date("H:i", strtotime($row['hEfectiva'])), 0, 0, 'C');
                $this->Rect($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4], $currentY + 1, $widths[5], $cellHeight); // Rectángulo alrededor de la celda de horas efectivas
                $horaEfectiva4 = $row['hEfectiva'];

                $fotos4[] = $row['fotos'];

                $descripcion4[] = mb_convert_encoding($row['descima'], 'ISO-8859-1', 'UTF-8');

                // Verificamos si el formato de la hora es correcto (HH:MM:SS)
                if (preg_match('/^(\d{2}):(\d{2}):(\d{2})$/', $horaEfectiva4, $matches4)) {
                    list($hora4, $minuto4) = array($matches4[1], $matches4[2], $matches4[3]);

                    // Convertir a enteros para la suma
                    $horasEfectiva4 = (int)$hora4;
                    $minutosEfectiva4 = (int)$minuto4;

                    // Sumar las horas, minutos y segundos
                    $horasTotales4 += $horasEfectiva4;
                    $minutosTotales4 += $minutosEfectiva4;

                    // Si los minutos totales son 60 o más, ajustamos a horas
                    if ($minutosTotales4 >= 60) {
                        $horasTotales4 += floor($minutosTotales4 / 60);
                        $minutosTotales4 = $minutosTotales4 % 60;
                    }
                }

                $alamceandor4 = sprintf('%02d h : %02d m', $horasTotales4, $minutosTotales4) ?: '00:00';

                // Firma estudiante
                $this->SetXY($xStart + $widths[0] + $widths[1] + $widths[2] + $widths[3] + $widths[4] + $widths[5], $currentY + 1);
                $this->Cell($widths[6], 15, '', 1, 0, 'C');

                // Mover a la siguiente línea, asegurando que todas las celdas tengan la misma altura
                $this->Ln($cellHeight);
            }
        } else {
            $this->SetX($xStart);
            $this->Cell(array_sum($widths), 10, 'No existen datos', 1, 0, 'C');
            $this->Ln(10);
        }

        // Verificar si queda espacio en la página, si no, agregar una nueva página
        $currentY = $this->GetY();
        $pageHeight = $this->GetPageHeight();
        $spaceToBottom = $pageHeight - $currentY;

        if ($spaceToBottom < 20) {
            $this->AddPage();
        }
        $text4 = 'Hora total semanal:  ' . $alamceandor4;
        $this->SetFont('FreeSans', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY() + 5);
        $this->MultiCell(0, 6, $text4, 0, 'L');
        $this->Ln(5);

       $texta = $responsable;
        $textb = $tutoracademico;
        $this->SetFont('FreeSans', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY() + 10);
        $this->SetX(10);
        $this->Cell(90, 1, $texta, 0, 0, 'L');
        $this->SetX(-120);
        $this->Cell(90, 3, mb_convert_encoding($textb, 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');
        $this->Ln(1);

        $texta = $entidadreceptora;
        $textb = $cargotutor;
        $this->SetFont('FreeSans', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY());
        $this->SetX(10);
        $this->Cell(90, 1, $texta, 0, 0, 'L');
        $this->SetX(-120);
        $this->Cell(90, 3, $textb, 0, 1, 'R');
        $this->Ln(1);

        $this->AddPage();

        $text4 = 'Anexos:';
        $this->SetFont('FreeSans', '', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetY($this->GetY() + 5);
        $this->MultiCell(0, 6, $text4, 0, 'L');
        $this->Ln(5);

        $widths = [60, 60, 60];  // Anchos de las celdas
        $heights = 60;           // Altura de las celdas
        $maxRows = 2;            // Número máximo de filas
        $maxCols = 3;            // Número máximo de columnas
        $spaceBetween = 10;      // Espacio adicional entre las celdas (en píxeles)

        // Configuración de la fuente y el color
        $this->SetFont('FreeSans', '', 12);
        $this->SetTextColor(0, 0, 0);

        // Calcular el ancho total y la posición inicial
        $totalWidth = array_sum($widths) + ($spaceBetween * ($maxCols - 1));  // Añadir espacio extra entre columnas
        $pageWidth = $this->GetPageWidth();
        $xStart = ($pageWidth - $totalWidth) / 2;

        $x = $xStart;
        $y = $this->GetY();

        // Verificar si hay fotos en el array
        if (empty($fotos4)) {
            // Si no hay imágenes, mostrar mensaje en el PDF
            $this->Cell(0, 10, mb_convert_encoding('No hay imágenes disponibles.', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
        } else {
            // Limpiar y decodificar las rutas de las imágenes
            foreach ($fotos4 as &$foto4) {
                $foto4 = json_decode($foto4);  // Esto elimina los corchetes y las comillas extra
                // Si json_decode devuelve un arreglo, accedemos al primer elemento
                if (is_array($foto4)) {
                    $foto4 = $foto4[0];  // Obtener la ruta correcta
                }
            }

            // Dibujar las imágenes en una cuadrícula dinámica
            $imageIndex4 = 0;
            $imageFound = false; // Variable para verificar si encontramos imágenes válidas

            for ($row = 0; $row < $maxRows; $row++) {
                for ($col = 0; $col < $maxCols; $col++) {
                    if (isset($fotos4[$imageIndex4])) {
                        $ruta = $fotos4[$imageIndex4];
                        $imagePath4 = '../ingreso/' . $ruta;

                        if (file_exists($imagePath4)) {
                            // Verificar si la imagen es un formato válido (JPEG, PNG, GIF)
                            $imageInfo = getimagesize($imagePath4);
                            if ($imageInfo !== false && in_array($imageInfo[2], [IMAGETYPE_JPEG, IMAGETYPE_PNG, IMAGETYPE_GIF])) {
                                // Establecer las coordenadas X y Y para cada celda, añadiendo espacio entre las imágenes
                                $this->SetXY(
                                    $x + (($imageIndex4 % $maxCols) * ($widths[$imageIndex4 % $maxCols] + $spaceBetween)),
                                    $y + (floor($imageIndex4 / $maxCols) * ($heights + $spaceBetween))
                                );

                                // Dibujar un rectángulo (opcional)
                                $this->Rect(
                                    $x + (($imageIndex4 % $maxCols) * ($widths[$imageIndex4 % $maxCols] + $spaceBetween)),
                                    $y + (floor($imageIndex4 / $maxCols) * ($heights + $spaceBetween)),
                                    $widths[$imageIndex4 % $maxCols],
                                    $heights
                                );

                                // Insertar la imagen en la celda
                                try {
                                    $this->Image(
                                        $imagePath4,
                                        $x + (($imageIndex4 % $maxCols) * ($widths[$imageIndex4 % $maxCols] + $spaceBetween)),
                                        $y + (floor($imageIndex4 / $maxCols) * ($heights + $spaceBetween)),
                                        $widths[$imageIndex4 % $maxCols],
                                        $heights
                                    );
                                } catch (Exception $e) {
                                    $this->Cell(0, 10, 'Error al cargar la imagen: ' . $e->getMessage(), 0, 1, 'C');
                                }

                                // Descripción debajo de la imagen
                                $this->SetXY(
                                    $x + (($imageIndex4 % $maxCols) * ($widths[$imageIndex4 % $maxCols] + $spaceBetween)),
                                    $y + (floor($imageIndex4 / $maxCols) * ($heights + $spaceBetween)) + 61
                                );
                                $this->MultiCell($widths[$imageIndex4 % $maxCols], 3, $descripcion4[$imageIndex4] ?: 'S/D', 0, 'C');

                                // Indicamos que al menos una imagen fue encontrada y procesada
                                $imageFound = true;
                            } else {
                                $this->Cell(0, 10, mb_convert_encoding('La imagen no es válida o no es un formato soportado: ', 'ISO-8859-1', 'UTF-8') . $imagePath4, 0, 1, 'C');
                            }
                        } else {
                            $this->Cell(0, 10, 'El archivo de imagen no existe: ' . $imagePath4, 0, 1, 'C');
                        }

                        $imageIndex4++;
                    }
                }
            }

            // Si no se encontraron imágenes válidas, mostrar mensaje en el PDF
            if (!$imageFound) {
                $this->Cell(0, 10, mb_convert_encoding('No se pudieron cargar imágenes válidas en Tipo 4.', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');
            }
        }
    }

    // Pie de página
    /*function Footer()
    {
        $this->SetY(-35);
        $this->SetFont('FreeSans', 'I', 8);
        $this->Cell(0, 10, 'ISTRED - Pagina ' . $this->PageNo(), 0, 0, 'L'); // Alineación a la izquierda
    */}
}

$pdf = new PDF('L', 'mm', 'A4');
$pdf->AddPage();
$pdf->Body();
$pdf->Output('I', 'documento.pdf');

// Finaliza el buffer de salida
ob_end_flush();

// Cierra las conexiones
$conexion2->cerrar_conexion();
