<?php
require('pdf/fpdf.php'); // Asegúrate de que la ruta sea correcta
header('Content-Type: text/html; charset=utf-8');

class PDF extends FPDF
{
    // Encabezado
    function Header()
    {
        // Imagen a la izquierda
        $this->Image('img/fondo.png', 1, 1, 210); // Ruta de la imagen
        // Ajustar la posición X para el texto
        $this->SetX(10); // Cambia el valor según sea necesario para alinear el texto

        // Imagen a la derecha (ajusta la posición según necesites)
         $this->Image('img/logo-vinc-prac.jpg', 120, 10, 80); // Ruta de la imagen
    }

    // Cuerpo
    function Body()
    {
        
         if (isset($_GET['id']) && !empty($_GET['id'])) {
        
        $nombre="[nombre del estudiante]";
        $ci='[cedula del estudiante]';
        $siglas='[nomenclaruta]';
        $carrera='[carrera]';
        $horas='[horas]';
        $empresa='[empresa]';
        $nota='[calificacion]';
        $finicio='[fecha de inicio]';
        $ffin='[fecha fin]';
        $promocion='[promocion]';
        
        
        include_once '../../model/model_conexion.php';
        
        $id=$_GET['id'];

        
        $conexion = new conexionBD;
        $pdo= $conexion->conexionPDO();

        if($pdo){
            $sql = "SELECT s.idsolicitud, s.NombreEstudiante, s.cedulaEstudiante, s.nomenclatura, pe.nEmpresa, s.Carrera, s.horas, ast.promo, s.fInicio, s.fFin, s.f_aprobacion,pe.responsable, pe.cargo_empresa, s.id_oficio_inicio, ast.nombre_tutor, ast.telefono_tutor, ast.correo_tutor FROM solicitud s JOIN asig_tutor ast ON ast.CedulaEstudiante = s.cedulaEstudiante JOIN prac_empresa pe on pe.idEmpresa=s.idsolicitud WHERE s.idsolicitud = :id";
            try {
                $stmt = $pdo->prepare($sql);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                $stmt->execute();
                $info = $stmt->fetch(PDO::FETCH_ASSOC);

                if($info){
                    $nombre=isset($info['NombreEstudiante'])?$info['NombreEstudiante']:'';
                    $ci=isset($info['cedulaEstudiante'])?$info['cedulaEstudiante']:'';
                    $siglas=isset($info['nomenclatura'])?$info['nomenclatura']:'';
                    $carrera=isset($info['Carrera'])?$info['Carrera']:'';
                    $horas=isset($info['horas'])?$info['horas']:'';
                    $empresa=isset($info['nEmpresa'])?$info['nEmpresa']:'';
                    $responsable =isset($info['responsable'])?$info['responsable']:'';
                    $cargo= isset($info['cargo_empresa'])?$info['cargo_empresa']:'';
                    $tutornombre=isset($info['nombre_tutor'])?$info['nombre_tutor']:'';
                    $tutortelefono=isset($info['telefono_tutor'])?$info['telefono_tutor']:'';
                    $tutorcorreo=isset($info['correo_tutor'])?$info['correo_tutor']:'';
                    $finicio=isset($info['fInicio'])?$info['fInicio']:'';
                    $ffin=isset($info['fFin'])?$info['fFin']:'';
                    $promocion=isset($info['promo'])?$info['promo']:'';
                    $fecha=isset($info['f_aprobacion'])?$info['f_aprobacion']:'';
                    $oficio=isset($info['id_oficio_inicio'])?$info['id_oficio_inicio']:'000';
                    
                }
                
            } catch (PDOException $e) {
                echo "Error en la conexion :" . $e->getMessage();
            }
        }else {
            echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
        }
        
         $fechaArray = explode('-', $fecha);

         $dia = $fechaArray[2]?:'00';  // Día
         $mes = $fechaArray[1]?:'00';  // Mes (en formato numérico)
         $anio = $fechaArray[0]?:'00'; // Año
         
        $meses = [
            '01' => 'Enero',
            '02' => 'Febrero',
            '03' => 'Marzo',
            '04' => 'Abril',
            '05' => 'Mayo',
            '06' => 'Junio',
            '07' => 'Julio',
            '08' => 'Agosto',
            '09' => 'Septiembre',
            '10' => 'Octubre',
            '11' => 'Noviembre',
            '12' => 'Diciembre'
        ];

        $mesEspañol = $meses[$mes];
        $textoFecha = $mesEspañol . ' ' . $dia . ', ' . $anio;
        $text = 'Daule, ' . $textoFecha;

        $this->SetLeftMargin(25);
        $this->SetRightMargin(25);
        $this->SetTopMargin(25);
        
        $numero = str_pad($oficio, 3, '0', STR_PAD_LEFT);

        $text2 = 'Oficio CVINCINST-UPLCR-ISTRED-'.strtoupper($siglas).'-'.strtoupper($promocion).'-'.strtoupper($mesEspañol).'-No.'.$numero.'';
        $this->SetFont('Arial', 'BI', 12);
        $this->SetY(28);
        $this->Cell(0, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');
        $this->Ln(2); // Espacio inferior

        $this->SetFont('Arial', 'BI', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetFillColor(0, 56, 175);
        $this->SetY(38);
        $this->Cell(160, 6, $text, 0, 1, 'R');
        $this->SetY(36);
        $this->Ln(5);

        $text2 = $responsable??'[NO REGISTRA]';
        $this->SetFont('Arial', 'BI', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(50); // Volver a establecer Y para el texto
        $this->Cell(70, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text2 = $cargo??'[NO REGISTRA]';
        $this->SetFont('Arial', 'BI', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(54); // Volver a establecer Y para el texto
        $this->Cell(86, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text3 = $empresa??'[NO REGISTRA]';
        $this->SetFont('Arial', 'BI', 11);
        $textWidth = $this->GetStringWidth($text3);
        $this->SetY(58); // Volver a establecer Y para el texto
        $this->Cell(71, 6, mb_convert_encoding($text3, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text2 = 'Asunto:  Inicio de las Actividades de Prácticas Preprofesionales ';
        $this->SetFont('Arial', 'B', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(70); // Volver a establecer Y para el texto
        $this->Cell(55, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text2 = 'De mi consideración:';
        $this->SetFont('Arial', '', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(78); // Volver a establecer Y para el texto
        $this->Cell(55, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text4 = 'Reciba un cordial y afectuoso saludo. La Coordinación de Vinculación Institucional del Instituto Superior Tecnológico Rey David, ha designado a los siguientes estudiantes para realizar las Prácticas Preprofesionales en la institución que acertadamente direcciona, los cuales pertenecen a la carrera de '.$carrera.' y cuya nómina es la siguiente:';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(85);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(3);

        $this->Cell(50, 10, 'Apellidos y Nombres', 1, 0, 'C');
        $this->SetFont('Arial', '', 10);
        $this->Cell(50, 10, mb_convert_encoding('Cédula', 'ISO-8859-1', 'UTF-8'), 1, 0, 'C');
        $this->Cell(50, 10, mb_convert_encoding('Promoción', 'ISO-8859-1', 'UTF-8'), 1, 1, 'C');
        
        $y = $this->GetY();

// Escribe el nombre con MultiCell
$this->MultiCell(50, 6, mb_convert_encoding($nombre, 'ISO-8859-1', 'UTF-8'), 1, 'C');
// Obtén la nueva posición Y después de MultiCell
$newY = $this->GetY();

// Posiciona el cursor para la siguiente celda (Celular)
$this->SetXY(75, $y); // 60 es la posición X de la segunda columna
$this->Cell(50, $newY - $y, $ci, 1, 0, 'C'); // Ajusta la altura

// Posiciona el cursor para la siguiente celda (Correo)
$this->SetXY(125, $y); // 110 es la posición X de la tercera columna
$this->Cell(50, $newY - $y, $promocion, 1, 0, 'C'); // Ajusta la altura

// Actualiza la posición Y para la siguiente fila
$this->SetY($newY);

        $text4 = 'Las actividades las deberán ejecutar dentro de las siguientes fechas:';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(140);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(3);

        $text4 = '- Fecha de inicio:  '.$finicio;
        $this->SetFont('Arial', '', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(145);
        $this->Cell(10); 
        $this->Cell(0, 6, $text4, 0, 1, 'L'); 
        $this->Ln(5);

        $text4 = '- Fecha de finalización: '.$ffin;
        $this->SetFont('Arial', '', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(150);
        $this->Cell(10); 
        $this->Cell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); 
        $this->Ln(5);

        $text4 = '- Horas totales: '.$horas;
        $this->SetFont('Arial', '', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(155);
        $this->Cell(10); 
        $this->Cell(0, 6, $text4, 0, 1, 'L'); 
        $this->Ln(5);

        $text4 = 'De existir algún tipo de inconveniente, se deberá informar al siguiente número o correo electrónico del tutor responsable: ';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(163);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(5);

       $this->SetFont('Arial', '', 10);
$this->Cell(50, 10, 'Apellidos y Nombres', 1, 0, 'C');
$this->Cell(50, 10, 'Celular', 1, 0, 'C');
$this->Cell(50, 10, 'Correo', 1, 1, 'C');

// Guarda la posición Y actual
$y = $this->GetY();

// Escribe el nombre con MultiCell
$this->MultiCell(50, 5, $tutornombre, 1, 'C');
// Obtén la nueva posición Y después de MultiCell
$newY = $this->GetY();

// Posiciona el cursor para la siguiente celda (Celular)
$this->SetXY(75, $y); // 60 es la posición X de la segunda columna
$this->Cell(50, $newY - $y, $tutortelefono, 1, 0, 'C'); // Ajusta la altura

// Posiciona el cursor para la siguiente celda (Correo)
$this->SetXY(125, $y); // 110 es la posición X de la tercera columna
$this->Cell(50, $newY - $y, $tutorcorreo, 1, 0, 'C'); // Ajusta la altura

// Actualiza la posición Y para la siguiente fila
$this->SetY($newY);

        $text4 = 'Quedamos a la espera de sus comentarios, no sin antes agradecer por su amable atención.';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(200);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(5);

        $text4 = 'Atentamente, ';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(220);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);

        $text4 = 'Econ. Roberto Caicedo Meza';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(250);
        $this->MultiCell(0, 6, $text4, 0, 'C');
        $this->Ln(5);
        $text4 = 'Coordinador de Vinculación Institucional';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(255);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'C');
        $this->Ln(5);
        $text4 = 'Instituto Superior Tecnológico Rey David';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(260);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'C');
        $this->Ln(5);
         }
           
    }

    // Pie de página
    /* function Footer()
    {
        $this->SetY(-35);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'ISTRED - Pagina ' . $this->PageNo(), 0, 0, 'L'); // Alineación a la izquierda
    }*/
}

// Crear una instancia de PDF
$pdf = new PDF();
$pdf->AddPage();
$pdf->Body(); // Llamar a la función que agrega el cuerpo
$pdf->Output('I', 'documento.pdf');
