<?php
require('pdf/fpdf.php'); // Asegúrate de que la ruta sea correcta
header('Content-Type: text/html; charset=utf-8');

class PDF extends FPDF
{
    // Encabezado
    function Header()
    {
        // Imagen a la izquierda
        $this->Image('img/fondo.png', 1, 1, 210); // Ruta de la imagen
        // Ajustar la posición X para el texto
        $this->SetX(10); // Cambia el valor según sea necesario para alinear el texto

        // Imagen a la derecha (ajusta la posición según necesites)
        $this->Image('../img/logo-vinc-prac.jpg', 130, 10, 70); // Ruta de la imagen
    }

    // Cuerpo
    function Body()
    {
        if (isset($_GET['id']) && !empty($_GET['id'])) {
        
        $nombre="[nombre del estudiante]";
        $ci='[cedula del estudiante]';
        $siglas='[nomenclaruta]';
        $carrera='[carrera]';
        $horas='[horas]';
        $empresa='[empresa]';
        $nota='[calificacion]';
        $finicio='[fecha de inicio]';
        $ffin='[fecha fin]';
        $promocion='[promocion]';
        
        
        include_once '../../model/model_conexion.php';
        
        $id=$_GET['id'];
        
        $conexion = new conexionBD;
        $pdo= $conexion->conexionPDO();

        if($pdo){
            $sql = "SELECT s.idsolicitud, s.NombreEstudiante, s.cedulaEstudiante, s.nomenclatura, pe.nEmpresa, s.Carrera, s.horas, ast.promo, s.fInicio, s.fFin, s.f_finalizacion, s.id_oficio_fin, ee.p1_p1, ee.p1_p2, ee.p1_p3, ee.p1_p4, ee.p1_p5, ee.p1_p6, ee.p2_p1, ee.p2_p2, ee.p2_p3, ee.p2_p4, ee.p2_p5, ee.p3_p1, ee.p3_p2, ee.p3_p3, ee.p3_p4 FROM solicitud s JOIN eval_empresa ee ON ee.idsol = s.idsolicitud JOIN asig_tutor ast ON ast.CedulaEstudiante = s.cedulaEstudiante JOIN prac_empresa pe on pe.idEmpresa=s.idsolicitud WHERE s.idsolicitud = :id";
            try {
                $stmt = $pdo->prepare($sql);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                $stmt->execute();
                $info = $stmt->fetch(PDO::FETCH_ASSOC);

                if($info){
                    $nombre=isset($info['NombreEstudiante'])?$info['NombreEstudiante']:'';
                    $ci=isset($info['cedulaEstudiante'])?$info['cedulaEstudiante']:'';
                    $siglas=isset($info['nomenclatura'])?$info['nomenclatura']:'';
                    $carrera=isset($infp['Carrera'])?$info['Carrera']:'';
                    $horas=isset($info['horas'])?$info['horas']:'';
                    $empresa=isset($info['nEmpresa'])?$info['nEmpresa']:'';
                    $notap1=is_numeric($info['p1_p1'])?intval($info['p1_p1']):0;
                    $notap2=is_numeric($info['p1_p2'])?intval($info['p1_p2']):0;
                    $notap3=is_numeric($info['p1_p3'])?intval($info['p1_p3']):0;
                    $notap4=is_numeric($info['p1_p4'])?intval($info['p1_p4']):0;
                    $notap5=is_numeric($info['p1_p5'])?intval($info['p1_p5']):0;
                    $notap6=is_numeric($info['p1_p6'])?intval($info['p1_p6']):0;
                    $notap7=is_numeric($info['p2_p1'])?intval($info['p2_p1']):0;
                    $notap8=is_numeric($info['p2_p2'])?intval($info['p2_p2']):0;
                    $notap9=is_numeric($info['p2_p3'])?intval($info['p2_p3']):0;
                    $notap10=is_numeric($info['p2_p4'])?intval($info['p2_p4']):0;
                    $notap11=is_numeric($info['p2_p5'])?intval($info['p2_p5']):0;
                    $notap12=is_numeric($info['p3_p1'])?intval($info['p3_p1']):0;
                    $notap13=is_numeric($info['p3_p2'])?intval($info['p3_p2']):0;
                    $notap14=is_numeric($info['p3_p3'])?intval($info['p3_p3']):0;
                    $notap15=is_numeric($info['p3_p4'])?intval($info['p3_p4']):0;
                    $suma1=($notap1+$notap2+$notap3+$notap4+$notap5+$notap6)/6;
                    $suma2=($notap7+$notap8+$notap9+$notap10+$notap11)/5;
                    $suma3=($notap12+$notap13+$notap14+$notap15)/4;
                    $total=($suma1+$suma2+$suma3)/3;
                    $nota=number_format($total,2)??'[NO REGISTRA]';
                    $finicio=isset($info['fInicio'])?$info['fInicio']:'';
                    $ffin=isset($info['fFin'])?$info['fFin']:'';
                    $promocion=isset($info['promo'])?$info['promo']:'';
                    $fecha=isset($info['f_finalizacion'])?$info['f_finalizacion']:'';
                    $oficio=isset($info['id_oficio_fin'])?$info['id_oficio_fin']:'';
                    
                }
                
            } catch (PDOException $e) {
                echo "Error en la conexion :" . $e->getMessage();
            }
        }else {
            echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
        }

       $fechaArray = explode('-', $fecha);

$dia = $fechaArray[2]?:'00';  // Día
$mes = $fechaArray[1]?:'00';  // Mes (en formato numérico)
$anio = $fechaArray[0]?:'00'; // Año

// Definir los meses en español
$meses = [
    '01' => 'Enero',
    '02' => 'Febrero',
    '03' => 'Marzo',
    '04' => 'Abril',
    '05' => 'Mayo',
    '06' => 'Junio',
    '07' => 'Julio',
    '08' => 'Agosto',
    '09' => 'Septiembre',
    '10' => 'Octubre',
    '11' => 'Noviembre',
    '12' => 'Diciembre'
];

// Obtener el nombre del mes en español usando el mes numérico
$mesEspañol = $meses[$mes];

// Crear el texto con la fecha en formato "Mes Día, Año"
$textoFecha = $mesEspañol . ' ' . $dia . ', ' . $anio;


        $this->SetLeftMargin(25);
        $this->SetRightMargin(25);
        $this->SetTopMargin(25);
        
        if ($oficio === null) {
             $numero = '001';
         } else {
             // Incrementamos el último oficio
             $numero = str_pad($oficio, 3, '0', STR_PAD_LEFT);
         }

        $text2 = 'Certificación_CVSPP_UPP_'.strtoupper($siglas).'_'.strtoupper($promocion).'_'.strtoupper($mesEspañol).'_'.$numero.'_'.$anio.'';
        $this->SetFont('Arial', 'BI', 10);
        $textWidth = $this->GetStringWidth($text2); // Calcular el ancho del texto
        $this->SetY(30); // Establecer la posición Y para el texto
        
        // Calcular la posición X para alinearlo a la derecha
        $rightMargin = 10; // Margen derecho de 10mm (ajusta si es necesario)
        $pageWidth = $this->GetPageWidth(); // Obtener el ancho total de la página
        $xPos = $pageWidth - $rightMargin - $textWidth; // Restar el margen derecho y el ancho del texto
        
        $this->SetX($xPos); // Establecer la posición X calculada
        $this->Cell(30, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // El texto se dibuja desde la posición X a la izquierda
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(2); // Espacio inferior        

        $text3 = 'CERTIFICADO DE CULMINACIÓN DE PRÁCTICAS PREPROFESIONALES';
        $this->SetFont('Arial', 'BI', 12);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(70); // Volver a establecer Y para el texto
        $this->Cell(71, 6, mb_convert_encoding($text3, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = 'El suscrito certifica que el '.$nombre.' titular de la cédula No. '.$ci.', estudiante de la carrera de '.$carrera.' del Instituto Superior Tecnológico Rey David, en conformidad con las leyes vigentes de educación superior y normativas internas, CUMPLIÓ con las '.$horas.' horas de Prácticas Preprofesionales en la empresa '.$empresa.', donde se le otorgó una calificación de '.$nota.'/10 puntos, durante el periodo comprendido entre las fechas: '.$finicio.' hasta '.$ffin.', demostrando en todas las actividades: responsabilidad, profesionalismo y proactividad.';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(85);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(3);

       
        $text4 = 'Constancia que se expide en Daule el dia '.$dia.' del mes de '.$mesEspañol.' del año '.$anio.'.';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(140);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(5);

        $text4 = 'Expedido por:';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(160);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);

        $text4 = 'Econ. Roberto Caicedo Meza';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(200);
        $this->MultiCell(0, 6, $text4, 0, 'C');
        $this->Ln(5);
        $text4 = 'Coordinador de Vinculación Institucional';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(205);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'C');
        $this->Ln(5);
        $text4 = 'Instituto Superior Tecnológico Rey David';
        $this->SetFont('Arial', '', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(210);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'C');
        $this->Ln(5);
        
        }
    }

    // Pie de página
    /* function Footer()
    {
        $this->SetY(-35);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'ISTRED - Pagina ' . $this->PageNo(), 0, 0, 'L'); // Alineación a la izquierda
    }*/
}

// Crear una instancia de PDF
$pdf = new PDF();
$pdf->AddPage();
$pdf->Body(); // Llamar a la función que agrega el cuerpo
$pdf->Output('I', 'documento.pdf');
