<?php
session_start();
include_once '../../model/model_conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validar campos obligatorios
    if (!isset($_POST['cedula']) || empty($_POST['cedula'])) {
        echo json_encode(['status' => 'error', 'message' => 'Cdula es obligatoria']);
        exit;
    }

    // Captura de datos (con sanitizacin bsica)
    $cedula = $_POST['cedula'];
    $ruc = $_POST['ruc'] ?? '';
    $telefono = $_POST['telefono'] ?? '';
    $direccion = mb_strtoupper($_POST['direccion'] ?? '');
    $correo = strtoupper($_POST['correo'] ?? '');
    $empresa = strtoupper($_POST['emp'] ?? ''); 
    $tipoemp = strtoupper($_POST['tipoemp'] ?? '');
    $actividad = mb_strtoupper($_POST['actividad'] ?? '', 'UTF-8');
    $dedica = mb_strtoupper($_POST['dedica'] ?? '');
    $areas = $_POST['areas'] ?? []; // Array de reas
    $canton = $_POST['canton'] ?? ''; // String
    $ins = strtoupper($_POST['ins'] ?? '');
    $provee = strtoupper($_POST['provee'] ?? 'NINGUNO');
    $exp = strtoupper($_POST['exp'] ?? '');
    $necesidades = strtoupper($_POST['necesidades'] ?? '');
    $obs = strtoupper($_POST['obs'] ?? 'ninguna');

    // Procesar arrays a strings
    $areaStr = !empty($areas) ? implode(", ", array_map('strtoupper', $areas)) : '';

    // Conexin a la base de datos
    $conexion = new conexionBD();
    $pdo = $conexion->conexionPDO();

    // Verificar si existe un registro "APROBADO"
    try {
        $sqlCheck = "SELECT COUNT(*) as total FROM solicitud 
                     WHERE cedulaEstudiante = :cedula 
                     AND estado = 'APROBADO'";
        $stmtCheck = $pdo->prepare($sqlCheck);
        $stmtCheck->bindValue(':cedula', $cedula, PDO::PARAM_STR);
        $stmtCheck->execute();
        $resultado = $stmtCheck->fetch(PDO::FETCH_ASSOC);
        $totalRegistros = $resultado['total'] ?? 0;

        if ($totalRegistros > 0) {
            echo json_encode(['status' => 'error', 'message' => 'No se puede actualizar (estado APROBADO)']);
            exit;
        }
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Error al verificar registros: ' . $e->getMessage()]);
        exit;
    }

    if ($totalRegistros == 0) {
        try {
            $sqlUpdate = "UPDATE prac_empresa
                          JOIN solicitud ON prac_empresa.idEmpresa = solicitud.idsolicitud
                          SET 
                              ruc_empresa = :ruc,
                              ciudad_canton_empresa = :canton,
                              telefono_empresa = :telefono,
                              empresa = :empresa,
                              direccion_empresa = :direccion,
                              correo_empresa = :correo,
                              tipo_empresa = :tipoemp,
                              actividad_empresa = :actividad,
                              dedica_empresa = :dedica,
                              arpra_empresa = :areas,
                              rmateriales_empresa = :ins,
                              provee_empresa = :provee,
                              exp_empresa = :exp,
                              npracticantes_empresa = :necesidades,
                              obs_empresa = :obs
                          WHERE 
                              solicitud.cedulaEstudiante = :cedula
                              AND solicitud.estado = 'PENDIENTE'";

            $stmtUpdate = $pdo->prepare($sqlUpdate);
            $stmtUpdate->bindValue(':ruc', $ruc);
            $stmtUpdate->bindValue(':canton', $canton);
            $stmtUpdate->bindValue(':telefono', $telefono);
            $stmtUpdate->bindValue(':empresa', $empresa);
            $stmtUpdate->bindValue(':direccion', $direccion);
            $stmtUpdate->bindValue(':correo', $correo);
            $stmtUpdate->bindValue(':tipoemp', $tipoemp);
            $stmtUpdate->bindValue(':actividad', $actividad);
            $stmtUpdate->bindValue(':dedica', $dedica);
            $stmtUpdate->bindValue(':areas', $areaStr);
            $stmtUpdate->bindValue(':ins', $ins);
            $stmtUpdate->bindValue(':provee', $provee);
            $stmtUpdate->bindValue(':exp', $exp);
            $stmtUpdate->bindValue(':necesidades', $necesidades);
            $stmtUpdate->bindValue(':obs', $obs);
            $stmtUpdate->bindValue(':cedula', $cedula);

            if ($stmtUpdate->execute()) {
                echo json_encode(['status' => 'success', 'message' => 'Datos actualizados']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Error al actualizar']);
            }
        } catch (PDOException $e) {
            echo json_encode(['status' => 'error', 'message' => 'Error en UPDATE: ' . $e->getMessage()]);
        }
    }
}
?>