<?php
include_once '../../model/model_conexion.php';


$json = file_get_contents('php://input');
$datos = json_decode($json, true);

$conexion5 = new conexionBD();
$pdo5 = $conexion5->conexionPDO();

if ($pdo5) {
    $sql5 = "SELECT ast.fecha, ast.mes, ast.numero FROM asig_tutor ast ORDER BY ast.fecha DESC LIMIT 1";
    $query5 = $pdo5->prepare($sql5);
  
    try {
      $query5->execute();
      $resultados = $query5->fetchAll(PDO::FETCH_ASSOC);
      
      if ($resultados) {
        $ultimoRegistro = $resultados[0];
        $ultimoMes = $ultimoRegistro['mes'];
        $ultimoNumero = $ultimoRegistro['numero'];
        
        $mesActual = date('m');
        $mesActualLetra = date('F'); // Obtener el mes en letra
  
        $mesesEnEspanol = [
          'January' => 'ENERO',
          'February' => 'FEBRERO',
          'March' => 'MARZO',
          'April' => 'ABRIL',
          'May' => 'MAYO',
          'June' => 'JUNIO',
          'July' => 'JULIO',
          'August' => 'AGOSTO',
          'September' => 'SEPTIEMBRE',
          'October' => 'OCTUBRE',
          'November' => 'NOVIEMBRE',
          'December' => 'DICIEMBRE'
        ];
      
        $mesActualEnEspanol = $mesesEnEspanol[$mesActualLetra];
      
        if ($ultimoMes == $mesActualEnEspanol) {
          $nuevoNumero = $ultimoNumero + 1;
          $nuevomes = $ultimoMes;
        } else {
          $nuevoNumero = 1;
          $nuevomes = $mesActualEnEspanol;
        }
      }
   
    } catch (PDOException $e) {
      error_log("Error al ejecutar la consulta: " . $e->getMessage());
    }
  } else {
    echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
  }

  $conexion = new conexionBD();
  $pdo = $conexion->conexionPDO();

if ($pdo) {

    $cedulaDocente = $datos['cdocente'];
    $nombreDocente = $datos['ndocente'];
    $apellidoDocente = $datos['adocente'];
    $apellidoDocente2 = $datos['a2docente'];
    $nDocente=$nombreDocente.' '.$apellidoDocente.' '.$apellidoDocente2;
    $correoDocente = isset($datos['correodocente']) ? $datos['correodocente'] : null;  // Usar null si el campo no existe
    $celuDocente = $datos['celudocente'];
    $promo = $datos['promo'];

    // Acceder a los datos del estudiante
    $cedulaEstudiante = $datos['estudiante']['cedula'];
    $nombreEstudiante = $datos['estudiante']['nombre'];
    $apellidoEstudiante = $datos['estudiante']['apellido'];
    $nestudiante=$nombreEstudiante.' '.$apellidoEstudiante;
    $correoEstudiante = $datos['estudiante']['correo'];
    $carreraEstudiante = $datos['estudiante']['carreraest'];
    $promocion = $datos['estudiante']['promocion'];
    $periodo = $datos['estudiante']['periodaca'];

    $fecha = date('Y-m-d');

    try {
        // Preparar la consulta SQL
        $sql = "INSERT INTO asig_tutor (
            CedulaDocente, nombre_tutor, telefono_tutor, correo_tutor, Carrera, CedulaEstudiante, nombre_estudiante, promocion,  correo_estudiante,
            per_acad_estudiante, promo, fecha, mes, numero
         
        ) VALUES (
            :cdocente, :ndocente, :telefono, :codocente, :carrera, :cestudiante, :nestudiante, :promocion, :correoestudiante, :periodo, :promo, :fecha, :mes, :numero
        )";

        $stmt = $pdo->prepare($sql);

        // Vincular los parámetros/*
        $stmt->bindParam(':cdocente', $cedulaDocente);
        $stmt->bindParam(':ndocente', $nDocente);
        $stmt->bindParam(':telefono', $celuDocente);
        $stmt->bindParam(':codocente', $correoDocente);
        $stmt->bindParam(':carrera', $carreraEstudiante);
        $stmt->bindParam(':cestudiante', $cedulaEstudiante);
        $stmt->bindParam(':nestudiante', $nestudiante);
        $stmt->bindParam(':promocion', $promocion);
        $stmt->bindParam(':correoestudiante', $correoEstudiante);  
        $stmt->bindParam(':periodo', $periodo);
        $stmt->bindParam(':promo', $promo);
        $stmt->bindParam(':fecha', $fecha);
        $stmt->bindParam(':mes', $nuevomes);
        $stmt->bindParam(':numero', $nuevoNumero);

        // Ejecutar la consulta
        $stmt->execute();

        echo json_encode(['success' => true]);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'No se pudo conectar a la base de datos']);
}

$conexion->cerrar_conexion();
