<?php
include_once '../../model/model_conexion.php';

// Recibir los datos JSON
$json = file_get_contents('php://input');
$datos = json_decode($json, true);

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

if ($pdo) {

    $cedulaestudiante = $datos['cedulaestudiante'];
   
    try {
        // Preparar la consulta SQL
        $sql = "DELETE FROM asig_tutor WHERE CedulaEstudiante = :cestudiante"; 
      

        $stmt = $pdo->prepare($sql);

        // Vincular los parámetros/*
        $stmt->bindParam(':cestudiante', $cedulaestudiante);
       
        // Ejecutar la consulta
        $stmt->execute();

        echo json_encode(['success' => true]);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'No se pudo conectar a la base de datos']);
}

$conexion->cerrar_conexion();
?>