<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Conexión a la base de datos
    include_once '../../model/model_conexion.php';
    $conexion = new conexionBD();
    $pdo = $conexion->conexionPDO();

    $carpetaBase = 'fotopracticas/';
    
    if ($pdo) {
        $data = json_decode(file_get_contents("php://input"), true);
        
        // Capturar los datos enviados
        $idinfopractica = $data['idinfopractica'];  // Cambiado a idinfopractica
        $fecha = $data['fecha'];
        $actividades = $data['actividades'];
        $detalle = $data['detalle'];
        $horaIngreso = $data['horaIngreso'];
        $horaSalida = $data['horaSalida'];
        $horasEfectivas = $data['horasEfectivas'];
        $cedulaEstudiante = $data['cedulaEstudiante'];
        $idSemana= $data['semana'];

        $carpetaDestino = $carpetaBase . $cedulaEstudiante . '/semana_' . $idSemana . '/' . date('Y-m-d', strtotime($fecha));

        if (!file_exists($carpetaDestino)) {
            mkdir($carpetaDestino, 0777, true); // Crear la carpeta si no existe
        }

        // Verificar si se envían nuevas fotos o no
        $fotos = [];
        if (isset($data['fotos']) && is_array($data['fotos'])) {
            $contadorFotos = 1;
            foreach ($data['fotos'] as $fotoBase64) {
                // Decodificar la imagen base64
                $fotoData = explode(',', $fotoBase64); // Separar la metadata (si la tiene) de la imagen
                $foto = base64_decode($fotoData[1]);

                // Crear un nombre de archivo único para la foto
                $extension = 'jpg'; // Aquí se puede agregar lógica para determinar la extensión según el tipo MIME
                $newFileName = $cedulaEstudiante . '_' . $fecha . '_semana_' . $idSemana . '_foto_' . $contadorFotos++ . '.' . $extension;
                $destination = $carpetaDestino . '/' . $newFileName;

                // Guardar el archivo físico en el servidor
                file_put_contents($destination, $foto);

                // Agregar la ruta de la foto al array de fotos
                $fotos[] = $destination;

                $fotosJson = json_encode($fotos);
            }
        } else {
            // Si no hay nuevas fotos, no las modificamos
            $fotosJson = $data['fotos_previas']; // Asumimos que las fotos previas se pasan en el JSON
        }

        if (isset($data['fotos']) && is_array($data['fotos']) && !empty($data['fotos'])){
            $sql = "UPDATE infopractica SET fecha = :fecha, actividades = :actividades, detalle = :detalle, 
            hIngreso = :horaIngreso, hSalida = :horaSalida, hEfectiva = :horasEfectivas, fotos = :fotos 
            WHERE idInfopractica = :idinfopractica";  // Cambio a WHERE idinfopractica

    try {
        $query = $pdo->prepare($sql);
        $query->bindParam(':fecha', $fecha);
        $query->bindParam(':actividades', $actividades);
        $query->bindParam(':detalle', $detalle);
        $query->bindParam(':horaIngreso', $horaIngreso);
        $query->bindParam(':horaSalida', $horaSalida);
        $query->bindParam(':horasEfectivas', $horasEfectivas);
        $query->bindParam(':fotos', $fotosJson);
        $query->bindParam(':idinfopractica', $idinfopractica);  // Usamos idinfopractica aquí
        $query->execute();
        echo json_encode(['status' => 'success']);
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
        }else{
            $sql = "UPDATE infopractica SET fecha = :fecha, actividades = :actividades, detalle = :detalle, 
            hIngreso = :horaIngreso, hSalida = :horaSalida, hEfectiva = :horasEfectivas
            WHERE idInfopractica = :idinfopractica";  // Cambio a WHERE idinfopractica

    try {
        $query = $pdo->prepare($sql);
        $query->bindParam(':fecha', $fecha);
        $query->bindParam(':actividades', $actividades);
        $query->bindParam(':detalle', $detalle);
        $query->bindParam(':horaIngreso', $horaIngreso);
        $query->bindParam(':horaSalida', $horaSalida);
        $query->bindParam(':horasEfectivas', $horasEfectivas);
       
        $query->bindParam(':idinfopractica', $idinfopractica);  // Usamos idinfopractica aquí
        $query->execute();
        echo json_encode(['status' => 'success']);
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
        }

        // Actualización de los datos por idinfopractica
      
    } else {
        echo json_encode(['status' => 'error', 'message' => 'No se pudo conectar a la base de datos']);
    }
    $conexion->cerrar_conexion();
}
?>
