<?php
include_once '../model/model_conexion.php';

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

if (isset($_GET['id']) && !empty($_GET['id'])) {
  $encoded_id = $_GET['id'];
  $id = base64_decode($encoded_id);

  if ($pdo) {
    $sql = "SELECT so.cedulaEstudiante, so.NombreEstudiante, so.Carrera, so.Periodo, so.fInicio, so.fFin, pe.nEmpresa, pe.responsable, pe.cargo_empresa FROM solicitud so JOIN prac_empresa pe ON so.cedulaEstudiante = pe.cedulaEstudiante WHERE so.estado = 'APROBADO' AND pe.estado = 'APROBADO' AND so.idsolicitud = '" . $id . "'";

    try {
      $query = $pdo->prepare($sql);
      $query->execute();

      $resultados = $query->fetch(PDO::FETCH_ASSOC);

      if ($resultados) {
       $cedulae = isset($resultados['cedulaEstudiante']) ? str_pad($resultados['cedulaEstudiante'], 10, '0', STR_PAD_LEFT) : '';
        $nombrest = isset($resultados['NombreEstudiante']) ? $resultados['NombreEstudiante'] : '';
        $carrera = isset($resultados['Carrera']) ? $resultados['Carrera'] : '';
        $periodo = isset($resultados['Periodo']) ? $resultados['Periodo'] : '';
        $finicio = isset($resultados['fInicio']) ? $resultados['fInicio'] : '';
        $ffin = isset($resultados['fFin']) ? $resultados['fFin'] : '';
        $nempresa = isset($resultados['nEmpresa']) ? $resultados['nEmpresa'] : '';
        $responsable = isset($resultados['responsable']) ? $resultados['responsable'] : '';
        $cargo = isset($resultados['cargo_empresa']) ? $resultados['cargo_empresa'] : '';
      } else {
        echo "No se encontraron resultados";
      }
    } catch (PDOException $e) {
      echo "Error al ejecutar la consulta: " . $e->getMessage();
    }
  } else {
  }

  $conexion->cerrar_conexion();

?>

  <!DOCTYPE html>
  <html lang="en">

  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>SYVI | Admin</title>

    <!-- Google Font: Source Sans Pro -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="../plantilla/plugins/fontawesome-free/css/all.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="../plantilla/dist/css/adminlte.min.css">
    <link rel="stylesheet" type="text/css" href="../utilitario/DataTables/datatables.min.css" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="shortcut icon" href="img/cara1.jpeg" type="image/jpeg" />
  </head>

  <body class="hold-transition sidebar-mini">
    <div class="wrapper">

      <!-- Navbar -->
      <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <!-- Left navbar links -->
        <ul class="navbar-nav">
          <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
          </li>

        </ul>

        <!-- Right navbar links -->
        <ul class="navbar-nav ml-auto">
          <!-- Notifications Dropdown Menu -->
          <!--
      <li class="nav-item dropdown">
        
        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
          <span class="dropdown-header">15 Notifications</span>
          <div class="dropdown-divider"></div>
          <a href="#" class="dropdown-item">
            <i class="fas fa-envelope mr-2"></i> 4 new messages
            <span class="float-right text-muted text-sm">3 mins</span>
          </a>
          <div class="dropdown-divider"></div>
          <a href="#" class="dropdown-item">
            <i class="fas fa-users mr-2"></i> 8 friend requests
            <span class="float-right text-muted text-sm">12 hours</span>
          </a>
          <div class="dropdown-divider"></div>
          <a href="#" class="dropdown-item">
            <i class="fas fa-file mr-2"></i> 3 new reports
            <span class="float-right text-muted text-sm">2 days</span>
          </a>
          <div class="dropdown-divider"></div>
          <a href="#" class="dropdown-item dropdown-footer">See All Notifications</a>
        </div>
      </li>-->
          <!-- Notifications Dropdown Menu -->
        </ul>
      </nav>
      <!-- /.navbar -->

      <!-- Main Sidebar Container -->
      <aside class="main-sidebar elevation-4" style="background-color:#21376D;font-weight:bold">
        <!-- Brand Logo -->
        <a class="brand-link">
          <img src="img/cara2.png" alt="AdminLTE Logo" class="brand-image elevation-3" style="opacity: .8">
          <span class="brand-text text-white fw-bold">PRACTICAS</span>
        </a>

        <!-- Sidebar -->
        <div class="sidebar">
          <!-- Sidebar user panel (optional) -->
          <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <!-- <div class="image">
          <img src="../plantilla/dist/img/user2-160x160.jpg" class="img-circle elevation-2" alt="User Image">
        </div>-->
            <div class="info">
              <a href="" class="d-block"></a>
            </div>
          </div>

          <!-- SidebarSearch Form -->
          <div class="form-inline">

          </div>
        </div>
        <!-- /.sidebar -->
      </aside>

      <!-- Content Wrapper. Contains page content -->
      <div class="content-wrapper" id="contenido_principal">
        <!-- Content Header (Page header) -->
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-6">
                <h1 class="m-0">SEGUIMIENTO DE ACTIVIDADES EN LA ENTIDAD RECEPTORA</h1>
              </div><!-- /.col -->
            </div><!-- /.row -->
          </div><!-- /.container-fluid -->
        </div>
        <div class="col-12">
          <div class="row">
            <div class="col-md-12">
              <div class="card card-primary">
                <div class="card-header">
                  <h3 class="card-title"><b>Información de la Institución</h3><b>
                </div>
                <div class="card-body">
                  <div class="row">
                    <div class="col-6 form-group">
                      <label for="" style="font-size:small;">NOMBRES Y APELLIDOS DEL ESTUDIANTE </label>
                      <input class="form-control" id="txt_estudiante" style="width:100%" value="<?php echo $nombrest; ?>" placeholder="Nombres y Apellidos del Estudiantes" readonly>
                    </div>
                    <div class="col-6 form-group">
                      <label for="" style="font-size:small;">CARRERA</label>
                      <input class="form-control" id="txt_carrera" style="width:100%" value="<?php echo $carrera; ?>" readonly>

                    </div>
                    <div class="col-6 form-group">
                      <label for="" style="font-size:small;">FECHA DE EVALUACION</label>
                      <input type="date" class="form-control" id="txt_fechae" style="width:100%" required>
                    </div>
                    <div class="col-6 form-group">
                      <label for="" style="font-size:small;">PERIODO ACADEMICO DEL ESTUDIANTE</label>
                      <input class="form-control" id="txt_periodoacademico" style="width:100%" value="<?php echo $periodo; ?>" readonly>
                    </div>
                    <div class="col-6 form-group ">
                      <label for="" style="font-size:small;">FECHA DE INICIO Y DE FIN DE LAS PPP</label>
                      <div class="d-flex justify-content-between">
                        <input type="text" class="form-control" id="txt_fechainicio" style="width:30%" value="<?php echo $finicio; ?>" readonly>
                        <label for=""> hasta </label>
                        <input type="text" class="form-control" id="txt_fechafin" style="width:30%" value="<?php echo $ffin; ?>" readonly>
                      </div>
                    </div>
                    <div class="col-6 form-group">
                      <label for="" style="font-size:small;">NOMBRE DE LA ENTIDAD RECEPTORA</label>
                      <input class="form-control" id="txt_nombreentidad" style="width:100%" placeholder="Nombre de la Entidad Receptora" value="<?php echo $nempresa; ?>" readonly>
                    </div>
                    <div class="col-6 form-group">
                      <label for="" style="font-size:small;">NOMBRES Y APELLIDOS DEL EVALUADOR</label>
                      <input class="form-control" id="txt_evaluador" style="width:100%" placeholder="Nombres y Apellidos del Evaluador" value="<?php echo $responsable; ?>" readonly>
                    </div>
                    <div class="col-6 form-group">
                      <label for="" style="font-size:small;">CARGO DEL EVALUADOR DENTRO DE LA ENTIDAD</label>
                      <input class="form-control" id="txt_cargoevaluador" style="width:100%" placeholder="Cargo del Evaluador dentro de la Entidad" value="<?php echo $cargo; ?>" readonly>
                    </div>
                    <div class="table-responsive">
                      <table class="table table-bordered table-hover">
                        <thead>
                          <tr>
                            <th colspan="3">1.- EVALUACION DE CONOCIMIENTOS GENERALES</th>
                          </tr>
                        </thead>
                        <tbody>
                          <tr>
                            <td style="width: 30%;">
                              <label for="">PARAMETRO GENERAL </label>
                            </td>
                            <td style="width: 40%;">
                              <label for="">PARAMETROS ESPECIFICOS </label>
                            </td>
                            <td>
                              <label for="">PUNTAJE (CALIFICAR DEL 1 AL 10) </label>
                            </td>
                          </tr>
                          <tr>
                            <td class="align-middle text-center" rowspan="6">
                              <label style="font-weight: normal;" for="">Los conocimientos generales asignados son evaluados con los siguientes criterios:</label>
                            </td>
                            <td>
                              <label style="font-weight: normal;" for="">Calidad del trabajo realizado</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_calidadtra" onchange="actualizarSuma()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>
                          </tr>
                          <tr>

                            <td>
                              <label style="font-weight: normal;" for="">Grado de independencia</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_gradoin" onchange="actualizarSuma()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>
                          </tr>
                          <tr>

                            <td>
                              <label style="font-weight: normal;" for="">El estudiante demuestra conocimientos en el área de práctica pre-profesional</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_conocimientos" onchange="actualizarSuma()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>

                          </tr>
                          <tr>

                            <td>
                              <label style="font-weight: normal;" for="">Utiliza los recursos necesarios en las tareas asignadas</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_recursos" onchange="actualizarSuma()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>

                          </tr>
                          <tr>

                            <td>
                              <label style="font-weight: normal;" for="">Aplicación y manejo de destrezas y habilidades acordes al plan de aprendizaje.</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_aplicacion" onchange="actualizarSuma()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>

                            </td>
                          </tr>
                          <tr>

                            <td>
                              <label style="font-weight: normal;" for="">Habilidades en el uso de las Tecnologías de la Información y la Comunicación.</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_habilidades" onchange="actualizarSuma()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>
                          </tr>
                          <tr>
                            <td colspan="2" style="text-align:center;">
                              <label for="" class="calculo">PROMEDIO DE LOS PUNTAJES</label>

                            </td>
                            <td>
                              <input type="text" class="form-control" name="promedio1" id="promedio1" placeholder="0" readonly>
                            </td>
                          </tr>
                          <tr>
                            <th colspan="3">2.- EVALUACION DE CAPACIDADES</th>
                          </tr>
                          <tr>
                            <td>
                              <label for="">PARAMETRO GENERAL </label>
                            </td>
                            <td>
                              <label for="">PARAMETROS ESPECIFICOS </label>
                            </td>
                            <td>
                              <label for="">PUNTAJE (CALIFICAR DEL 1 AL 10) </label>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label style="font-weight: normal;" for="">Comprensión del trabajo</label>
                            </td>
                            <td>
                              <label style="font-weight: normal;" for="">Capacidad de entender instrucciones y explicaciones dadas para el desarrollo</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_instrucciones" onchange="actualizarSuma2()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label style="font-weight: normal;" for="">Asimilación del trabajo</label>
                            </td>
                            <td>
                              <label style="font-weight: normal;" for="">Capacidad de retener y hacer suyos los
                                conocimientos que se adquieren en el trabajo</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_retener" onchange="actualizarSuma2()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label style="font-weight: normal;" for="">Expresión</label>
                            </td>
                            <td>
                              <label style="font-weight: normal;" for="">Capacidad de expresar ideas tanto verbalmente como por escrito</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_expresar" onchange="actualizarSuma2()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label style="font-weight: normal;" for="">Iniciativa</label>
                            </td>
                            <td>
                              <label style="font-weight: normal;" for="">Capacidad de generar ideas y acciones pertinentes al trabajo, más allá de las instrucciones y explicaciones recibidas</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_ideas" onchange="actualizarSuma2()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label style="font-weight: normal;" for="">Respuesta</label>
                            </td>
                            <td>
                              <label style="font-weight: normal;" for="">Capacidad para identificar, planear y resolver problemas en el área práctica</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_identificar" onchange="actualizarSuma2()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>
                            </td>
                          </tr>
                          <tr>
                            <td colspan="2" style="text-align:center;">
                              <label for="" class="calculo">PROMEDIO DE LOS PUNTAJES</label>
                            </td>
                            <td>
                              <input type="text" class="form-control" name="promedio2" id="promedio2" placeholder="0" readonly>
                            </td>

                          </tr>

                          <tr>
                            <th colspan="3">3.- EVALUACION DE ACTITUDES Y COMPORTAMIENTO</th>
                          </tr>
                          <tr>
                            <td>
                              <label for="">PARAMETRO GENERAL </label>
                            </td>
                            <td>
                              <label for="">PARAMETROS ESPECIFICOS </label>
                            </td>
                            <td>
                              <label for="">PUNTAJE (CALIFICAR DEL 1 AL 10) </label>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label style="font-weight: normal;" for="">Responsabilidad</label>
                            </td>
                            <td>
                              <label style="font-weight: normal;" for="">Actitud que induce a ejecutar el trabajo con atención y esmero, haciéndose responsable de las
                                acciones y resultados</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_ejecutar" onchange="actualizarSuma3()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label style="font-weight: normal;" for="">Dedicación:</label>
                            </td>
                            <td>
                              <label style="font-weight: normal;" for="">Ejecución del trabajo con interés, de principio a fin, no por salir del paso</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_interes" onchange="actualizarSuma3()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label style="font-weight: normal;" for="">Calidad de ejecución</label>
                            </td>
                            <td>
                              <label style="font-weight: normal;" for="">Interés en hacer las cosas bien</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_bien" onchange="actualizarSuma3()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label style="font-weight: normal;" for="">Normas internas</label>
                            </td>
                            <td>
                              <label style="font-weight: normal;" for="">Sigue las políticas y normas internas de la empresa</label>
                            </td>
                            <td>
                              <select class="form-control" id="txt_politicas" onchange="actualizarSuma3()" required>
                                <option value="" selected disabled>Seleccione</option>
                                <?php
                                for ($i = 1; $i <= 10; $i++) {
                                  echo "<option value=\"$i\">$i</option>";
                                }
                                ?>
                              </select>
                            </td>
                          </tr>
                          <tr>
                            <td colspan="2" style="width: 50%; text-align:center;">
                              <label for="" class="calculo">PROMEDIO DE LOS PUNTAJES</label>

                            </td>
                            <td>
                              <input type="text" class="form-control" name="promedio3" id="promedio3" placeholder="0" readonly>

                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label class="calculo" for="">PUNTAJE FINAL</label>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label for="">Puntaje total en la evaluación de conocimientos
                                generales (ítem 1)</label>
                            </td>
                            <td>
                              <input type="text" class="form-control" name="txt_promedio" id="txt_promedio" placeholder="0" readonly>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label for="">Puntaje total en la evaluación de capacidades
                                (ítem 2)</label>
                            </td>
                            <td>
                              <input type="text" class="form-control" name="txt_promedio2" id="txt_promedio2" placeholder="0" readonly>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label for="">Puntaje total en la evaluación de actitudes y
                                comportamiento (ítem 3)</label>
                            </td>
                            <td>
                              <input type="text" class="form-control" name="txt_promedio3" id="txt_promedio3" placeholder="0" readonly>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label class="calculo">SUMA DE TOTALES (sumar los 3 ítems)</label>
                            </td>
                            <td>
                              <input type="text" class="form-control" name="txt_suma" id="txt_suma" placeholder="0" readonly>
                            </td>
                          </tr>

                          <tr>
                            <td>
                              <label for="">NOTA FINAL DE LA EVALUACIÓN DEL DESEMPEÑO</label>
                            </td>
                            <td>
                              <input class="form-control" type="text" name="txt_final" id="txt_final" placeholder="0" readonly>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label for="" class="">OBSERVACIONES</label>

                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label for="" class="">¿Cuáles son las observaciones positivas o negativas que hay que mencionar, y cuáles son
                                los comentarios y las sugerencias específicas que debe recibir el estudiante para poder
                                mejorar y optimizar su proceso de aprendizaje y comportamiento?</label>

                            </td>
                            <td>
                              <textarea class="form-control" style="width: 100%;" name="txt_observaciones" id="txt_observaciones"></textarea>
                            </td>
                          </tr>
                          <tr>

                            <td>
                              <label for="" class="">De acuerdo a las fortalezas y debilidades del estudiante ¿Qué medidas se deben iniciar para
                                mejorar a corto plazo el desempeño del estudiante?</label>
                            </td>
                            <td>
                              <textarea class="form-control" style="width: 100%;" name="txt_fortalezas" id="txt_fortalezas"></textarea>
                            </td>
                          </tr>
                          <tr>
                            <td>
                              <label for="" class="">¿Tiene una propuesta sobre un desarrollo específico sobre fortalezas y potencialidades del
                                estudiante?</label>
                            </td>
                            <td>
                              <textarea class="form-control" style="width: 100%;" name="txt_propuesta" id="txt_propuesta"></textarea>
                            </td>
                          </tr>
                           <tr>
                            <td>
                              <label for="" class="">Insertar Certificado de la Entidad Receptora<br> <a href="https://docs.google.com/document/d/101hpkcU0SfBBjiQ22Vci0xuA2Q39dt4R/edit?usp=sharing&ouid=100056608300897827766&rtpof=true&sd=true" target="_blank" style="color:blue">Descargar Certificado</a></label>
                            </td>
                            <td>
                              <input type="file" class="form-control" style="width: 100%;" name="txt_ficha" id="txt_ficha" accept="application/pdf" required>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
                  <div class="col text-right">
                    <button class="btn btn-lg bg-primary" onclick="guardarDatos()">Enviar</button>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
      <!-- /.content-wrapper -->

      <!-- Control Sidebar -->
      <aside class="control-sidebar control-sidebar-dark">
        <!-- Control sidebar content goes here -->
        <div class="p-3">
        </div>
      </aside>
      <!-- /.control-sidebar -->

      <!-- Main Footer -->
      <footer class="main-footer">
        <!-- To the right -->
        <div class="float-right d-none d-sm-inline">

        </div>
        <!-- Default to the left -->
        <strong>Copyright &copy; 2025 <a href="https://itred.edu.ec" target="_blank">ITRED.COM</a>.</strong> Todos los Derechos Reservados.
      </footer>
    </div>
    <!-- ./wrapper -->
  <?php
}
  ?>
  <!-- REQUIRED SCRIPTS -->
  <script>
    function initializeInputs() {
      document.getElementById('txt_suma').value = '0';
      document.getElementById('txt_final').value = '0';
      document.getElementById('promedio1').value = '0';
    }

    window.addEventListener('load', initializeInputs);

    function promedio() {
      // Obtiene los valores de los inputs
      const num1 = parseFloat(document.getElementById('txt_calidadtra').value) || 0;
      const num2 = parseFloat(document.getElementById('txt_gradoin').value) || 0;
      const num3 = parseFloat(document.getElementById('txt_conocimientos').value) || 0;
      const num4 = parseFloat(document.getElementById('txt_recursos').value) || 0;
      const num5 = parseFloat(document.getElementById('txt_aplicacion').value) || 0;
      const num6 = parseFloat(document.getElementById('txt_habilidades').value) || 0;

      // Realiza la suma
      const resultado = num1 + num2 + num3 + num4 + num5 + num6;
      // Calcula el promedio
      const promedio = resultado / 6;
      // Redondea el promedio a dos decimales
      const promedioConDosDecimales = promedio.toFixed(2);
      // Muestra el resultado en el input de resultado
      document.getElementById('promedio1').value = promedioConDosDecimales;
      document.getElementById('txt_promedio').value = promedioConDosDecimales;

      const total1 = parseFloat(document.getElementById('txt_promedio').value) || 0;
      const total2 = parseFloat(document.getElementById('txt_promedio2').value) || 0;
      const total3 = parseFloat(document.getElementById('txt_promedio3').value) || 0;

      if (total1 !== 0 && total2 !== 0 && total3 !== 0) {

        const sumatotal = total1 + total2 + total3;

        const total = sumatotal / 3;

        const totalConDosDecimales = total.toFixed(2);

        document.getElementById('txt_suma').value = sumatotal;
        document.getElementById('txt_final').value = totalConDosDecimales;

      }

    }

    // Función que se ejecuta cuando se cambia el valor del select
    function actualizarSuma() {
      // Llamamos a la función sumar cuando se cambie el select
      promedio();
    }

    function promedio2() {
      // Obtiene los valores de los inputs
      const num7 = parseFloat(document.getElementById('txt_instrucciones').value) || 0;
      const num8 = parseFloat(document.getElementById('txt_retener').value) || 0;
      const num9 = parseFloat(document.getElementById('txt_expresar').value) || 0;
      const num10 = parseFloat(document.getElementById('txt_ideas').value) || 0;
      const num11 = parseFloat(document.getElementById('txt_identificar').value) || 0;

      // Realiza la suma
      const resultado2 = num7 + num8 + num9 + num10 + num11;
      // Calcula el promedio
      const promedio2 = resultado2 / 5;
      // Redondea el promedio a dos decimales
      const promedioConDosDecimales2 = promedio2.toFixed(2);
      // Muestra el resultado en el input de resultado
      document.getElementById('promedio2').value = promedioConDosDecimales2;
      document.getElementById('txt_promedio2').value = promedioConDosDecimales2;

      const total1 = parseFloat(document.getElementById('txt_promedio').value) || 0;
      const total2 = parseFloat(document.getElementById('txt_promedio2').value) || 0;
      const total3 = parseFloat(document.getElementById('txt_promedio3').value) || 0;

      if (total1 !== 0 && total2 !== 0 && total3 !== 0) {

        const sumatotal = total1 + total2 + total3;

        const total = sumatotal / 3;

        const totalConDosDecimales = total.toFixed(2);

        document.getElementById('txt_suma').value = sumatotal;
        document.getElementById('txt_final').value = totalConDosDecimales;

      }

    }

    // Función que se ejecuta cuando se cambia el valor del select
    function actualizarSuma2() {
      // Llamamos a la función sumar cuando se cambie el select
      promedio2();
    }

    function promedio3() {
      // Obtiene los valores de los inputs
      const num13 = parseFloat(document.getElementById('txt_ejecutar').value) || 0;
      const num14 = parseFloat(document.getElementById('txt_interes').value) || 0;
      const num15 = parseFloat(document.getElementById('txt_bien').value) || 0;
      const num16 = parseFloat(document.getElementById('txt_politicas').value) || 0;

      // Realiza la suma
      const resultado3 = num13 + num14 + num15 + num16;
      // Calcula el promedio
      const promedio3 = resultado3 / 4;
      // Redondea el promedio a dos decimales
      const promedioConDosDecimales3 = promedio3.toFixed(2);
      // Muestra el resultado en el input de resultado
      document.getElementById('promedio3').value = promedioConDosDecimales3;
      document.getElementById('txt_promedio3').value = promedioConDosDecimales3;

      const total1 = parseFloat(document.getElementById('txt_promedio').value) || 0;
      const total2 = parseFloat(document.getElementById('txt_promedio2').value) || 0;
      const total3 = parseFloat(document.getElementById('txt_promedio3').value) || 0;

      if (total1 !== 0 && total2 !== 0 && total3 !== 0) {

        const sumatotal = total1 + total2 + total3;

        const total = sumatotal / 3;

        const totalConDosDecimales = total.toFixed(2);

        document.getElementById('txt_suma').value = sumatotal;
        document.getElementById('txt_final').value = totalConDosDecimales;

      }

    }

    // Función que se ejecuta cuando se cambia el valor del select
    function actualizarSuma3() {
      // Llamamos a la función sumar cuando se cambie el select
      promedio3();
    }

   function guardarDatos() {
  // Recopilar todos los datos del formulario
  var archivo = document.getElementById('txt_ficha').files[0];

  // Validar si el archivo ha sido seleccionado
  if (!archivo) {
    Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'Por favor selecciona un archivo PDF.',
      confirmButtonText: 'Aceptar'
    });
    return;
  }

  // Validar el tamaño del archivo (10 MB = 10,485,760 bytes)
  var maxSize = 10 * 1024 * 1024; // 10 MB en bytes
  if (archivo.size > maxSize) {
    Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'El archivo es demasiado grande. El tamaño máximo permitido es de 10 MB.',
      confirmButtonText: 'Aceptar'
    });
    return;
  }

  // Validar que el archivo sea un PDF
  if (!archivo.name.toLowerCase().endsWith('.pdf')) {
    Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'Por favor selecciona un archivo PDF válido.',
      confirmButtonText: 'Aceptar'
    });
    return;
  }

  // Validar que los campos del formulario estén llenos (excepto observaciones)
  var camposRequeridos = [
    'txt_fechae', 
    'txt_calidadtra', 
    'txt_gradoin', 
    'txt_conocimientos',
    'txt_recursos',
    'txt_aplicacion',
    'txt_habilidades',
    'txt_instrucciones',
    'txt_retener',
    'txt_expresar',
    'txt_ideas',
    'txt_identificar',
    'txt_ejecutar',
    'txt_interes',
    'txt_bien',
    'txt_politicas'
  ];

  // Recorremos los campos requeridos para asegurarnos de que no estén vacíos
  for (let campo of camposRequeridos) {
    var valor = document.getElementById(campo).value.trim();
    if (valor === '') {
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: 'Por favor, llena todos los campos requeridos.',
        confirmButtonText: 'Aceptar'
      });
      return;
    }
  }

  // Crear un objeto FormData para enviar los datos
  var formData = new FormData();
  formData.append('id', <?php echo $id ?>);
  formData.append('estudiante', '<?php echo addslashes($cedulae); ?>');
  formData.append('fechaEvaluacion', document.getElementById('txt_fechae').value);

  formData.append('p1p1', document.getElementById('txt_calidadtra').value);
  formData.append('p1p2', document.getElementById('txt_gradoin').value);
  formData.append('p1p3', document.getElementById('txt_conocimientos').value);
  formData.append('p1p4', document.getElementById('txt_recursos').value);
  formData.append('p1p5', document.getElementById('txt_aplicacion').value);
  formData.append('p1p6', document.getElementById('txt_habilidades').value);

  formData.append('p2p1', document.getElementById('txt_instrucciones').value);
  formData.append('p2p2', document.getElementById('txt_retener').value);
  formData.append('p2p3', document.getElementById('txt_expresar').value);
  formData.append('p2p4', document.getElementById('txt_ideas').value);
  formData.append('p2p5', document.getElementById('txt_identificar').value);

  formData.append('p3p1', document.getElementById('txt_ejecutar').value);
  formData.append('p3p2', document.getElementById('txt_interes').value);
  formData.append('p3p3', document.getElementById('txt_bien').value);
  formData.append('p3p4', document.getElementById('txt_politicas').value);

  // Los campos de observaciones no son requeridos
  formData.append('ob1', document.getElementById('txt_observaciones').value);
  formData.append('ob2', document.getElementById('txt_fortalezas').value);
  formData.append('ob3', document.getElementById('txt_propuesta').value);

  formData.append('archivo', archivo);
  
  console.log(<?php echo $cedulae; ?>);

  // Enviar los datos al servidor
  fetch('ingreso/ingreso_seguimiento.php', {
    method: 'POST',
    body: formData
  })
  .then(response => response.json())
  .then(data => {
    if (data.success) {
      // Mensaje de éxito con SweetAlert
      Swal.fire({
        icon: 'success',
        title: 'Éxito',
        text: 'Datos guardados correctamente',
        confirmButtonText: 'Aceptar'
      }).then(() => {
        // Redirigir a index.html después del mensaje de éxito
        window.location.href = '../index.php';
      });
    } else {
      // Mensaje de error con SweetAlert
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: 'Error al guardar los datos: ' + data.message,
        confirmButtonText: 'Aceptar'
      });
    }
  })
  .catch((error) => {
    console.error('Error:', error);
    // Mensaje de error si ocurre algún fallo en la solicitud
    Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'Error al guardar los datos',
      confirmButtonText: 'Aceptar'
    });
  });
}
  </script>
  <!-- jQuery -->
  <script src="../plantilla/plugins/jquery/jquery.min.js"></script>
  <!-- Bootstrap 4 -->
  <script src="../plantilla/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

  <script src="../plantilla/dist/js/adminlte.min.js"></script>
  <script type="text/javascript" src="../utilitario/DataTables/datatables.min.js"></script>
  <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <script type="text/javascript" src="../js/console_webapi.js"></script>
  <script>
    obtener_tokens();
    <?php if ($_SESSION['S_ROL'] == 'Administrador') { ?>
      Traer_Widget();

      function Traer_Widget() {
        $.ajax({
          "url": "../controller/usuario/controlador_traer_widget.php",
          type: 'POST'
        }).done(function(resp) {

          let data = JSON.parse(resp);
          if (data.length > 0) {
            document.getElementById('lbl_tramite').innerHTML = data[0][0];
            document.getElementById('lbl_tramite_finalizado').innerHTML = data[0][1];
          }
        })
      }
    <?php
    }
    ?>
  </script>

  </body>

  </html>