<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
if (!isset($_SESSION['S_ID'])) {
    header('Location: ../index.php');
}
$id_usuario = $_SESSION['S_ID'];
?>
<script src="../js/console_tramite.js?rev=<?php echo time(); ?>"></script>
<link rel="stylesheet" href="../plantilla/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.css">

<!-- Content Header (Page header) -->

<style>
    #loading-screen {
        position: fixed;
        width: 100%;
        height: 100%;
        background: #fff;
        z-index: 9999;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        border: 16px solid #f3f3f3;
        border-top: 16px solid #17285e;
        border-radius: 50%;
        width: 120px;
        height: 120px;
        animation: spin 2s linear infinite;
    }

    .black-text {
        font-weight: bold;
    }

    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }
</style>

<div id="loading-screen">
    <div class="spinner"></div>
</div>

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">SEGUIMIENTO DE ACTIVIDADES EN LA ENTIDAD RECEPTORA</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Inicio</a></li>
                    <li class="breadcrumb-item active">DOC.</li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<?php
include_once '../../model/model_conexion.php';

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

$id=$_GET['id'];

if ($pdo) {
    $sql = "SELECT so.cedulaEstudiante, pe.nEmpresa, pe.responsable, pe.cargo_empresa FROM solicitud AS so JOIN prac_empresa AS pe ON so.cedulaEstudiante = pe.cedulaEstudiante WHERE so.estado = 'APROBADO' AND pe.estado= 'APROBADO' AND so.idsolicitud = '".$id."'";

    try {
        $query = $pdo->prepare($sql);
        $query->execute();

        $resultados = $query->fetch(PDO::FETCH_ASSOC);

        if ($resultados) {
            $cedula = isset($resultados['cedulaEstudiante']) ? $resultados['cedulaEstudiante'] : '';
            $nempresa = isset($resultados['nEmpresa']) ? $resultados['nEmpresa'] : '';
            $rempresa = isset($resultados['responsable']) ? $resultados['responsable'] : '';
            $cempresa = isset($resultados['cargo_empresa']) ? $resultados['cargo_empresa'] : '';
        } else {
            echo "No se encontraron resultados para el estudiante con CedulaEstudiante '0920121928'.";
        }
    } catch (PDOException $e) {
        echo "Error al ejecutar la consulta: " . $e->getMessage();
    }
} else {
}

$conexion->cerrar_conexion();
?>
<div class="col-12">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title"><b>Información de la Institución</h3><b>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">NOMBRES Y APELLIDOS DEL ESTUDIANTE </label>
                            <input class="form-control" id="txt_estudiante" style="width:100%" placeholder="Nombres y Apellidos del Estudiantes" required>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">CARRERA</label>
                            <select class="form-control" id="txt_carrera" style="width:100%" required>
                                <option value="" selected disabled>Seleccione</option>
                                <option value="1">1</option>
                                <option value="2">2</option>
                            </select>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">PROMOCION:</label>
                            <!-- <textarea  id="txt_asunto" rows="3" class="form-control" style="resize:none"></textarea>-->
                            <select class="form-control" id="txt_promocion" style="width:100%" required>
                                <option value="" selected disabled>Seleccione</option>
                                <option value="1">1</option>
                                <option value="2">2</option>
                            </select>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">FECHA DE EVALUACION</label>
                            <input type="date" class="form-control" id="txt_fechae" style="width:100%" required>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">PERIODO ACADEMICO DEL ESTUDIANTE</label>
                            <select class="form-control" id="txt_periodoacademico" style="width:100%" required>
                                <option value="" selected disabled>Seleccione</option>
                                <option value="1">1</option>
                                <option value="2">2</option>
                            </select>
                        </div>
                        <div class="col-6 form-group ">
                            <label for="" style="font-size:small;">FECHA DE INICIO Y DE FIN DE LAS PPP</label>
                            <div class="d-flex justify-content-between">
                                <input type="date" class="form-control" id="txt_fechainicio" style="width:50%" required>
                                <input type="date" class="form-control" id="txt_fechafin" style="width:50%" required>
                            </div>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">NOMBRE DE LA ENTIDAD RECEPTORA</label>
                            <input class="form-control" id="txt_nombreentidad" style="width:100%" placeholder="Nombre de la Entidad Receptora" required>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">NOMBRES Y APELLIDOS DEL EVALUADOR</label>
                            <input class="form-control" id="txt_evaluador" style="width:100%" placeholder="Nombres y Apellidos del Evaluador" required>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">CARGO DEL EVALUADOR DENTRO DE LA ENTIDAD</label>
                            <input class="form-control" id="txt_cargoevaluador" style="width:100%" placeholder="Cargo del Evaluador dentro de la Entidad" required>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th colspan="3">1.- EVALUACION DE CONOCIMIENTOS GENERALES</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="width: 30%;">
                                            <label for="">PARAMETRO GENERAL </label>
                                        </td>
                                        <td style="width: 40%;">
                                            <label for="">PARAMETROS ESPECIFICOS </label>
                                        </td>
                                        <td>
                                            <label for="">PUNTAJE (CALIFICAR DEL 1 AL 10) </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="align-middle text-center" rowspan="6">
                                            <label style="font-weight: normal;" for="">Los conocimientos generales asignados son evaluados con los siguientes criterios:</label>
                                        </td>
                                        <td>
                                            <label style="font-weight: normal;" for="">Calidad del trabajo realizado</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_calidadtra" onchange="actualizarSuma()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>

                                        <td>
                                            <label style="font-weight: normal;" for="">Grado de independencia</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_gradoin" onchange="actualizarSuma()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>

                                        <td>
                                            <label style="font-weight: normal;" for="">El estudiante demuestra conocimientos en el área de práctica pre-profesional</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_conocimientos" onchange="actualizarSuma()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>

                                    </tr>
                                    <tr>

                                        <td>
                                            <label style="font-weight: normal;" for="">Utiliza los recursos necesarios en las tareas asignadas</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_recursos" onchange="actualizarSuma()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>

                                    </tr>
                                    <tr>

                                        <td>
                                            <label style="font-weight: normal;" for="">Aplicación y manejo de destrezas y habilidades acordes al plan de aprendizaje.</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_aplicacion" onchange="actualizarSuma()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>

                                        <td>
                                            <label style="font-weight: normal;" for="">Habilidades en el uso de las Tecnologías de la Información y la Comunicación.</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_habilidades" onchange="actualizarSuma()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="text-align:center;">
                                            <label for="" class="calculo">PROMEDIO DE LOS PUNTAJES</label>

                                        </td>
                                        <td>
                                            <input type="text" class="form-control" name="promedio1" id="promedio1" placeholder="0" readonly>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th colspan="3">2.- EVALUACION DE CAPACIDADES</th>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label for="">PARAMETRO GENERAL </label>
                                        </td>
                                        <td>
                                            <label for="">PARAMETROS ESPECIFICOS </label>
                                        </td>
                                        <td>
                                            <label for="">PUNTAJE (CALIFICAR DEL 1 AL 10) </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label style="font-weight: normal;" for="">Comprensión del trabajo</label>
                                        </td>
                                        <td>
                                            <label style="font-weight: normal;" for="">Capacidad de entender instrucciones y explicaciones dadas para el desarrollo</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_instrucciones" onchange="actualizarSuma2()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label style="font-weight: normal;" for="">Asimilación del trabajo</label>
                                        </td>
                                        <td>
                                            <label style="font-weight: normal;" for="">Capacidad de retener y hacer suyos los
                                                conocimientos que se adquieren en el trabajo</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_retener" onchange="actualizarSuma2()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label style="font-weight: normal;" for="">Expresión</label>
                                        </td>
                                        <td>
                                            <label style="font-weight: normal;" for="">Capacidad de expresar ideas tanto verbalmente como por escrito</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_expresar" onchange="actualizarSuma2()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label style="font-weight: normal;" for="">Iniciativa</label>
                                        </td>
                                        <td>
                                            <label style="font-weight: normal;" for="">Capacidad de generar ideas y acciones pertinentes al trabajo, más allá de las instrucciones y explicaciones recibidas</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_ideas" onchange="actualizarSuma2()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label style="font-weight: normal;" for="">Respuesta</label>
                                        </td>
                                        <td>
                                            <label style="font-weight: normal;" for="">Capacidad para identificar, planear y resolver problemas en el área práctica</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_identificar" onchange="actualizarSuma2()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="text-align:center;">
                                            <label for="" class="calculo">PROMEDIO DE LOS PUNTAJES</label>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" name="promedio2" id="promedio2" placeholder="0" readonly>
                                        </td>

                                    </tr>

                                    <tr>
                                        <th colspan="3">3.- EVALUACION DE ACTITUDES Y COMPORTAMIENTO</th>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label for="">PARAMETRO GENERAL </label>
                                        </td>
                                        <td>
                                            <label for="">PARAMETROS ESPECIFICOS </label>
                                        </td>
                                        <td>
                                            <label for="">PUNTAJE (CALIFICAR DEL 1 AL 10) </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label style="font-weight: normal;" for="">Responsabilidad</label>
                                        </td>
                                        <td>
                                            <label style="font-weight: normal;" for="">Actitud que induce a ejecutar el trabajo con atención y esmero, haciéndose responsable de las
                                                acciones y resultados</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_ejecutar" onchange="actualizarSuma3()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label style="font-weight: normal;" for="">Dedicación:</label>
                                        </td>
                                        <td>
                                            <label style="font-weight: normal;" for="">Ejecución del trabajo con interés, de principio a fin, no por salir del paso</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_interes" onchange="actualizarSuma3()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label style="font-weight: normal;" for="">Calidad de ejecución</label>
                                        </td>
                                        <td>
                                            <label style="font-weight: normal;" for="">Interés en hacer las cosas bien</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_bien" onchange="actualizarSuma3()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label style="font-weight: normal;" for="">Normas internas</label>
                                        </td>
                                        <td>
                                            <label style="font-weight: normal;" for="">Sigue las políticas y normas internas de la empresa</label>
                                        </td>
                                        <td>
                                            <select class="form-control" id="txt_politicas" onchange="actualizarSuma3()" required>
                                                <option value="" selected disabled>Seleccione</option>
                                                <?php
                                                for ($i = 1; $i <= 10; $i++) {
                                                    echo "<option value=\"$i\">$i</option>";
                                                }
                                                ?>
                                            </select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="width: 50%; text-align:center;">
                                            <label for="" class="calculo">PROMEDIO DE LOS PUNTAJES</label>

                                        </td>
                                        <td>
                                            <input type="text" class="form-control" name="promedio3" id="promedio3" placeholder="0" readonly>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label class="calculo" for="">PUNTAJE FINAL</label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label for="">Puntaje total en la evaluación de conocimientos
                                                generales (ítem 1)</label>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" name="txt_promedio" id="txt_promedio" placeholder="0" readonly>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label for="">Puntaje total en la evaluación de capacidades
                                                (ítem 2)</label>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" name="txt_promedio2" id="txt_promedio2" placeholder="0" readonly>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label for="">Puntaje total en la evaluación de actitudes y
                                                comportamiento (ítem 3)</label>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" name="txt_promedio3" id="txt_promedio3" placeholder="0" readonly>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label class="calculo">SUMA DE TOTALES (sumar los 3 ítems)</label>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" name="txt_suma" id="txt_suma" placeholder="0" readonly>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <label for="">NOTA FINAL DE LA EVALUACIÓN DEL DESEMPEÑO</label>
                                        </td>
                                        <td>
                                            <input class="form-control" type="text" name="txt_final" id="txt_final" placeholder="0" readonly>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label for="" class="">OBSERVACIONES</label>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label for="" class="">¿Cuáles son las observaciones positivas o negativas que hay que mencionar, y cuáles son
                                                los comentarios y las sugerencias específicas que debe recibir el estudiante para poder
                                                mejorar y optimizar su proceso de aprendizaje y comportamiento?</label>

                                        </td>
                                        <td>
                                            <textarea class="form-control" style="width: 100%;" name="txt_observaciones" id="txt_observaciones"></textarea>
                                        </td>
                                    </tr>
                                    <tr>

                                        <td>
                                            <label for="" class="">De acuerdo a las fortalezas y debilidades del estudiante ¿Qué medidas se deben iniciar para
                                                mejorar a corto plazo el desempeño del estudiante?</label>
                                        </td>
                                        <td>
                                            <textarea class="form-control" style="width: 100%;" name="txt_fortalezas" id="txt_fortalezas"></textarea>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label for="" class="">¿Tiene una propuesta sobre un desarrollo específico sobre fortalezas y potencialidades del
                                                estudiante?</label>
                                        </td>
                                        <td>
                                            <textarea class="form-control" style="width: 100%;" name="txt_propuesta" id="txt_propuesta"></textarea>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col text-right">
                        <button class="btn btn-lg bg-primary" onclick="guardarDatos()">Enviar</button>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function initializeInputs() {
        document.getElementById('txt_suma').value = '0';
        document.getElementById('txt_final').value = '0';
        document.getElementById('promedio1').value = '0';
    }

    window.addEventListener('load', initializeInputs);

    function promedio() {
        // Obtiene los valores de los inputs
        const num1 = parseFloat(document.getElementById('txt_calidadtra').value) || 0;
        const num2 = parseFloat(document.getElementById('txt_gradoin').value) || 0;
        const num3 = parseFloat(document.getElementById('txt_conocimientos').value) || 0;
        const num4 = parseFloat(document.getElementById('txt_recursos').value) || 0;
        const num5 = parseFloat(document.getElementById('txt_aplicacion').value) || 0;
        const num6 = parseFloat(document.getElementById('txt_habilidades').value) || 0;

        // Realiza la suma
        const resultado = num1 + num2 + num3 + num4 + num5 + num6;
        // Calcula el promedio
        const promedio = resultado / 6;
        // Redondea el promedio a dos decimales
        const promedioConDosDecimales = promedio.toFixed(2);
        // Muestra el resultado en el input de resultado
        document.getElementById('promedio1').value = promedioConDosDecimales;
        document.getElementById('txt_promedio').value = promedioConDosDecimales;

        const total1 = parseFloat(document.getElementById('txt_promedio').value) || 0;
        const total2 = parseFloat(document.getElementById('txt_promedio2').value) || 0;
        const total3 = parseFloat(document.getElementById('txt_promedio3').value) || 0;

        if (total1 !== 0 && total2 !== 0 && total3 !== 0) {

            const sumatotal = total1 + total2 + total3;

            const total = sumatotal / 3;

            const totalConDosDecimales = total.toFixed(2);

            document.getElementById('txt_suma').value = sumatotal;
            document.getElementById('txt_final').value = totalConDosDecimales;

        }

    }

    // Función que se ejecuta cuando se cambia el valor del select
    function actualizarSuma() {
        // Llamamos a la función sumar cuando se cambie el select
        promedio();
    }

    function promedio2() {
        // Obtiene los valores de los inputs
        const num7 = parseFloat(document.getElementById('txt_instrucciones').value) || 0;
        const num8 = parseFloat(document.getElementById('txt_retener').value) || 0;
        const num9 = parseFloat(document.getElementById('txt_expresar').value) || 0;
        const num10 = parseFloat(document.getElementById('txt_ideas').value) || 0;
        const num11 = parseFloat(document.getElementById('txt_identificar').value) || 0;

        // Realiza la suma
        const resultado2 = num7 + num8 + num9 + num10 + num11;
        // Calcula el promedio
        const promedio2 = resultado2 / 5;
        // Redondea el promedio a dos decimales
        const promedioConDosDecimales2 = promedio2.toFixed(2);
        // Muestra el resultado en el input de resultado
        document.getElementById('promedio2').value = promedioConDosDecimales2;
        document.getElementById('txt_promedio2').value = promedioConDosDecimales2;

        const total1 = parseFloat(document.getElementById('txt_promedio').value) || 0;
        const total2 = parseFloat(document.getElementById('txt_promedio2').value) || 0;
        const total3 = parseFloat(document.getElementById('txt_promedio3').value) || 0;

        if (total1 !== 0 && total2 !== 0 && total3 !== 0) {

            const sumatotal = total1 + total2 + total3;

            const total = sumatotal / 3;

            const totalConDosDecimales = total.toFixed(2);

            document.getElementById('txt_suma').value = sumatotal;
            document.getElementById('txt_final').value = totalConDosDecimales;

        }

    }

    // Función que se ejecuta cuando se cambia el valor del select
    function actualizarSuma2() {
        // Llamamos a la función sumar cuando se cambie el select
        promedio2();
    }

    function promedio3() {
        // Obtiene los valores de los inputs
        const num13 = parseFloat(document.getElementById('txt_ejecutar').value) || 0;
        const num14 = parseFloat(document.getElementById('txt_interes').value) || 0;
        const num15 = parseFloat(document.getElementById('txt_bien').value) || 0;
        const num16 = parseFloat(document.getElementById('txt_politicas').value) || 0;

        // Realiza la suma
        const resultado3 = num13 + num14 + num15 + num16;
        // Calcula el promedio
        const promedio3 = resultado3 / 4;
        // Redondea el promedio a dos decimales
        const promedioConDosDecimales3 = promedio3.toFixed(2);
        // Muestra el resultado en el input de resultado
        document.getElementById('promedio3').value = promedioConDosDecimales3;
        document.getElementById('txt_promedio3').value = promedioConDosDecimales3;

        const total1 = parseFloat(document.getElementById('txt_promedio').value) || 0;
        const total2 = parseFloat(document.getElementById('txt_promedio2').value) || 0;
        const total3 = parseFloat(document.getElementById('txt_promedio3').value) || 0;

        if (total1 !== 0 && total2 !== 0 && total3 !== 0) {

            const sumatotal = total1 + total2 + total3;

            const total = sumatotal / 3;

            const totalConDosDecimales = total.toFixed(2);

            document.getElementById('txt_suma').value = sumatotal;
            document.getElementById('txt_final').value = totalConDosDecimales;

        }
    
    }

    // Función que se ejecuta cuando se cambia el valor del select
    function actualizarSuma3() {
        // Llamamos a la función sumar cuando se cambie el select
        promedio3();
    }

    window.addEventListener('load', function() {
        document.getElementById('loading-screen').style.display = 'none';
    });

    // Forzar la desaparición de la pantalla de carga después de 5 segundos
    setTimeout(function() {
        document.getElementById('loading-screen').style.display = 'none';
    }, 3000);

function guardarDatos() {
    // Recopilar todos los datos del formulario
    var datos = {
        idsol= <?php echo $id; ?>,
        estudiante: document.getElementById('txt_estudiante').value,
        periodoAcademico: document.getElementById('txt_periodoacademico').value,
        
        p1p1: document.getElementById('txt_calidadtra').value,
        p1p2: document.getElementById('txt_gradoin').value,
        p1p3: document.getElementById('txt_conocimientos').value,
        p1p4: document.getElementById('txt_recursos').value,
        p1p5: document.getElementById('txt_aplicacion').value,
        p1p6: document.getElementById('txt_habilidades').value,

        p2p1: document.getElementById('txt_instrucciones').value,
        p2p2: document.getElementById('txt_retener').value,
        p2p3: document.getElementById('txt_expresar').value,
        p2p4: document.getElementById('txt_ideas').value,
        p2p5: document.getElementById('txt_identificar').value,
     
        p3p1: document.getElementById('txt_ejecutar').value,
        p3p2: document.getElementById('txt_interes').value,
        p3p3: document.getElementById('txt_bien').value,
        p3p4: document.getElementById('txt_politicas').value,

        ob1: document.getElementById('txt_observaciones').value,
        ob2: document.getElementById('txt_fortalezas').value,
        ob3: document.getElementById('txt_propuesta').value,
       
    };

    // Enviar los datos al servidor
    fetch('ingreso/ingreso_seguimiento.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(datos)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Mensaje de éxito con SweetAlert
            Swal.fire({
                icon: 'success',
                title: 'Éxito',
                text: 'Datos guardados correctamente',
                confirmButtonText: 'Aceptar'
            }).then(() => {
                // Redirigir a index.html después del mensaje de éxito
                window.location.href = 'index.php'; // Redirige a la página deseada
            });
        } else {
            // Mensaje de error con SweetAlert
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Error al guardar los datos: ' + data.message,
                confirmButtonText: 'Aceptar'
            });
        }
    })
    .catch((error) => {
        console.error('Error:', error);
        // Mensaje de error si ocurre algún fallo en la solicitud
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Error al guardar los datos',
            confirmButtonText: 'Aceptar'
        });
    });
}

   
</script>