<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
if (!isset($_SESSION['S_ID'])) {
    header('Location: ../index.php');
}

$cedulaEncriptada = isset($_GET['cedula']) ? $_GET['cedula'] : null;
$cdocente = ' ';
$cestudiante = ' ';
$nombree = ' ';
$promocion = ' ';
$correoe = ' ';
$peacademico = ' ';
$ntutor = ' ';
$ttutor = ' ';
$correot = ' ';
$nempresa = ' ';
$areae = ' ';
$fecha1 = ' ';
$fecha2 = ' ';
$fecha = ' ';
$responsable = ' ';
$cargo = ' ';

if (!empty($cedulaEncriptada)) {
    $cedula = base64_decode($cedulaEncriptada)??' ';
}

$id_usuario = $_SESSION['S_ID'];
?>
<script src="../js/console_tramite.js?rev=<?php echo time(); ?>"></script>
<link rel="stylesheet" href="../plantilla/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.css">

<!-- Content Header (Page header) -->

<style>
    tbody {
        text-align: center;
        align-items: center;
    }

    #loading-screen {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(255, 255, 255, 0.8);
        /* Fondo blanco semi-transparente */
        z-index: 9999;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        border: 16px solid #f3f3f3;
        border-top: 16px solid #17285e;
        border-radius: 50%;
        width: 120px;
        height: 120px;
        animation: spin 2s linear infinite;
    }

    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }
</style>

<div id="loading-screen">
    <div class="spinner"></div>
</div>

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">SEGUIMIENTO DE ACTIVIDADES EN LA ENTIDAD RECEPTORA</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Inicio</a></li>
                    <li class="breadcrumb-item active">DOC.</li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<?php

include_once '../../model/model_conexion.php';


$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

if ($pdo) {
    $sql = "SELECT s.idsolicitud, ast.nombre_tutor, ast.CedulaDocente, ast.CedulaEstudiante, ast.Carrera, ast.correo_estudiante, ast.telefono_tutor, ast.correo_tutor, ast.CedulaEstudiante, ast.correo_estudiante, ast.nombre_estudiante, ast.per_acad_estudiante, ast.promo, pe.nEmpresa, s.fInicio, s.fFin, pe.arpra_empresa, pe.cargo_empresa, pe.responsable FROM asig_tutor ast JOIN prac_empresa pe ON pe.cedulaEstudiante = ast.CedulaEstudiante JOIN solicitud s ON s.cedulaEstudiante = pe.cedulaEstudiante WHERE ast.CedulaEstudiante ='$cedula'";

    try {
        $query = $pdo->prepare($sql);
        $query->execute();

        $resultados = $query->fetch(PDO::FETCH_ASSOC);

        if ($resultados) {
            $idsolicitud = isset($resultados['idsolicitud']) ? strval($resultados['idsolicitud']) : '';
            $cdocente = isset($resultados['CedulaDocente']) ? $resultados['CedulaDocente'] : '';
            $cestudiante = isset($resultados['CedulaEstudiante']) ? $resultados['CedulaEstudiante'] : '';
            $nombree = isset($resultados['nombre_estudiante']) ? $resultados['nombre_estudiante'] : '';
            $promocion = isset($resultados['promo']) ? $resultados['promo'] : '';
            $correoe = isset($resultados['correo_estudiante']) ? $resultados['correo_estudiante'] : '';
            $peacademico = isset($resultados['per_acad_estudiante']) ? $resultados['per_acad_estudiante'] : '';
            $ntutor = isset($resultados['nombre_tutor']) ? $resultados['nombre_tutor'] : '';
            $ttutor = isset($resultados['telefono_tutor']) ? $resultados['telefono_tutor'] : '';
            $correot = isset($resultados['correo_tutor']) ? $resultados['correo_tutor'] : '';
            $nempresa = isset($resultados['nEmpresa']) ? $resultados['nEmpresa'] : '';
            $areae = isset($resultados['arpra_empresa']) ? $resultados['arpra_empresa'] : '';
            $fecha1 = isset($resultados['fInicio']) ? $resultados['fInicio'] : '';
            $fecha2 = isset($resultados['fFin']) ? $resultados['fFin'] : '';
            $fecha = $fecha1 . ' hasta ' . $fecha2;
            $responsable = isset($resultados['responsable']) ? $resultados['responsable'] : '';
            $cargo = isset($resultados['cargo_empresa']) ? $resultados['cargo_empresa'] : '';
        } else {

            echo "<script>alert('Debe Seleccionar un Estudiante');</script>";
        }
    } catch (PDOException $e) {
        echo "Error al ejecutar la consulta: " . $e->getMessage();
    }
} else {
    echo "<script>alert('No se encontraron resultados');</script>";
}

$conexion->cerrar_conexion();
?>
<div class="col-12">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title"><b>Información de la Institución</h3><b>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-6 form-group" style="display: none;">
                        <input class="form-control" id="txt_idsol" value ="<?php echo $idsolicitud; ?>" >
                        </div>
                        <div class="col-6 form-group" style="display: none;">
                            <input class="form-control" id="txt_cedula_estudiante" style="width:100%" value="<?php echo $cestudiante; ?>" placeholder="Cedula Estudiante">
                        </div>
                        <div class="col-6 form-group" style="display:none;">
                            <input class="form-control" id="txt_cedula_tutor" style="width:100%" value="<?php echo $cdocente; ?>" placeholder="Cedula Estudiante">
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">NOMBRES Y APELLIDOS DEL ESTUDIANTE</label>
                            <input class="form-control" id="txt_nombreest" style="width:100%" value="<?php echo $nombree; ?>" placeholder="Nombre Completo Estudiante" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">PROMOCIÓN</label>
                            <input class="form-control" id="txt_promocion" style="width:100%" value="<?php echo $promocion; ?>" placeholder="Promocion" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">CORREO DEL ESTUDIANTE</label>
                            <input class="form-control" id="txt_correo_e" style="width:100%" value="<?php echo $correoe; ?>" placeholder="Correo del Estudiante" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">NOMBRE DE LA ENTIDAD RECEPTORA</label>
                            <input class="form-control" id="txt_entidad" style="width:100%" value="<?php echo $nempresa; ?>" placeholder="Nombre de la Entidad Receptora" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">ÁREA DE LA ENTIDAD RECEPTORA</label>
                            <input class="form-control" id="txt_area_entidad" style="width:100%" value="<?php echo $areae; ?>" placeholder="Area de la Entidad Receptora" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">PERÍODO ACADÉMICO DEL ESTUDIANTE</label>
                            <input class="form-control" id="txt_periodo" style="width:100%" value="<?php echo $peacademico; ?>" placeholder="Periodo Academico del Estudiante" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">FECHA DE PRÁCTICAS</label>
                            <input class="form-control" id="txt_fecha" style="width:100%" value="<?php echo $fecha; ?>" placeholder="Fecha de Practicas" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">NOMBRES Y APELLIDOS DEL TUTOR EMPRESARIAL</label>
                            <input class="form-control" id="txt_nombre_responsable" style="width:100%" value="<?php echo $responsable; ?>" placeholder="Nombre Completo del Tutor Empresarial" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">CARGO DEL TUTOR RESPONSABLE</label>
                            <input class="form-control" id="txt_cargo_responsable" style="width:100%" value="<?php echo $cargo; ?>" placeholder="Cargo del Tutor Responsable" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">NOMBRE Y APELLIDO DEL TUTOR ACADÉMICO</label>
                            <input class="form-control" id="txt_tutor" style="width:100%" value="<?php echo $ntutor; ?>" placeholder="Nombre y Apellido del Tutor Academico" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">TELÉFONO DEL TUTOR ACADÉMICO</label>
                            <input class="form-control" id="txt_telef_tutor" style="width:100%" value="<?php echo $ttutor; ?>" placeholder="Teléfono del Tutor Académico" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">CORREO DEL TUTOR ACADÉMICO</label>
                            <input class="form-control" id="txt_correo_tutor" style="width:100%" value="<?php echo $correot; ?>" placeholder="Correo del Tutor Academico" readonly>
                        </div>
                        <div class="col-6 form-group">
                            <label for="" style="font-size:small;">FECHA DE LA VISITA</label>
                            <!-- <textarea  id="txt_asunto" rows="3" class="form-control" style="resize:none"></textarea>-->
                            <input type="date" name="txt_visita" id="txt_visita" class="form-control" style="width:100%">
                        </div>
                        <div class="table-responsive">
                            <label style="font-size:small;">Detalles de la Evaluación(Siempre-Casi Siempre-Poco-Nuncas) </label>
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>Descripción</th>
                                        <th>Evaluación</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="width: 50%;text-align:left">
                                            <label for="">1.- Asistencia puntual. </label>
                                        </td>
                                        <td style="width: 50%;">
                                            <select class="form-control" id="slc_asistencia">
                                                <option value="" selected disabled>Seleccione</option>
                                                <option value="SIEMPRE">Siempre</option>
                                                <option value="CASI SIEMPRE">Casi Siempre</option>
                                                <option value="POCO">Poco</option>
                                                <option value="NUNCA">Nunca</option>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%;text-align:left">
                                            <label for="">2.- Cumplimiento de horas de prácticas programadas.</label>
                                        </td>
                                        <td style="width: 50%;">
                                            <select class="form-control" id="slc_cumplimiento">
                                                <option value="" selected disabled>Seleccione</option>
                                                <option value="SIEMPRE">Siempre</option>
                                                <option value="CASI SIEMPRE">Casi Siempre</option>
                                                <option value="POCO">Poco</option>
                                                <option value="NUNCA">Nunca</option>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%; text-align:left">
                                            <label for="">3.- Cumplimiento de actividades en los plazos propuestos.</label>
                                        </td>
                                        <td style="width: 50%;">
                                            <select class="form-control" id="slc_cactividades">
                                                <option value="" selected disabled>Seleccione</option>
                                                <option value="SIEMPRE">Siempre</option>
                                                <option value="CASI SIEMPRE">Casi Siempre</option>
                                                <option value="POCO">Poco</option>
                                                <option value="NUNCA">Nunca</option>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%;text-align:left">
                                            <label for="">4.- Aporte de sugerencias a favor de la organización.</label>
                                        </td>
                                        <td style="width: 50%;">
                                            <select class="form-control" id="slc_aporte">
                                                <option value="" selected disabled>Seleccione</option>
                                                <option value="SIEMPRE">Siempre</option>
                                                <option value="CASI SIEMPRE">Casi Siempre</option>
                                                <option value="POCO">Poco</option>
                                                <option value="NUNCA">Nunca</option>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%;text-align:left">
                                            <label for="">5.- Creatividad para la solución de problemas.</label>
                                        </td>
                                        <td style="width: 50%;">
                                            <select class="form-control" id="slc_creatividad">
                                                <option value="" selected disabled>Seleccione</option>
                                                <option value="SIEMPRE">Siempre</option>
                                                <option value="CASI SIEMPRE">Casi Siempre</option>
                                                <option value="POCO">Poco</option>
                                                <option value="NUNCA">Nunca</option>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%;text-align:left">
                                            <label for="">6.- Demuestra sus competencias, conocimientos y habilidades en el desarrollo de las prácticas.</label>
                                        </td>
                                        <td style="width: 50%;">
                                            <select class="form-control" id="slc_competencias">
                                                <option value="" selected disabled>Seleccione</option>
                                                <option value="SIEMPRE">Siempre</option>
                                                <option value="CASI SIEMPRE">Casi Siempre</option>
                                                <option value="POCO">Poco</option>
                                                <option value="NUNCA">Nunca</option>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%;text-align:left">
                                            <label for="">7.- Demuestra responsabilidad y compromiso en el desarrollo de actividades.</label>
                                        </td>
                                        <td style="width: 50%;">
                                            <select class="form-control" id="slc_responsabilidad">
                                                <option value="" selected disabled>Seleccione</option>
                                                <option value="SIEMPRE">Siempre</option>
                                                <option value="CASI SIEMPRE">Casi Siempre</option>
                                                <option value="POCO">Poco</option>
                                                <option value="NUNCA">Nunca</option>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%;text-align:left">
                                            <label for="">8.- El estudiante tiene al día sus bitácoras de actividades.</label>
                                        </td>
                                        <td style="width: 50%;">
                                            <select class="form-control" id="slc_bitacoras">
                                                <option value="" selected disabled>Seleccione</option>
                                                <option value="SIEMPRE">Siempre</option>
                                                <option value="CASI SIEMPRE">Casi Siempre</option>
                                                <option value="POCO">Poco</option>
                                                <option value="NUNCA">Nunca</option>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%;text-align:left">
                                            <label for="">9.- El estudiante cumple con la indumentaria establecida para el desarrollo de sus prácticas pre-profesionales.</label>
                                        </td>
                                        <td style="width: 50%;">
                                            <select class="form-control" id="slc_indumentaria">
                                                <option value="" selected disabled>Seleccione</option>
                                                <option value="SIEMPRE">Siempre</option>
                                                <option value="CASI SIEMPRE">Casi Siempre</option>
                                                <option value="POCO">Poco</option>
                                                <option value="NUNCA">Nunca</option>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%;text-align:left">
                                            <label for="">10.- Las actividades que desarrolla el estudiante están acorde a su perfil de egreso.</label>
                                        </td>
                                        <td style="width: 50%;">
                                            <select class="form-control" id="slc_actividades">
                                                <option value="" selected disabled>Seleccione</option>
                                                <option value="SIEMPRE">Siempre</option>
                                                <option value="CASI SIEMPRE">Casi Siempre</option>
                                                <option value="POCO">Poco</option>
                                                <option value="NUNCA">Nunca</option>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="width: 50%; text-align:center;">
                                            <label name="" id="">Valoración del lugar en el que el estudiante desarrolla sus Prácticas Pre-profesionales</label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%;text-align:left">
                                            <label name="" id="">1.- El estudiante cuenta con un puesto de trabajo asignado.</label>
                                        </td>
                                        <td style="width: 50%;">
                                            <select class="form-control" id="slc_puesto">
                                                <option value="" selected disabled>Seleccione</option>
                                                <option value="SIEMPRE">Siempre</option>
                                                <option value="CASI SIEMPRE">Casi Siempre</option>
                                                <option value="POCO">Poco</option>
                                                <option value="NUNCA">Nunca</option>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%;text-align:left">
                                            <label name="" id="">2.- El estudiante cuenta con el acompañamiento del tutor empresarial, el cual fomenta su formación.</label>
                                        </td>
                                        <td style="width: 50%;">
                                            <select class="form-control" id="slc_acompanamiento">
                                                <option value="" selected disabled>Seleccione</option>
                                                <option value="SIEMPRE">Siempre</option>
                                                <option value="CASI SIEMPRE">Casi Siempre</option>
                                                <option value="POCO">Poco</option>
                                                <option value="NUNCA">Nunca</option>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 50%;text-align:left">
                                            <label name="" id="">3.- Se evidencian dispositivos y normas de seguridad.</label>
                                        </td>
                                        <td style="width: 50%;">
                                            <select class="form-control" id="slc_evidencias">
                                                <option value="" selected disabled>Seleccione</option>
                                                <option value="SIEMPRE">Siempre</option>
                                                <option value="CASI SIEMPRE">Casi Siempre</option>
                                                <option value="POCO">Poco</option>
                                                <option value="NUNCA">Nunca</option>
                                            </select>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="width: 50%; text-align:center;">
                                            <label name="" id="">Llamados de atención:</label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="width: 50%; text-align:center;">
                                            <textarea style="width: 100%;" name="txt_llamados" id="txt_llamados"></textarea>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="width: 50%; text-align:center;">
                                            <label name="" id="">Resumen de la entrevista realizada con el tutor empresarial</label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="width: 50%; text-align:center;">
                                            <textarea style="width: 100%;" name="txt_entrevista" id="txt_entrevista"></textarea>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="width: 50%; text-align:center;">
                                            <label name="" id="">Conclusiones y comentarios adicionales:</label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="width: 50%; text-align:center;">
                                            <textarea style="width: 100%;" name="txt_conclusion" id="txt_conclusion"></textarea>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="width: 50%; text-align:center;">
                                            <label name="" id="">ANEXOS Y DESCRIPCION (Maximo 2 imagenes):</label>
                                        </td>
                                    </tr>
                                    <tr>

                                      <td colspan="2" style="width: 100%; text-align:center;">
    <div class="d-flex justify-content-between">
        <div style="margin-right: 10px;">
            <input type="file" class="form-control" id="txt_anexos_1" name="anexos[]" accept="docente/*">
            <textarea id="txt_img1" name="txt_img1" class="form-control"></textarea>
        </div>
        <div>
            <input type="file" class="form-control" id="txt_anexos_2" name="anexos[]" accept="docente/*">
            <textarea id="txt_img2" name="txt_img2" class="form-control"></textarea>
        </div>
    </div>
</td>

                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col text-right">
                        <button class="btn btn-lg bg-primary" onclick="guardarDatos()">Enviar</button>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    window.addEventListener('load', function() {
        document.getElementById('loading-screen').style.display = 'none';
    });

    // Forzar la desaparición de la pantalla de carga después de 5 segundos
    setTimeout(function() {
        document.getElementById('loading-screen').style.display = 'none';
    }, 3000);


   function guardarDatos() {
    // Verificar que al menos una imagen haya sido subida
    var imagen1 = document.getElementById('txt_anexos_1').files[0];
    var imagen2 = document.getElementById('txt_anexos_2').files[0];

    if (!imagen1 && !imagen2) {
        Swal.fire({
            icon: 'error',
            title: '¡Oops!',
            text: 'Por favor, suba al menos una foto.',
        });
        return; // Detener el envío si no hay fotos
    }

    // Recopilar todos los datos del formulario
    var datos = {
        id: document.getElementById('txt_idsol').value,
        cedula: document.getElementById('txt_cedula_estudiante').value,
        cedula_tutor: document.getElementById('txt_cedula_tutor').value,
        visita: document.getElementById('txt_visita').value,
        asistencia: document.getElementById('slc_asistencia').value,
        cumplimiento: document.getElementById('slc_cumplimiento').value,
        cactividad: document.getElementById('slc_cactividades').value,
        aporte: document.getElementById('slc_aporte').value,
        creatividad: document.getElementById('slc_creatividad').value,
        competencia: document.getElementById('slc_competencias').value,
        responsabilidad: document.getElementById('slc_responsabilidad').value,
        bitacoras: document.getElementById('slc_bitacoras').value,
        indumentarias: document.getElementById('slc_indumentaria').value,
        actividades: document.getElementById('slc_actividades').value,
        puesto: document.getElementById('slc_puesto').value,
        acompanamiento: document.getElementById('slc_acompanamiento').value,
        evidencias: document.getElementById('slc_evidencias').value,
        llamados: document.getElementById('txt_llamados').value,
        entrevistas: document.getElementById('txt_entrevista').value,
        conclusion: document.getElementById('txt_conclusion').value,
        descripcion1: document.getElementById('txt_img1').value,
        descripcion2: document.getElementById('txt_img2').value,
    };

    // Validar que si se sube una imagen, su descripción sea obligatoria
    if (imagen1 && datos.descripcion1 === "") {
        Swal.fire({
            icon: 'error',
            title: '¡Oops!',
            text: 'Por favor, ingrese la descripción de la imagen 1.',
        });
        return; // Detener el envío si falta la descripción de la imagen 1
    }

    if (imagen2 && datos.descripcion2 === "") {
        Swal.fire({
            icon: 'error',
            title: '¡Oops!',
            text: 'Por favor, ingrese la descripción de la imagen 2.',
        });
        return; // Detener el envío si falta la descripción de la imagen 2
    }

    // Límite de tamaño de la imagen (en bytes)
    var MAX_SIZE = 2 * 1024 * 1024; // 2MB

    // Validar el tamaño de las imágenes
    if (imagen1 && imagen1.size > MAX_SIZE) {
        Swal.fire({
            icon: 'error',
            title: '¡Oops!',
            text: 'La imagen 1 es demasiado grande. El tamaño máximo permitido es 2MB.',
        });
        return; // Detener el envío si la imagen es demasiado grande
    }

    if (imagen2 && imagen2.size > MAX_SIZE) {
        Swal.fire({
            icon: 'error',
            title: '¡Oops!',
            text: 'La imagen 2 es demasiado grande. El tamaño máximo permitido es 2MB.',
        });
        return; // Detener el envío si la imagen es demasiado grande
    }

    // Convertir las imágenes a un formato compatible (JPEG o PNG)
    function convertirImagen(imagen, callback) {
        var canvas = document.createElement('canvas');
        var ctx = canvas.getContext('2d');
        var img = new Image();

        img.onload = function () {
            canvas.width = img.width;
            canvas.height = img.height;
            ctx.drawImage(img, 0, 0);

            // Convertir a JPEG (o PNG si prefieres)
            var imagenConvertida = canvas.toDataURL('image/jpeg', 0.8); // Calidad del 80%
            callback(imagenConvertida);
        };

        img.src = URL.createObjectURL(imagen);
    }

    // Crear un objeto FormData para los archivos y cargar las imágenes en base64
    var reader1 = new FileReader();
    var reader2 = new FileReader();

    if (imagen1) {
        convertirImagen(imagen1, function (imagenConvertida) {
            datos.imagen_1 = imagenConvertida;

            if (imagen2) {
                convertirImagen(imagen2, function (imagenConvertida) {
                    datos.imagen_2 = imagenConvertida;
                    enviarDatos(datos);
                });
            } else {
                enviarDatos(datos);
            }
        });
    } else if (imagen2) {
        convertirImagen(imagen2, function (imagenConvertida) {
            datos.imagen_2 = imagenConvertida;
            enviarDatos(datos);
        });
    } else {
        enviarDatos(datos);
    }
}

function enviarDatos(datos) {
    console.log(datos);
    // Enviar los datos al servidor
    fetch('ingreso/ingreso_seguimiento_docente.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(datos)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Mensaje de éxito con SweetAlert
            Swal.fire({
                icon: 'success',
                title: 'Éxito',
                text: 'Ficha completada correctamente',
                confirmButtonText: 'Aceptar'
            }).then(() => {
                // Redirigir a index.html después del mensaje de éxito
                window.location.href = 'index.php'; // Redirige a la página deseada
            });
        } else {
            // Mensaje de error con SweetAlert
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Error al guardar los datos: ' + data.message,
                confirmButtonText: 'Aceptar'
            });
        }
    })
    .catch((error) => {
        console.error('Error:', error);
        // Mensaje de error si ocurre algún fallo en la solicitud
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Error al guardar los datos',
            confirmButtonText: 'Aceptar'
        });
    });
}
</script>