<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['S_ID'])) {
  header('Location: ../index.php');
}

include_once '../../model/model_conexion.php';

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

$cedula=$_SESSION['S_USU'];

$solicitudes = [];

if ($pdo) {
  $sql = "SELECT ed.estudiante_id, ed.idsol, ed.cedula_estudiante, ast.nombre_estudiante, ed.cedula_tutor, ast.nombre_tutor, ed.visita FROM eval_docente ed join asig_tutor ast on ast.CedulaEstudiante=ed.cedula_estudiante join prac_empresa pe on pe.cedulaEstudiante=ed.cedula_estudiante where ast.CedulaDocente='".$cedula."'";

  try {
    $query = $pdo->prepare($sql);
    $query->execute();
    $resultados = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resultados) {
      foreach ($resultados as $row) {
        $solicitudes[] = [
          'estudiante_id' => $row['estudiante_id'] ?? 'NO REGISTRA',
          'cedulaEstudiante' => $row['cedula_estudiante'] ?? 'NO REGISTRA',
          'nestudiante' => $row['nombre_estudiante'] ?? 'NO REGISTRA',
          'cedulatutor' => $row['cedula_tutor'] ?? 'NO REGISTRA',
          'ntutor' => $row['nombre_tutor'] ?? 'NO REGISTRA',
          'visita' => $row['visita'] ?? 'NO REGISTRA',
          'accion' => "<a href='pdf/ficha_docente.php?id=".$row['idsol']."&ideval=".$row['estudiante_id']."' class='btn btn-primary btn-sm' target='_blank' tittle='Imprimir info Empresa'><i class='fa fa-print' aria-hidden='true'></i></a>"


        ];
      }
    }
  } catch (PDOException $e) {
    error_log("Error al ejecutar la consulta: " . $e->getMessage());
  }
} else {
  echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>

<!-- Incluir los recursos necesarios para Bootstrap y DataTables -->
 <link rel="stylesheet" href="../plantilla/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<style>
  /* Agregar tus estilos personalizados aquí */
</style>

<!-- Cabecera -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0">FICHAS DE DOCENTE</h1>
      </div>
    </div>
  </div>
</div>

<!-- Main content -->
<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">
            <div class="col-12 table-responsive">
              <table id="tabla_tramites" class="display" style="width:100%; text-align: center;">
                <thead>
                  <tr>
                    <th class="text-center">No</th>
                    <th class="text-center">CI Estudiante</th>
                    <th class="text-center">Nombre Estudiante</th>
                    <th class="text-center">CI Tutor</th>
                    <th class="text-center">Tutor</th>
                    <th class="text-center">Visita</th>
                    <th class="text-center">Accion</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $contador=1;
                  foreach ($solicitudes as $solicitud): ?>
                    <tr>
                      <td><?php echo $contador; ?></td>
                      <td><?php echo $solicitud['cedulaEstudiante']; ?></td>
                      <td><?php echo $solicitud['nestudiante']; ?></td>
                      <td><?php echo $solicitud['cedulatutor']; ?></td>
                      <td><?php echo $solicitud['ntutor']; ?></td>
                      <td><?php echo $solicitud['visita']; ?></td>
                      <td><?php echo $solicitud['accion']; ?></td>
                    </tr>
                  <?php $contador++;
                  endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function() {
    // Inicializar la tabla DataTable
    $('#tabla_tramites').DataTable();
  });

  // Variable global para almacenar la cédula del estudiante
  let cedulaEstudianteGlobal = '';

  // Función para abrir el modal de edición
  function editarEstado(cedulaEstudiante) {
    cedulaEstudianteGlobal = cedulaEstudiante;

    // Asegurarse de eliminar todos los fondos y modales existentes
    removeModalBackdrop();

    // Inicializar el modal
    var modalElement = document.getElementById('modalEditarEstado');
    var modal = new bootstrap.Modal(modalElement, {
      backdrop: 'static', // No cerrar con click fuera del modal
      keyboard: false // No cerrar con tecla ESC
    });

    modal.show(); // Mostrar el modal
  }

  // Función para guardar el estado
  function guardarEstado() {
    var estado = document.getElementById("estado").value;

    fetch('ingreso/actualizacion_sol_practica.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify({
          estado: estado,
          cedula: cedulaEstudianteGlobal
        })
      })
      .then(response => response.json())
      .then(data => {
        if (data.success) {
          // Mostrar mensaje de éxito con SweetAlert2
          Swal.fire({
            icon: 'success',
            title: 'Estado actualizado',
            text: 'El estado se ha actualizado a: ' + estado,
            confirmButtonText: 'Aceptar'
          }).then((result) => {
            if (result.isConfirmed) {
              // Recargar el contenido de la página
              cargar_contenido('contenido_principal', 'coordinador/view_sol_prac.php');
            }
          });
        } else {
          // Mostrar mensaje de error con SweetAlert2
          Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Hubo un error al actualizar el estado.',
            confirmButtonText: 'Aceptar'
          });
        }
      })
      .catch(error => {
        console.error('Error:', error);
        Swal.fire({
          icon: 'error',
          title: 'Error',
          text: 'Hubo un error al actualizar el estado.',
          confirmButtonText: 'Aceptar'
        });
      });

    // Cerrar el modal después de guardar
    var modalElement = document.getElementById('modalEditarEstado');
    var modal = bootstrap.Modal.getInstance(modalElement);
    modal.hide();

    // Eliminar fondo oscuro manualmente
    removeModalBackdrop();
  }

  // Función para eliminar el fondo oscuro y modal-backdrop
  function removeModalBackdrop() {
    // Forzar eliminación de la clase modal-open del body
    $(document.body).removeClass('modal-open');

    // Eliminar el fondo oscuro .modal-backdrop si existe
    $('.modal-backdrop').remove();

    // Asegurarse de que no haya más instancias acumuladas de fondo oscuro
    $('body').removeClass('modal-open'); // Forzar eliminación de la clase modal-open
    $('.modal-backdrop').remove(); // Eliminar cualquier fondo persistente
  }

  // Función para cargar contenido dinámicamente en el contenedor
  function cargar_contenido(id, vista) {
    $("#" + id).load(vista, function(response, status, xhr) {
      if (status == "error") {
        alert("Error: " + xhr.status + " " + xhr.statusText);
      } else {
        // Reinicializar DataTable después de cargar el contenido
        $('#tabla_tramites').DataTable();

        // Volver a cargar los recursos JS y CSS necesarios si fuera necesario
        loadCSS("https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css");
        loadJS("https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js");
      }
    });
  }

  // Función para cargar archivos CSS dinámicamente
  function loadCSS(url) {
    var link = document.createElement("link");
    link.rel = "stylesheet";
    link.type = "text/css";
    link.href = url;
    document.head.appendChild(link);
  }

  // Función para cargar archivos JS dinámicamente
  function loadJS(url) {
    var script = document.createElement("script");
    script.src = url;
    document.head.appendChild(script);
  }
</script>