<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['S_ID'])) {
  header('Location: ../index.php');
}

$id_usuario = $_SESSION['S_ID'];
include_once '../config/conexion_ip.php';

$conexion = new newonexionBD();
$pdo = $conexion->newconexionPDO();

$solicitudes = [];

if ($pdo) {
  // Inicializar el array para almacenar los resultados
  $solicitudes = [];

  $sql = "SELECT p.CedulaPersonal, p.ApellidosPersonal, p.ApellidosPersonal2, p.NombresPersonal, p.CelularPersonal, p.CorreoPersonal, GROUP_CONCAT(DISTINCT c.NombreCarrera SEPARATOR ', ') AS Carreras FROM personal p JOIN usuario u ON p.IdPersonal = u.IdPersonal JOIN recordcabecera rc ON rc.IdPersonal = p.IdPersonal JOIN carrera c ON c.IdCarrera = rc.IdCarrera WHERE u.IdRolUsuario = 7 GROUP BY p.IdPersonal, p.CedulaPersonal, p.ApellidosPersonal, p.NombresPersonal;";

  try {
    // Preparar y ejecutar la consulta
    $query = $pdo->prepare($sql);
    $query->execute();
    $resultados = $query->fetchAll(PDO::FETCH_ASSOC);

    // Verificar si se han obtenido resultados
    if ($resultados && count($resultados) > 0) {
      foreach ($resultados as $row) {
        $solicitudes[] = [
          'cedulapersonal' => $row['CedulaPersonal'] ?? 'NO REGISTRA',
          'apellidopersonal' => $row['ApellidosPersonal'] ?? 'NO REGISTRA',
          'apellidopersonal2' => $row['ApellidosPersonal2'] ?? 'NO REGISTRA',
          'nombrepersonal' => $row['NombresPersonal'] ?? 'NO REGISTRA',
          'celupersonal' => $row['CelularPersonal'] ?? 'NO REGISTRA',
          'correopersonal' => $row['CorreoPersonal'] ?? 'NO REGISTRA',
          'carreras' => $row['Carreras'] ?? 'NO REGISTRA',
          'accion' => "<a href='#' class='btn btn-primary btn-sm' data-bs-toggle='modal' data-bs-target='#modalEditarEstado' onclick='editarEstado(\"" . $row['CedulaPersonal'] . "\")'><i class='fa fa-pencil-square-o' aria-hidden='true'></i> Asignar</a>"
        ];
      }
    } else {
      echo "<script>alert('No se encontraron resultados para el rol de usuario 7.');</script>";
    }
  } catch (PDOException $e) {
    // Log de error y mensaje al usuario
    error_log("Error al ejecutar la consulta: " . $e->getMessage());
    echo "<script>alert('Hubo un error al consultar los datos.');</script>";
  }
} else {
  echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>

<!-- Cabecera -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0">LISTA DE DOCENTES</h1>
      </div>
    </div>
  </div>
</div>

<!-- Main content -->
<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">
            <div class="col-12 table-responsive">
              <table id="tabla_tramites" class="display" style="width:100%">
                <thead>
                  <tr>
                    <th class="text-center">No</th>
                    <th class="text-center">C.I</th>
                    <th class="text-center">Nombres</th>
                    <th class="text-center">Carrera</th>
                    <th class="text-center">Accion</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $contador = 1; ?>

                  <?php foreach ($solicitudes as $solicitud): ?>
                    <tr>
                      <?php $nombre = $solicitud['apellidopersonal'] . ' ' . $solicitud['apellidopersonal2'] . ' ' . $solicitud['nombrepersonal'];  ?>
                      <td><?php echo $contador; ?></td>
                      <td><?php echo $solicitud['cedulapersonal']; ?></td>
                      <td><?php echo $nombre; ?></td>
                      <td style="font-size: 10px; width:30%"><?php echo $solicitud['carreras']; ?></td>
                      <td><?php echo $solicitud['accion'];
                          $contador++; ?></td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php

$conexion2 = new newonexionBD();
$pdo2 = $conexion2->newconexionPDO();

$solicitudes2 = [];

if ($pdo2) {
  $sql2 = "SELECT DISTINCT
    e.CedulaEstudiante, 
    e.ApellidoPaternoEstudiante, 
    e.ApellidoMaternoEstudiante, 
    e.NombresEstudiante, 
    e.CorreoEstudiante, 
    c.NombreCarrera, 
    pl.DescripPeriodoLect, 
    pa.NombrePeriodoAcademico
FROM 
    estudiante e
JOIN 
    recorddetalle rd ON rd.IdEstudiante = e.IdEstudiante
JOIN 
    recordcabecera rc ON rc.IdRecordCabecera = rd.IdRecordCabecera
JOIN 
    carrera c ON c.IdCarrera = e.idcarrera
JOIN 
    periodoacademico pa ON pa.IdPeriodoAcademico = rc.IdPeriodoAcademico
JOIN 
    periodolectivo pl ON pl.IdPeriodoLectivo = rc.IdPeriodoLectivo
JOIN 
    ( 
        SELECT 
            rd.IdEstudiante, 
            MAX(pa.IdPeriodoAcademico) AS MaxPeriodo
        FROM 
            recorddetalle rd
        JOIN 
            recordcabecera rc ON rc.IdRecordCabecera = rd.IdRecordCabecera
        JOIN 
            periodoacademico pa ON pa.IdPeriodoAcademico = rc.IdPeriodoAcademico
        GROUP BY 
            rd.IdEstudiante
    ) AS MaxPeriodos
    ON MaxPeriodos.IdEstudiante = e.IdEstudiante
    AND MaxPeriodos.MaxPeriodo = rc.IdPeriodoAcademico 
ORDER BY 
    e.ApellidoPaternoEstudiante ASC;
";

  try {
    $query2 = $pdo2->prepare($sql2);
    $query2->execute();
    $resultados2 = $query2->fetchAll(PDO::FETCH_ASSOC);

    if ($resultados2) {
      foreach ($resultados2 as $row2) {
        $solicitudes2[] = [
          'cedulaestudiante' => $row2['CedulaEstudiante'] ?? 'NO REGISTRA',
          'apelllidoestudiante' => $row2['ApellidoPaternoEstudiante'] ?? 'NO REGISTRA',
          'apellidomaterno' => $row2['ApellidoMaternoEstudiante'] ?? 'NO REGISTRA',
          'NombresEstudiante' => $row2['NombresEstudiante'] ?? 'NO REGISTRA',
          'CorreoEstudiante' => $row2['CorreoEstudiante'] ?? 'NO REGISTRA',
          'CarreraEstudiante' => $row2['NombreCarrera'] ?? 'NO REGISTRA',
          'Promocion' => $row2['DescripPeriodoLect'] ?? 'NO REGISTRA',
          'PeriodoAcademico' => $row2['NombrePeriodoAcademico'] ?? 'NO REGISTRA',
        ];
      }
    }
  } catch (PDOException $e) {
    error_log("Error al ejecutar la consulta: " . $e->getMessage());
  }
} else {
  echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>
<!-- Modal de Edición con Bootstrap -->
<div class="modal fade" id="modalEditarEstado" tabindex="-1" aria-labelledby="modalEditarEstadoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalEditarEstadoLabel">Asignar Estudiante</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formEditarEstado">
          <div class="mb-3">
            <label for="lst_estudiante" class="form-label">Listado de Estudiantes</label>
            <select class="form-control" id="lst_estudiante" name="lst_estudiante" style="width: 100%;">
              <option value="">Seleccione un estudiante</option>
              <?php foreach ($solicitudes2 as $solicitud2): ?>
                <?php
                $nombre = $solicitud2['apelllidoestudiante'] . ' ' . $solicitud2['apellidomaterno'] . ' ' . $solicitud2['NombresEstudiante'];
                $cedula = $solicitud2['cedulaestudiante'];
                ?>
                <option value="<?php echo htmlspecialchars($cedula); ?>"><?php echo htmlspecialchars($nombre); ?></option>
              <?php endforeach; ?>
            </select>
            <label for="promocion" class="form-label">Promoción</label>
            <input type="text" class="form-control" id="promocion" name="promocion" placeholder="Promoción" required>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" id="guardarBtn" onclick="guardarEstado()">Asignar</button>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
$(document).ready(function() {
  // Inicializar la tabla DataTable
  $('#tabla_tramites').DataTable();
  
  // Inicializar Select2
  $('.select2').select2();
});

  var solicitudes = <?php echo json_encode($solicitudes); ?>;
  var solicitudes2 = <?php echo json_encode($solicitudes2); ?>;
  var docenteSeleccionado;
  var datosEstudiante = null; // Iniciar vacío
  

  function editarEstado(CedulaPersonal) {
    // Aquí buscamos la información del docente basándonos en su cédula
    docenteSeleccionado = solicitudes.find(s => s.cedulapersonal === CedulaPersonal);

    // Asegurarse de eliminar todos los fondos y modales existentes
    removeModalBackdrop();

    // Inicializar el modal
    var modalElement = document.getElementById('modalEditarEstado');
    var modal = new bootstrap.Modal(modalElement, {
      backdrop: 'static', // No cerrar con click fuera del modal
      keyboard: false // No cerrar con tecla ESC
    });

    modal.show(); // Mostrar el modal
  }

  // Evento para detectar el cambio de selección del estudiante
  $('#lst_estudiante').change(function() {
    const cedulaEstudiante = $(this).val().trim(); // Captura la cédula del estudiante seleccionado y elimina espacios
   
    if (cedulaEstudiante) {
      // Buscar los datos del estudiante seleccionado en el array de solicitudes2
      var estudiante = solicitudes2.find(est => est.cedulaestudiante.trim() === cedulaEstudiante);

      if (estudiante) {
        // Guardamos toda la información del estudiante en la variable datosEstudiante
        datosEstudiante = {
          cedula: estudiante.cedulaestudiante,
          nombre: estudiante.NombresEstudiante,
          apellido: estudiante.apelllidoestudiante + ' ' + estudiante.apellidomaterno,
          correo: estudiante.CorreoEstudiante,
          carreraest: estudiante.CarreraEstudiante,
          promocion: estudiante.Promocion,
          periodaca: estudiante.PeriodoAcademico,
          
        };
// Verifica que los datos del estudiante se almacenan correctamente
      } else {
        console.log("Estudiante no encontrado"); // Verifica si no se encuentra el estudiante
      }
    } else {
      // Si no se selecciona estudiante, limpiamos la variable
      datosEstudiante = null;
      console.log("No se ha seleccionado un estudiante"); // Verifica si no se ha seleccionado
    }
  });

  function guardarEstado() {

    var promo = document.getElementById('promocion').value;
    // Verificar que se haya seleccionado un estudiante
    if (!datosEstudiante) {
      Swal.fire({
        icon: 'warning',
        title: 'Advertencia',
        text: 'Por favor, seleccione un estudiante.',
        confirmButtonText: 'Aceptar'
      });
      return;
    }

    // Verificar que se haya seleccionado un docente
    if (!docenteSeleccionado) {
      Swal.fire({
        icon: 'warning',
        title: 'Advertencia',
        text: 'Por favor, seleccione un docente.',
        confirmButtonText: 'Aceptar'
      });
      return;
    }

    // Recoger los datos de la solicitud para enviar
    const datosEnviar = {
      cdocente: docenteSeleccionado.cedulapersonal, // Cédula del docente seleccionado
      ndocente: docenteSeleccionado.nombrepersonal, // Nombre del docente
      adocente: docenteSeleccionado.apellidopersonal,
      a2docente: docenteSeleccionado.apellidopersonal2, // Apellido del docente
      correodocente: docenteSeleccionado.correopersonal,
      celudocente: docenteSeleccionado.celupersonal, // Correo del docente // Carrera del docente
      estudiante: datosEstudiante,
      promo: promo // Enviar todos los datos del estudiante
    };

    fetch('ingreso/ingreso_asignacion.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify(datosEnviar) // Enviar los datos como JSON
      })
      .then(response => response.json())
      .then(data => {
        if (data.success) {
          // Mostrar mensaje de éxito con SweetAlert2
          Swal.fire({
            icon: 'success',
            title: 'Asignación exitosa',
            text: 'El estudiante ha sido asignado correctamente.',
            confirmButtonText: 'Aceptar'
          }).then((result) => {
            if (result.isConfirmed) {
              // Recargar el contenido de la página
              cargar_contenido('contenido_principal', 'coordinador/view_solicitud_todo.php');
            }
          });
        } else {
          // Mostrar mensaje de error con SweetAlert2
          Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Hubo un error al asignar al estudiante.',
            confirmButtonText: 'Aceptar'
          });
        }
      })
      .catch(error => {
        console.error('Error:', error);
        Swal.fire({
          icon: 'error',
          title: 'Error',
          text: 'Hubo un error al actualizar el estado.',
          confirmButtonText: 'Aceptar'
        });
      });

    // Cerrar el modal después de guardar
   $('#modalEditarEstado').modal('hide'); // Usamos .modal('hide') en lugar de getInstance()

  // Usamos un setTimeout para asegurarnos de que el modal se haya cerrado antes de eliminar el fondo
  setTimeout(removeModalBackdrop, 200);
  }

  // Función para eliminar el fondo oscuro y modal-backdrop
 function removeModalBackdrop() {
  // Eliminar el fondo oscuro .modal-backdrop si existe
  $('.modal-backdrop').remove();

  // Eliminar la clase modal-open del body
  $('body').removeClass('modal-open');

  // Asegurarse de que no haya más instancias acumuladas de fondo oscuro
  $('body').css('padding-right', ''); // Restablecer el padding del body
}
</script>