<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['S_ID'])) {
  header('Location: ../index.php');
  exit(); // Asegúrate de salir después de redirigir
}

include_once '../../model/model_conexion.php';

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

$solicitudes = [];

if ($pdo) {
  $sql = "SELECT s.idsolicitud, s.cedulaEstudiante, s.Carrera, s.nomenclatura, s.Periodo, s.fInicio, s.fFin, s.horas, s.estado, s.f_finalizacion, s.f_aprobacion, s.oficio_apro  
          FROM solicitud s ";

  try {
    $query = $pdo->prepare($sql);
    $query->execute();
    $resultados = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resultados) {
      foreach ($resultados as $row) {
        $solicitudes[] = [
          'idsolicitud' => $row['idsolicitud'] ?? 'NO REGISTRA',
          'cedulaEstudiante' => $row['cedulaEstudiante'] ?? 'NO REGISTRA',
          'Carrera' => $row['Carrera'] ?? 'NO REGISTRA',
          'sigla' => $row['nomenclatura'] ?? 'NO REGISTRA',
          'Periodo' => $row['Periodo'] ?? 'NO REGISTRA',
          'fInicio' => $row['fInicio'] ?? 'NO REGISTRA',
          'fFin' => $row['fFin'] ?? 'NO REGISTRA',
          'horas' => $row['horas'] ?? 'NO REGISTRA',
          'finalizacion' => $row['f_finalizacion'] ?? 'NO REGISTRA',
          'aprobacion' => $row['f_aprobacion'] ?? 'NO REGISTRA',
          'estado' => $row['estado'] ?? 'NO REGISTRA',
          'accion' => "<a href='#' class='btn btn-primary btn-sm btn-editar' 
                          data-bs-toggle='modal' 
                          data-bs-target='#modalEditarEstado'
                          data-id='" . $row['idsolicitud'] . "'
                          data-cedula='" . $row['cedulaEstudiante'] . "'
                          data-carrera='" . $row['Carrera'] . "'
                          data-finalizacion='" . $row['f_finalizacion'] . "'
                           data-aprobacion='" . $row['f_aprobacion'] . "'>
                        <i class='fa fa-check' aria-hidden='true'></i>
                      </a>
                      <a href='pdf/sol_prac.php?id=" . $row['idsolicitud'] . "' class='btn btn-primary btn-sm' target='_blank'>
                        <i class='fa fa-print' aria-hidden='true'></i>
                      </a>
                       <a href='" . (!empty($row['oficio_apro']) ? $row['oficio_apro'] : '#') . "' class='btn " . (!empty($row['oficio_apro']) ? 'btn-success' : 'btn-danger') . " btn-sm'><i class='fa fa-print' aria-hidden='true'></i></a>"
      ];
      }
    }
  } catch (PDOException $e) {
    error_log("Error al ejecutar la consulta: " . $e->getMessage());
  }
} else {
  echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>

<!-- Cabecera -->
 <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">LISTA DE SOLICITUDES PRACTICAS</h1>
        </div>
      </div>
    </div>
  </div>

  <!-- Main content -->
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-12">
          <div class="card">
            <div class="card-body">
              <div class="col-12 table-responsive">
                <table id="tabla_tramites" class="display" style="width:100%">
                  <thead>
                    <tr>
                      <th class="text-center">Cedula Estudiante</th>
                      <th class="text-center">Carrera</th>
                      <th class="text-center">Periodo</th>
                      <th class="text-center">Fecha Inicio</th>
                      <th class="text-center">Fecha Fin</th>
                      <th class="text-center">Horas</th>
                      <th class="text-center">Estado</th>
                      <th class="text-center">Accion</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php foreach ($solicitudes as $solicitud): ?>
                      <tr>
                        <td><?php echo $solicitud['cedulaEstudiante']; ?></td>
                        <td><?php echo $solicitud['Carrera']; ?></td>
                        <td><?php echo $solicitud['Periodo']; ?></td>                    
                        <td><?php echo $solicitud['fInicio']; ?></td>
                        <td><?php echo $solicitud['fFin']; ?></td>
                        <td><?php echo $solicitud['horas']; ?></td>
                        <td>
                          <?php
                          $estado = $solicitud['estado'];
                          if ($estado === 'PENDIENTE') {
                            echo '<span class="badge bg-danger">Pendiente</span>';
                          } elseif ($estado === 'APROBADO') {
                            echo '<span class="badge bg-success">Aprobado</span>';
                          } elseif ($estado === 'EN PROCESO') {
                            echo '<span class="badge bg-primary">En Proceso</span>';
                          } elseif ($estado === 'RECHAZADO') {
                            echo '<span class="badge bg-warning">Rechazado</span>';
                          } elseif ($estado === 'FINALIZADO') {
                            echo '<span class="badge bg-dark">Finalizado</span>';
                          } else {
                            echo '<span class="badge bg-secondary">ERROR</span>';
                          }
                          ?>
                        </td>
                        <td style="display: flex; gap: 10px; text-align: center;">
                          <?php echo $solicitud['accion']; ?>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal de Edición con Bootstrap -->
  <div class="modal fade" id="modalEditarEstado" tabindex="-1" aria-labelledby="modalEditarEstadoLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalEditarEstadoLabel">Cambiar Estado del Trámite</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        </div>
        <div class="modal-body">
          <form id="formEditarEstado">
            <div class="form-group">
              <label for="estado" class="control-label">Estado del Trámite</label>
              <select class="form-control" id="estado" name="estado">
                <option value="NO REGISTRA">NO REGISTRA</option>
                <option value="PENDIENTE">PENDIENTE</option>
                <option value="APROBADO">APROBADO</option>
                <option value="EN PROCESO">EN PROCESO</option>
                <option value="RECHAZADO">RECHAZADO</option>
                <option value="FINALIZADO">FINALIZADO</option>
              </select>
            </div>
          </form>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
          <button type="button" class="btn btn-primary" id="guardarBtn" onclick="guardarEstado()">Guardar</button>
        </div>
      </div>
    </div>
  </div>
  <script type="text/javascript">
    $(document).ready(function() {
      // Inicializar DataTable
      $('#tabla_tramites').DataTable();

      // Manejar el clic en el botón de editar
      $(document).on('click', '.btn-editar', function() {
        // Obtener los datos del botón
        const id = $(this).data('id');
        const cedula = $(this).data('cedula');
        const carrera = $(this).data('carrera');
        const finalizacion = $(this).data('finalizacion');
          const aprobacion = $(this).data('aprobacion');

        // Guardar los datos en variables globales
        window.idGlobal = id;
        window.cedulaGlobal = cedula;
        window.carreraGlobal = carrera;
        window.finalizacionGlobal = finalizacion;
        window.aprobacionGlobal = aprobacion;

        // Mostrar el modal
        $('#modalEditarEstado').modal('show');
      });
    });

    function guardarEstado() {
      const estado = document.getElementById("estado").value;

      // Enviar los datos al servidor
      fetch('ingreso/actualizacion_sol_practica.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify({
          id: window.idGlobal,
          estado: estado,
          cedula: window.cedulaGlobal,
          carrera: window.carreraGlobal,
          finalizacion: window.finalizacionGlobal,
          aprobacion: window.aprobacionGlobal
        })
      })
      .then(response => response.json())
      .then(data => {
        if (data.success) {
          Swal.fire({
            icon: 'success',
            title: 'Estado actualizado',
            text: 'El estado se ha actualizado a: ' + estado,
            confirmButtonText: 'Aceptar'
          }).then((result) => {
            if (result.isConfirmed) {
              location.reload(); // Recargar la página
            }
          });
        } else {
          Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Hubo un error al actualizar el estado.',
            confirmButtonText: 'Aceptar'
          });
        }
      })
      .catch(error => {
        console.error('Error:', error);
        Swal.fire({
          icon: 'error',
          title: 'Error',
          text: 'Hubo un error al actualizar el estado.',
          confirmButtonText: 'Aceptar'
        });
      });

      // Cerrar el modal
      $('#modalEditarEstado').modal('hide');
    }
  </script>