<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['S_ID'])) {
  header('Location: ../index.php');
}

include_once '../../model/model_conexion.php';

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

$solicitudes = [];

if ($pdo) {
  $sql = "SELECT * FROM asig_tutor";

  try {
    $query = $pdo->prepare($sql);
    $query->execute();
    $resultados = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resultados) {
      foreach ($resultados as $row) {
        $solicitudes[] = [
          'ceduladocente' => $row['CedulaDocente'] ?? 'NO REGISTRA',
          'nombretutor' => $row['nombre_tutor'] ?? 'NO REGISTRA',
          'telefonotutor' => $row['telefono_tutor'] ?? 'NO REGISTRA',
          'correotutor' => $row['correo_tutor'] ?? 'NO REGISTRA',
          'carrera' => $row['Carrera'] ?? 'NO REGISTRA',
          'cedulaestudiante' => $row['CedulaEstudiante'] ?? 'NO REGISTRA',
          'nombreestudiante' => $row['nombre_estudiante'] ?? 'NO REGISTRA',
          'promocion' => $row['promocion'] ?? 'NO REGISTRA',
          'corroestudiante' => $row['correo_estudiante'] ?? 'NO REGISTRA',
          'accion' => "<a href='#' class='btn btn-danger btn-sm' style='text-align:center' onclick='eliminarasignacion(\"" . $row['CedulaEstudiante'] . "\")'><i class='fa fa-trash' aria-hidden='true'></i></a>"
        ];
      }
    }
  } catch (PDOException $e) {
    error_log("Error al ejecutar la consulta: " . $e->getMessage());
  }
} else {
  echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>

<!-- Cabecera -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0">LISTA DE ASIGNACIONES</h1>
      </div>
    </div>
  </div>
</div>

<!-- Main content -->
<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">
            <div class="col-12 table-responsive">
              <table id="tabla_tramites" class="display" style="width:100%">
                <thead>
                  <tr>  
                    <th class="text-center">Nombre Tutor</th>
                    <th class="text-center">Telefono Tutor</th>
                    <th class="text-center">Correo Tutor</th>
                    <th class="text-center">Carrera</th>
                    <th class="text-center">Nombre Estudiante</th>
                    <th class="text-center">Promocion</th>
                    <th class="text-center">Correo Estudiante</th>
                    <th class="text-center">Accion</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($solicitudes as $solicitud): ?>
                    <tr>
                      <td><?php echo $solicitud['nombretutor']; ?></td>
                      <td><?php echo $solicitud['telefonotutor']; ?></td>
                      <td><?php echo $solicitud['correotutor']; ?></td>
                      <td><?php echo $solicitud['carrera']; ?></td>
                      <td><?php echo $solicitud['nombreestudiante']; ?></td>
                      <td><?php echo $solicitud['promocion']; ?></td>
                      <td><?php echo $solicitud['corroestudiante']; ?></td>
                      <td class="text-center align-middle"><?php echo $solicitud['accion']; ?></td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal de Edición con Bootstrap -->

<script type="text/javascript">
$(document).ready(function() {
  // Inicializar la tabla DataTable
  $('#tabla_tramites').DataTable();
  
  // Inicializar Select2
  $('.select2').select2();
});

  // Función para abrir el modal de edición y eliminar la asignación
  function eliminarasignacion(CedulaEstudiante) {
    // Crear un objeto con los datos a enviar
    const data = {
        cedulaestudiante: CedulaEstudiante  // El valor de la cédula
    };

    // Usando fetch para enviar los datos al archivo PHP
    fetch('ingreso/eliminar_asignacion.php', {
        method: 'POST',  // Usamos el método POST
        headers: {
            'Content-Type': 'application/json',  // Indicamos que estamos enviando JSON
        },
        body: JSON.stringify(data),  // Convertimos el objeto a JSON
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
          // Mostrar mensaje de éxito con SweetAlert2
          Swal.fire({
            icon: 'success',
            title: 'Eliminación de Asignación exitosa',
            text: 'Asignación eliminada correctamente.',
            confirmButtonText: 'Aceptar'
          }).then((result) => {
            if (result.isConfirmed) {
              // Recargar el contenido de la página
              cargar_contenido('contenido_principal', 'coordinador/view_asignaciones.php');
            }
          });
        } else {
          // Mostrar mensaje de error con SweetAlert2
          Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Hubo un error al eliminar.',
            confirmButtonText: 'Aceptar'
          });
        }
    })
    .catch(error => {
        console.error('Error:', error);
        Swal.fire({
          icon: 'error',
          title: 'Error',
          text: 'Hubo un error al actualizar la página.',
          confirmButtonText: 'Aceptar'
        });
    });

    // Eliminar el fondo del modal (asegúrate de que la función esté definida)
    removeModalBackdrop();
  }
</script>
