<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

include_once 'model/model_conexion.php'; // Asegúrate de incluir la conexión correctamente
$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();
$cedula = isset($_GET['cedula']) ? $_GET['cedula'] : ''; // Obtener la cédula de la consulta

// Solo procesar si hay cédula
if ($cedula != '') {
    try {
        $sql = "SELECT idinfopractica, fecha, actividades, detalle, hIngreso, hSalida, hEfectiva, fotos FROM infopractica WHERE cedulaEstudiante = :cedula";
        $query = $pdo->prepare($sql);
        $query->bindParam(':cedula', $cedula, PDO::PARAM_STR);
        $query->execute();
        $resultados = $query->fetchAll(PDO::FETCH_ASSOC);

        // Devolver los datos como JSON
        echo json_encode($resultados);
    } catch (PDOException $e) {
        echo json_encode(['error' => 'Error al ejecutar la consulta: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['error' => 'Cédula no proporcionada.']);
}

// Cerrar la conexión
$conexion->cerrar_conexion();
?>
