<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cambio de Contraseña</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #21376D;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .form-container {
            background: white;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            padding: 30px;
            max-width: 500px;
            width: 100%;
        }
        .form-title {
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 20px;
            text-align: center;
            color: #21376D;
        }
        .btn-primary {
            background-color: #21376D;
            border: none;
        }
        .btn-primary:hover {
            background-color: #28c0a5;
        }
    </style>
</head>
<body>
    <div class="form-container">
        <h2 class="form-title">Cambio de Contraseña</h2>
        <form>
            <div class="mb-3">
                <label for="newPassword" class="form-label">Nueva Contraseña</label>
                <input type="password" class="form-control" id="newPassword" placeholder="Ingrese la nueva contraseña" required>
            </div>
            <div class="mb-3">
                <label for="confirmNewPassword" class="form-label">Confirmar Nueva Contraseña</label>
                <input type="password" class="form-control" id="confirmNewPassword" placeholder="Confirme la nueva contraseña" required>
            </div>
            <div class="d-flex justify-content-between">
                <button type="reset" class="btn btn-secondary">Cancelar</button>
                <button type="submit" class="btn btn-primary">Guardar Cambios</button>
            </div>
        </form>
    </div>
</body>
</html>
