<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Enviar Correo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* Estilos generales */
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f7fc;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }

        .card {
            width: 100%;
            max-width: 450px;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .card-header {
            background-color: #21376D;
            color: white;
            padding: 15px;
            text-align: center;
            font-size: 20px;
            border-radius: 8px 8px 0 0;
        }

        .form-container {
            padding: 20px;
        }

        input[type="email"] {
            width: 100%;
            padding: 12px;
            margin: 10px 0;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 16px;
            box-sizing: border-box;
        }

        button {
            width: 100%;
            padding: 12px;
            background-color: #21376D;
            color: white;
            font-size: 16px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        button:hover {
            background-color: #1b2b56;
        }

        /* Mensaje de confirmación */
        .response-message {
            text-align: center;
            margin-top: 20px;
            padding: 15px;
            border-radius: 5px;
            display: none;
            font-size: 16px;
        }

        .success {
            background-color: #28a745;
            color: white;
        }

        .error {
            background-color: #dc3545;
            color: white;
        }

        /* Estilos de la animación de carga */
        .loading {
            display: none;
            text-align: center;
            margin-top: 15px;
        }

        /* Asegurar que el formulario no se desborde en pantallas pequeñas */
        @media (max-width: 576px) {
            .card {
                max-width: 100%;
                padding: 10px;
            }

            input[type="email"], button {
                font-size: 14px;
                padding: 10px;
            }
        }
    </style>
</head>
<body>

<div class="card">
    <div class="card-header">
        Reseteo de Contraseña
    </div>

    <div class="form-container">
        <!-- Formulario que envía la solicitud POST al archivo PHP -->
        <form action="send_email.php" method="POST">
            <label for="email">Ingrese su Correo</label>
            <input type="email" id="email" name="email" placeholder="Tu correo electrónico" required>
            <button type="submit">Enviar</button>
        </form>
    </div>

    <!-- Mensaje de confirmación -->
    <div id="response-message" class="response-message"></div>

    <!-- Animación de carga -->
    <div id="loading" class="loading">
        <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Cargando...</span>
        </div>
    </div>
</div>

</body>
</html>
