<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['S_ID'])) {
  header('Location: ../index.php');
}

$id_usuario = $_SESSION['S_ID'];
include_once '../../model/model_conexion.php';

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

$solicitudes = [];

if ($pdo) {
  $sql = "SELECT cedulaEstudiante, idCarrera, idPeriodo, fInicio, fFin, horas, estado FROM solicitud where cedulaEstudiante='".$cedula."'";

  try {
    $query = $pdo->prepare($sql);
    $query->execute();
    $resultados = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resultados) {
      foreach ($resultados as $row) {
        $solicitudes[] = [
          'cedulaEstudiante' => $row['cedulaEstudiante'] ?? 'NO REGISTRA',
          'idCarrera' => $row['idCarrera'] ?? 'NO REGISTRA',
          'idPeriodo' => $row['idPeriodo'] ?? 'NO REGISTRA',
          'fInicio' => $row['fInicio'] ?? 'NO REGISTRA',
          'fFin' => $row['fFin'] ?? 'NO REGISTRA',
          'horas' => $row['horas'] ?? 'NO REGISTRA',
          'estado' => $row['estado'] ?? 'NO REGISTRA',
          'accion' => "<a href='#' class='btn btn-primary btn-sm' data-bs-toggle='modal' data-bs-target='#modalEditarEstado' onclick='editarEstado(\"" . $row['cedulaEstudiante'] . "\")'><i class='fas fa-pencil-square-o' aria-hidden='true'></i> Cambiar Estado</a>"
        ];
      }
    }
  } catch (PDOException $e) {
    error_log("Error al ejecutar la consulta: " . $e->getMessage());
  }
} else {
  echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>

<!-- Incluir los recursos necesarios para Bootstrap y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css" />
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>

<style>

.badge {
    display: inline-block;
    padding: 0.5em 1em;
    border-radius: 12px;
    font-size: 14px;
    font-weight: bold;
    color: white;
    text-align: center;
    min-width: 100px;
    box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
    transition: all 0.3s ease-in-out;
}

.badge.pendiente {
    background-color: limegreen;
    animation: glow 1.5s infinite;
}


.badge.finalizado {
    background-color: crimson;
}


.badge.proceso {
    background-color: dodgerblue;
}
#loading-screen {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(255, 255, 255, 0.8); /* Fondo blanco semi-transparente */
        z-index: 9999;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        border: 16px solid #f3f3f3;
        border-top: 16px solid #17285e;
        border-radius: 50%;
        width: 120px;
        height: 120px;
        animation: spin 2s linear infinite;
    }


@keyframes glow {
    0% {
        box-shadow: 0 0 5px limegreen;
    }
    50% {
        box-shadow: 0 0 15px limegreen;
    }
    100% {
        box-shadow: 0 0 5px limegreen;
    }
   
}
@keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
  tbody {
    text-align: center;
    align-items: center;
  }
</style>


<!-- Cabecera -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0">LISTA DE SOLICITUDES PRACTICAS</h1>
       <div id="loading-screen">
        <div class="spinner"></div>
      </div>
      </div>
    </div>
  </div>
</div>

<div id="loading-screen">
    <div class="spinner"></div>
</div>

<!-- Main content -->
<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">
            <div class="col-12 table-responsive">
              <table id="tabla_tramites" class="display" style="width:100%">
                <thead>
                  <tr>
                    <th class="text-center">Cedula Estudiante</th>
                    <th class="text-center">Carrera</th>
                    <th class="text-center">Periodo</th>
                    <th class="text-center">Fecha Inicio</th>
                    <th class="text-center">Fecha Fin</th>
                    <th class="text-center">Horas</th>
                    <th class="text-center">Estado</th>
                    <th class="text-center">Accion</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($solicitudes as $solicitud): ?>
                    <tr>
                      <td><?php echo $solicitud['cedulaEstudiante']; ?></td>
                      <td><?php echo $solicitud['idCarrera']; ?></td>
                      <td><?php echo $solicitud['idPeriodo']; ?></td>
                      <td><?php echo $solicitud['fInicio']; ?></td>
                      <td><?php echo $solicitud['fFin']; ?></td>
                      <td><?php echo $solicitud['horas']; ?></td>
                      <td>
                        <?php
                         $estado = $solicitud['estado'];
                       if ($estado === 'PENDIENTE') {
                        echo '<span class="badge bg-danger">Pendiente</span>';
                      } elseif ($estado === 'APROBADO') {
                        echo '<span class="badge bg-success">Aprobado</span>';
                      } elseif ($estado === 'EN PROCESO') {
                        echo '<span class="badge bg-primary">En Proceso</span>';
                      } elseif ($estado === 'RECHAZADO') {
                        echo '<span class="badge bg-warning">Rechazado</span>';
                      } elseif ($estado === 'FINALIZADO') {
                        echo '<span class="badge bg-dark">Finalizado</span>';
                      } else {
                        echo '<span class="badge bg-secondary">ERROR</span>';
                      }
                        ?>
                      </td>
                      <td><?php echo $solicitud['accion']; ?></td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal de Edición con Bootstrap -->
<div class="modal fade" id="modalEditarEstado" tabindex="-1" aria-labelledby="modalEditarEstadoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalEditarEstadoLabel">Cambiar Estado del Trámite</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="formEditarEstado">
          <div class="mb-3">
            <label for="estado" class="form-label">Estado del Trámite</label>
            <select class="form-control" id="estado" name="estado">
              <option value="NO REGISTRA">No Registra</option>
              <option value="PENDIENTE">Pendiente</option>
              <option value="APROBADO">Aprobado</option>
              <option value="EN PROCESO">En Proceso</option>
            </select>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" id="guardarBtn" onclick="guardarEstado()">Guardar</button>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function() {
    // Inicializar la tabla DataTable
    $('#tabla_tramites').DataTable();
    // Hide the loading screen after the table is initialized
    $('#loading-screen').hide();
  });

  // Función para abrir el modal de edición
  function editarEstado(cedulaEstudiante) {
    console.log("Editando estado para el estudiante con cédula: " + cedulaEstudiante);
    // Aquí puedes cargar el estado actual del estudiante si lo deseas.
    // Se abrirá el modal automáticamente gracias a Bootstrap.
  }

  // Función para guardar el estado
  function guardarEstado() {
    var estado = document.getElementById("estado").value;
    M.toast({
      html: 'Estado actualizado a: ' + estado,
      classes: 'green'
    });
    // Aquí puedes agregar la lógica para guardar el estado en la base de datos si es necesario.
    // Cerrar el modal después de guardar.
    var modal = bootstrap.Modal.getInstance(document.getElementById('modalEditarEstado'));
    modal.hide();
  }
</script>