<?php 
session_start();
 
$id = $_GET['id'];

?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">SUBIR SOLICITUD</h1>
            </div><!-- /.col -->
        </div>
    </div>
</div>
<div class="container mt-5">
    <div class="card-container">
        <div class="card card-primary">
            <div class="card-header">
                <h3>Aprobación de Entidad Receptora</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="mb-2">
                            <h4 class="card-tittle">Cargar Aprobación</h4>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="input-field">
                            <!-- Cambié el método de POST a GET en el formulario -->
                                 <input type="file" class="form-control" style="width: 100%;" name="txt_solicitud" id="txt_solicitud" accept="application/pdf" required>
                        </div>
                    </div>
                     <div class="col-md-4">
                        <div class="mb-2">
                              <button class="btn btn-lg bg-primary" onclick="guardarDatos()">Enviar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Materialize JS -->
<link rel="stylesheet" href="../plantilla/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<script type="text/javascript">
     function guardarDatos() {
  // Recopilar todos los datos del formulario
  var archivo = document.getElementById('txt_solicitud').files[0];

  // Validar si el archivo ha sido seleccionado
  if (!archivo) {
    Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'Por favor selecciona un archivo PDF.',
      confirmButtonText: 'Aceptar'
    });
    return;
  }

  // Validar el tamaño del archivo (10 MB = 10,485,760 bytes)
  var maxSize = 10 * 1024 * 1024; // 10 MB en bytes
  if (archivo.size > maxSize) {
    Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'El archivo es demasiado grande. El tamaño máximo permitido es de 10 MB.',
      confirmButtonText: 'Aceptar'
    });
    return;
  }

  // Validar que el archivo sea un PDF
  if (!archivo.name.toLowerCase().endsWith('.pdf')) {
    Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'Por favor selecciona un archivo PDF válido.',
      confirmButtonText: 'Aceptar'
    });
    return;
  }

  // Crear un objeto FormData para enviar los datos
  var formData = new FormData();
  formData.append('id', <?php echo $id ?>);
  formData.append('archivo', archivo);
  
  // Enviar los datos al servidor
  fetch('ingreso/ingreso_sol_pdf.php', {
    method: 'POST',
    body: formData
  })
  .then(response => response.json())
  .then(data => {
    if (data.success) {
      // Mensaje de éxito con SweetAlert
      Swal.fire({
        icon: 'success',
        title: 'Éxito',
        text: 'Datos guardados correctamente',
        confirmButtonText: 'Aceptar'
      }).then(() => {
        // Redirigir a index.html después del mensaje de éxito
        window.location.href = '../index.php';
      });
    } else {
      // Mensaje de error con SweetAlert
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: 'Error al guardar los datos: ' + data.message,
        confirmButtonText: 'Aceptar'
      });
    }
  })
  .catch((error) => {
    console.error('Error:', error);
    // Mensaje de error si ocurre algún fallo en la solicitud
    Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'Error al guardar los datos',
      confirmButtonText: 'Aceptar'
    });
  });
}
</script>
