<?php
require('pdf/fpdf.php'); // Asegúrate de que la ruta sea correcta
header('Content-Type: text/html; charset=utf-8');

class PDF extends FPDF
{
    // Encabezado
    function Header()
    {
        // Imagen a la izquierda
        $this->Image('img/fondo.png', 1, 1, 210); // Ruta de la imagen
        // Ajustar la posición X para el texto
        $this->SetX(10); // Cambia el valor según sea necesario para alinear el texto

        // Imagen a la derecha (ajusta la posición según necesites)
        // $this->Image('../img/header.png', 160, 10, 40); // Ruta de la imagen
    }

    // Cuerpo
    function Body()
    {

        include_once '../../model/model_conexion.php';

        $conexion = new conexionBD;
        $pdo= $conexion->conexionPDO();

        $id=$_GET['id'];
        $cestudiante='';
        $nestudiante='';
        $nempresa='';
        $responsable='';
        $cargo='';
        $periodo='';
        $carrera='';
        $fInicio='';
        $coestudiante='';
        $testudiante='';
        $ffin='';
        $horas='';

        if($pdo){
            $sql = "SELECT s.cedulaEstudiante, s.celular_estudiante,s.correo_estudiante, s.Carrera, s.NombreEstudiante, pe.nEmpresa, pe.responsable, pe.cargo_empresa, s.Periodo, s.fInicio, s.fFin, s.horas, s.fecha FROM solicitud s join prac_empresa pe on pe.cedulaEstudiante=s.cedulaEstudiante WHERE s.idsolicitud='$id';";
            try {
                $stmt = $pdo->prepare($sql);
                $stmt->execute();
                $info = $stmt->fetchAll(PDO::FETCH_ASSOC);

                if($info){
                    foreach($info as $estudiante){
                        $fecha=isset($estudiante['fecha']) ? $estudiante['fecha']:'[No Registra]';
                        $cestudiante= isset($estudiante['cedulaEstudiante']) ? $estudiante['cedulaEstudiante']:'[No Registra]';
                        $nestudiante=isset($estudiante['NombreEstudiante']) ? $estudiante['NombreEstudiante']: '[No Registra]';
                        $nempresa=isset($estudiante['nEmpresa']) ? $estudiante['nEmpresa']: '[No Registra]';
                        $responsable =isset($estudiante['responsable'])? $estudiante['responsable']:'[No Registra]';
                        $cargo = isset($estudiante['cargo_empresa'])? $estudiante['cargo_empresa']:'[No Registra]';
                        $periodo = isset($estudiante['Periodo']) ? $estudiante['Periodo']:'[No Registra]';
                        $carrera = isset($estudiante['Carrera']) ? $estudiante['Carrera']:'[No Registra]';
                        $fInicio =isset($estudiante['fInicio']) ? $estudiante['fInicio']: '[No Registra]';
                        $coestudiante =isset($estudiante['correo_estudiante']) ? $estudiante['correo_estudiante']: '[No Registra]';
                        $testudiante =isset($estudiante['celular_estudiante']) ? $estudiante['celular_estudiante']: '[No Registra]';
                        $ffin = isset($estudiante['fFin']) ? $estudiante['fFin']: '[No Registra]';
                        $horas =isset($estudiante['horas']) ? $estudiante['horas']: '[No Registra]';
                                            }
                }
                
            } catch (PDOException $e) {
                echo "Error en la conexion :" . $e->getMessage();
            }
        }else {
            echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
        }

        $this->SetLeftMargin(25);
        $this->SetRightMargin(25);
        $this->SetTopMargin(25);
        $this->SetY(30);

        $fechaArray = explode('-', $fecha);

$dia = $fechaArray[2]?:'00';  // Día
$mes = $fechaArray[1]?:'00';  // Mes (en formato numérico)
$anio = $fechaArray[0]?:'00'; // Año

// Definir los meses en español
$meses = [
    '01' => 'Enero',
    '02' => 'Febrero',
    '03' => 'Marzo',
    '04' => 'Abril',
    '05' => 'Mayo',
    '06' => 'Junio',
    '07' => 'Julio',
    '08' => 'Agosto',
    '09' => 'Septiembre',
    '10' => 'Octubre',
    '11' => 'Noviembre',
    '12' => 'Diciembre'
];

// Obtener el nombre del mes en español usando el mes numérico
$mesEspañol = $meses[$mes];

// Crear el texto con la fecha en formato "Mes Día, Año"
$textoFecha = $mesEspañol . ' ' . $dia . ', ' . $anio;

        $text = 'Daule, ' . $textoFecha;

        $this->SetFont('Arial', 'BI', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetFillColor(0, 56, 175);
        $this->SetY(30);
        $this->Cell(160, 6, $text, 0, 1, 'R');
        $this->SetY(36);
        $this->Ln(5);

        $text2 = 'Econ. Roberto Caicedo Meza';
        $this->SetFont('Arial', 'BI', 12);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(40); // Volver a establecer Y para el texto
        $this->Cell(70, 6, $text2, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text2 = 'Coordinador de Vinculación Institucional';
        $this->SetFont('Arial', 'BI', 12);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(44); // Volver a establecer Y para el texto
        $this->Cell(86, 6, (mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8')), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text3 = 'Instituto Superior Tecnológico Rey David';
        $this->SetFont('Arial', 'BI', 13);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(48); // Volver a establecer Y para el texto
        $this->Cell(71, 6, (mb_convert_encoding($text3, 'ISO-8859-1', 'UTF-8')), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text2 = 'Asunto: Solicitud de inicio de Prácticas Profesionales';
        $this->SetFont('Arial', 'B', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(62); // Volver a establecer Y para el texto
        $this->Cell(55, 6, (mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8')), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text2 = 'De mi consideración:';
        $this->SetFont('Arial', '', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(73); // Volver a establecer Y para el texto
        $this->Cell(55, 6, (mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8')), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text4 = 'Por medio del presente, yo '.$nestudiante.', con cédula de ciudadanía Nº '.$cestudiante.', estudiante de la carrera de '.$carrera.', solicito a usted muy comedidamente, se digne autorizar la ejecución de las Prácticas Preprofesionales, de acuerdo con el detalle indicado a continuación:';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(85);
        $this->MultiCell(0, 6, (mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8')), 0, 'J');
        $this->Ln(3);

        $text4 = '- INSTITUCIÓN/EMPRESA RECEPTORA : '.$nempresa;
        $this->SetFont('Arial', '', 10);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(110);
        $this->Cell(10); 
        $this->Cell(0, 6, (mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8')), 0, 1, 'L'); 
        $this->Ln(5);

        $text4 = '- RESPONSABLE DE LA EMPRESA: '.(mb_convert_encoding($responsable, 'ISO-8859-1', 'UTF-8'));
        $this->SetFont('Arial', '', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(115); // Volver a establecer Y para el texto
        $this->Cell(10); 
        $this->Cell(0, 6, $text4, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = '- CARGO: '.$cargo;
        $this->SetFont('Arial', '', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(120); // Volver a establecer Y para el texto
        $this->Cell(10); 
        $this->Cell(0, 6, $text4, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = '- PERÍODO: ' .$periodo;
        $this->SetFont('Arial', '', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(125); // Volver a establecer Y para el texto
        $this->Cell(10); 
        $this->Cell(0, 6, (mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8')), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = '- FECHA DE INICIO: '.$fInicio;
        $this->SetFont('Arial', '', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(130); // Volver a establecer Y para el texto
        $this->Cell(10); 
        $this->Cell(0, 6, $text4, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = '- FECHA DE FIN: '.$ffin;
        $this->SetFont('Arial', '', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(135); // Volver a establecer Y para el texto
        $this->Cell(10); 
        $this->Cell(0, 6, $text4, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = '- HORAS DE PRÁCTICAS A CUMPLIR: '.$horas;
        $this->SetFont('Arial', '', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(140); // Volver a establecer Y para el texto
        $this->Cell(10); 
        $this->Cell(0, 6, (mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8')), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = 'También aprovecho para solicitar de la manera más cordial la designación de un tutor de seguimiento de las actividades.';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(150);
        $this->MultiCell(0, 6, (mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8')), 0, 'J');
        $this->Ln(3);

        $text4 = 'Por la atención al presente, anticipo mi agradecimiento. ';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(165);
        $this->MultiCell(0, 6, (mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8')), 0, 'J');
        $this->Ln(5);

        $text4 = 'Atentamente, ';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(180);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);

        $text4 = $nestudiante;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(210);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);
        $text4 = $cestudiante;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(215);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);
        $text4 = $coestudiante;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(220);
        $this->MultiCell(0, 6, (mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8')), 0, 'J');
        $this->Ln(5);
        $text4 = ($testudiante == 0) ? '' : $testudiante;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(225);
        $this->MultiCell(0, 6,(mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8')), 0, 'J');
        $this->Ln(5);

       
    }

    // Pie de página
    /* function Footer()
    {
        $this->SetY(-35);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'ISTRED - Pagina ' . $this->PageNo(), 0, 0, 'L'); // Alineación a la izquierda
    }*/
}

// Crear una instancia de PDF
$pdf = new PDF();
$pdf->AddPage();
$pdf->Body(); // Llamar a la función que agrega el cuerpo
$pdf->Output('I', 'documento.pdf');
