<?php

require('pdf/fpdf.php'); // Asegúrate de que la ruta sea correcta
header('Content-Type: text/html; charset=utf-8');

class PDF extends FPDF
{
    // Encabezado
    function Header()
    {
        // Imagen a la izquierda
        $this->Image('img/fondo.png', 1, 1, 210); // Ruta de la imagen
        // Ajustar la posición X para el texto
        $this->SetX(10); // Cambia el valor según sea necesario para alinear el texto

        // Imagen a la derecha (ajusta la posición según necesites)
        // $this->Image('../img/header.png', 160, 10, 40); // Ruta de la imagen
    }

    // Cuerpo
    function Body()
    {

     

        include_once '../../model/model_conexion.php';

        $conexion = new conexionBD();
        $pdo = $conexion->conexionPDO();

        $id = 9;

     
        $nestudiante = '';
        $testudiante = '';
        $caestudiante = '';
        $nempresa = '';
        $finicio = '';
        $ffin = '';

        if ($pdo) {
            
        $stmt = $pdo->prepare("SELECT s.idsolicitud,pe.nEmpresa, s.Periodo, s.NombreEstudiante, s.Carrera, s.cedulaEstudiante, s.celular_estudiante, s.correo_estudiante, s.fInicio, s.fFin FROM prac_empresa pe JOIN solicitud s on s.idsolicitud=pe.idEmpresa where s.idsolicitud =:id and s.estado='FINALIZADO'");
       
       try {
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        $datos = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($datos) {
        
                $ciestudiante = isset($datos['cedulaEstudiante'])?$datos['cedulaEstudiante']:'NO REGISTRA';
                $nempresa = isset($datos['nEmpresa'])?$datos['nEmpresa']:'NO REGISTRA';
                $periodo = isset($datos['Periodo'])?$datos['Periodo']:'NO REGISTRA';
                $nestudiante = isset($datos['NombreEstudiante'])?$datos['NombreEstudiante']:'NO REGISTRA';
                $celestudiante  = isset($datos['celular_estudiante'])?$datos['celular_estudiante']:'NO REGISTRA';
                $coestudiante = isset($datos['correo_estudiante'])?$datos['correo_estudiante']:'NO REGISTRA';
                $finicio = isset($datos['fInicio'])?$datos['fInicio']:'NO REGISTRA';
                $ffin = isset($datos['fFin'])?$datos['fFin']:'NO REGISTRA';
                $caestudiante = isset($datos['Carrera'])?$datos['Carrera']:'NO REGISTRA';
             
        } else {
           
        }
    } catch (PDOException $e) {
        echo 'Error: '. $e->getMessage();
    }
        } else {
            echo '<script>alert("No se pudo conectar a la base de datos");</script>';
        }
        $conexion->cerrar_conexion();

        $this->SetLeftMargin(25);
        $this->SetRightMargin(25);
        $this->SetTopMargin(25);

        $this->SetY(30);

        $fecha = date('d', strtotime('today'));
        $mes = date('m', strtotime('today'));
        $anio = date('Y', strtotime('today'));
        $meses = [
            '01' => 'Enero',
            '02' => 'Febrero',
            '03' => 'Marzo',
            '04' => 'Abril',
            '05' => 'Mayo',
            '06' => 'Junio',
            '07' => 'Julio',
            '08' => 'Agosto',
            '09' => 'Septiembre',
            '10' => 'Octubre',
            '11' => 'Noviembre',
            '12' => 'Diciembre'
        ];

        $mesEspañol = $meses[$mes];
        $textoFecha = $mesEspañol . ' ' . $fecha . ', ' . $anio;
        $text = 'Daule, ' . $textoFecha;

        $this->SetFont('Arial', 'BI', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetFillColor(0, 56, 175);
        $this->SetY(30);
        $this->Cell(160, 6, $text, 0, 1, 'R');
        $this->SetY(36);
        $this->Ln(5);

        $text2 = 'Econ. Roberto Caicedo Meza';
        $this->SetFont('Arial', 'BI', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(40); // Volver a establecer Y para el texto
        $this->Cell(70, 6, $text2, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text2 = 'Coordinador de Vinculación Institucional';
        $this->SetFont('Arial', 'BI', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(44); // Volver a establecer Y para el texto
        $this->Cell(86, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text3 = 'Instituto Superior Tecnológico Rey David';
        $this->SetFont('Arial', 'BI', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(48); // Volver a establecer Y para el texto
        $this->Cell(71, 6, mb_convert_encoding($text3, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text2 = 'Asunto: Notificación de finalización de Prácticas Profesionales';
        $this->SetFont('Arial', 'B', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(62); // Volver a establecer Y para el texto
        $this->Cell(55, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text2 = 'De mi consideración:';
        $this->SetFont('Arial', '', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(73); // Volver a establecer Y para el texto
        $this->Cell(55, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text4 = 'Por medio del presente, yo ' . $nestudiante . ', con cédula de ciudadanía N.º ' . $ciestudiante . ', estudiante de la carrera de ' . $caestudiante . ', notifico a Usted muy comedidamente, que he finalizado mis actividades correspondientes a Prácticas Preprofesionales, de acuerdo con el detalle indicado a continuación';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(85);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(3);

        $text4 = '- INSTITUCIÓN/EMPRESA RECEPTORA: ' . $nempresa;
        $this->SetFont('Arial', '', 10);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(110);
        $this->Cell(20);
        $this->Cell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');
        $this->Ln(5);

        $text4 = '- PERÍODO: ' . $finicio . ' hasta ' . $ffin;
        $this->SetFont('Arial', '', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(115); // Volver a establecer Y para el texto
        $this->Cell(20);
        $this->Cell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = 'También aprovecho para solicitar de la manera más cordial la designación de un tutor de seguimiento de las actividades.';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(125);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(3);

        $text4 = 'Por la atención al presente, anticipo mi agradecimiento. ';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(145);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(5);

        $text4 = 'Atentamente, ';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(155);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);

        $text4 = $nestudiante;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(190);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(5);
        $text4 = $ciestudiante;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(195);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);
        $text4 = $celestudiante??'';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(200);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);
    }

    // Pie de página
    /* function Footer()
    {
        $this->SetY(-35);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'ISTRED - Pagina ' . $this->PageNo(), 0, 0, 'L'); // Alineación a la izquierda
    }*/
//}
}

// Crear una instancia de PDF
$pdf = new PDF();
$pdf->AddPage();
$pdf->Body(); // Llamar a la función que agrega el cuerpo
$pdf->Output('I', 'documento.pdf');
ob_end_clean();
