<?php
session_start();
require('pdf/fpdf.php'); // Asegúrate de que la ruta sea correcta
header('Content-Type: text/html; charset=utf-8');

class PDF extends FPDF
{
    // Encabezado
    function Header()
    {  
        include_once '../../model/model_conexion.php';
        
         $cedula = $_SESSION['S_USU'];
         $idsol =$_GET['id'];
         
         $this->idsol=$idsol;
         
        $conexion = new conexionBD;
        $pdo = $conexion->conexionPDO();

        if ($pdo) {

            $sql = "SELECT * FROM prac_empresa pe join solicitud s on s.cedulaEstudiante=pe.cedulaEstudiante where idEmpresa='".$idsol."'";

            try {
                $stmt = $pdo->prepare($sql);
                $stmt->execute();
                $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

                if ($resultados) {
                    foreach ($resultados as $empresa) {
                        $nentidad = isset($empresa['nEmpresa'])?$empresa['nEmpresa']:'[NO REGISTRA]';
                        $tentidad = isset($empresa['tipo_empresa'])?$empresa['tipo_empresa']:'[NO REGISTRA]';
                        $rempresa = isset($empresa['ruc_empresa'])?$empresa['ruc_empresa']:'[NO REGISTRA]';
                        $telempresa = isset($empresa['telefono_empresa'])?$empresa['telefono_empresa']:'[NO REGISTRA]';
                        $correoe = isset($empresa['correo_empresa'])?$empresa['correo_empresa']:'[NO REGISTRA]';
                        $dempresa = isset($empresa['direccion_empresa'])?$empresa['direccion_empresa']:'[NO REGISTRA]';
                        $dedempresa = isset($empresa['dedica_empresa'])?$empresa['dedica_empresa']:'[NO REGISTRA]';
                        $numero =isset($empresa['stasol'])?$empresa['stasol']:'[NO REGISTRA]';
                        $sempresa = isset($empresa['actividad_empresa'])?$empresa['actividad_empresa']:'[NO REGISTRA]';
                        $aemrpesa = isset($empresa['arpra_empresa'])?$empresa['arpra_empresa']:'[NO REGISTRA]';
                        $indempresa = isset($empresa['rmateriales_empresa'])?$empresa['rmateriales_empresa']:'[NO REGISTRA]';
                        $pempresa = isset($empresa['provee_empresa'])?$empresa['provee_empresa']:'[NO REGISTRA]';
                        $exempresa = isset($empresa['exp_empresa'])?$empresa['exp_empresa']:'[NO REGISTRA]';
                        $nempresa = isset($empresa['npracticantes_empresa'])?$empresa['npracticantes_empresa']:'[NO REGISTRA]';
                        $fecha =isset($empresa['fecha'])?$empresa['fecha']:'[NO REGISTRA]';
                    }
                }
            } catch (PDOException $e) {
                echo "Error en la conexion :" . $e->getMessage();
            }
        } else {
            echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
        }
         
         
        $fechaArray = explode('-', $fecha);

         $dia = $fechaArray[2]?:'00';  
         $mes = $fechaArray[1]?:'00';  
         $anio = $fechaArray[0]?:'00'; 
         
        $meses = [
            '01' => 'Enero',
            '02' => 'Febrero',
            '03' => 'Marzo',
            '04' => 'Abril',
            '05' => 'Mayo',
            '06' => 'Junio',
            '07' => 'Julio',
            '08' => 'Agosto',
            '09' => 'Septiembre',
            '10' => 'Octubre',
            '11' => 'Noviembre',
            '12' => 'Diciembre'
        ];

        $mesEspañol = $meses[$mes];
        $textoFecha = $mesEspañol . ' ' . $dia . ', ' . $anio;

        // Imagen a la izquierda
        $this->Image('img/fondo.png', 1, 1, 210); // Ruta de la imagen
        // Ajustar la posición X para el texto
        $this->SetX(10); // Cambia el valor según sea necesario para alinear el texto

        // Imagen a la derecha (ajusta la posición según necesites)
        $this->Image('img/logo-vinc-prac.jpg', 10, 40, 60); // Ruta de la imagen

        $this->SetFont('Arial', '', 9);
        $this->SetTextColor(52, 73, 94);
        $this->SetY(30);

        $this->Cell(60, 30, '', 1, 0, 'C');
        $this->Cell(60, 10, '', 1, 0, 'C');
        $this->Cell(60, 10, '', 1, 1, 'C');

        $this->Cell(60, 10, '', 0, 0, 'C');
        $this->Cell(60, 10, '', 1, 0, 'C');
        $this->Cell(60, 10, '', 1, 1, 'C');

        $this->Cell(60, 10, '', 0, 0, 'C');
        $this->Cell(60, 10, '', 1, 0, 'C');
        $this->Cell(60, 10, '', 1, 1, 'C');

        $this->SetFont('Arial', 'B', 7);
        $this->SetTextColor(0, 0, 0);
        $this->SetXY(40, 30);
        $this->MultiCell(120, 5, mb_convert_encoding("INSTITUTO SUPERIOR TECNOLOGICO REY DAVID", 'ISO-8859-1', 'UTF-8'), 0, 'C');

        $this->SetFont('Arial', '', 8);
        $this->SetTextColor(0, 0, 0);
        $this->SetXY(41, 41);
        $this->MultiCell(120, 3, mb_convert_encoding("COORDINACIÓN DE VINCULACIÓN", 'ISO-8859-1', 'UTF-8'), 0, 'C');
        $this->SetXY(40, 46);
        $this->MultiCell(120, 3, "INSTITUCIONAL", 0, 'C');

        $text = 'Codigo:';
        $this->SetFont('Arial', 'BI', 7);
        $this->SetTextColor(0, 0, 0);
        $this->SetFillColor(0, 56, 175);
        $this->SetY(30);
        $this->Cell(180, 6, $text, 0, 1, 'R');
        $this->SetY(36);
        $this->Ln(5);
        
         $oficio = str_pad($numero, 3, '0', STR_PAD_LEFT);

        $text = 'CVINCINST-ISTRED-FSIRPP-' . $anio.'-'.$oficio.'';
        $this->SetFont('Arial', 'BI', 7);
        $this->SetTextColor(0, 0, 0);
        $this->SetFillColor(0, 56, 175);
        $this->SetY(35);
        $this->Cell(180, 6, $text, 0, 1, 'R');
        $this->SetY(36);
        $this->Ln(5);

        $text = 'Fecha: ' . $textoFecha;
        $this->SetFont('Arial', 'BI', 7);
        $this->SetTextColor(0, 0, 0);
        $this->SetFillColor(0, 56, 175);
        $this->SetY(40);
        $this->Cell(180, 6, $text, 0, 1, 'R');
        $this->SetY(36);
        $this->Ln(5);

        $this->SetAutoPageBreak(true, 15);
        $this->AliasNbPages();
        $text = mb_convert_encoding('Página ', 'ISO-8859-1', 'UTF-8') . $this->PageNo() . ' de {nb}';
        $this->SetFont('Arial', 'BI', 7);
        $this->SetTextColor(0, 0, 0);
        $this->SetFillColor(0, 56, 175);
        $this->SetY(50);
        $this->Cell(180, 6, $text, 0, 1, 'R');
    }

    // Cuerpo
    function Body()
    {
        include_once '../../model/model_conexion.php';
        $cedula = $_SESSION['S_USU'];
        
        $nentidad = '';
        $tentidad= '';
        $rempresa= '';
        $telempresa= '';
        $correoe= '';
        $dempresa= '';
        $dedempresa= '';
        $sempresa= '';
        $aemrpesa= '';
        $indempresa= '';
        $pempresa= '';
        $exempresa= '';
        $nempresa= '';

        $conexion = new conexionBD;
        $pdo = $conexion->conexionPDO();

        if ($pdo) {

            $sql = "SELECT * FROM prac_empresa pe join solicitud s on s.cedulaEstudiante=pe.cedulaEstudiante where idEmpresa='".$this->idsol."'";

            try {
                $stmt = $pdo->prepare($sql);
                $stmt->execute();
                $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

                if ($resultados) {
                    foreach ($resultados as $empresa) {
                        $nentidad = isset($empresa['nEmpresa'])?$empresa['nEmpresa']:'[NO REGISTRA]';
                        $tentidad = isset($empresa['tipo_empresa'])?$empresa['tipo_empresa']:'[NO REGISTRA]';
                        $rempresa = isset($empresa['ruc_empresa'])?$empresa['ruc_empresa']:'[NO REGISTRA]';
                        $telempresa = isset($empresa['telefono_empresa'])?$empresa['telefono_empresa']:'[NO REGISTRA]';
                        $correoe = isset($empresa['correo_empresa'])?$empresa['correo_empresa']:'[NO REGISTRA]';
                        $dempresa = isset($empresa['direccion_empresa'])?$empresa['direccion_empresa']:'[NO REGISTRA]';
                        $dedempresa = isset($empresa['dedica_empresa'])?$empresa['dedica_empresa']:'[NO REGISTRA]';
                        $sempresa = isset($empresa['actividad_empresa'])?$empresa['actividad_empresa']:'[NO REGISTRA]';
                        $aemrpesa = isset($empresa['arpra_empresa'])?$empresa['arpra_empresa']:'[NO REGISTRA]';
                        $indempresa = isset($empresa['rmateriales_empresa'])?$empresa['rmateriales_empresa']:'[NO REGISTRA]';
                        $pempresa = isset($empresa['provee_empresa'])?$empresa['provee_empresa']:'[NO REGISTRA]';
                        $exempresa = isset($empresa['exp_empresa'])?$empresa['exp_empresa']:'[NO REGISTRA]';
                        $nempresa = isset($empresa['npracticantes_empresa'])?$empresa['npracticantes_empresa']:'[NO REGISTRA]';
                        $fecha =isset($empresa['fecha'])?$empresa['fecha']:'[NO REGISTRA]';
                    }
                }
            } catch (PDOException $e) {
                echo "Error en la conexion :" . $e->getMessage();
            }
        } else {
            echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
        }

        $this->SetLeftMargin(25);
        $this->SetRightMargin(25);
        $this->SetTopMargin(25);

        $this->SetY(30);

        $fechaArray = explode('-', $fecha);

         $dia = $fechaArray[2]?:'00';  
         $mes = $fechaArray[1]?:'00';  
         $anio = $fechaArray[0]?:'00'; 
         
        $meses = [
            '01' => 'Enero',
            '02' => 'Febrero',
            '03' => 'Marzo',
            '04' => 'Abril',
            '05' => 'Mayo',
            '06' => 'Junio',
            '07' => 'Julio',
            '08' => 'Agosto',
            '09' => 'Septiembre',
            '10' => 'Octubre',
            '11' => 'Noviembre',
            '12' => 'Diciembre'
        ];

        $mesEspañol = $meses[$mes];
        $textoFecha = $mesEspañol . ' ' . $dia . ', ' . $anio;
        $text = 'Daule, ' . $textoFecha;

        $this->SetFont('Arial', 'BI', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetFillColor(0, 56, 175);
        $this->SetY(64);
        $this->Cell(160, 6, $text, 0, 1, 'R');
        $this->SetY(36);
        $this->Ln(5);

        $text2 = 'FICHA DE SELECCIÓN DE LA INSTITUCION';
        $this->SetFont('Arial', 'BI', 7);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(49); // Volver a establecer Y para el texto
        $this->Cell(150, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'C'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text2 = 'RECEPTORA DE PRÁCTICAS';
        $this->SetFont('Arial', 'BI', 7);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(52); // Volver a establecer Y para el texto
        $this->Cell(150, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'C'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text3 = 'PREPROFESIONALES';
        $this->SetFont('Arial', 'BI', 7);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(55); // Volver a establecer Y para el texto
        $this->Cell(150, 6, $text3, 0, 1, 'C'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);
        
        $text2 = 'Nombre de la entidad receptora: '. $nentidad;
        $this->SetFont('Arial', '', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(75); // Volver a establecer Y para el texto
        $this->Cell(55, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text4 = 'Tipo: '.mb_convert_encoding($tentidad, 'ISO-8859-1', 'UTF-8');
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(85);
        $this->MultiCell(0, 6, $text4, 0, 'L');
        $this->Ln(3);

        $text4 = 'RUC:  ' . $rempresa;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(95);
        $this->MultiCell(0, 6, $text4, 0, 'L');
        $this->Ln(3);

        $text4 = 'Teléfono:  ' . $telempresa;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(105);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'L');
        $this->Ln(3);

        $text4 = 'Correo electrónico:  ' . $correoe;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(105);
        $this->Cell(80);
        $this->Cell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');
        $this->Ln(5);

        $text4 = 'Dirección:  ' . $dempresa;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(115);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'L');
        $this->Ln(3);

        $text4 = 'Descripción de la actividad económica: ' . $dedempresa;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(125);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'L');
        $this->Ln(3);

        $text4 = 'Servicio:   ' . mb_convert_encoding($sempresa, 'ISO-8859-1', 'UTF-8');
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(135);
        $this->MultiCell(0, 6, $text4, 0, 'L');
        $this->Ln(3);

        $text4 = 'Áreas donde realizará las prácticas: '.$aemrpesa;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(145);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(3);

        $text4 = 'Requiere indumentaria o insumos específicos:  ' . $indempresa;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(155);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(5);

        $text4 = 'Provee la institución o estudiante:   ' . $pempresa;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(165);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(5);

        $text4 = 'Experiencia como entidad formadora:  ' . $exempresa;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(175);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);

        $text4 = 'Necesidad de practicantes (número):  ' . $nempresa;
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(185);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(5);

        $text4 = 'Por lo antes descrito, y conforme al análisis y validación de la información, realizada por la Coordinación de Vinculación con la Sociedad y Prácticas Preprofesionales se aprueba la entidad formadora.';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(200);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(3);
        
        $text4 = 'Econ. Roberto Caicedo Meza';
        $this->SetFont('Arial', '', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(245);
        $this->MultiCell(0, 6, $text4, 0, 'L');
        $this->Ln(5);

        $text4 = 'Coordinación de Vinculación Institucional';
        $this->SetFont('Arial', 'B', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(250);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'L');
        $this->Ln(5);
    }

    // Pie de página
    /* function Footer()
    {
        $this->SetY(-35);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'ISTRED - Pagina ' . $this->PageNo(), 0, 0, 'L'); // Alineación a la izquierda
    }*/
}

// Crear una instancia de PDF
$pdf = new PDF();
$pdf->AddPage();
$pdf->Body(); // Llamar a la función que agrega el cuerpo
$pdf->Output('I', 'documento.pdf');
