<?php
require('pdf/fpdf.php'); // Asegúrate de que la ruta sea correcta
header('Content-Type: text/html; charset=utf-8');

class PDF extends FPDF
{
    // Encabezado
    function Header()
    {
        // Imagen a la izquierda
        $this->Image('img/header.png', 10, 10, 65); // Ruta de la imagen
        // Ajustar la posición X para el texto
        $this->SetX(10); // Cambia el valor según sea necesario para alinear el texto

        // Imagen a la derecha (ajusta la posición según necesites)
        // $this->Image('../img/header.png', 160, 10, 40); // Ruta de la imagen
    }

    // Cuerpo
    function Body()
    {

        $this->SetLeftMargin(25);
        $this->SetRightMargin(25);
        $this->SetTopMargin(25);
        $this->SetY(30);

        $fecha = date('d', strtotime('today'));
        $mes = date('m', strtotime('today'));
        $anio = date('Y', strtotime('today'));
        $meses = [
            '01' => 'Enero',
            '02' => 'Febrero',
            '03' => 'Marzo',
            '04' => 'Abril',
            '05' => 'Mayo',
            '06' => 'Junio',
            '07' => 'Julio',
            '08' => 'Agosto',
            '09' => 'Septiembre',
            '10' => 'Octubre',
            '11' => 'Noviembre',
            '12' => 'Diciembre'
        ];

        $mesEspañol = $meses[$mes];
        $textoFecha = $mesEspañol . ' ' . $fecha . ', ' . $anio;
        $text = 'Daule, ' . $textoFecha;

        $this->SetFont('Arial', 'BI', 12);
        $this->SetTextColor(0, 0, 0);
        $this->SetFillColor(0, 56, 175);
        $this->SetY(30);
        $this->Cell(160, 6, $text, 0, 1, 'R');
        $this->SetY(36);
        $this->Ln(5);

        $text2 = 'Econ. Roberto Caicedo Meza';
        $this->SetFont('Arial', 'BI', 12);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(40); // Volver a establecer Y para el texto
        $this->Cell(70, 6, $text2, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text2 = 'Coordinador de Vinculación Institucional';
        $this->SetFont('Arial', 'BI', 12);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(44); // Volver a establecer Y para el texto
        $this->Cell(86, 6, $text2, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text3 = 'Instituto Superior Tecnológico Rey David';
        $this->SetFont('Arial', 'BI', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(48); // Volver a establecer Y para el texto
        $this->Cell(71, 6, $text3, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text2 = 'Asunto: Solicitud de inicio de Prácticas Profesionales';
        $this->SetFont('Arial', 'B', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(62); // Volver a establecer Y para el texto
        $this->Cell(55, 6, $text2, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text2 = 'De mi consideración:';
        $this->SetFont('Arial', '', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(73); // Volver a establecer Y para el texto
        $this->Cell(55, 6, $text2, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text4 = 'Por medio del presente, yo xxxxxxxxx, con cédula de ciudadanía Nºxxxxx, estudiante de la carrera de Elija un elemento., solicito a usted muy comedidamente, se digne autorizar la ejecución de las Prácticas Preprofesionales, de acuerdo con el detalle indicado a continuación:';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(85);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(3);

        $text4 = '- INSTITUCIÓN/EMPRESA RECEPTORA:';
        $this->SetFont('Arial', 'B', 10);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(110);
        $this->Cell(10); 
        $this->Cell(0, 6, $text4, 0, 1, 'L'); 
        $this->Ln(5);

        $text4 = '- RESPONSABLE DE LA EMPRESA:';
        $this->SetFont('Arial', 'B', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(115); // Volver a establecer Y para el texto
        $this->Cell(10); 
        $this->Cell(0, 6, $text4, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = '- CARGO:';
        $this->SetFont('Arial', 'B', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(120); // Volver a establecer Y para el texto
        $this->Cell(10); 
        $this->Cell(0, 6, $text4, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = '- PERÍODO:';
        $this->SetFont('Arial', 'B', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(125); // Volver a establecer Y para el texto
        $this->Cell(10); 
        $this->Cell(0, 6, $text4, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = '- FECHA DE INICIO:';
        $this->SetFont('Arial', 'B', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(130); // Volver a establecer Y para el texto
        $this->Cell(10); 
        $this->Cell(0, 6, $text4, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = '- FECHA DE FIN:';
        $this->SetFont('Arial', 'B', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(135); // Volver a establecer Y para el texto
        $this->Cell(10); 
        $this->Cell(0, 6, $text4, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = '- HORAS DE PRÁCTICAS A CUMPLIR:';
        $this->SetFont('Arial', 'B', 10);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(140); // Volver a establecer Y para el texto
        $this->Cell(10); 
        $this->Cell(0, 6, $text4, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text4 = 'También aprovecho para solicitar de la manera más cordial la designación de un tutor de seguimiento de las actividades.';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(150);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(3);

        $text4 = 'Por la atención al presente, anticipo mi agradecimiento. ';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(165);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);

        $text4 = 'Atentamente, ';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(175);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);

        $text4 = 'Nombre del estudiante  ';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(190);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);
        $text4 = 'cedula  ';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(195);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);
        $text4 = 'N.º de telf. del estudiante:';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(200);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);
        $text4 = 'Dirección de correo electrónico';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(205);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);

       
    }

    // Pie de página
    /* function Footer()
    {
        $this->SetY(-35);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'ISTRED - Pagina ' . $this->PageNo(), 0, 0, 'L'); // Alineación a la izquierda
    }*/
}

// Crear una instancia de PDF
$pdf = new PDF();
$pdf->AddPage();
$pdf->Body(); // Llamar a la función que agrega el cuerpo
$pdf->Output('I', 'documento.pdf');
