<?php
require('pdf/fpdf.php'); // Asegúrate de que la ruta sea correcta
header('Content-Type: text/html; charset=utf-8');

class PDF extends FPDF
{
    // Encabezado
    function Header()
    {
        // Imagen a la izquierda
        $this->Image('img/fondo.png', 1, 1, 210); // Ruta de la imagen
        // Ajustar la posición X para el texto
        $this->SetX(10); // Cambia el valor según sea necesario para alinear el texto

        // Imagen a la derecha (ajusta la posición según necesites)
        // $this->Image('../img/header.png', 160, 10, 40); // Ruta de la imagen
    }

    // Cuerpo
    function Body()
    {
        
        if(isset($_GET['id']) && !empty($_GET['id'])){
        
        
        $carrera='[carrera]';
        $promocion='[promocion]';
        $cargo='[cargo tutor empresa]';
        $empresa='[nombre empresa]';
        $nombre='[nombre estudinte]';
        $ci='[cedula estudiante]';
        $horas='[horas practica]';

        $this->SetLeftMargin(25);
        $this->SetRightMargin(25);
        $this->SetTopMargin(25);
        
         include_once '../../model/model_conexion.php';
        
        $id=$_GET['id'];
        
        $conexion = new conexionBD;
        $pdo= $conexion->conexionPDO();

        if($pdo){
            $sql = "SELECT s.idsolicitud, s.NombreEstudiante, s.cedulaEstudiante, s.nomenclatura, pe.nEmpresa, s.Carrera, s.horas, ast.promo, s.fInicio, s.fFin, s.f_aprobacion, s.id_oficio_inicio, pe.responsable, pe.cargo_empresa, ast.nombre_tutor, ast.telefono_tutor, ast.correo_tutor FROM solicitud s JOIN asig_tutor ast ON ast.CedulaEstudiante = s.cedulaEstudiante JOIN prac_empresa pe on pe.idEmpresa=s.idsolicitud WHERE s.idsolicitud = :id";
            try {
                $stmt = $pdo->prepare($sql);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                $stmt->execute();
                $info = $stmt->fetch(PDO::FETCH_ASSOC);

                if($info){
                    $nombre=isset($info['NombreEstudiante'])?$info['NombreEstudiante']:'';
                    $ci=isset($info['cedulaEstudiante'])?$info['cedulaEstudiante']:'';
                    $siglas=isset($info['nomenclatura'])?$info['nomenclatura']:'';
                    $carrera=isset($info['Carrera'])?$info['Carrera']:'';
                    $horas=isset($info['horas'])?$info['horas']:'';
                    $responsable = isset($info['responsable'])? $info['responsable']:'';
                    $cargo = isset($info['cargo_empresa'])? $info['cargo_empresa']:'';
                    $empresa=isset($info['nEmpresa'])?$info['nEmpresa']:'';
                    $tutornombre=isset($info['nombre_tutor'])?$info['nombre_tutor']:'';
                    $tutortelefono=isset($info['telefono_tutor'])?$info['telefono_tutor']:'';
                    $tutorcorreo=isset($info['correo_tutor'])?$info['correo_tutor']:'';
                    $finicio=isset($info['fInicio'])?$info['fInicio']:'';
                    $ffin=isset($info['fFin'])?$info['fFin']:'';
                    $promocion=isset($info['promo'])?$info['promo']:'';
                    $fecha=isset($info['f_aprobacion'])?$info['f_aprobacion']:'';
                    $oficio=isset($info['id_oficio_inicio'])?$info['id_oficio_inicio']:'000';
                    
                }
                
            } catch (PDOException $e) {
                echo "Error en la conexion :" . $e->getMessage();
            }
        }else {
            echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
        }
        
       $fechaArray = explode('-', $fecha);

$dia = $fechaArray[2]?:'00';  // Día
$mes = $fechaArray[1]?:'00';  // Mes (en formato numérico)
$anio = $fechaArray[0]?:'00'; // Año

        $meses = [
            '01' => 'Enero',
            '02' => 'Febrero',
            '03' => 'Marzo',
            '04' => 'Abril',
            '05' => 'Mayo',
            '06' => 'Junio',
            '07' => 'Julio',
            '08' => 'Agosto',
            '09' => 'Septiembre',
            '10' => 'Octubre',
            '11' => 'Noviembre',
            '12' => 'Diciembre'
        ];

        $mesEspañol = $meses[$mes];
        $textoFecha = $mesEspañol . ' ' . $dia . ', ' . $anio;
        $text = 'Daule, ' . $textoFecha;
        
         $numero = str_pad($oficio, 3, '0', STR_PAD_LEFT);

        $text2 = 'Oficio CVINCINST-UPLCR-ISTRED-'.strtoupper($siglas).'-'.strtoupper($promocion).'-'.strtoupper($mesEspañol).'-No.'.$numero.'';
                $this->SetFont('Arial', 'BI', 12);
        $this->SetY(28);
        $this->Cell(0, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'R');
        $this->Ln(2); // Espacio inferior

        $this->SetFont('Arial', 'BI', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetFillColor(0, 56, 175);
        $this->SetY(38);
        $this->Cell(160, 6, $text, 0, 1, 'R');
        $this->SetY(36);
        $this->Ln(5);

        $text2 = $responsable??'[NO REGISTRA]';
        $this->SetFont('Arial', 'BI', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(50); // Volver a establecer Y para el texto
        $this->Cell(70, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text2 = $cargo??'[NO REGISTRA]';
        $this->SetFont('Arial', 'BI', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(54); // Volver a establecer Y para el texto
        $this->Cell(86, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text3 = $empresa??'[NO REGISTRA]';
        $this->SetFont('Arial', 'BI', 11);
        $textWidth = $this->GetStringWidth($text3);
        $this->SetY(58); // Volver a establecer Y para el texto
        $this->Cell(71, 6, mb_convert_encoding($text3, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5);

        $text2 = 'Asunto:  Solicitud para realización de prácticas.';
        $this->SetFont('Arial', 'B', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(70); // Volver a establecer Y para el texto
        $this->Cell(55, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text2 = 'En su despacho';
        $this->SetFont('Arial', '', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(78); // Volver a establecer Y para el texto
        $this->Cell(55, 6, $text2, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text4 = 'Reciba un cordial saludo, de quienes conformamos el Instituto Superior Tecnológico Rey David, con sede en el cantón Daule desde el año de 1995.';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(85);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(3);

        $text4 = 'Mediante el presente manifestamos a usted que, la misión del ISTRED es formar Profesionales proactivos, motivos por el cual en busca de mejorar la calidad de la educación superior a nivel nacional e interesados en potenciar los conocimientos teóricos de nuestros alumnos a través del desarrollo de actividades académicas tales como, Vinculación con la Sociedad y Prácticas Preprofesionales en instituciones que cuenten con  la infraestructura técnica y el equipamiento especializado que permitan a través de la práctica demostrar sus conocimientos y a su vez adquirir nuevas habilidades para así, cumplir con la misión institucional.';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(105);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(3);

        $text4 = 'Mediante el presente solicitamos a usted de manera muy comedida en calidad de '.$cargo.' de '.$empresa.', que el señor/ra '.$nombre.', con cédula de ciudadanía '.$ci.' estudiante de la carrera de '.$carrera.' pueda realizar prácticas pre profesionales en la empresa que dignamente usted representa por '.$horas.' horas.';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(160);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(5);

        $text4 = 'En espera optimista que en la prontitud de sus posibilidades se logrará de usted o de quien dignamente corresponda la aprobación de lo expuesto, quedamos de usted altamente agradecido, en la que además se indique el área, los datos del tutor empresarial, las actividades y el horario en el que el estudiante realizará sus prácticas en el entorno laboral real. Sírvase además encontrar el anexo donde se encuentran los datos del estudiante y del tutor académico designado, en la que también se estipula una fecha tentativa de inicio y de fin de las prácticas preprofesionales.';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(195);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'J');
        $this->Ln(5);

        $text4 = 'Atentamente, ';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(240);
        $this->MultiCell(0, 6, $text4, 0, 'J');
        $this->Ln(5);

        $text4 = 'Econ. Roberto Caicedo Meza';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(260);
        $this->MultiCell(0, 6, $text4, 0, 'C');
        $this->Ln(5);

        $text4 = 'Coordinador de Vinculación Institucional';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(265);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'C');
        $this->Ln(5);

        $text4 = 'Instituto Superior Tecnológico Rey David';
        $this->SetFont('Arial', '', 11);
        $this->SetTextColor(0, 0, 0);
        $this->SetY(270);
        $this->MultiCell(0, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 'C');
        $this->Ln(5);
        }
    }

    // Pie de página
    /* function Footer()
    {
        $this->SetY(-35);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'ISTRED - Pagina ' . $this->PageNo(), 0, 0, 'L'); // Alineación a la izquierda
    }*/
}

// Crear una instancia de PDF
$pdf = new PDF();
$pdf->AddPage();
$pdf->Body(); // Llamar a la función que agrega el cuerpo
$pdf->Output('I', 'documento.pdf');
