<?php
require('pdf/fpdf.php'); // Asegúrate de que la ruta sea correcta
header('Content-Type: text/html; charset=utf-8');

class PDF extends FPDF
{
    // Encabezado
    function Header()
    {
        // Imagen a la izquierda
        $this->Image('img/header.png', 10, 10, 40); // Ruta de la imagen
        // Ajustar la posición X para el texto
        $this->SetX(10); // Cambia el valor según sea necesario para alinear el texto

        // Texto centrado debajo de la imagen
        $this->SetFont('Arial', 'B', 11);
        $this->SetTextColor(52, 73, 94);
        $insti = 'INSTITUTO SUPERIOR TECNOLÓGICO REY DAVID';
        $this->MultiCell(0, 5, mb_convert_encoding($insti, 'ISO-8859-1', 'UTF-8'), 0, 'C');

        $this->SetFont('Arial', '', 9);
        $this->SetTextColor(52, 73, 94);
        $this->MultiCell(0, 3, "Olmedo y Misael Acosta Daule-Guayas-Ecuador", 0, 'C');
        $this->MultiCell(0, 3, "Telefono: 043963738", 0, 'C');
        $this->MultiCell(0, 3, "Email: info@itred.edu.ec", 0, 'C');


        // Espacio entre el encabezado y el cuerpo
        $this->Ln(5);
    }

    // Cuerpo
    function Body()
    {
        include_once '../../model/model_conexion.php';

        if(isset($_GET['id']) && !empty($_GET['id'])){
            $id = $_GET['id'];
        $conexion = new conexionBD();
        $pdo=$conexion->conexionPDO();

        if($pdo){

            $sql = "SELECT s.NombreEstudiante, ep.fecha_eval, s.Periodo, s.fInicio, s.fFin, pe.nEmpresa, pe.responsable, pe.cargo_empresa, ast.promo, ep.p1_p1,ep.p1_p2,ep.p1_p3,ep.p1_p4,ep.p1_p5,ep.p1_p6,ep.p2_p1,ep.p2_p2,ep.p2_p3,ep.p2_p4,ep.p2_p5,ep.p3_p1,ep.p3_p2,ep.p3_p3,ep.p3_p4,ep.ob1,ep.ob2,ep.ob3 FROM eval_empresa ep JOIN solicitud s on s.idsolicitud=ep.idsol join prac_empresa pe on pe.idEmpresa=ep.idsol join asig_tutor ast on ast.CedulaEstudiante = s.cedulaEstudiante WHERE ep.id_eval='".$id."'";
            
            try{
            $stmt = $pdo->prepare($sql);
            $stmt->execute();
            $empresa = $stmt->fetch(PDO::FETCH_ASSOC);

            if($empresa){
               
                    $nombre = $empresa['NombreEstudiante'];
                    $fecha = $empresa['fecha_eval']??'[NO REGISTRA]';
                    $periodo = $empresa['Periodo']??'[NO REGISTRA]';
                    $fInicio = $empresa['fInicio']??'[NO REGISTRA]';
                    $promocion = $empresa['promo']??'[NO REGISTRA]';
                    $fFin = $empresa['fFin']??'[NO REGISTRA]';
                    $nempresa = $empresa['nEmpresa']??'[NO REGISTRA]';
                    $responsable = $empresa['responsable']??'[NO REGISTRA]';
                    $cargo = $empresa['cargo_empresa']??'[NO REGISTRA]';
                    $p1_p1 = $empresa['p1_p1']??'[NO REGISTRA]';
                    $p1_p2 = $empresa['p1_p2']??'[NO REGISTRA]';
                    $p1_p3 = $empresa['p1_p3']??'[NO REGISTRA]';
                    $p1_p4 = $empresa['p1_p4']??'[NO REGISTRA]';
                    $p1_p5 = $empresa['p1_p5']??'[NO REGISTRA]';
                    $p1_p6 = $empresa['p1_p6']??'[NO REGISTRA]';
                    $p2_p1 = $empresa['p2_p1']??'[NO REGISTRA]';
                    $p2_p2 = $empresa['p2_p2']??'[NO REGISTRA]';
                    $p2_p3 = $empresa['p2_p3']??'[NO REGISTRA]';
                    $p2_p4 = $empresa['p2_p4']??'[NO REGISTRA]';
                    $p2_p5 = $empresa['p2_p5']??'[NO REGISTRA]';
                    $p3_p1 = $empresa['p3_p1']??'[NO REGISTRA]';
                    $p3_p2 = $empresa['p3_p2']??'[NO REGISTRA]';
                    $p3_p3 = $empresa['p3_p3']??'[NO REGISTRA]';
                    $p3_p4 = $empresa['p3_p4']??'[NO REGISTRA]';
                    $ob1 = $empresa['ob1']??'[NO REGISTRA]';
                    $ob2 = $empresa['ob2']??'[NO REGISTRA]';
                    $ob3 = $empresa['ob3']??'[NO REGISTRA]';
                    
                

            }else{
                echo "<script>alert('No se encontraron datos')</script>";
            }

        }catch(PDOException $e){
            echo "<script>alert('Error al ejecutar la consulta')</script>";
            echo $e->getMessage();

        }
        }else{
            echo "<script>alert('Error al conectar con la base de datos')</script>";
        }


        $this->SetY(30); // Margen superior para el cuerpo
        $text = 'FICHA SEGUIMIENTO EMPRESA';
        $this->SetFont('Arial', 'B', 12);
        $this->SetTextColor(0, 0, 0); // Color blanco para el texto
        $textWidth = $this->GetStringWidth($text);
        $this->SetFillColor(0, 56, 175);
        $this->SetY(30); // Volver a establecer Y para el texto
        $this->Cell(180, 6, $text, 0, 1, 'C'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $text2 = 'INFORMACIÓN GENERAL';
        $this->SetFont('Arial', 'B', 11);
        $textWidth = $this->GetStringWidth($text2);
        $this->SetY(40); // Volver a establecer Y para el texto
        $this->Cell(60, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $this->SetY(50);
        $this->SetFont('Arial', 'B', 10);

        $text1 = 'ESTUDIANTE:';
        $this->Cell(40, 6, $text1, 0, 0, 'L');
        $this->SetFont('Arial', '', 10);
        $this->Cell(50, 6, $nombre , 0, 1, 'L');

        $this->SetFont('Arial', 'B', 10);
        $text2 = 'PROMOCIÓN:';
        $this->Cell(40, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
        $this->SetFont('Arial', '', 10);
        $this->Cell(50, 6,$promocion, 0, 1, 'L');
        
         $this->SetFont('Arial', 'B', 10);
        $text2 = 'NOMBRE ENTIDAD:';
        $this->Cell(40, 6, $text2, 0, 0, 'L');
        $this->SetFont('Arial', '', 10);
        $this->Cell(50, 6, mb_convert_encoding($nempresa, 'ISO-8859-1', 'UTF-8') , 0, 1, 'L');

        $this->SetFont('Arial', 'B', 10);
        $text2 = 'FECHA DE INICIO:';
        $this->Cell(40, 6, $text2, 0, 0, 'L');
        $this->SetFont('Arial', '', 10);
        $this->Cell(50, 6, $fInicio , 0, 1, 'L');

        $this->SetFont('Arial', 'B', 10);
        $text2 = 'CARGO EVALUADOR:';
        $this->Cell(40, 6, $text2, 0, 0, 'L');
        $this->SetFont('Arial', '', 10);
        $this->MultiCell(50, 4, $cargo , 0, 'L');

        // Segunda columna
        $this->SetY(50);
        $this->SetX(110); // Ajusta este valor para la posición de la segunda columna
        $this->SetFont('Arial', 'B', 10);

        $text3 = 'FECHA DE EVALUACIÓN:';
        $this->Cell(50, 6, mb_convert_encoding($text3, 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
        $this->SetFont('Arial', '', 10);
        $this->Cell(50, 6, mb_convert_encoding($fecha, 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');

        $this->SetX(110); // Mantener la alineación con la segunda columna
        $this->SetFont('Arial', 'B', 10);
        $text4 = 'PERIODO ACADÉMICO:';
        $this->Cell(50, 6, mb_convert_encoding($text4, 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
        $this->SetFont('Arial', '', 10);
        $this->MultiCell(50, 6, mb_convert_encoding($periodo, 'ISO-8859-1', 'UTF-8'), 0,'L');

        $this->SetX(110); // Mantener la alineación con la segunda columna
        $this->SetFont('Arial', 'B', 10);
        $text4 = 'FECHA DE FIN:';
        $this->Cell(50, 6, $text4, 0, 0, 'L');
        $this->SetFont('Arial', '', 10);
        $this->Cell(50, 6, $fFin , 0, 1, 'L');

        $this->SetX(110); // Mantener la alineación con la segunda columna
        $this->SetFont('Arial', 'B', 10);
        $text4 = 'EVALUADOR:';
        $this->Cell(50, 6, $text4, 0, 0, 'L');
        $this->SetFont('Arial', '', 10);
        $this->MultiCell(50, 6, mb_convert_encoding($responsable, 'ISO-8859-1', 'UTF-8'), 0, 'L');

        $this->Ln(5);

        $text6 = '1.- EVALUACION DE CONOCIMIENTOS GENERALES';
        $this->SetFont('Arial', 'B', 11);
        $this->SetY(90); // Volver a establecer Y para el texto
        $this->Cell(60, 6, $text6, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $this->SetFont('Arial', 'B', 10); // Cambiar el tamaño y estilo de la fuente
        $this->MultiCell(80, 8, 'Los conocimientos generales asignados son evaluados con los siguientes criterios:', 0, 'L');
        $this->SetFont('Arial', '', 8); // Volver a cambiar el tamaño y estilo de la fuente

        // Ajuste la posición Y antes de comenzar la primera fila de celdas
        $posicionY = $this->GetY();
        $this->SetXY(90, $posicionY - 14); // Ajustar la posición X e Y para las subceldas

        // Primera fila
        $this->Cell(70, 10, 'Calidad del trabajo realizado', 1, 0, 'L');
        $this->Cell(10, 10, $p1_p1, 1, 1, 'C'); // 1, 1 para terminar la fila

        // Segunda fila
        $this->Cell(80, 8, '', 0, 0, 'L');
        $this->Cell(70, 10, 'Grado de independencia', 1, 0, 'L');
        $this->Cell(10, 10, $p1_p2, 1, 1, 'C'); // 1, 1 para terminar la fila

        // Tercera fila
        $this->Cell(80, 8, '', 0, 0, 'L');
        $t1 = 'El estudiante demuestra conocimientos en el área de práctica pre-profesional';
        $this->MultiCell(70, 5, mb_convert_encoding($t1, 'ISO-8859-1', 'UTF-8'), 1, 'L');
        $this->SetXY(160, $this->GetY() - 10); // Ajustar la posición X e Y para la última celda
        $this->Cell(10, 10, $p1_p3, 1, 1, 'C'); // 1, 1 para terminar la fila

        // Cuarta fila
        $this->Cell(80, 16, '', 0, 0, 'L');
        $this->MultiCell(70, 5, 'Utiliza los recursos necesarios en las tareas asignadas', 1, 'L');
        $this->SetXY(160, $this->GetY() - 10);
        $this->Cell(10, 10, $p1_p4, 1, 1, 'C'); // 1, 1 para terminar la fila

        // Quinta fila
        $this->Cell(80, 16, '', 0, 0, 'L');
        $t2 = 'Aplicación y manejo de destrezas y habilidades acordes al plan de aprendizaje';
        $this->MultiCell(70, 5, mb_convert_encoding($t2, 'ISO-8859-1', 'UTF-8'), 1, 'L');
        $this->SetXY(160, $this->GetY() - 10);
        $this->Cell(10, 10, $p1_p5, 1, 1, 'C'); // 1, 1 para terminar la fila

        // Sexta fila
        $this->Cell(80, 16, '', 0, 0, 'L');
        $t3 = 'Habilidades en el uso de las Tecnologías de la Información y la Comunicación';
        $this->MultiCell(70, 5, mb_convert_encoding($t3, 'ISO-8859-1', 'UTF-8'), 1, 'L');
        $this->SetXY(160, $this->GetY() - 10);
        $this->Cell(10, 10, $p1_p6, 1, 1, 'C'); // 1, 1 para terminar la fila

        $this->Ln(3); // Espacio entre las filas

        // ** Ajustar la posición Y para la segunda tabla (distancia de separación)**
        $this->SetY($this->GetY()-10); // Aumentar espacio entre las dos tablas

        // Segunda tabla - EVALUACION DE CAPACIDADES
        $text6 = '2.- EVALUACION DE CAPACIDADES';
        $this->SetFont('Arial', 'B', 11);
        $this->SetY($this->GetY() + 10); // Ajustar la posición Y para el texto de la segunda tabla
        $this->Cell(60, 6, $text6, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $this->SetFont('Arial', 'B', 10);
        $t4 = 'Comprensión del trabajo:';
        $this->Cell(80, 8, mb_convert_encoding($t4, 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');

        // Para el siguiente texto, usaremos MultiCell pero ajustamos la posición para evitar que afecte el diseño.
        $this->SetFont('Arial', '', 8); // Volver a cambiar el tamaño y estilo de la fuente
        $this->MultiCell(70, 5, 'Capacidad de entender instrucciones y explicaciones dadas para el desarrollo: ', 1, 'L');
        $this->SetXY(160, $this->GetY() - 10); // R
        $this->Cell(10, 10, $p2_p1, 1, 1, 'C');

        $this->SetFont('Arial', 'B', 10);
        $t5 = 'Asimilación del trabajo:';
        $this->Cell(80, 8, mb_convert_encoding($t5, 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
        $this->SetFont('Arial', '', 8);

        // Usamos MultiCell aquí para evitar que el texto se desborde
        $this->MultiCell(70, 5, 'Capacidad de retener y hacer suyos los conocimientos que se adquieren en el trabajo: ', 1, 'L');
        $this->SetXY(160, $this->GetY() - 10); // Restablecer la posición para que las celdas no se desalineen.
        $this->Cell(10, 10, $p2_p2, 1, 1, 'C');

        $this->SetFont('Arial', 'B', 10);
        $t6 = 'Expresión:';
        $this->Cell(80, 8, mb_convert_encoding($t6, 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
        $this->SetFont('Arial', '', 8);

        // Usamos MultiCell para que el texto largo se ajuste
        $this->MultiCell(70, 5, 'Capacidad de expresar ideas tanto verbalmente como por escrito: ', 1, 'L');
        $this->SetXY($this->GetX() + 150, $this->GetY() - 10); // Ajustar la posición X e Y
        $this->Cell(10, 10, $p2_p3, 1, 1, 'C');

        $this->SetFont('Arial', 'B', 10);
        $this->Cell(80, 8, 'Iniciativa: ', 0, 0, 'L');
        $this->SetFont('Arial', '', 8);

        // Usamos MultiCell para el texto largo
        $t7 = 'Capacidad de generar ideas y acciones pertinentes al trabajo, más allá de las instrucciones y explicaciones recibidas: ';
        $this->MultiCell(70, 5, mb_convert_encoding($t7, 'ISO-8859-1', 'UTF-8'), 1, 'L');
        $this->SetXY($this->GetX() + 150, $this->GetY() - 15); // Ajustar la posición X e Y
        $this->Cell(10, 15, $p2_p4 , 1, 1, 'C');

        $this->SetFont('Arial', 'B', 10);
        $this->Cell(80, 8, 'Respuesta: ', 0, 0, 'L');
        $this->SetFont('Arial', '', 8);

        // Usamos MultiCell para el texto largo
        $t8 = 'Capacidad para identificar, planear y resolver problemas en el área práctica: ';
        $this->MultiCell(70, 5, mb_convert_encoding($t8, 'ISO-8859-1', 'UTF-8'), 1, 'L');
        $this->SetXY($this->GetX() + 150, $this->GetY() - 10); // Ajustar la posición X e Y
        $this->Cell(10, 10, $p2_p5 , 1, 1, 'C');

        $this->Ln(5); // Espacio entre las filas

        // ** Ajustar la posición Y para la segunda tabla (distancia de separación)**
        $this->SetY($this->GetY() + 25); // Aumentar espacio entre las dos tablas

        $text6 = '3.- EVALUACION DE ACTITUDES Y COMPORTAMIENTO';
        $this->SetFont('Arial', 'B', 11);
        $this->SetY($this->GetY() + 10); // Ajustar la posición Y para el texto de la segunda tabla
        $this->Cell(60, 6, $text6, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        // Segunda tabla - EVALUACION DE CAPACIDADES
        $this->SetFont('Arial', 'B', 10);
        $this->Cell(80, 8, 'Responsabilidad', 0, 0, 'L');
        $this->SetFont('Arial', '', 8);
        $tt1 = 'Actitud que induce a ejecutar el trabajo con atención y esmero, haciéndose responsable de las acciones y resultados';
        $this->MultiCell(70, 5, mb_convert_encoding($tt1, 'ISO-8859-1', 'UTF-8'), 1, 'L');
        $this->SetXY($this->GetX() + 150, $this->GetY() - 15);
        $this->Cell(10, 15, $p3_p1, 1, 1, 'C');

        $this->SetFont('Arial', 'B', 10);
        $t9 = 'Dedicación:';
        $tt2 = 'Capacidad de retener y hacer suyos los conocimientos que se adquieren en el trabajo ';
        $this->Cell(80, 8, mb_convert_encoding($t9, 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
        $this->SetFont('Arial', '', 8);

        $this->MultiCell(70, 5, mb_convert_encoding($tt2, 'ISO-8859-1', 'UTF-8'), 1, 'L');
        $this->SetXY($this->GetX() + 150, $this->GetY() - 10);
        $this->Cell(10, 10, $p3_p2, 1, 1, 'C');

        $this->SetFont('Arial', 'B', 10);
        $t10 = 'Calidad de ejecución:';
        $this->Cell(80, 10, mb_convert_encoding($t10, 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');

        $this->SetFont('Arial', '', 8);
        $this->MultiCell(70, 5, 'Capacidad de expresar ideas tanto verbalmente como por escrito: ', 1, 'L');
        $this->SetXY($this->GetX() + 150, $this->GetY() - 10);
        $this->Cell(10, 10, $p3_p3, 1, 1, 'C');

        $this->SetFont('Arial', 'B', 10);
        $this->Cell(80, 8, 'Normas internas: ', 0, 0, 'L');

        $this->SetFont('Arial', '', 8);
        $t8 = 'Capacidad para identificar, planear y resolver problemas en el área práctica: ';
        $this->MultiCell(70, 5, mb_convert_encoding($t8, 'ISO-8859-1', 'UTF-8'), 1, 'L');
        $this->SetXY($this->GetX() + 150, $this->GetY() - 10);
        $this->Cell(10, 10, $p3_p4, 1, 1, 'C');

        $this->Ln(5); // Espacio entre las filas

        // ** Ajustar la posición Y para la segunda tabla (distancia de separación)**
        $this->SetY($this->GetY()-10); // Aumentar espacio entre las dos tablas

        $text6 = 'PUNTAJE FINAL';
        $this->SetFont('Arial', 'B', 11);
        $this->SetY($this->GetY() + 10); // Ajustar la posición Y para el texto de la segunda tabla
        $this->Cell(60, 6, $text6, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $suma1= 0;
        $suma2= 0;
        $suma3= 0;

        $suma1 = $p1_p1 + $p1_p2 + $p1_p3 + $p1_p4 + $p1_p5+ $p1_p6;
        $suma2= $p2_p1 + $p2_p2 + $p2_p3 + $p2_p4 + $p2_p5;
        $suma3= $p3_p1 + $p3_p2 + $p3_p3 + $p3_p4;

        $promedio1=0;
        $promedio2=0;
        $promedio3=0;

        $promedio1=number_format($suma1/6,2);
        $promedio2=number_format($suma2/5,2);
        $promedio3=number_format($suma3/4,2);

        $this->SetFont('Arial', 'B', 10);
        $ta1 = 'Puntaje total en la evaluación de conocimientos generales (ítem 1)';
        $this->Cell(150, 8, mb_convert_encoding($ta1, 'ISO-8859-1', 'UTF-8'), 1, 0, 'L');
        $this->SetFont('Arial', '', 8);
        $this->Cell(10, 8, $promedio1, 1, 1, 'C');

        $this->SetFont('Arial', 'B', 10);
        $ta2 = 'Puntaje total en la evaluación de capacidades (ítem 2)';
        $this->Cell(150, 8, mb_convert_encoding($ta2, 'ISO-8859-1', 'UTF-8'), 1, 0, 'L');
        $this->SetFont('Arial', '', 8);
        $this->Cell(10, 8, $promedio2, 1, 1, 'C');

        $this->SetFont('Arial', 'B', 10);
        $ta3 = 'Puntaje total en la evaluación de actitudes y comportamiento (ítem 3)';
        $this->Cell(150, 8, mb_convert_encoding($ta3, 'ISO-8859-1', 'UTF-8'), 1, 0, 'L');
        $this->SetFont('Arial', '', 8);
        $this->Cell(10, 8, $promedio3, 1, 1, 'C');

        $sumatotal=0;
        $promediototal=0;

        $sumatotal=number_format(($promedio1+$promedio2+$promedio3),2);
        $promediototal=number_format(($sumatotal)/3,2);

        $this->SetFont('Arial', 'B', 10);
        $ta4 = 'SUMA DE TOTALES (sumar los 3 ítems)';
        $this->Cell(150, 8, mb_convert_encoding($ta4, 'ISO-8859-1', 'UTF-8'), 1, 0, 'L');
        $this->SetFont('Arial', '', 8);
        $this->Cell(10, 8, $sumatotal, 1, 1, 'C');

        $this->SetFont('Arial', 'B', 10);
        $ta5 = 'NOTA FINAL DE LA EVALUACIÓN DEL DESEMPEÑO';
        $this->Cell(150, 8, mb_convert_encoding($ta5, 'ISO-8859-1', 'UTF-8'), 1, 0, 'L');
        $this->SetFont('Arial', '', 8);
        $this->Cell(10, 8, $promediototal, 1, 1, 'C');


        $this->Ln(5); // Espacio entre las filas

        // ** Ajustar la posición Y para la segunda tabla (distancia de separación)**
        $this->SetY($this->GetY()-10); // Aumentar espacio entre las dos tablas

        $text6 = 'OBSERVACIONES';
        $this->SetFont('Arial', 'B', 11);
        $this->SetY($this->GetY() + 10); // Ajustar la posición Y para el texto de la segunda tabla
        $this->Cell(60, 6, $text6, 0, 1, 'L'); // Texto centrado sobre el fondo azul
        $this->SetTextColor(0, 0, 0); // Texto negro
        $this->Ln(5); // Espacio inferior

        $this->SetFont('Arial', 'B', 10);
        $to2 = '¿Cuáles son las observaciones positivas o negativas que hay que mencionar, y cuáles son los comentarios y las sugerencias específicas que debe recibir el estudiante para poder mejorar y optimizar su proceso de aprendizaje y comportamiento?';
        $this->multiCell(160, 5, mb_convert_encoding($to2, 'ISO-8859-1', 'UTF-8'), 1, 'L');
        $this->SetXY($this->GetX() , $this->GetY());
        $this->SetFont('Arial', '', 8);
        $this->MultiCell(160, 8, mb_convert_encoding($ob1, 'ISO-8859-1', 'UTF-8'), 1, 'C');

        $this->SetFont('Arial', 'B', 10);
        $to3 = 'De acuerdo a las fortalezas y debilidades del estudiante ¿Qué medidas se deben iniciar para mejorar a corto plazo el desempeño del estudiante?';
        $this->MultiCell(160, 5, mb_convert_encoding($to3, 'ISO-8859-1', 'UTF-8'), 1, 'L');
        $this->SetXY($this->GetX() , $this->GetY());
        $this->SetFont('Arial', '', 8);
        $this->MultiCell(160, 8, mb_convert_encoding($ob2, 'ISO-8859-1', 'UTF-8'), 1, 'C');

        $this->SetFont('Arial', 'B', 10);
        $to4 = '¿Tiene una propuesta sobre un desarrollo específico sobre fortalezas y potencialidades del estudiante?';
        $this->MultiCell(160, 5, mb_convert_encoding($to4, 'ISO-8859-1', 'UTF-8'), 1, 'L');
        $this->SetXY($this->GetX() , $this->GetY());
        $this->SetFont('Arial', '', 8);
        $this->MultiCell(160, 8, mb_convert_encoding($ob3, 'ISO-8859-1', 'UTF-8'), 1, 'C');

    }else{
        $this-> SetFont('Arial', 'B', 12);
        $mensaje = 'No se encontraron datos';
        $this->Cell(0, 10, mb_convert_encoding($mensaje, 'ISO-8859-1', 'UTF-8'), 0, 0, 'C'); // Centrar el texto
    }
    
            $this->Cell(180, 30, mb_convert_encoding('_______________________________________', 'ISO-8859-1', 'UTF-8'), 0,0, 'C');
            $this->SetXY($this->GetX()-190, $this->GetY()+20);
            $this->Cell(0, 0, mb_convert_encoding('Firma Tutor Empresarial', 'ISO-8859-1', 'UTF-8'), 0,0, 'C');
}

    // Pie de página
    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $foot = 'ISTRED - Página ';
        $this->Cell(0, 10, mb_convert_encoding($foot, 'ISO-8859-1', 'UTF-8') . $this->PageNo(), 0, 0, 'L'); // Alineación a la izquierda
    }
}

// Crear una instancia de PDF
$pdf = new PDF();
$pdf->AddPage();
$pdf->Body(); // Llamar a la función que agrega el cuerpo
$pdf->Output('I', 'documento.pdf');
