<?php
session_start();
require('pdf/fpdf.php'); // Asegúrate de que la ruta sea correcta
header('Content-Type: text/html; charset=utf-8');

class PDF extends FPDF
{

    var $cedula;
    // Encabezado
    function Header()
    {

        include_once '../../model/model_conexion.php';

        if (isset($_GET['id']) && !empty($_GET['id'])) {
            $id = $_GET['id'];
            $ideval = $_GET['ideval'];
            $this->ideval = $ideval;
            $conexion = new conexionBD();
            $pdo = $conexion->conexionPDO();

            if ($pdo) {

                $sql = "SELECT s.nomenclatura, s.cedulaEstudiante, ed.visita FROM eval_docente ed JOIN solicitud s on s.idsolicitud=ed.idsol WHERE ed.idsol=".$id." and ed.estudiante_id=".$ideval."";

                try {
                    $stmt = $pdo->prepare($sql);
                    $stmt->execute();
                    $docente = $stmt->fetch(PDO::FETCH_ASSOC);

                    if ($docente) {

                        $nomcarrera = $docente['nomenclatura'] ?? '[NO REGISTRA]';
                        $this->cedula = $docente['cedulaEstudiante'] ?? '[NO REGISTRA]';
                        $fecha = $docente['visita'] ?? '0000-00-00';
                    } else {
                        echo "No se encontraron registros";
                    }
                } catch (PDOException $e) {
                    echo "Error al ejecutar la consulta: " . $e->getMessage();
                }
            }

            // Imagen a la izquierda
            $this->Image('img/fondo.png', 1, 1, 210); // Ruta de la imagen
            // Ajustar la posición X para el texto
            $this->SetX(10); // Cambia el valor según sea necesario para alinear el texto

            // Imagen a la derecha (ajusta la posición según necesites)
            $this->Image('img/logo-vinc-prac.jpg', 9, 35, 65); // Ruta de la imagen

            $this->SetFont('Arial', '', 9);
            $this->SetTextColor(52, 73, 94);
            $this->SetY(30);

            $this->Cell(60, 40, '', 1, 0, 'C');
            $this->Cell(120, 10, '', 1, 1, 'C');

            $this->Cell(60, 10, '', 0, 0, 'C');
            $this->Cell(120, 10, '', 1, 1, 'C');


            $this->Cell(60, 8, '', 1, 0, 'C');
            $this->Cell(30, 8, '', 1, 0, 'C');
            $this->Cell(30, 8, '', 1, 0, 'C');
            $this->Cell(60, 14, '', 1, 0, 'C');
            $this->Cell(0, 8, '', 0, 1, 'C');

            $this->Cell(60, 12, '', 1, 0, 'C');
            $this->Cell(30, 12, '', 1, 0, 'C');
            $this->Cell(30, 12, '', 1, 0, 'C');
            $this->Cell(30, 12, '', 1, 0, 'C');
            $this->Cell(30, 12, '', 1, 0, 'C');

            $this->SetFont('Arial', 'B', 12);
            $this->SetTextColor(0, 0, 0);
            $this->SetXY(70, 32);
            $this->MultiCell(120, 5, mb_convert_encoding('INSTITUTO SUPERIOR TECNOLÓGICO REY DAVID', 'ISO-8859-1', 'UTF-8'), 0, 'C');

            $this->SetFont('Arial', 'B', 8);
            $this->SetTextColor(0, 0, 0);
            $this->SetXY(70, 44);
            $this->MultiCell(120, 3, "SEGUIMIENTO DE ACTIVIDADES EN LA ENTIDAD RECEPTORA", 0, 'C');
            $this->SetXY(40, 46);


            $this->SetAutoPageBreak(true, 15);
            $this->AliasNbPages();
            $text = mb_convert_encoding('Página', 'ISO-8859-1', 'UTF-8') . $this->PageNo() . ' de {nb}';
            $this->SetFont('Arial', 'BI', 7);
            $this->SetTextColor(0, 0, 0);
            $this->SetFillColor(0, 56, 175);
            $this->SetY(64);
            $this->Cell(180, 6, $text, 0, 1, 'R');

            $this->SetY(30);

            $fechaArray = explode('-', $fecha);

            $dia = $fechaArray[2] ?: '00';  // Día
            $mes = $fechaArray[1] ?: '00';  // Mes (en formato numérico)
            $anio = $fechaArray[0] ?: '00'; // Año

            // Definir los meses en español
            $meses = [
                '01' => 'Enero',
                '02' => 'Febrero',
                '03' => 'Marzo',
                '04' => 'Abril',
                '05' => 'Mayo',
                '06' => 'Junio',
                '07' => 'Julio',
                '08' => 'Agosto',
                '09' => 'Septiembre',
                '10' => 'Octubre',
                '11' => 'Noviembre',
                '12' => 'Diciembre'
            ];

            // Obtener el nombre del mes en español usando el mes numérico
            $mesEspañol = $meses[$mes];

            // Crear el texto con la fecha en formato "Mes Día, Año"
            $textoFecha = $mesEspañol . ' ' . $dia . ', ' . $anio;

            $this->SetFont('Arial', 'BI', 8);
            $this->SetTextColor(0, 0, 0);
            $this->SetFillColor(0, 56, 175);
            $this->SetY(58);
            $this->Cell(180, 6, $textoFecha, 0, 1, 'R');
            $this->SetY(36);
            $this->Ln(5);

            $text2 = 'UNIDAD:';
            $this->SetFont('Arial', 'B', 10);
            $textWidth = $this->GetStringWidth($text2);
            $this->SetY(49); // Volver a establecer Y para el texto
            $this->Cell(65, 10, $text2, 0, 1, 'C'); // Texto centrado sobre el fondo azul
            $this->SetTextColor(0, 0, 0); // Texto negro
            $this->Ln(5); // Espacio inferior

            $text2 = 'CODIFICACIÓN:';
            $this->SetFont('Arial', 'B', 10);
            $textWidth = $this->GetStringWidth($text2);
            $this->SetY(49); // Volver a establecer Y para el texto
            $this->Cell(150, 10, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'C'); // Texto centrado sobre el fondo azul
            $this->SetTextColor(0, 0, 0); // Texto negro
            $this->Ln(5); // Espacio inferior

            $text2 = 'CARRERA:';
            $this->SetFont('Arial', 'B', 10);
            $textWidth = $this->GetStringWidth($text2);
            $this->SetY(49); // Volver a establecer Y para el texto
            $this->Cell(210, 10, $text2, 0, 1, 'C'); // Texto centrado sobre el fondo azul
            $this->SetTextColor(0, 0, 0); // Texto negro
            $this->Ln(5); // Espacio inferior

            $text2 = 'VERSIÓN:';
            $this->SetFont('Arial', 'B', 10);
            $textWidth = $this->GetStringWidth($text2);
            $this->SetY(49); // Volver a establecer Y para el texto
            $this->Cell(280, 10, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'C'); // Texto centrado sobre el fondo azul
            $this->SetTextColor(0, 0, 0); // Texto negro
            $this->Ln(5); // Espacio inferior

            $text2 = '1.0';
            $this->SetFont('Arial', '', 10);
            $textWidth = $this->GetStringWidth($text2);
            $this->SetY(49); // Volver a establecer Y para el texto
            $this->Cell(330, 10, $text2, 0, 1, 'C'); // Texto centrado sobre el fondo azul
            $this->SetTextColor(0, 0, 0); // Texto negro
            $this->Ln(5); // Espacio inferior

            $text2 = 'PRÁCTICAS LABORALES EN EL CONTEXTO REAL';
            $this->SetFont('Arial', 'BI', 6.5);
            $textWidth = $this->GetStringWidth($text2);
            $this->SetY(62); // Volver a establecer Y para el texto
            $this->Cell(62, 6, mb_convert_encoding($text2, 'ISO-8859-1', 'UTF-8'), 0, 1, 'C'); // Texto centrado sobre el fondo azul
            $this->SetTextColor(0, 0, 0); // Texto negro
            $this->Ln(5);

            $text3 = 'UPP-005';
            $this->SetFont('Arial', 'BI', 9);
            $textWidth = $this->GetStringWidth($text2);
            $this->SetY(62); // Volver a establecer Y para el texto
            $this->Cell(155, 6, $text3, 0, 1, 'C'); // Texto centrado sobre el fondo azul
            $this->SetTextColor(0, 0, 0); // Texto negro
            $this->Ln(5);

            $carrera = $nomcarrera ?? '[NO REGISTRA]';
            $this->SetFont('Arial', 'BI', 12);
            $textWidth = $this->GetStringWidth($text2);
            $this->SetY(59); // Volver a establecer Y para el texto
            $this->Cell(210, 6, strtoupper($carrera), 0, 1, 'C'); // Texto centrado sobre el fondo azul
            $this->SetTextColor(0, 0, 0); // Texto negro
            $this->Ln(5);

            $text3 = 'FECHA:';
            $this->SetFont('Arial', 'BI', 7);
            $textWidth = $this->GetStringWidth($text2);
            $this->SetY(59); // Volver a establecer Y para el texto
            $this->Cell(270, 6, $text3, 0, 1, 'C'); // Texto centrado sobre el fondo azul
            $this->SetTextColor(0, 0, 0); // Texto negro
            $this->Ln(5);

            $text3 = 'PAG.:';
            $this->SetFont('Arial', 'BI', 7);
            $textWidth = $this->GetStringWidth($text2);
            $this->SetY(64); // Volver a establecer Y para el texto
            $this->Cell(270, 6, mb_convert_encoding($text3, 'ISO-8859-1', 'UTF-8'), 0, 1, 'C'); // Texto centrado sobre el fondo azul
            $this->SetTextColor(0, 0, 0); // Texto negro
            $this->Ln(5);
        }
    }

    // Cuerpo
    function Body()
    {

        include_once '../config/conexion_ip.php';
        include_once '../../model/model_conexion.php';


        $conexion1 = new conexionBD();
        $pdo1 = $conexion1->conexionPDO();

        $conexion2 = new newonexionBD();
        $pdo2 = $conexion2->newconexionPDO();

        $resultados1 = [];
        $resultados2 = [];

        if (isset($_GET['id']) && !empty($_GET['id'])) {



            if ($pdo1) {
                $sql1 = "SELECT s.NombreEstudiante, s.correo_estudiante, pe.nEmpresa, pe.arpra_empresa, s.Periodo, s.fInicio, s.fFin, pe.responsable, ast.nombre_tutor, ast.telefono_tutor, ast.correo_tutor, ed.visita, ast.promo, ed.asistencia, ed.cumplimiento, ed.cactividades, ed.aporte, ed.creatividad, ed.competencias, ed.responsabilidad, ed.bitacoras, ed.indumentaria, ed.actividades, ed.puesto, ed.acompanamiento, ed.evidencias, ed.llamados, ed.entrevista, ed.descripcion1, ed.descripcion2, ed.conclusion, ed.anexo1, ed.anexo2 FROM eval_docente ed JOIN solicitud s on s.idsolicitud=ed.idsol join asig_tutor ast on ast.CedulaEstudiante=s.cedulaEstudiante join prac_empresa pe on pe.idEmpresa=s.idsolicitud WHERE ed.cedula_estudiante = :cedula and estudiante_id=:ideval LIMIT 1";
                try {
                    $query1 = $pdo1->prepare($sql1);
                    $query1->bindParam(':cedula', $this->cedula, PDO::PARAM_STR);
                    $query1->bindParam(':ideval', $this->ideval, PDO::PARAM_INT);
                    $query1->execute();
                    $resultados1 = $query1->fetch(PDO::FETCH_ASSOC);

                    if ($resultados1) {
                        $nombrestudiante = $resultados1['NombreEstudiante'] ?? '[NO REGISTRA]';
                        $correoestudiante = $resultados1['correo_estudiante'] ?? '[NO REGISTRA]';
                        $nombreeempresa = $resultados1['nEmpresa'] ?? '[NO REGISTRA]';
                        $arpraempresa = $resultados1['arpra_empresa'] ?? '[NO REGISTRA]';
                        $periodo = $resultados1['Periodo'] ?? '[NO REGISTRA]';
                        $finicio = $resultados1['fInicio'] ?? '[NO REGISTRA]';
                        $ffin = $resultados1['fFin'] ?? '[NO REGISTRA]';
                        $responsable = $resultados1['responsable'] ?? '[NO REGISTRA]';
                        $nombretutor = $resultados1['nombre_tutor'] ?? '[NO REGISTRA]';
                        $telefonotutor = $resultados1['telefono_tutor'] ?? '[NO REGISTRA]';
                        $correotutor = $resultados1['correo_tutor'] ?? '[NO REGISTRA]';
                        $visita = $resultados1['visita'] ?? '[NO REGISTRA]';
                        $promo = $resultados1['promo'] ?? '[NO REGISTRA]';
                        $asistencia = $resultados1['asistencia'] ?? '[NO REGISTRA]';
                        $cumplimiento = $resultados1['cumplimiento'] ?? '[NO REGISTRA]';
                        $cactividades = $resultados1['cactividades'] ?? '[NO REGISTRA]';
                        $aporte = $resultados1['aporte'] ?? '[NO REGISTRA]';
                        $creatividad = $resultados1['creatividad'] ?? '[NO REGISTRA]';
                        $competencias = $resultados1['competencias'] ?? '[NO REGISTRA]';
                        $responsabilidad = $resultados1['responsabilidad'] ?? '[NO REGISTRA]';
                        $bitacoras = $resultados1['bitacoras'] ?? '[NO REGISTRA]';
                        $indumentaria = $resultados1['indumentaria'] ?? '[NO REGISTRA]';
                        $actividades = $resultados1['actividades'] ?? '[NO REGISTRA]';
                        $puesto = $resultados1['puesto'] ?? '[NO REGISTRA]';
                        $acompanamiento = $resultados1['acompanamiento'] ?? '[NO REGISTRA]';
                        $evidencias = $resultados1['evidencias'] ?? '[NO REGISTRA]';
                        $llamados = $resultados1['llamados'] ?? '[NO REGISTRA]';
                        $entrevista = $resultados1['entrevista'] ?? '[NO REGISTRA]';
                        $conclusion = $resultados1['conclusion'] ?? '[NO REGISTRA]';
                        $descripcion1 = $resultados1['descripcion1'] ?? '[NO REGISTRA]';
                        $descripcion2 = $resultados1['descripcion2'] ?? '[NO REGISTRA]';
                        $anexo1 = $resultados1['anexo1'] ?? '';
                        $anexo2 = $resultados1['anexo2'] ?? '';
                    } else {
                        echo "No se encontraron registros";
                    }
                } catch (PDOException $e) {
                    echo "Error al ejecutar la primera consulta: " . $e->getMessage();
                }
            }

            // Encabezado de la tabla
            $this->SetFont('Arial', 'B', 11);
            $this->Cell(180, 10, 'EVIDENCIA VISITA DE SEGUIMIENTO EN LA ENTIDAD RECEPTORA', 1, 1, 'C');

            if (!empty($resultados1)) {

                // Datos de la tabla
                $this->SetFont('Arial', '', 10);

                $this->Cell(90, 10, 'Nombres y apellidos del estudiante:', 1, 0, 'C');
                $this->Cell(90, 10, $nombrestudiante ?? 'NO REGISTRA', 1, 1, 'C');
                $this->Cell(90, 10, mb_convert_encoding('Promoción:', 'ISO-8859-1', 'UTF-8'), 1, 0, 'C');
                $this->Cell(90, 10, $promo ?? 'NO REGISTRA', 1, 1, 'C');
                $this->Cell(90, 10,  'Correo del estudiante:', 1, 0, 'C');
                $this->Cell(90, 10, $correoestudiante ?? 'NO REGISTRA', 1, 1, 'C');
                $this->Cell(90, 10,  'Nombre de la Entidad Receptora:', 1, 0, 'C');
                $this->Cell(90, 10, mb_convert_encoding($nombreeempresa, 'ISO-8859-1', 'UTF-8') ?? 'NO REGISTRA', 1, 1, 'C');
                $this->Cell(90, 10,  mb_convert_encoding('Área de la Entidad Receptora:', 'ISO-8859-1', 'UTF-8'), 1, 0, 'C');
                $this->Cell(90, 10, mb_convert_encoding($arpraempresa, 'ISO-8859-1', 'UTF-8') ?? 'NO REGISTRA', 1, 1, 'C');
                $this->Cell(90, 10,  mb_convert_encoding('Período académico del estudiante:', 'ISO-8859-1', 'UTF-8'), 1, 0, 'C');
                $this->Cell(90, 10, mb_convert_encoding($periodo, 'ISO-8859-1', 'UTF-8') ?? 'NO REGISTRA', 1, 1, 'C');
                $this->Cell(90, 10,  mb_convert_encoding('Fecha de prácticas:', 'ISO-8859-1', 'UTF-8'), 1, 0, 'C');
                $this->Cell(90, 10, $finicio . ' hasta ' . $ffin, 1, 1, 'C');
                $this->Cell(90, 10,  'Nombres y apellidos del Tutor Empresarial:', 1, 0, 'C');
                $this->Cell(90, 10, mb_convert_encoding($responsable, 'ISO-8859-1', 'UTF-8') ?? 'NO REGISTRA', 1, 1, 'C');
                $this->Cell(90, 10,  mb_convert_encoding('Nombres y apellidos del Tutor Académico:', 'ISO-8859-1', 'UTF-8'), 1, 0, 'C');
                $this->Cell(90, 10, mb_convert_encoding($nombretutor, 'ISO-8859-1', 'UTF-8') ?? 'NO REGISTRA', 1, 1, 'C');
                $this->Cell(90, 10,  mb_convert_encoding('Teléfono del Tutor Académico:', 'ISO-8859-1', 'UTF-8'), 1, 0, 'C');
                $this->Cell(90, 10, $telefonotutor ?? 'NO REGISTRA', 1, 1, 'C');
                $this->Cell(90, 10,  mb_convert_encoding('Correo del Tutor Académico:', 'ISO-8859-1', 'UTF-8'), 1, 0, 'C');
                $this->Cell(90, 10, $correotutor ?? 'NO REGISTRA', 1, 1, 'C');
                $this->Cell(90, 10,  mb_convert_encoding('Fecha de la visita (o reunión zoom):', 'ISO-8859-1', 'UTF-8'), 1, 0, 'C');
                $this->Cell(90, 10, $visita ?? 'NO REGISTRA', 1, 1, 'C');
            } else {
                $this->Cell(180, 8, 'No data', 1, 1, 'C');
            }

            $this->SetFont('Arial', 'B', 11);
            $this->Cell(90, 10,  'DESCRIPCION', 1, 0, 'C');
            $this->Cell(90, 10, 'EVALUACION', 1, 1, 'C');


            $this->SetFont('Arial', '', 9);
            $this->Cell(90, 12,  '1.- Asistencia puntual.', 1, 0, 'L');
            $this->Cell(90, 12, $asistencia ?? 'NO REIGSTRA', 1, 1, 'C');

            $this->MultiCell(90, 12, mb_convert_encoding('2.- Cumplimiento de horas de prácticas programadas.', 'ISO-8859-1', 'UTF-8'), 1, 'L'); // Adjust cell height
            $this->SetXY($this->GetX() + 90, $this->GetY() - 12);
            $this->Cell(90, 12,  $cumplimiento ?? 'NO REIGSTRA', 1, 1, 'C');

            $this->MultiCell(90, 12, '3.- Cumplimiento de actividades en los plazos propuestos.', 1, 'L');
            $this->SetXY($this->GetX() + 90, $this->GetY() - 12);
            $this->Cell(90, 12,  $cactividades ?? 'NO REIGSTRA', 1, 1, 'C');

            $this->MultiCell(90, 12, mb_convert_encoding('4.- Aporte de sugerencias a favor de la organización.', 'ISO-8859-1', 'UTF-8'), 1, 'L');
            $this->SetXY($this->GetX() + 90, $this->GetY() - 12);
            $this->Cell(90, 12,  $aporte ?? 'NO REIGSTRA', 1, 1, 'C');

            $this->MultiCell(90, 12, mb_convert_encoding('5.- Creatividad para la solución de problemas.', 'ISO-8859-1', 'UTF-8'), 1, 'L');
            $this->SetXY($this->GetX() + 90, $this->GetY() - 12);
            $this->Cell(90, 12, $creatividad ?? 'NO REGISTRA', 1, 1, 'C');

            $this->AddPage();

            $this->MultiCell(90, 6, mb_convert_encoding('6.- Demuestra sus competencias, conocimientos y habilidades en el desarrollo de las prácticas.', 'ISO-8859-1', 'UTF-8'), 1, 'L');
            $this->SetXY($this->GetX() + 90, $this->GetY() - 12);
            $this->Cell(90, 12, $competencias ?? 'NO REGISTRA', 1, 1, 'C');

            $this->MultiCell(90, 6, '7.- Demuestra responsabilidad y compromiso en el desarrollo de actividades.', 1, 'L');
            $this->SetXY($this->GetX() + 90, $this->GetY() - 12);
            $this->Cell(90, 12, $responsabilidad ?? 'NO REGISTRA', 1, 1, 'C');

            $this->MultiCell(90, 12, mb_convert_encoding('8.- El estudiante tiene al día sus bitácoras de actividades.', 'ISO-8859-1', 'UTF-8'), 1, 'L');
            $this->SetXY($this->GetX() + 90, $this->GetY() - 12);
            $this->Cell(90, 12, $bitacoras ?? 'NO REGISTRA', 1, 1, 'C');

            $this->MultiCell(90, 6, mb_convert_encoding('9.- El estudiante cumple con la indumentaria establecida para el desarrollo de sus prácticas pre-profesionales.', 'ISO-8859-1', 'UTF-8'), 1, 'L');
            $this->SetXY($this->GetX() + 90, $this->GetY() - 12);
            $this->Cell(90, 12, $indumentaria ?? 'NO REGISTRA', 1, 1, 'C');

            $this->MultiCell(90, 6, mb_convert_encoding('10.- Las actividades que desarrolla el estudiante están acorde a su perfil de egreso.', 'ISO-8859-1', 'UTF-8'), 1, 'L');
            $this->SetXY($this->GetX() + 90, $this->GetY() - 12);
            $this->Cell(90, 12, $actividades ?? 'NO REGISTRA', 1, 1, 'C');

            $this->SetFont('Arial', 'B', 10);
            $this->Cell(180, 10, mb_convert_encoding('Valoración del lugar en el que el estudiante desarrolla sus Prácticas Pre-profesionales', 'ISO-8859-1', 'UTF-8'), 1, 1, 'C');

            $this->SetFont('Arial', '', 9);
            $this->MultiCell(90, 12, '1.- El estudiante cuenta con un puesto de trabajo asignado.', 1, 'L');
            $this->SetXY($this->GetX() + 90, $this->GetY() - 12);
            $this->Cell(90, 12, $puesto ?? 'NO REGISTRA', 1, 1, 'C');

            $this->MultiCell(90, 6, mb_convert_encoding('2.- El estudiante cuenta con el acompañamiento del tutor empresarial, el cual fomenta su formación.', 'ISO-8859-1', 'UTF-8'), 1, 'L');
            $this->SetXY($this->GetX() + 90, $this->GetY() - 12);
            $this->Cell(90, 12, $acompanamiento ?? 'NO REGISTRA', 1, 1, 'C');

            $this->MultiCell(90, 12, '3.- Se evidencian dispositivos y normas de seguridad.', 1, 'L');
            $this->SetXY($this->GetX() + 90, $this->GetY() - 12);
            $this->Cell(90, 12, $evidencias ?? 'NO REGISTRA', 1, 1, 'C');

            $this->Ln(5);

            $this->MultiCell(180, 5, mb_convert_encoding('Llamados de atención:', 'ISO-8859-1', 'UTF-8'), 1, 'L');
            $this->SetXY($this->GetX(), $this->GetY());
            $this->MultiCell(180, 5, $llamados ?? 'NO REGISTRA', 1, 'C');

            $this->MultiCell(180, 5, mb_convert_encoding('Resumen de la entrevista realizada con el tutor empresarial:', 'ISO-8859-1', 'UTF-8'), 1, 'L');
            $this->SetXY($this->GetX(), $this->GetY());
            $this->MultiCell(180, 5, $entrevista ?? 'NO REGISTRA', 1, 'C');

            $this->MultiCell(180, 5, mb_convert_encoding('Conclusiones y comentarios adicionales:', 'ISO-8859-1', 'UTF-8'), 1, 'L');
            $this->SetXY($this->GetX(), $this->GetY());
            $this->MultiCell(180, 5, $conclusion ?? 'NO REGISTRA', 1, 'C');

            $this->Ln(5);

            $this->SetFont('Arial', 'B', 10);
            $this->MultiCell(180, 5, mb_convert_encoding('Anexos:', 'ISO-8859-1', 'UTF-8'), 1, 'C');
            $this->SetXY($this->GetX(), $this->GetY());

            $this->Ln(1);

          $anchoImagen = 90; // Ancho definido para la imagen
$altoImagen = 60;  // Alto definido para la imagen

// Calcular la posición X para centrar la imagen o el texto
$posX = ($this->GetPageWidth() - $anchoImagen) / 2;

$margenInferior = 15;

if ($this->GetY() + $altoImagen + 20 > $this->GetPageHeight() - $margenInferior) {
    $this->AddPage();
}

// Verificar si hay una primera imagen
if (isset($anexo1) && !empty($anexo1)) {
    $imagen1 = '../ingreso/' . $anexo1;
    $this->Image($imagen1, $posX, $this->GetY(), $anchoImagen, $altoImagen);

    // Mover la posición del cursor para la descripción
    $this->Ln($altoImagen + 5); // Espacio después de la imagen

    // Agregar la descripción de la imagen 1
    $this->SetFont('Arial', '', 10); // Fuente y tamaño para la descripción

    // Calcular el ancho del texto para centrarlo
    $anchoTexto = $this->GetStringWidth($descripcion1);
    $posXTexto = ($this->GetPageWidth() - $anchoTexto) / 2;

    // Posicionar el cursor en la posición X calculada
    $this->SetX($posXTexto);

    // Escribir la descripción centrada
    $this->Cell($anchoTexto, 5, $descripcion1, 0, 0, 'C');
    $this->Ln(5); // Espacio después de la descripción
}

// Verificar si hay una segunda imagen
if (isset($anexo2) && !empty($anexo2)) {
    // Ajustar la posición para la segunda imagen
    if ($this->GetY() + $altoImagen + 20 > $this->GetPageHeight() - $margenInferior) {
        $this->AddPage();
    }

    $imagen2 = '../ingreso/' . $anexo2;
    $this->Image($imagen2, $posX, $this->GetY(), $anchoImagen, $altoImagen);

    // Mover la posición del cursor para la descripción
    $this->Ln($altoImagen + 5); // Espacio después de la imagen

    // Agregar la descripción de la imagen 2
    $this->SetFont('Arial', '', 10); // Fuente y tamaño para la descripción

    // Calcular el ancho del texto para centrarlo
    $anchoTexto = $this->GetStringWidth($descripcion2);
    $posXTexto = ($this->GetPageWidth() - $anchoTexto) / 2;

    // Posicionar el cursor en la posición X calculada
    $this->SetX($posXTexto);

    // Escribir la descripción centrada
    $this->Cell($anchoTexto, 5, $descripcion2, 0, 0, 'C');
    $this->Ln(15); // Espacio después de la descripción
}

            $this->Cell(180, 40, mb_convert_encoding('_______________________________________', 'ISO-8859-1', 'UTF-8'), 0,0, 'C');
            $this->SetXY($this->GetX()-180, $this->GetY()+25);
            
            
            $this->Cell(0, 0, mb_convert_encoding('Firma Tutor Académico', 'ISO-8859-1', 'UTF-8'), 0,0, 'C');
        }
    }
}

// Pie de página
/* function Footer()
    {
        $this->SetY(-35);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'ISTRED - Pagina ' . $this->PageNo(), 0, 0, 'L'); // Alineación a la izquierda
    }*/


// Crear una instancia de PDF
$pdf = new PDF();
$pdf->AddPage();
$pdf->Body(); // Llamar a la función que agrega el cuerpo
$pdf->Output('I', 'documento.pdf');
