<?php

session_start();
include_once '../../model/model_conexion.php';

$carpetaBase = 'fotopracticas/';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    if (isset($data['idSemana'], $data['cedulaEstudiante'], $data['fecha'], $data['actividades'], $data['detalle'], $data['horaIngreso'], $data['horaSalida'], $data['horasEfectivas'], $data['fotos'])) {
        
        $idSemana = $data['idSemana'];
        $cedulaEstudiante = $data['cedulaEstudiante'];
        $fecha = $data['fecha'];
        $actividades = $data['actividades'];
        $detalle = $data['detalle'];
        $hIngreso = $data['horaIngreso'];
        $hSalida = $data['horaSalida'];
        $hEfectiva = $data['horasEfectivas'];
        $descripcion = $data['descripcion'];
        $idsolicitud =$data['idsolicitud'];

        // Carpeta destino donde se almacenarán las fotos
        $carpetaDestino = $carpetaBase . $cedulaEstudiante . '/semana_' . $idSemana . '/' . date('Y-m-d', strtotime($fecha));

        if (!file_exists($carpetaDestino)) {
            mkdir($carpetaDestino, 0777, true); // Crear la carpeta si no existe
        }

        $fotos = [];
        if (isset($data['fotos']) && is_array($data['fotos'])) {
            $contadorFotos = 1;
            foreach ($data['fotos'] as $fotoBase64) {
                // Verificar si la imagen base64 es válida
                if (preg_match('/^data:image\/(\w+);base64,/', $fotoBase64, $matches)) {
                    $extension = strtolower($matches[1]); // Obtener la extensión del tipo MIME
                    $fotoData = base64_decode(preg_replace('/^data:image\/\w+;base64,/', '', $fotoBase64));

                    // Verificar si la decodificación fue exitosa
                    if ($fotoData === false) {
                        echo json_encode(['status' => 'error', 'message' => 'Error al decodificar la imagen base64']);
                        exit;
                    }

                    // Crear un nombre de archivo único para la foto
                    $newFileName = $cedulaEstudiante . '_' . $fecha . '_semana_' . $idSemana . '_foto_' . $contadorFotos++ . '.' . $extension;
                    $destination = $carpetaDestino . '/' . $newFileName;

                    // Guardar el archivo físico en el servidor
                    if (file_put_contents($destination, $fotoData) === false) {
                        echo json_encode(['status' => 'error', 'message' => 'Error al guardar la imagen en el servidor']);
                        exit;
                    }

                    // Agregar la ruta de la foto al array de fotos
                    $fotos[] = $destination;
                } else {
                    echo json_encode(['status' => 'error', 'message' => 'Formato de imagen base64 no válido']);
                    exit;
                }
            }
        }

        $fotosJson = json_encode($fotos);

        // Preparar la consulta SQL para guardar los datos en la base de datos
        $sql = "INSERT INTO infopractica (idSemana, idsolicitud, cedulaEstudiante, fecha, actividades, detalle, hIngreso, hSalida, hEfectiva, descima, fotos) 
                VALUES (:idSemana, :idsolicitud, :cedulaEstudiante, :fecha, :actividades, :detalle, :hIngreso, :hSalida, :hEfectiva, :descripcion, :fotos)";

        $conexion = new conexionBD();
        $pdo = $conexion->conexionPDO();

        try {
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':idSemana', $idSemana);
            $stmt->bindParam(':idsolicitud', $idsolicitud);
            $stmt->bindParam(':cedulaEstudiante', $cedulaEstudiante);
            $stmt->bindParam(':fecha', $fecha);
            $stmt->bindParam(':actividades', $actividades);
            $stmt->bindParam(':detalle', $detalle);
            $stmt->bindParam(':hIngreso', $hIngreso);
            $stmt->bindParam(':hSalida', $hSalida);
            $stmt->bindParam(':hEfectiva', $hEfectiva);
            $stmt->bindParam(':descripcion', $descripcion);
            $stmt->bindParam(':fotos', $fotosJson);

            if ($stmt->execute()) {
                echo json_encode(['status' => 'success', 'message' => 'Solicitud registrada con éxito']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Error al registrar la solicitud']);
            }
        } catch (Exception $e) {
            echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Datos incompletos']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Método no permitido']);
}
?>
