<?php
include_once '../../model/model_conexion.php';

// Recibir los datos del formulario y archivo
$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

if ($pdo) {
    try {
        // Verificar si se recibió un archivo
        if (isset($_FILES['archivo']) && $_FILES['archivo']['error'] === UPLOAD_ERR_OK) {
            $archivoTmp = $_FILES['archivo']['tmp_name'];
            $archivoNombre = basename($_FILES['archivo']['name']);
            $archivoTamanio = $_FILES['archivo']['size'];
            $archivoTipo = mime_content_type($archivoTmp);

            // Verificar que el archivo sea un PDF
            if ($archivoTipo !== 'application/pdf') {
                echo json_encode(['success' => false, 'message' => 'El archivo debe ser un PDF']);
                exit;
            }

            // Verificar el tamaño del archivo (10 MB)
            $tamanioMaximo = 10 * 1024 * 1024; // 10 MB en bytes
            if ($archivoTamanio > $tamanioMaximo) {
                echo json_encode(['success' => false, 'message' => 'El archivo excede el tamaño máximo permitido de 10 MB']);
                exit;
            }

            // Definir la ruta donde se guardará el archivo
            $directorioDestino = 'empresa_solicitud/'.$_POST['id'].'/';
            if (!file_exists($directorioDestino)) {
                if (!mkdir($directorioDestino, 0777, true)) {
                    echo json_encode(['success' => false, 'message' => 'No se pudo crear el directorio de destino']);
                    exit;
                }
            }

            $rutaDestino = $directorioDestino . $archivoNombre;

            // Mover el archivo a la carpeta de destino
            if (!move_uploaded_file($archivoTmp, $rutaDestino)) {
                echo json_encode(['success' => false, 'message' => 'Hubo un error al mover el archivo']);
                exit;
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'No se recibió un archivo válido']);
            exit;
        }
        
        $rutafinal ='ingreso/'.$rutaDestino;

        // Preparar la consulta SQL para insertar los datos en la base de datos
        $sql = "UPDATE solicitud SET oficio_apro = :archivoRuta WHERE idsolicitud = :idsol";

        $stmt = $pdo->prepare($sql);

        // Vincular los parámetros
        $stmt->bindParam(':idsol', $_POST['id']);
        $stmt->bindParam(':archivoRuta', $rutafinal);

        // Ejecutar la consulta
        $stmt->execute();

        echo json_encode(['success' => true, 'message' => 'Datos y archivo guardados correctamente']);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error al guardar los datos: ' . $e->getMessage()]);
    } finally {
        $conexion->cerrar_conexion();
    }
} else {
    echo json_encode(['success' => false, 'message' => 'No se pudo conectar a la base de datos']);
}
?>
