<?php
include_once '../../model/model_conexion.php';

$json = file_get_contents('php://input');
$datos = json_decode($json, true);

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

if ($pdo) {
    try {
        $sql = "INSERT INTO eval_docente (
            cedula_estudiante, cedula_tutor, idsol, visita, asistencia, cumplimiento, 
            cactividades, aporte, creatividad, competencias, responsabilidad, bitacoras, 
            indumentaria, actividades, puesto, acompanamiento, evidencias, llamados, 
            entrevista, conclusion, descripcion1, descripcion2, anexo1, anexo2
        ) VALUES (
            :cedula, :tutor, :id, :visita, :asistencia, :cumplimiento, 
            :cactividades, :aporte, :creatividad, :competencias, :responsabilidad, :bitacoras, 
            :indumentaria, :actividades, :puesto, :acompanamiento, :evidencias, :llamados, 
            :entrevista, :conclusion, :descripcion1, :descripcion2, :imagen_1, :imagen_2
        )";

        $stmt = $pdo->prepare($sql);

        $stmt->bindParam(':cedula', $datos['cedula']);
        $stmt->bindParam(':tutor', $datos['cedula_tutor']);
        $stmt->bindParam(':id', $datos['id']);
        $stmt->bindParam(':visita', $datos['visita']);
        $stmt->bindParam(':asistencia', $datos['asistencia']);
        $stmt->bindParam(':cumplimiento', $datos['cumplimiento']);
        $stmt->bindParam(':cactividades', $datos['cactividad']);
        $stmt->bindParam(':aporte', $datos['aporte']);
        $stmt->bindParam(':creatividad', $datos['creatividad']);
        $stmt->bindParam(':competencias', $datos['competencia']);
        $stmt->bindParam(':responsabilidad', $datos['responsabilidad']);
        $stmt->bindParam(':bitacoras', $datos['bitacoras']);
        $stmt->bindParam(':indumentaria', $datos['indumentarias']);
        $stmt->bindParam(':actividades', $datos['actividades']);
        $stmt->bindParam(':puesto', $datos['puesto']);
        $stmt->bindParam(':acompanamiento', $datos['acompanamiento']);
        $stmt->bindParam(':evidencias', $datos['evidencias']);
        $stmt->bindParam(':llamados', $datos['llamados']);
        $stmt->bindParam(':entrevista', $datos['entrevistas']);
        $stmt->bindParam(':conclusion', $datos['conclusion']);
        $stmt->bindParam(':descripcion1', $datos['descripcion1']);
        $stmt->bindParam(':descripcion2', $datos['descripcion2']);

        $imagen_1 = null;
        $imagen_2 = null;

        if (isset($datos['imagen_1'])) {
            $imagen_1 = guardarImagen($datos['imagen_1'], $datos['cedula_tutor'], $datos['cedula']);
        }

        if (isset($datos['imagen_2'])) {
            $imagen_2 = guardarImagen($datos['imagen_2'], $datos['cedula_tutor'], $datos['cedula']);
        }

        $stmt->bindParam(':imagen_1', $imagen_1);
        $stmt->bindParam(':imagen_2', $imagen_2);

        $stmt->execute();

        echo json_encode(['success' => true]);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'No se pudo conectar a la base de datos']);
}

$conexion->cerrar_conexion();

function guardarImagen($imagenBase64, $cedulaDocente, $cedulaEstudiante) {
    $fecha = date('Y/m/d');
    $directorio = 'docente_ficha/' . $cedulaDocente . '/' . $cedulaEstudiante . '_' . $fecha . '/';

    if (!is_dir($directorio)) {
        mkdir($directorio, 0777, true);
    }

    $imagenData = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $imagenBase64));

    if ($imagenData === false) {
        throw new Exception("Error al decodificar la imagen.");
    }

    $nombreImagenArchivo = uniqid('imagen_') . '.jpg';

    $rutaImagen = $directorio . $nombreImagenArchivo;
    if (file_put_contents($rutaImagen, $imagenData) === false) {
        throw new Exception("Error al guardar la imagen.");
    }

    return $rutaImagen;
}


?>

