<?php
include_once '../../model/model_conexion.php';

// Recibir los datos del formulario y archivo
$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

if ($pdo) {
    try {
        // Verificar si se recibió un archivo
        if (isset($_FILES['archivo']) && $_FILES['archivo']['error'] === UPLOAD_ERR_OK) {
            $archivoTmp = $_FILES['archivo']['tmp_name'];
            $archivoNombre = basename($_FILES['archivo']['name']);
            $archivoTamanio = $_FILES['archivo']['size'];
            $archivoTipo = mime_content_type($archivoTmp);

            // Verificar que el archivo sea un PDF
            if ($archivoTipo !== 'application/pdf') {
                echo json_encode(['success' => false, 'message' => 'El archivo debe ser un PDF']);
                exit;
            }

            // Verificar el tamaño del archivo (10 MB)
            $tamanioMaximo = 10 * 1024 * 1024; // 10 MB en bytes
            if ($archivoTamanio > $tamanioMaximo) {
                echo json_encode(['success' => false, 'message' => 'El archivo excede el tamaño máximo permitido de 10 MB']);
                exit;
            }

            // Definir la ruta donde se guardará el archivo
            $directorioDestino = 'empresa_ficha/'.$_POST['estudiante'].'/';
            if (!file_exists($directorioDestino)) {
                if (!mkdir($directorioDestino, 0777, true)) {
                    echo json_encode(['success' => false, 'message' => 'No se pudo crear el directorio de destino']);
                    exit;
                }
            }

            $rutaDestino = $directorioDestino . $archivoNombre;

            // Mover el archivo a la carpeta de destino
            if (!move_uploaded_file($archivoTmp, $rutaDestino)) {
                echo json_encode(['success' => false, 'message' => 'Hubo un error al mover el archivo']);
                exit;
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'No se recibió un archivo válido']);
            exit;
        }

        // Preparar la consulta SQL para insertar los datos en la base de datos
        $sql = "INSERT INTO eval_empresa (
            idsol, ci_estudiante, fecha_eval, 
            p1_p1, p1_p2, p1_p3, p1_p4, p1_p5, p1_p6, p2_p1, p2_p2, p2_p3, p2_p4, p2_p5, p3_p1, p3_p2, p3_p3, p3_p4,
            ob1, ob2, ob3, archivo_ruta
        ) VALUES (
            :idsol, :estudiante, :fechaEvaluacion, :p1p1, :p1p2, :p1p3, :p1p4, :p1p5, :p1p6, :p2p1, :p2p2, :p2p3, :p2p4, 
            :p2p5, :p3p1, :p3p2, :p3p3, :p3p4, :ob1, :ob2, :ob3, :archivoRuta
        )";

        $stmt = $pdo->prepare($sql);

        // Vincular los parámetros
        $stmt->bindParam(':idsol', $_POST['id']);
        $stmt->bindParam(':estudiante', $_POST['estudiante']);
        $stmt->bindParam(':fechaEvaluacion', $_POST['fechaEvaluacion']);
        $stmt->bindParam(':p1p1', $_POST['p1p1']);
        $stmt->bindParam(':p1p2', $_POST['p1p2']);
        $stmt->bindParam(':p1p3', $_POST['p1p3']);
        $stmt->bindParam(':p1p4', $_POST['p1p4']);
        $stmt->bindParam(':p1p5', $_POST['p1p5']);
        $stmt->bindParam(':p1p6', $_POST['p1p6']);
        $stmt->bindParam(':p2p1', $_POST['p2p1']);
        $stmt->bindParam(':p2p2', $_POST['p2p2']);
        $stmt->bindParam(':p2p3', $_POST['p2p3']);
        $stmt->bindParam(':p2p4', $_POST['p2p4']);
        $stmt->bindParam(':p2p5', $_POST['p2p5']);
        $stmt->bindParam(':p3p1', $_POST['p3p1']);
        $stmt->bindParam(':p3p2', $_POST['p3p2']);
        $stmt->bindParam(':p3p3', $_POST['p3p3']);
        $stmt->bindParam(':p3p4', $_POST['p3p4']);
        $stmt->bindParam(':ob1', $_POST['ob1']);
        $stmt->bindParam(':ob2', $_POST['ob2']);
        $stmt->bindParam(':ob3', $_POST['ob3']);
        $stmt->bindParam(':archivoRuta', $rutaDestino);

        // Ejecutar la consulta
        $stmt->execute();

        echo json_encode(['success' => true, 'message' => 'Datos y archivo guardados correctamente']);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error al guardar los datos: ' . $e->getMessage()]);
    } finally {
        $conexion->cerrar_conexion();
    }
} else {
    echo json_encode(['success' => false, 'message' => 'No se pudo conectar a la base de datos']);
}
?>
