<?php
include_once '../../model/model_conexion.php';

// Recibir la cédula encriptada
$id = $_GET['id'];

$cedula = base64_decode($cedulaEncriptada);

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

$response = ['success' => false, 'message' => 'Error desconocido.'];

if ($pdo) {
    try {
        // Eliminar de la tabla 'solicitud'
        $sql = 'DELETE FROM solicitud WHERE idsolicitud=:id'; 
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->execute();

        // Eliminar de la tabla 'prac_empresa'
        $sql2 = 'DELETE FROM prac_empresa WHERE idEmpresa=:id'; 
        $stmt2 = $pdo->prepare($sql2);
        $stmt2->bindParam(':id', $id);
        $stmt2->execute();

        // Respuesta de éxito
        $response = ['success' => true, 'message' => 'El registro ha sido eliminado exitosamente.'];
    } catch (PDOException $e) {
        // Respuesta de error
        $response = ['success' => false, 'message' => 'Error al eliminar el registro.'];
    }
} else {
    // Respuesta de error de conexión
    $response = ['success' => false, 'message' => 'No se pudo conectar a la base de datos.'];
}

$conexion->cerrar_conexion();

// Enviar la respuesta como JSON
echo json_encode($response);
?>
