<?php
// Configuración de la base de datos
include_once("../../model/model_conexion.php");

// Obtener los datos JSON recibidos en el cuerpo de la solicitud
$data = json_decode(file_get_contents('php://input'), true);

// Verificar si el estado fue enviado
if (isset($data['estado'])) {
    $id = $data['id'];
    $estado = $data['estado'];
    $cedula = $data['cedula'];
    $finalizacion = $data['finalizacion'];
    $aprobacion = $data['aprobacion'];

    // Crear la conexión a la base de datos usando PDO
    $conexion = new conexionBD();
    $pdo = $conexion->conexionPDO();

    if ($pdo) {
        // Lógica para cuando el estado es 'FINALIZADO'
        if ($estado == 'FINALIZADO') {
            $sql = "SELECT s.nomenclatura, ast.promo, s.f_finalizacion, s.id_oficio_fin 
                    FROM solicitud s 
                    JOIN asig_tutor ast ON ast.CedulaEstudiante = s.cedulaEstudiante 
                    WHERE s.idsolicitud = :id";

            try {
                // Preparamos y ejecutamos la consulta
                $st = $pdo->prepare($sql);
                $st->bindParam(':id', $id, PDO::PARAM_INT); // Parametrizamos el ID de solicitud
                $st->execute();
                $oficio = $st->fetch(PDO::FETCH_ASSOC);
                $fecha = date('Y-M-D');
                $nomcarrera = $oficio['nomenclatura'] ?? '';
                $promo = $oficio['promo'] ?? '';
                $fecha_fin = $oficio['f_finalizacion'] ?? '';
                $numero = $oficio['id_oficio_fin'] ?? '';
                if ($oficio) {

                    if($fecha_fin == null){

                        $sql_check = "SELECT MAX(s.id_oficio_fin) as last_id 
                                      FROM solicitud s 
                                      JOIN asig_tutor ast ON ast.CedulaEstudiante = s.cedulaEstudiante 
                                      WHERE nomenclatura = :nomcarrera 
                                      AND ast.promo = :promo 
                                      AND MONTH(s.f_finalizacion) = MONTH(:fecha_fin) 
                                      AND YEAR(s.f_finalizacion) = YEAR(:fecha_fin)";
                        $st_check = $pdo->prepare($sql_check);
                        $st_check->bindParam(':nomcarrera', $nomcarrera);
                        $st_check->bindParam(':promo', $promo);
                        $st_check->bindParam(':fecha_fin', $fecha);
                        $st_check->execute();
                        $result = $st_check->fetch(PDO::FETCH_ASSOC);


                        if($result['last_id'] !== null){

                            $new_number=($result && $result['last_id'] !== null) ? $result['last_id'] + 1 : 1;
                        }else{
                            $new_number = $result['last_id'];
                        }

                    } else {

                        $new_number = $numero;

                    }

                    // Actualizamos la tabla solicitud
                    $sql_update_solicitud = "
                        UPDATE solicitud s
                        INNER JOIN prac_empresa pe ON pe.idEmpresa = s.idsolicitud
                        SET s.estado = :estado, s.f_finalizacion = :finalizacion, s.id_oficio_fin = :new_oficio
                        WHERE s.cedulaEstudiante = :cedula AND s.idsolicitud = :id
                    ";
                    $stmt_update_solicitud = $pdo->prepare($sql_update_solicitud);
                    $stmt_update_solicitud->bindParam(':estado', $estado);
                    $stmt_update_solicitud->bindParam(':cedula', $cedula);
                    $stmt_update_solicitud->bindParam(':finalizacion', $fecha);
                    $stmt_update_solicitud->bindParam(':new_oficio', $new_number);
                    $stmt_update_solicitud->bindParam(':id', $id);
                    $stmt_update_solicitud->execute();

                    // Actualizamos la tabla prac_empresa
                    $sql_update_empresa = "
                        UPDATE prac_empresa pe
                        INNER JOIN solicitud s ON s.idsolicitud = pe.idEmpresa
                        SET pe.estado = :estado2
                        WHERE pe.cedulaEstudiante = :cedula2 AND pe.idEmpresa = :id
                    ";
                    $stmt_update_empresa = $pdo->prepare($sql_update_empresa);
                    $stmt_update_empresa->bindParam(':estado2', $estado);
                    $stmt_update_empresa->bindParam(':cedula2', $cedula);
                    $stmt_update_empresa->bindParam(':id', $id);
                    $stmt_update_empresa->execute();

                    // Si todo fue exitoso, respondemos con éxito
                    echo json_encode(["success" => true, "message" => "Estado actualizado correctamente", "new_oficio" => $new_number]);
                } else {
                    echo json_encode(["success" => false, "message" => "No se encontraron registros"]);
                }
            } catch (PDOException $e) {
                echo json_encode(["success" => false, "message" => "Error al ejecutar la consulta: " . $e->getMessage()]);
            }
        } elseif ($estado == 'EN PROCESO') {
    // Consulta para obtener detalles de la solicitud
    $sql2 = "SELECT s.nomenclatura, ast.promo, s.f_aprobacion, s.id_oficio_inicio 
             FROM solicitud s 
             JOIN asig_tutor ast ON ast.CedulaEstudiante = s.cedulaEstudiante 
             WHERE s.idsolicitud = :id";

    try {
        // Preparamos y ejecutamos la consulta
        $st2 = $pdo->prepare($sql2);
        $st2->bindParam(':id', $id, PDO::PARAM_INT); // Parametrizamos el ID de solicitud
        $st2->execute();
        $oficio2 = $st2->fetch(PDO::FETCH_ASSOC);
        $fecha = date('Y-m-d');
        $nomcarrera = $oficio2['nomenclatura'] ?? '';
        $promo = $oficio2['promo'] ?? '';
        $aprobacion= $oficio2['f_aprobacion'] ?? '';
        $noficio= $oficio2['id_oficio_inicio'] ?? '';
        
        if ($oficio2) {
        if($aprobacion == null){

        $sql_check2 = "SELECT MAX(s.id_oficio_inicio) as last_id 
                               FROM solicitud s 
                               JOIN asig_tutor ast ON ast.CedulaEstudiante = s.cedulaEstudiante 
                               WHERE nomenclatura = :nomcarrera 
                               AND ast.promo = :promo 
                               AND MONTH(s.f_aprobacion) = MONTH(:fecha_inicio) 
                               AND YEAR(s.f_aprobacion) = YEAR(:fecha_inicio)";
                $st_check2 = $pdo->prepare($sql_check2);
                $st_check2->bindParam(':nomcarrera', $nomcarrera);
                $st_check2->bindParam(':promo', $promo);
                $st_check2->bindParam(':fecha_inicio', $fecha);
                $st_check2->execute();
                $result2 = $st_check2->fetch(PDO::FETCH_ASSOC);
                
                if($result2['last_id'] !== null){
                    
                   $nuevo_number = ($result2 && $result2['last_id'] !== null) ? $result2['last_id'] + 1 : 1;
                    
                }else{

                   $nuevo_number =$result2['last_id'];
                    
                }
                
            } else {
                
                $nuevo_number = $noficio;
            }

            // Fecha actual para la aprobación
            

            // Actualizamos la tabla solicitud
            $sql_update_solicitud = "
                UPDATE solicitud s
                INNER JOIN prac_empresa pe ON pe.idEmpresa = s.idsolicitud
                SET s.estado = :estado, s.f_aprobacion = :aprobacion, s.id_oficio_inicio = :new_oficio
                WHERE s.cedulaEstudiante = :cedula AND s.idsolicitud = :id
            ";
            $stmt_update_solicitud = $pdo->prepare($sql_update_solicitud);
            $stmt_update_solicitud->bindParam(':estado', $estado);
            $stmt_update_solicitud->bindParam(':cedula', $cedula);
            $stmt_update_solicitud->bindParam(':aprobacion', $fecha);
            $stmt_update_solicitud->bindParam(':new_oficio', $nuevo_number);
            $stmt_update_solicitud->bindParam(':id', $id);
            $stmt_update_solicitud->execute();

            // Actualizamos la tabla prac_empresa
            $sql_update_empresa = "
                UPDATE prac_empresa pe
                INNER JOIN solicitud s ON s.idsolicitud = pe.idEmpresa
                SET pe.estado = :estado2
                WHERE pe.cedulaEstudiante = :cedula2 AND pe.idEmpresa = :id
            ";
            $stmt_update_empresa = $pdo->prepare($sql_update_empresa);
            $stmt_update_empresa->bindParam(':estado2', $estado);
            $stmt_update_empresa->bindParam(':cedula2', $cedula);
            $stmt_update_empresa->bindParam(':id', $id);
            $stmt_update_empresa->execute();

            // Respuesta de éxito
            echo json_encode(["success" => true, "message" => "Estado actualizado correctamente", "new_oficio" => $nuevo_number]);
        } else {
            // Si no se encuentran registros
            echo json_encode(["success" => false, "message" => "No se encontraron registros"]);
        }
    } catch (PDOException $e) {
        // Manejo de errores
        echo json_encode(["success" => false, "message" => "Error al ejecutar la consulta: " . $e->getMessage()]);
    }
}else{
              try {
                // Actualizamos el estado en la tabla 'solicitud'
                $sql = "
                    UPDATE solicitud s
                    INNER JOIN prac_empresa pe ON pe.idEmpresa = s.idsolicitud
                    SET s.estado = :estado
                    WHERE s.cedulaEstudiante = :cedula AND s.idsolicitud = :id
                ";
                $stmt = $pdo->prepare($sql);
                $stmt->bindParam(':estado', $estado);
                $stmt->bindParam(':cedula', $cedula);
                $stmt->bindParam(':id', $id);
                $stmt->execute();

                // Actualizamos la tabla prac_empresa
                $sql2 = "
                    UPDATE prac_empresa pe
                    INNER JOIN solicitud s ON s.idsolicitud = pe.idEmpresa
                    SET pe.estado = :estado2
                    WHERE pe.cedulaEstudiante = :cedula2 AND pe.idEmpresa = :id
                ";
                $stmt2 = $pdo->prepare($sql2);
                $stmt2->bindParam(':estado2', $estado);
                $stmt2->bindParam(':cedula2', $cedula);
                $stmt2->bindParam(':id', $id);
                $stmt2->execute();

                // Si todo fue exitoso
                echo json_encode(["success" => true, "message" => "Estado actualizado correctamente"]);
            } catch (PDOException $e) {
                echo json_encode(["success" => false, "message" => "Error de conexión: " . $e->getMessage()]);
            }
        }
    } else {
        echo json_encode(["success" => false, "message" => "Error de conexión a la base de datos"]);
    }
} else {
    // Si no se proporcionó el estado en el JSON
    echo json_encode(["success" => false, "message" => "Estado no proporcionado"]);
}
?>