<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
if (!isset($_SESSION['S_ID'])) {
    header('Location: ../index.php');
}
$id_usuario = $_SESSION['S_ID'];

include_once '../../model/model_conexion.php';

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

if ($pdo) {
    $cedulaEstudiante = '0910983741'; 

    $cedulaEncriptada = base64_encode($cedulaEstudiante);

    $sql = "SELECT cedulaEstudiante, idCarrera, idPeriodo, fInicio, fFin, horas, estado FROM solicitud WHERE CedulaEstudiante = :cedulaEstudiante";
    
    try {
        $query = $pdo->prepare($sql);
        $query->bindParam(':cedulaEstudiante', $cedulaEstudiante, PDO::PARAM_STR);
        $query->execute();
        $resultados = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($resultados) {
            $solicitudes = [];

            foreach ($resultados as $row) {
                $solicitudes[] = [
                    'cedulaEstudiante' => $row['cedulaEstudiante'] ?? 'NO REGISTRA',
                    'idCarrera' => $row['idCarrera'] ?? 'NO REGISTRA',
                    'idPeriodo' => $row['idPeriodo'] ?? 'NO REGISTRA',
                    'fInicio' => $row['fInicio'] ?? 'NO REGISTRA',
                    'fFin' => $row['fFin'] ?? 'NO REGISTRA',
                    'horas' => $row['horas'] ?? 'NO REGISTRA',
                    'estado' => $row['estado'] ?? 'NO REGISTRA',
                    'accion' => "<a href='pdf/sol_prac.php?cedulaEstudiante=" . $cedulaEncriptada . "' class='btn btn-primary btn-sm'><i class='fa fa-print' aria-hidden='true'></i></a>"
                ];
            }

            echo "<script>
                    // Guardamos los datos en localStorage
                    localStorage.setItem('solicitudes', JSON.stringify(" . json_encode($solicitudes) . "));
                </script>";
        } else {
            echo "<script>alert('No se encontraron resultados para el estudiante con CedulaEstudiante $cedulaEstudiante');</script>";
        }
    } catch (PDOException $e) {
        error_log("Error al ejecutar la consulta: " . $e->getMessage());
        echo "<script>alert('Hubo un problema con la consulta. Intenta más tarde.');</script>";
    }
} else {
    echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>
<link rel="stylesheet" href="../plantilla/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css"/>

<style>
  tbody {
    text-align: center;
    align-items: center;
  }
  .btn-verde {
    background-color: green;
    color: white;
    border: none;
    padding: 5px 10px;
    cursor: pointer;
  }

  .btn-rojo {
    background-color: red;
    color: white;
    border: none;
    padding: 5px 10px;
    cursor: pointer;
  }

  .btn-verde:hover, .btn-rojo:hover {
    opacity: 0.8;
  }
</style>

<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0">LISTA DE SOLICITUD</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Inicio</a></li>
          <li class="breadcrumb-item active">DOC.</li>
        </ol>
      </div>
    </div>
  </div>
</div>

<!-- Main content -->
<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-header">
            <button class="btn btn-primary btn-sm float-right" onclick="cargar_contenido('contenido_principal','solicitud/view_solicitud_registro.php')"> <i class="fas fa-plus"> </i>Nueva Solicitud</button>
          </div>
          <div class="card-body">
            <div class="col-12 table-responsive">
              <table id="tabla_tramites" class="display" style="width:100%">
                <thead>
                    <tr>
                        <th class="text-center">Cedula Estudiante</th>
                        <th class="text-center">Carrera</th>
                        <th class="text-center">Periodo</th>
                        <th class="text-center">Fecha Inicio</th>
                        <th class="text-center">Fecha Fin</th>
                        <th class="text-center">Horas</th>
                        <th class="text-center">Estado</th>
                        <th class="text-center">Accion</th>
                    </tr>
                </thead>
                <tbody>

                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>

  function cargarTablaDesdeLocalStorage() {
    var data = JSON.parse(localStorage.getItem('solicitudes'));
    if (data && data.length > 0) {
      var table = $('#tabla_tramites').DataTable({
        data: data,
        destroy: true,
        columns: [
          { data: 'cedulaEstudiante' },
          { data: 'idCarrera' },
          { data: 'idPeriodo' },
          { data: 'fInicio' },
          { data: 'fFin' },
          { data: 'horas' },
          { data: 'estado' },
          { data: 'accion' }
        ],
        paging: true,  
        searching: true, 
        ordering: true, 
        info: true, 
        responsive: true 
      });
    } else {
      alert('No se encontraron datos en el almacenamiento local.');
    }
  }

  $(document).ready(function() {
    cargarTablaDesdeLocalStorage(); 
  });
</script>
