<?php

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['S_ID'])) {
    header('Location: ../index.php');
}

$cedula = $_SESSION['S_USU'];
include_once '../../model/model_conexion.php';

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

$solicitudes = [];

if ($pdo) {
    $sql = "SELECT ast.nombre_tutor, ast.Carrera, ast.promocion, ast.CedulaEstudiante, ast.nombre_estudiante, ast.per_acad_estudiante FROM asig_tutor ast where ast.CedulaDocente='$cedula'";
    
    try {
        $query = $pdo->prepare($sql);
        $query->execute();
        $resultados = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($resultados) {
          foreach ($resultados as $row) {
              // Encriptar la cédula
              $cedulaEncriptada = base64_encode($row['CedulaEstudiante']);
      
              $solicitudes[] = [
                  'cedula' => $row['CedulaEstudiante'] ?? 'NO REGISTRA',
                  'ntutor' => $row['nombre_tutor'] ?? 'NO REGISTRA',
                  'carrera' => $row['Carrera'] ?? 'NO REGISTRA',
                  'promocion' => $row['promocion'] ?? 'NO REGISTRA',
                  'nestudiante' => $row['nombre_estudiante'] ?? 'NO REGISTRA',
                  'periodo' => $row['per_acad_estudiante'] ?? 'NO REGISTRA',
                  'accion' => "<a href='#' onclick=\"cargar_contenido('contenido_principal', 'docentes/view_seguimiento_docente.php?cedula=" . urlencode($cedulaEncriptada) . "')\" class='btn btn-outline-primary btn-sm' title='Llenar Ficha'><i class='fa fa-pencil-alt' aria-hidden='true'></i></a>"               
                  ];
          }
        }
    } catch (PDOException $e) {
        error_log("Error al ejecutar la consulta: " . $e->getMessage());
    }
} else {
    echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>

<!-- Incluir los recursos necesarios para Bootstrap y DataTables -->
<link rel="stylesheet" href="../plantilla/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<style>
  tbody {
    text-align: center;
    align-items: center;
  }
  #loading-screen {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(255, 255, 255, 0.8); /* Fondo blanco semi-transparente */
        z-index: 9999;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .spinner {
        border: 16px solid #f3f3f3;
        border-top: 16px solid #17285e;
        border-radius: 50%;
        width: 120px;
        height: 120px;
        animation: spin 2s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
</style>

<div id="loading-screen">
    <div class="spinner"></div>
</div>

<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0">LISTA DE ESTUDIANTES</h1>
      </div>
    </div>
  </div>
</div>

<!-- Main content -->
<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">
            <div class="col-12 table-responsive">
              <table id="tabla_tramites" class="display" style="width:100%">
                <thead>
                  <tr>
                      <th class="text-center">No</th>
                      <th class="text-center">Tutor</th>
                      <th class="text-center">Carrera</th>
                      <th class="text-center">Promocion</th>
                      <th class="text-center">C.I Estudiante</th>
                      <th class="text-center">Estudiante</th>
                      <th class="text-center">Periodo</th>
                      <th class="text-center">Accion</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $contador=1;?>
                    <?php foreach ($solicitudes as $solicitud): ?>
                        <tr>
                          
                          <td><?php echo $contador; ?></td>
                          <td><?php echo $solicitud['ntutor']; ?></td>
                            <td><?php echo $solicitud['carrera']; ?></td>
                            <td><?php echo $solicitud['promocion']; ?></td>
                            <td><?php echo $solicitud['cedula']; ?></td>
                            <td><?php echo $solicitud['nestudiante']; ?></td>
                            <td><?php echo $solicitud['periodo']; ?></td>
                            <td><?php echo $solicitud['accion'];  $contador++;?></td>
                        </tr>
                    <?php endforeach; ?>
                        </tbody>
                            </table>        
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
                
                <script type="text/javascript">
                  $(document).ready(function() {
                    // Inicializar la tabla DataTable después de que el contenido esté completamente cargado
                    $('#tabla_tramites').DataTable();
                  });
                </script>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal de Edición con Bootstrap -->
<div class="modal fade" id="modalEditarEstado" tabindex="-1" aria-labelledby="modalEditarEstadoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalEditarEstadoLabel">Cambiar Estado del Trámite</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="formEditarEstado">
          <div class="mb-3">
            <label for="estado" class="form-label">Estado del Trámite</label>
            <select class="form-control" id="estado" name="estado">
              <option value="NO REGISTRA">No Registra</option>
              <option value="PENDIENTE">Pendiente</option>
              <option value="APROBADO">Aprobado</option>
              <option value="EN PROCESO">En Proceso</option>
            </select>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" id="guardarBtn" onclick="guardarEstado()">Guardar</button>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">

window.addEventListener('load', function() {
            document.getElementById('loading-screen').style.display = 'none';
        });

        // Forzar la desaparición de la pantalla de carga después de 5 segundos
        setTimeout(function() {
            document.getElementById('loading-screen').style.display = 'none';
        }, 3000);
  
  $(document).ready(function() {
    // Inicializar la tabla DataTable
    $('#tabla_tramites').DataTable();
  });

  // Función para guardar el estado
  function guardarEstado() {
    var estado = document.getElementById("estado").value;
    var alertPlaceholder = document.createElement('div');
    alertPlaceholder.innerHTML = '<div class="alert alert-success alert-dismissible fade show" role="alert">' +
                                 'Estado actualizado a: ' + estado +
                                 '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>' +
                                 '</div>';
    document.body.appendChild(alertPlaceholder);
    // Aquí puedes agregar la lógica para guardar el estado en la base de datos si es necesario.
    // Cerrar el modal después de guardar.
    var modal = bootstrap.Modal.getInstance(document.getElementById('modalEditarEstado'));
    modal.hide();
  }
</script>
