<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['S_ID'])) {
  header('Location: ../index.php');
}

include_once '../../model/model_conexion.php';

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

$solicitudes = [];

if ($pdo) {
  $sql = "SELECT s.idsolicitud, s.cedulaEstudiante, s.NombreEstudiante, pe.nEmpresa, pe.responsable, pe.cargo_empresa FROM solicitud s 
          join prac_empresa pe on pe.idEmpresa=s.idsolicitud WHERE s.cedulaEstudiante=pe.cedulaEstudiante";

  try {
    $query = $pdo->prepare($sql);
    $query->execute();
    $resultados = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resultados) {
      foreach ($resultados as $row) {
        $solicitudes[] = [
          'idsolicitud' => $row['idsolicitud'] ?? 'NO REGISTRA',
          'cedulaEstudiante' => $row['cedulaEstudiante'] ?? 'NO REGISTRA',
          'nestudiante' => $row['NombreEstudiante'] ?? 'NO REGISTRA',
          'empresa' => $row['nEmpresa'] ?? 'NO REGISTRA',
          'responsable' => $row['responsable'] ?? 'NO REGISTRA',
          'cargo' => $row['cargo_empresa'] ?? 'NO REGISTRA',
          'oficios' => "<a href='pdf/inicio_actividades.php?id=".$row['idsolicitud']."' class='btn btn-primary btn-sm' target='_blank'><i class='fa fa-print' aria-hidden='true'></i></a>
                        <a href='pdf/oficio_practicas.php?id=".$row['idsolicitud']."' class='btn btn-primary btn-sm' target='_blank'><i class='fa fa-print' aria-hidden='true'></i></a>
                        <a href='pdf/sol_inst_rec.php?id=".$row['idsolicitud']."' class='btn btn-primary btn-sm' target='_blank' ><i class='fa fa-print' aria-hidden='true'></i></a>",
         'accion' => "<a href='javascript:void(0);' class='btn btn-primary btn-sm' onclick='copyToClipboard(".$row['idsolicitud'].")'><i class='fa fa-copy' aria-hidden='true'></i></a>"


        ];
      }
    }
  } catch (PDOException $e) {
    error_log("Error al ejecutar la consulta: " . $e->getMessage());
  }
} else {
  echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>

<!-- Incluir los recursos necesarios para Bootstrap y DataTables -->
<script>
   function copyToClipboard(idSolicitud) {
    // Codificamos la ID en base64
    var encryptedId = btoa(idSolicitud);  // btoa() codifica la ID en base64

    // Construimos la URL completa
    var url = 'https://prueba.itred.edu.ec/practicas/practicas/practicas/view/empresa.php?id=' + encryptedId;  // Construimos la URL

    // Creamos un campo de texto temporal para copiar la URL
    var tempInput = document.createElement('input');
    tempInput.value = url;  // Asignamos la URL al campo
    document.body.appendChild(tempInput);
    tempInput.select();  // Seleccionamos el contenido
    document.execCommand('copy');  // Copiamos al portapapeles
    document.body.removeChild(tempInput);  // Eliminamos el campo temporal

    // Mensaje de confirmación
    alert('Link de Ficha Copiado');
}
</script>

<!-- Cabecera -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0">LISTA DE EMPRESAS</h1>
      </div>
    </div>
  </div>
</div>

<!-- Main content -->
<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">
            <div class="col-12 table-responsive">
              <table id="tabla_tramites" class="display" style="width:100%; text-align: center;">
                <thead>
                  <tr>
                    <th class="text-center">Cedula Estudiante</th>
                    <th class="text-center">Nombre Estudiante</th>
                    <th class="text-center">Empresa</th>
                    <th class="text-center">Responsable</th>
                    <th class="text-center">Cargo</th>
                    <th class="text-center">Oficios</th>
                    <th class="text-center">Ficha</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($solicitudes as $solicitud): ?>
                    <tr>
                      <td><?php echo $solicitud['cedulaEstudiante']; ?></td>
                      <td><?php echo $solicitud['nestudiante']; ?></td>
                      <td><?php echo $solicitud['empresa']; ?></td>                    
                      <td><?php echo $solicitud['responsable']; ?></td>
                      <td><?php echo $solicitud['cargo']; ?></td>
                      <td style="display: flex; gap: 10px; text-align: center;"><?php echo $solicitud['oficios']; ?></td>
                        <td><?php echo $solicitud['accion']; ?></td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal de Edición con Bootstrap -->
<div class="modal fade" id="modalEditarEstado" tabindex="-1" aria-labelledby="modalEditarEstadoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalEditarEstadoLabel">Cambiar Estado del Trámite</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="formEditarEstado">
          <div class="mb-3">
            <label for="estado" class="form-label">Estado del Trámite</label>
            <select class="form-control" id="estado" name="estado">
              <option value="NO REGISTRA">NO REGISTRA</option>
              <option value="PENDIENTE">PENDIENTE</option>
              <option value="APROBADO">APROBADO</option>
              <option value="EN PROCESO">EN PROCESO</option>
              <option value="RECHAZADO">RECHAZADO</option>
              <option value="FINALIZADO">FINALIZADO</option>
            </select>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" id="guardarBtn" onclick="guardarEstado()">Guardar</button>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
  $(document).ready(function() {
    // Inicializar la tabla DataTable
    $('#tabla_tramites').DataTable();
  });

  // Variable global para almacenar la cédula del estudiante
  let cedulaEstudianteGlobal = '';

  // Función para abrir el modal de edición
  function editarEstado(cedulaEstudiante) {
    cedulaEstudianteGlobal = cedulaEstudiante;

    // Asegurarse de eliminar todos los fondos y modales existentes
    removeModalBackdrop();

    // Inicializar el modal
    var modalElement = document.getElementById('modalEditarEstado');
    var modal = new bootstrap.Modal(modalElement, {
      backdrop: 'static', // No cerrar con click fuera del modal
      keyboard: false // No cerrar con tecla ESC
    });

    modal.show(); // Mostrar el modal
  }

  // Función para guardar el estado
  function guardarEstado() {
    var estado = document.getElementById("estado").value;

    fetch('ingreso/actualizacion_sol_practica.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify({
          estado: estado,
          cedula: cedulaEstudianteGlobal
        })
      })
      .then(response => response.json())
      .then(data => {
        if (data.success) {
          // Mostrar mensaje de éxito con SweetAlert2
          Swal.fire({
            icon: 'success',
            title: 'Estado actualizado',
            text: 'El estado se ha actualizado a: ' + estado,
            confirmButtonText: 'Aceptar'
          }).then((result) => {
            if (result.isConfirmed) {
              // Recargar el contenido de la página
              cargar_contenido('contenido_principal', 'coordinador/view_sol_prac.php');
            }
          });
        } else {
          // Mostrar mensaje de error con SweetAlert2
          Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Hubo un error al actualizar el estado.',
            confirmButtonText: 'Aceptar'
          });
        }
      })
      .catch(error => {
        console.error('Error:', error);
        Swal.fire({
          icon: 'error',
          title: 'Error',
          text: 'Hubo un error al actualizar el estado.',
          confirmButtonText: 'Aceptar'
        });
      });

    // Cerrar el modal después de guardar
    var modalElement = document.getElementById('modalEditarEstado');
    var modal = bootstrap.Modal.getInstance(modalElement);
    modal.hide();

    // Eliminar fondo oscuro manualmente
    removeModalBackdrop();
  }

  // Función para eliminar el fondo oscuro y modal-backdrop
  function removeModalBackdrop() {
    // Forzar eliminación de la clase modal-open del body
    $(document.body).removeClass('modal-open');

    // Eliminar el fondo oscuro .modal-backdrop si existe
    $('.modal-backdrop').remove();

    // Asegurarse de que no haya más instancias acumuladas de fondo oscuro
    $('body').removeClass('modal-open'); // Forzar eliminación de la clase modal-open
    $('.modal-backdrop').remove(); // Eliminar cualquier fondo persistente
  }

  // Función para cargar contenido dinámicamente en el contenedor
  function cargar_contenido(id, vista) {
    $("#" + id).load(vista, function(response, status, xhr) {
      if (status == "error") {
        alert("Error: " + xhr.status + " " + xhr.statusText);
      } else {
        // Reinicializar DataTable después de cargar el contenido
        $('#tabla_tramites').DataTable();

        // Volver a cargar los recursos JS y CSS necesarios si fuera necesario
        loadCSS("https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css");
        loadJS("https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js");
      }
    });
  }

  // Función para cargar archivos CSS dinámicamente
  function loadCSS(url) {
    var link = document.createElement("link");
    link.rel = "stylesheet";
    link.type = "text/css";
    link.href = url;
    document.head.appendChild(link);
  }

  // Función para cargar archivos JS dinámicamente
  function loadJS(url) {
    var script = document.createElement("script");
    script.src = url;
    document.head.appendChild(script);
  }
</script>