<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['S_ID'])) {
  header('Location: ../index.php');
}

include_once '../../model/model_conexion.php';

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

$solicitudes = [];

if ($pdo) {
  $sql = "SELECT idsolicitud, cedulaEstudiante, Carrera, Periodo, fInicio, fFin, horas, estado FROM solicitud where estado='APROBADO'";

  try {
    $query = $pdo->prepare($sql);
    $query->execute();
    $resultados = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($resultados) {
      foreach ($resultados as $row) {
        $solicitudes[] = [
          'idsolicitud' => $row['idsolicitud'] ?? 'NO REGISTRA',
          'cedulaEstudiante' => $row['cedulaEstudiante'] ?? 'NO REGISTRA',
          'Carrera' => $row['Carrera'] ?? 'NO REGISTRA',
          'Periodo' => $row['Periodo'] ?? 'NO REGISTRA',
          'fInicio' => $row['fInicio'] ?? 'NO REGISTRA',
          'fFin' => $row['fFin'] ?? 'NO REGISTRA',
          'horas' => $row['horas'] ?? 'NO REGISTRA',
          'estado' => $row['estado'] ?? 'NO REGISTRA',
          'accion' => "<a href='pdf/inicio_actividades.php?id=".$row['idsolicitud']."' class='btn btn-primary btn-sm' target='_blank'><i class='fa fa-print' aria-hidden='true'></i></a>
                       <a href='pdf/inicio_actividades.php?id=".$row['idsolicitud']."' class='btn btn-primary btn-sm' target='_blank'><i class='fa fa-print' aria-hidden='true'></i></a>
                       <a href='pdf/inicio_actividades.php?id=".$row['idsolicitud']."' class='btn btn-primary btn-sm' target='_blank'><i class='fa fa-print' aria-hidden='true'></i></a>"


        ];
      }
    }
  } catch (PDOException $e) {
    error_log("Error al ejecutar la consulta: " . $e->getMessage());
  }
} else {
  echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>

<!-- Incluir los recursos necesarios para Bootstrap y DataTables -->

<style>
  /* Agregar tus estilos personalizados aquí */
</style>

<!-- Cabecera -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0">LISTA DE PRACTICAS FINALIZADAS</h1>
      </div>
    </div>
  </div>
</div>

<!-- Main content -->
<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">
            <div class="col-12 table-responsive">
              <table id="tabla_tramites" class="display" style="width:100%">
                <thead>
                  <tr>
                    <th class="text-center">Cedula Estudiante</th>
                    <th class="text-center">Carrera</th>
                    <th class="text-center">Periodo</th>
                    <th class="text-center">Fecha Inicio</th>
                    <th class="text-center">Fecha Fin</th>
                    <th class="text-center">Horas</th>
                    <th class="text-center">Estado</th>
                    <th class="text-center">Accion</th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($solicitudes as $solicitud): ?>
                    <tr>
                      <td><?php echo $solicitud['cedulaEstudiante']; ?></td>
                      <td><?php echo $solicitud['Carrera']; ?></td>
                      <td><?php echo $solicitud['Periodo']; ?></td>                    
                      <td><?php echo $solicitud['fInicio']; ?></td>
                      <td><?php echo $solicitud['fFin']; ?></td>
                      <td><?php echo $solicitud['horas']; ?></td>
                      <td>
                        <?php
                        $estado = $solicitud['estado'];
                        // Asignar color según el estado
                        if ($estado === 'PENDIENTE') {
                          echo '<span class="badge bg-danger">Pendiente</span>';
                        } elseif ($estado === 'APROBADO') {
                          echo '<span class="badge bg-success">Aprobado</span>';
                        } elseif ($estado === 'EN PROCESO') {
                          echo '<span class="badge bg-primary">En Proceso</span>';
                        } elseif ($estado === 'RECHAZADO') {
                          echo '<span class="badge bg-warning">Rechazado</span>';
                        } elseif ($estado === 'FINALIZADO') {
                          echo '<span class="badge bg-dark">Finalizado</span>';
                        } else {
                          echo '<span class="badge bg-secondary">ERROR</span>';
                        }
                        ?>
                      </td>
                      <td style="display: flex; gap: 10px;text-align:center" ><?php echo $solicitud['accion']; ?></td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal de Edición con Bootstrap -->
<div class="modal fade" id="modalEditarEstado" tabindex="-1" aria-labelledby="modalEditarEstadoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalEditarEstadoLabel">Cambiar Estado del Trámite</h5>
        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
          <i class="fas fa-times"></i> <!-- Icono de cerrar -->
        </button>
      </div>
      <div class="modal-body">
        <form id="formEditarEstado">
          <div class="form-group">
            <label for="estado" class="control-label">Estado del Trámite</label>
            <select class="form-control select2" id="estado" name="estado">
              <option value="NO REGISTRA">NO REGISTRA</option>
              <option value="PENDIENTE">PENDIENTE</option>
              <option value="APROBADO">APROBADO</option>
              <option value="EN PROCESO">EN PROCESO</option>
              <option value="RECHAZADO">RECHAZADO</option>
              <option value="FINALIZADO">FINALIZADO</option>
            </select>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" id="guardarBtn" onclick="guardarEstado()">Guardar</button>
      </div>
    </div>
  </div>
</div>


 <script type="text/javascript">
 if (typeof window.cedulaEstudianteGlobal === 'undefined') {
  window.cedulaEstudianteGlobal = '';
}

$(document).ready(function() {
  // Inicializar la tabla DataTable
  $('#tabla_tramites').DataTable();
  
  // Inicializar Select2
  $('.select2').select2();
});

// Función para abrir el modal de edición
function editarEstado(cedulaEstudiante) {
  // Asignar la cédula sin redeclarar la variable
  cedulaEstudianteGlobal = cedulaEstudiante;

  // Inicializar el modal
  var modalElement = document.getElementById('modalEditarEstado');
  var modal = new bootstrap.Modal(modalElement, {
    backdrop: 'static', // No cerrar con click fuera del modal
    keyboard: false // No cerrar con tecla ESC
  });

  modal.show(); // Mostrar el modal
}

// Función para guardar el estado
function guardarEstado() {
  var estado = document.getElementById("estado").value;

  fetch('ingreso/actualizacion_sol_practica.php', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json'
    },
    body: JSON.stringify({
      estado: estado,
      cedula: cedulaEstudianteGlobal // Usar la variable global
    })
  })
  .then(response => response.json())
  .then(data => {
    if (data.success) {
      // Mostrar mensaje de éxito con SweetAlert2
      Swal.fire({
        icon: 'success',
        title: 'Estado actualizado',
        text: 'El estado se ha actualizado a: ' + estado,
        confirmButtonText: 'Aceptar'
      }).then((result) => {
        if (result.isConfirmed) {
          // Recargar el contenido de la página
          cargar_contenido('contenido_principal', 'coordinador/view_sol_prac.php');
        }
      });
    } else {
      // Mostrar mensaje de error con SweetAlert2
      Swal.fire({
        icon: 'error',
        title: 'Error',
        text: 'Hubo un error al actualizar el estado.',
        confirmButtonText: 'Aceptar'
      });
    }
  })
  .catch(error => {
    console.error('Error:', error);
    Swal.fire({
      icon: 'error',
      title: 'Error',
      text: 'Hubo un error al actualizar el estado.',
      confirmButtonText: 'Aceptar'
    });
  });

  // Cerrar el modal después de guardar (usando Bootstrap 4)
  $('#modalEditarEstado').modal('hide'); // Usamos .modal('hide') en lugar de getInstance()

  // Usamos un setTimeout para asegurarnos de que el modal se haya cerrado antes de eliminar el fondo
  setTimeout(removeModalBackdrop, 200);
}

// Función para eliminar el fondo oscuro y modal-backdrop
function removeModalBackdrop() {
  // Eliminar el fondo oscuro .modal-backdrop si existe
  $('.modal-backdrop').remove();

  // Eliminar la clase modal-open del body
  $('body').removeClass('modal-open');

  // Asegurarse de que no haya más instancias acumuladas de fondo oscuro
  $('body').css('padding-right', ''); // Restablecer el padding del body
}
</script>