<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['S_ID'])) {
    header('Location: ../index.php');
    exit();
}

$cedula = $_SESSION['S_USU'];

include_once '../../model/model_conexion.php';

$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();

$resultados = [];

if ($pdo) {


    try {
        $sql = "SELECT s.idsolicitud, i.idSemana, i.cedulaEstudiante, i.fecha, i.actividades, i.detalle, i.hIngreso, i.hSalida, i.hEfectiva, i.fotos FROM infopractica i join solicitud s on s.cedulaEstudiante=i.cedulaEstudiante WHERE i.cedulaEstudiante = :cedula and s.estado='APROBADO'";
        $query = $pdo->prepare($sql);
        $query->bindParam(':cedula', $cedula, PDO::PARAM_INT);
        $query->execute();

        $resultados = $query->fetchAll(PDO::FETCH_ASSOC);
        
       
        $slq2= "SELECT s.idsolicitud from solicitud s WHERE s.cedulaEstudiante = :cedula and s.estado='APROBADO'";
        $query2 = $pdo->prepare($slq2);
        $query2->bindParam(':cedula', $cedula, PDO::PARAM_INT);
        $query2->execute();
        
        $idsol = $query2->fetch(PDO::FETCH_ASSOC);
        
        if($idsol){
            $sol= isset($idsol['idsolicitud'])?$idsol['idsolicitud']:'';
        }
        
        
    } catch (PDOException $e) {
        echo "Error al ejecutar la consulta: " . $e->getMessage();
    }
} else {
    echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>
    <link rel="stylesheet" href="css/style.css?<?php echo time(); ?>">
   
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">INGRESO DE BITACORA</h1>
            </div><!-- /.col -->
        </div>
    </div>
</div>

<div class="container mt-5">
    <!--   <div class="card-container">
            <div class="card">
                <div class="header text-white">
                    <h3>Datos de Estudiante y Empresa</h3>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-2">
                            <label class="datos form-label">Cedula: <?php echo $cedula ?></label>
                        </div>
                        <div class="mb-3">
                            <label for="nombre" class="datos form-label">Nombre: <?php echo $nombre; ?></label>
                        </div>
                        <div class="mb-3">
                            <label for="carrera" class="datos form-label">Carrera: <?php echo $carrera; ?> </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="entidad" class="datos form-label">Entidad Receptora:</label>
                        </div>
                        <div class="mb-3">
                            <label for="ciudad" class="datos form-label">Ciudad:</label>
                        </div>
                        <div class="mb-3">
                            <label for="direccion" class="datos form-label">Direccion:</label>
                        </div>
                    </div>

                </div>
            </div>
        </div>-->
    <div class="week-container">
        <!-- Semana 1 -->
        <div class="week-box" id="week1">
            <div class="week-header d-flex justify-content-between align-items-center mb-3">
                <h3>Semana 1</h3>
                <button class="btn btn-primary btn-week" data-bs-toggle="modal" data-bs-target="#modalAgregar" id="addBtnWeek1">Agregar Información</button>
            </div>
            <div id="alertWeek1" class="alert alert-warning d-none">Has alcanzado el límite de 5 registros.</div>
            <div class="table-responsive">
                <table id="bitacoraTableWeek1" class="table table-bordered table-sm">
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Actividades Realizadas</th>
                            <th>Detalle</th>
                            <th>Hora Ingreso</th>
                            <th>Hora Salida</th>
                            <th>Horas Efectivas</th>
                            <th>Fotos</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($resultados) {
                            foreach ($resultados as $resultado) {
                                if ($resultado['idSemana'] == 1) { ?>
                                    <tr>
                                        <td><?php echo $resultado['fecha']; ?></td>
                                        <td class="text-wrap text-break small" style="max-width: 200px; max-height: 100px; overflow-y: auto;">
                                            <?php echo nl2br(htmlspecialchars($resultado['actividades'])); ?>
                                        </td>
                                        <td class="text-wrap text-break small" style="max-width: 200px; max-height: 100px; overflow-y: auto;">
                                            <?php echo nl2br(htmlspecialchars($resultado['detalle'])); ?>
                                        </td>
                                        <td><?php echo $resultado['hIngreso']; ?></td>
                                        <td><?php echo $resultado['hSalida']; ?></td>
                                        <td><?php echo $resultado['hEfectiva']; ?></td>
                                        <td>
                                            <?php
                                            $fotos = json_decode($resultado['fotos'], true);
                                            if (is_array($fotos)) {
                                                foreach ($fotos as $foto) {
                                                    echo '<img src="ingreso/' . $foto . '" alt="Foto" class="img-thumbnail" style="width: 50px; height: 50px; margin-right: 5px;">';
                                                }
                                            }
                                            ?>
                                        </td>
                                    </tr>
                        <?php }
                            }
                        } ?>
                    </tbody>
                </table>
            </div>
        </div>


        <!-- Semana 2 -->
        <div class="week-box" id="week2">
            <div class="week-header d-flex justify-content-between align-items-center mb-3">
                <h3>Semana 2</h3>
                <button class="btn btn-primary btn-week" data-bs-toggle="modal" data-bs-target="#modalAgregar" id="addBtnWeek2">Agregar Información</button>
            </div>
            <div id="alertWeek2" class="alert alert-warning d-none">Has alcanzado el límite de 5 registros.</div>
            <div class="table-responsive">
            <table id="bitacoraTableWeek2" class="table table-bordered table-sm">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Actividades Realizadas</th>
                        <th>Detalle</th>
                        <th>Hora Ingreso</th>
                        <th>Hora Salida</th>
                        <th>Horas Efectivas</th>
                        <th>Fotos</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($resultados) {
                        foreach ($resultados as $resultado) {
                            if ($resultado['idSemana'] == 2) { ?>
                                <tr>
                                    <td><?php echo $resultado['fecha']; ?></td>
                                    <td class="text-wrap text-break small" style="max-width: 200px; max-height:100px; overflow-y:auto;"><?php echo nl2br(htmlspecialchars( $resultado['actividades'])); ?></td>
                                    <td class="text-wrap text-break small" style="max-width: 200px; max-height:100px; overflow-y:auto;"><?php echo nl2br(htmlspecialchars( $resultado['detalle'])); ?></td>
                                    <td><?php echo $resultado['hIngreso']; ?></td>
                                    <td><?php echo $resultado['hSalida']; ?></td>
                                    <td><?php echo $resultado['hEfectiva']; ?></td>
                                    <td>
                                        <?php
                                        $fotos = json_decode($resultado['fotos'], true);
                                        if (is_array($fotos)) {
                                            foreach ($fotos as $foto) {
                                                echo '<img src="ingreso/' . $foto . '" alt="Foto" class="img-thumbnail" style="width: 50px; height: 50px; margin-right: 5px;">';
                                            }
                                        }
                                        ?>
                                    </td>

                                </tr>
                    <?php }
                        }
                    } ?>
                </tbody>
            </table>
        </div>
        </div>

        <!-- Semana 3 -->
        <div class="week-box" id="week3">
        <div class="week-header d-flex justify-content-between align-items-center mb-3">
        <h3>Semana 3</h3>
                <button class="btn btn-primary btn-week" data-bs-toggle="modal" data-bs-target="#modalAgregar" id="addBtnWeek3">Agregar Información</button>
            </div>
            <div id="alertWeek3" class="alert alert-warning d-none">Has alcanzado el límite de 5 registros.</div>
            <div class="table-responsive">
            <table id="bitacoraTableWeek3" class="table table-bordered table-sm">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Actividades Realizadas</th>
                        <th>Detalle</th>
                        <th>Hora Ingreso</th>
                        <th>Hora Salida</th>
                        <th>Horas Efectivas</th>
                        <th>Fotos</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($resultados) {
                        foreach ($resultados as $resultado) {
                            if ($resultado['idSemana'] == 3) { ?>
                                <tr>
                                    <td><?php echo $resultado['fecha']; ?></td>
                                    <td class="text-wrap text-break small" style="max-width: 200px;max-height:100px; overflow-y:auto"><?php echo nl2br(htmlspecialchars($resultado['actividades'])); ?></td>
                                    <td class="text-wrap text-break small" style="max-width: 200px;max-heoght:100px; overflow-y:auto"><?php echo nl2br(htmlspecialchars($resultado['detalle'])); ?></td>
                                    <td><?php echo $resultado['hIngreso']; ?></td>
                                    <td><?php echo $resultado['hSalida']; ?></td>
                                    <td><?php echo $resultado['hEfectiva']; ?></td>
                                    <td>
                                        <?php
                                        $fotos = json_decode($resultado['fotos'], true);
                                        if (is_array($fotos)) {
                                            foreach ($fotos as $foto) {
                                                echo '<img src="ingreso/' . $foto . '" alt="Foto" class="img-thumbnail" style="width: 50px; height: 50px; margin-right: 5px;">';
                                            }
                                        }
                                        ?>
                                    </td>
                                </tr>
                    <?php }
                        }
                    } ?>
                </tbody>
            </table>
        </div>
        </div>

        <!-- Semana 4 -->
        <div class="week-box" id="week4">
        <div class="week-header d-flex justify-content-between align-items-center mb-3">
        <h3>Semana 4</h3>
                <button class="btn btn-primary btn-week" data-bs-toggle="modal" data-bs-target="#modalAgregar" id="addBtnWeek4">Agregar Información</button>
            </div>
            <div id="alertWeek4" class="alert alert-warning d-none" >Has alcanzado el límite de 5 registros.</div>
           <div class="table-responsive">
            <table id="bitacoraTableWeek4" class="table table-bordered table-sm">
                <thead>
                    <tr>
                        <th>Fecha</th>
                        <th>Actividades Realizadas</th>
                        <th>Detalle</th>
                        <th>Hora Ingreso</th>
                        <th>Hora Salida</th>
                        <th>Horas Efectivas</th>
                        <th>Fotos</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($resultados) {
                        foreach ($resultados as $resultado) {
                            if ($resultado['idSemana'] == 4) { ?>
                                <tr>
                                    <td><?php echo $resultado['fecha']; ?></td>
                                    <td class="text-wrap text-break small" style="max-width: 200px;max-height:100px; overflow-y:auto"><?php echo nl2br(htmlspecialchars( $resultado['actividades'])); ?></td>
                                    <td class="text-wrap text-break small" style="max-width: 200px;max-height:100px; overflow-y:auto"><?php echo nl2br(htmlspecialchars( $resultado['detalle'])); ?></td>
                                    <td><?php echo $resultado['hIngreso']; ?></td>
                                    <td><?php echo $resultado['hSalida']; ?></td>
                                    <td><?php echo $resultado['hEfectiva']; ?></td>
                                    <td>
                                        <?php
                                        $fotos = json_decode($resultado['fotos'], true);
                                        if (is_array($fotos)) {
                                            foreach ($fotos as $foto) {
                                                echo '<img src="ingreso/' . $foto . '" alt="Foto" class="img-thumbnail" style="width: 50px; height: 50px; margin-right: 5px;">';
                                            }
                                        }
                                        ?>
                                    </td>
                                </tr>
                    <?php }
                        }
                    } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Resto del código PHP/HTML -->

<!-- Modal -->
  <div class="modal fade" id="modalAgregar" role="dialog" tabindex="-1" aria-labelledby="modalAgregarLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalAgregarLabel">Agregar Bitácora</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <form id="formBitacora" enctype="multipart/form-data">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="fecha" class="form-label">Fecha:</label>
                                    <input style="display:none" id="idsolicitud" name="idsolicitud" value="<?php echo $sol; ?>">
                                    <input type="date" class="form-control" id="fecha" name="fecha" required max="<?php echo date('Y-m-d'); ?>">
                                </div>
                                <div class="mb-3">
                                    <label for="actividades" class="form-label">Actividades Realizadas:</label>
                                    <textarea class="form-control" id="actividades" name="actividades" required></textarea>
                                </div>
                                <div class="mb-3">
                                    <label for="detalle" class="form-label">Detalle (Aprendizaje alcanzado):</label>
                                    <textarea class="form-control" id="detalle" name="detalle" required></textarea>
                                </div>
                                <div class="mb-3">
                                    <label for="descripcion" class="form-label">Descripción de Foto:</label>
                                    <input type="text" class="form-control" id="descripcion" name="descripcion" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="horaIngreso" class="form-label">Hora de Ingreso:</label>
                                    <input type="time" class="form-control" id="horaIngreso" name="horaIngreso" required>
                                </div>
                                <div class="mb-3">
                                    <label for="horaSalida" class="form-label">Hora de Salida:</label>
                                    <input type="time" class="form-control" id="horaSalida" name="horaSalida" required>
                                </div>
                                <div class="mb-3">
                                    <label for="horasEfectivas" class="form-label">Horas Efectivas:</label>
                                    <input type="text" class="form-control" id="horasEfectivas" name="horasEfectivas" readonly>
                                </div>
                                <div class="mb-3">
                                    <label for="fotos" class="form-label">Seleccionar Foto:</label>
                                    <input type="file" class="form-control" id="fotos" name="fotos[]" accept="image/*" multiple>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                    <button type="button" class="btn btn-primary" id="guardarBtn">Guardar</button>
                </div>
            </div>
        </div>
    </div>

<script>
// Función para limpiar el formulario
// Función para limpiar el formulario
function limpiarFormulario() {
    document.getElementById('fotos').value = '';
    document.getElementById('fecha').value = '';
    document.getElementById('actividades').value = '';
    document.getElementById('detalle').value = '';
    document.getElementById('horaIngreso').value = '';
    document.getElementById('horaSalida').value = '';
    document.getElementById('horasEfectivas').value = '';
    document.getElementById('descripcion').value = '';
}

// Función para calcular horas efectivas
function calcularHorasEfectivas() {
    const horaIngreso = document.getElementById('horaIngreso').value;
    const horaSalida = document.getElementById('horaSalida').value;

    if (horaIngreso && horaSalida) {
        const [hhIngreso, mmIngreso] = horaIngreso.split(':').map(Number);
        const [hhSalida, mmSalida] = horaSalida.split(':').map(Number);

        const tiempoIngreso = hhIngreso * 60 + mmIngreso;
        const tiempoSalida = hhSalida * 60 + mmSalida;

        let diff = tiempoSalida - tiempoIngreso;
        if (diff < 0) {
            diff += 24 * 60;
        }

        const horas = Math.floor(diff / 60);
        const minutos = diff % 60;

        document.getElementById('horasEfectivas').value = `${horas}:${minutos < 10 ? '0' + minutos : minutos}`;
    } else {
        document.getElementById('horasEfectivas').value = '';
    }
}

// Asignar eventos cada vez que el modal se abra
$('#modalAgregar').on('show.bs.modal', function () {
    // Limpiar eventos anteriores
    document.getElementById("horaIngreso").removeEventListener("change", calcularHorasEfectivas);
    document.getElementById("horaSalida").removeEventListener("change", calcularHorasEfectivas);

    // Asignar eventos para calcular horas efectivas
    document.getElementById("horaIngreso").addEventListener("change", calcularHorasEfectivas);
    document.getElementById("horaSalida").addEventListener("change", calcularHorasEfectivas);
});

// Limpiar el formulario cuando el modal se cierre
$('#modalAgregar').on('hidden.bs.modal', function () {
    limpiarFormulario();
});

// Declaración única de la variable
if (typeof semanaSeleccionada === 'undefined') {
    let semanaSeleccionada = 1; // Solo declaramos si no ha sido declarada previamente
}


// Función para establecer la semana seleccionada
function setSemanaSeleccionada(semana) {
    semanaSeleccionada = semana;
}

// Asignar eventos a los botones para abrir el modal
document.getElementById("addBtnWeek1").addEventListener("click", () => {
    setSemanaSeleccionada(1);
    $('#modalAgregar').modal('show');
});
document.getElementById("addBtnWeek2").addEventListener("click", () => {
    setSemanaSeleccionada(2);
    $('#modalAgregar').modal('show');
});
document.getElementById("addBtnWeek3").addEventListener("click", () => {
    setSemanaSeleccionada(3);
    $('#modalAgregar').modal('show');
});
document.getElementById("addBtnWeek4").addEventListener("click", () => {
    setSemanaSeleccionada(4);
    $('#modalAgregar').modal('show');
});

// Función para agregar una nueva fila a la tabla
function agregarBitacora(semana, fecha, actividades, detalle, horaIngreso, horaSalida, horasEfectivas, fotos) {
    const container = document.querySelector(`#bitacoraTableWeek${semana} tbody`);
    const tr = document.createElement('tr');
    tr.innerHTML = `
        <td>${fecha}</td>
        <td>${actividades}</td>
        <td>${detalle}</td>
        <td>${horaIngreso}</td>
        <td>${horaSalida}</td>
        <td>${horasEfectivas}</td>
        <td>${fotos.map(foto => `<img src="${foto}" alt="Foto" class="img-thumbnail" style="width: 50px;">`).join('')}</td>
    `;
    container.appendChild(tr);
}

// Función para redimensionar imágenes
function redimensionarImagen(file, maxWidth, maxHeight) {
    return new Promise((resolve, reject) => {
        const img = new Image();
        const reader = new FileReader();

        reader.onload = function(e) {
            img.src = e.target.result;
            img.onload = function() {
                const canvas = document.createElement('canvas');
                let width = img.width;
                let height = img.height;

                if (width > height) {
                    if (width > maxWidth) {
                        height *= maxWidth / width;
                        width = maxWidth;
                    }
                } else {
                    if (height > maxHeight) {
                        width *= maxHeight / height;
                        height = maxHeight;
                    }
                }

                canvas.width = width;
                canvas.height = height;
                const ctx = canvas.getContext('2d');
                ctx.drawImage(img, 0, 0, width, height);

                canvas.toBlob(blob => {
                    resolve(blob);
                }, file.type, 0.7);
            };
        };

        reader.onerror = function(error) {
            reject(error);
        };

        reader.readAsDataURL(file);
    });
}

// Función para guardar la bitácora
document.getElementById("guardarBtn").addEventListener("click", function() {
    // Verificar si ya hay 5 ingresos para la semana seleccionada
    const registrosExistentes = document.querySelectorAll(`#bitacoraTableWeek${semanaSeleccionada} tbody tr`).length;
    if (registrosExistentes >= 6) {
        Swal.fire({
            icon: 'error',
            title: 'Límite alcanzado',
            text: 'No se pueden agregar más de 5 registros por semana.',
        });
        return;
    }

    const fecha = document.getElementById("fecha").value;
    const actividades = document.getElementById("actividades").value;
    const detalle = document.getElementById("detalle").value;
    const horaIngreso = document.getElementById("horaIngreso").value;
    const horaSalida = document.getElementById("horaSalida").value;
    const horasEfectivas = document.getElementById("horasEfectivas").value;
    const fotosInput = document.getElementById("fotos");
    const descripcion = document.getElementById("descripcion").value;
    const fotos = [];

    if (!fecha || !actividades || !detalle || !horaIngreso || !horaSalida || !horasEfectivas) {
        Swal.fire({
            icon: 'error',
            title: 'Campos obligatorios',
            text: 'Todos los campos son requeridos.',
        });
        return;
    }

    if (fotosInput.files.length > 0) {
        const formatosPermitidos = ['image/jpeg', 'image/png', 'image/gif'];
        const fotoPromises = Array.from(fotosInput.files).map(file => {
            return new Promise((resolve, reject) => {
                if (!formatosPermitidos.includes(file.type)) {
                    alert("Formato de imagen no permitido. Solo se permiten JPEG, PNG y GIF.");
                    reject("Formato de imagen no permitido");
                }

                if (file.size > 2000000) {
                    redimensionarImagen(file, 800, 600).then(blob => {
                        const reader = new FileReader();
                        reader.onloadend = function() {
                            fotos.push(reader.result);
                            resolve();
                        };
                        reader.readAsDataURL(blob);
                    }).catch(error => {
                        reject(error);
                    });
                } else {
                    const reader = new FileReader();
                    reader.onloadend = function() {
                        fotos.push(reader.result);
                        resolve();
                    };
                    reader.readAsDataURL(file);
                }
            });
        });

        Promise.all(fotoPromises)
            .then(() => guardarDatos(fotos))
            .catch(error => console.error('Error al procesar las fotos:', error));
    } else {
        guardarDatos(fotos);
    }
});

// Función para guardar los datos en el servidor
function guardarDatos(fotos) {
    const data = {
        idsolicitud: document.getElementById("idsolicitud").value,
        idSemana: semanaSeleccionada,
        cedulaEstudiante: "<?php echo $cedula; ?>",
        fecha: document.getElementById("fecha").value,
        actividades: document.getElementById("actividades").value,
        detalle: document.getElementById("detalle").value,
        horaIngreso: document.getElementById("horaIngreso").value,
        horaSalida: document.getElementById("horaSalida").value,
        horasEfectivas: document.getElementById("horasEfectivas").value,
        descripcion: document.getElementById("descripcion").value,
        fotos: fotos
    };
    console.log(data);
    fetch('ingreso/insertar_bitacora.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(result => {
        if (result.status === 'success') {
            agregarBitacora(semanaSeleccionada, data.fecha, data.actividades, data.detalle, data.horaIngreso, data.horaSalida, data.horasEfectivas, fotos);
            $('#modalAgregar').modal('hide');
            Swal.fire({
                icon: 'success',
                title: '¡Registro guardado exitosamente!',
                showConfirmButton: false,
                timer: 1500
            });
        } else {
            alert("Error al guardar el registro");
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert("Error al guardar el registro");
    });
}
</script>