<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">CONSULTA DE BITACORA</h1>
            </div><!-- /.col -->
        </div>
    </div>
</div>
<div class="container mt-5">
    <div class="card-container">
        <div class="card card-primary">
            <div class="card-header">
                <h3>Imprimir Bitacora</h3>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-2">
                            <h4 class="card-tittle">Ingrese Cedula</h4>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="input-field">
                            <!-- Cambié el método de POST a GET en el formulario -->
                            <form id="consultaForm" action="pdf/rep_bitacora.php" method="GET" target="_blank">
                                <input type="text" id="cedula" name="cedula" placeholder="Número de Cédula">
                                <button type="submit" class="btn btn-primary btn-week">Consultar</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Materialize JS -->
<link rel="stylesheet" href="../plantilla/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<script type="text/javascript">
    function validarCedula(cedula) {
        // Validar longitud
        if (cedula.length !== 10) {
            return false;
        }

        // Validar que solo contenga números
        if (!/^\d+$/.test(cedula)) {
            return false;
        }

        // Validar el código de provincia (dos primeros dígitos)
        const provincia = parseInt(cedula.substring(0, 2), 10);
        if (provincia < 1 || provincia > 24) {
            return false;
        }

        // Validar el último dígito
        const coeficientes = [2, 1, 2, 1, 2, 1, 2, 1, 2];
        const verificador = parseInt(cedula.charAt(9), 10);
        let suma = 0;

        for (let i = 0; i < coeficientes.length; i++) {
            let valor = parseInt(cedula.charAt(i), 10) * coeficientes[i];
            suma += valor >= 10 ? valor - 9 : valor;
        }

        const modulo = suma % 10;
        const digitoVerificador = modulo === 0 ? 0 : 10 - modulo;

        return digitoVerificador === verificador;
    }

    document.getElementById('cedula').addEventListener('input', function() {
        const cedula = this.value;
        if (validarCedula(cedula)) {
            this.style.borderColor = 'green';
        } else {
            this.style.borderColor = 'red';
        }
    });

    // Validar antes de enviar el formulario
    document.getElementById('consultaForm').addEventListener('submit', function(event) {
        var cedula = document.getElementById("cedula").value;
        if (cedula === "") {
            M.toast({
                html: 'Por favor, ingrese un número de cédula.',
                classes: 'red'
            });
            document.getElementById("cedula").style.borderColor = 'red';
            event.preventDefault(); // Evita el envío del formulario si está vacío
            return;
        }

        if (!validarCedula(cedula)) {
            M.toast({
                html: 'Número de cédula inválido.',
                classes: 'red'
            });
            document.getElementById("cedula").style.borderColor = 'red';
            event.preventDefault(); // Evita el envío del formulario si es inválido
            return;
        }

        document.getElementById("cedula").style.borderColor = 'green';
    });
</script>
