<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

$cedula = $_SESSION['S_USU'];
include_once '../../model/model_conexion.php';
$conexion = new conexionBD();
$pdo = $conexion->conexionPDO();
$resultados = null;

if ($pdo) {
    $sql = "SELECT idinfopractica, idSemana, cedulaEstudiante, fecha, actividades, detalle, hIngreso, hSalida, hEfectiva, fotos FROM infopractica where cedulaEstudiante=:cedula";
    try {
        $query = $pdo->prepare($sql);
        $query->bindParam(':cedula', $cedula, PDO::PARAM_STR);
        $query->execute();
        $resultados = $query->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        echo "Error al ejecutar la consulta: " . $e->getMessage();
    }
} else {
    echo "<script>alert('No se pudo establecer una conexión con la base de datos.');</script>";
}

$conexion->cerrar_conexion();
?>

<link rel="stylesheet" href="css/style.css?<?php echo time(); ?>">

<div class="wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">EDITAR BITACORA</h1>
                    </div><!-- /.col -->
                </div>
            </div>
        </div>
        <!-- Main content -->
        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="week-container">
                                    <?php if ($resultados) {
                                        // Agrupar los registros por idSemana
                                        $semanas = [];
                                        foreach ($resultados as $resultado) {
                                            $semanas[$resultado['idSemana']][] = $resultado;
                                        }

                                        // Ordenar las semanas por idSemana (de 1 a 4)
                                        ksort($semanas);

                                        // Mostrar los registros de cada semana
                                        foreach ($semanas as $idSemana => $semana) { ?>
                                            <div class="week-box" id="week<?php echo $idSemana; ?>">
                                                <div class="week-header d-flex justify-content-between align-items-center mb-3">
                                                    <h3>Semana <?php echo $idSemana; ?></h3>
                                                </div>
                                                <div class="table-responsive">
                                                    <table id="bitacoraTableWeek<?php echo $idSemana; ?>" class="table table-bordered table-sm">
                                                        <thead>
                                                            <tr>
                                                                <th>Fecha</th>
                                                                <th>Actividades Realizadas</th>
                                                                <th>Detalle</th>
                                                                <th>Hora Ingreso</th>
                                                                <th>Hora Salida</th>
                                                                <th>Horas Efectivas</th>
                                                                <th>Fotos</th>
                                                                <th>Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php foreach ($semana as $registro) { ?>
                                                                <tr data-id="<?php echo $registro['idinfopractica']; ?>" 
                                                                    data-idSemana="<?php echo $registro['idSemana']; ?>" 
                                                                    data-cedula="<?php echo $registro['cedulaEstudiante']; ?>"
                                                                    data-fecha="<?php echo $registro['fecha']; ?>"
                                                                    data-actividades="<?php echo htmlspecialchars($registro['actividades'] ?? ''); ?>"
                                                                    data-detalle="<?php echo htmlspecialchars($registro['detalle'] ?? ''); ?>"
                                                                    data-hIngreso="<?php echo $registro['hIngreso']; ?>"
                                                                    data-hSalida="<?php echo $registro['hSalida']; ?>"
                                                                    data-hEfectiva="<?php echo $registro['hEfectiva']; ?>"
                                                                    data-fotos="<?php echo htmlspecialchars($registro['fotos'] ?? ''); ?>">

                                                                    <td><?php echo $registro['fecha']; ?></td>
                                                                    <td class="text-wrap text-break small"><?php echo nl2br(htmlspecialchars($registro['actividades'] ?? '')); ?></td>
                                                                    <td class="text-wrap text-break small"><?php echo nl2br(htmlspecialchars($registro['detalle'] ?? '')); ?></td>
                                                                    <td><?php echo $registro['hIngreso']; ?></td>
                                                                    <td><?php echo $registro['hSalida']; ?></td>
                                                                    <td><?php echo $registro['hEfectiva']; ?></td>
                                                                    <td>
                                                                        <?php
                                                                        $fotos = $registro['fotos'] ? json_decode($registro['fotos'], true) : [];

                                                                        if (count($fotos) > 0) {
                                                                            foreach ($fotos as $foto) {
                                                                                echo '<img src="ingreso/' . htmlspecialchars($foto) . '" alt="Foto" class="img-thumbnail" style="width: 50px; height: 50px; margin-right: 5px;">';
                                                                            }
                                                                        } else {
                                                                            echo '<span>No tiene foto</span>';
                                                                        }
                                                                        ?>
                                                                    </td>
                                                                    <td>
                                                                        <button class="btn btn-warning btn-sm edit-btn" data-toggle="modal" data-target="#editModal">Editar</button>
                                                                    </td>
                                                                </tr>
                                                            <?php } ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        <?php }
                                    } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal para editar -->
    <div class="modal fade" id="editModal" role="dialog" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">Editar Registro de Semana</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="editIdInfopractica" name="idinfopractica">
                    <input type="hidden" id="editcedulaestudiante" name="cedulaestudiante">
                    <input type="hidden" id="editsemana" name="semana">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="editFecha" class="form-label">Fecha</label>
                                <input type="date" class="form-control" id="editFecha" name="fecha">
                            </div>
                            <div class="mb-3">
                                <label for="editActividades" class="form-label">Actividades</label>
                                <textarea class="form-control" id="editActividades" name="actividades" rows="3"></textarea>
                            </div>
                            <div class="mb-3">
                                <label for="editDetalle" class="form-label">Detalle</label>
                                <textarea class="form-control" id="editDetalle" name="detalle" rows="3"></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="editHoraIngreso" class="form-label">Hora Ingreso</label>
                                <input type="time" class="form-control" id="editHoraIngreso" name="horaIngreso" onchange="calcularHorasEfectivas()">
                            </div>
                            <div class="mb-3">
                                <label for="editHoraSalida" class="form-label">Hora Salida</label>
                                <input type="time" class="form-control" id="editHoraSalida" name="horaSalida" onchange="calcularHorasEfectivas()">
                            </div>
                            <div class="mb-3">
                                <label for="editHorasEfectivas" class="form-label">Horas Efectivas</label>
                                <input type="text" class="form-control" id="editHorasEfectivas" name="horasEfectivas" readonly>
                            </div>
                            <div class="mb-3">
                                <label for="editFotos" class="form-label">Fotos</label>
                                <input type="file" class="form-control" id="editFotos" name="fotos[]" accept="image/*" multiple>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                    <button type="button" class="btn btn-primary" id="guardarBtn">Guardar Cambios</button>
                </div>
            </div>
        </div>
    </div>

<script>
   // Configurar los datos del modal cuando se hace clic en el botón "Editar"
    document.querySelectorAll('.edit-btn').forEach(button => {
        button.addEventListener('click', function () {
            const row = this.closest('tr');
            const idInfopractica = row.getAttribute('data-id'); 
            const idsemana = row.getAttribute('data-idSemana');
            const cedulaestudiante = row.getAttribute('data-cedula'); 
            const fecha = row.getAttribute('data-fecha');
            const actividades = row.getAttribute('data-actividades');
            const detalle = row.getAttribute('data-detalle');
            const hIngreso = row.getAttribute('data-hIngreso');
            const hSalida = row.getAttribute('data-hSalida');
            const hEfectiva = row.getAttribute('data-hEfectiva');
            const fotos = row.getAttribute('data-fotos');

            document.getElementById('editIdInfopractica').value = idInfopractica;  
            document.getElementById('editcedulaestudiante').value = cedulaestudiante;
            document.getElementById('editsemana').value = idsemana;
            document.getElementById('editFecha').value = fecha;
            document.getElementById('editActividades').value = actividades;
            document.getElementById('editDetalle').value = detalle;
            document.getElementById('editHoraIngreso').value = hIngreso;
            document.getElementById('editHoraSalida').value = hSalida;
            document.getElementById('editHorasEfectivas').value = hEfectiva;
        });
    });

    function calcularHorasEfectivas() {
        const horaIngreso = document.getElementById('editHoraIngreso').value;
        const horaSalida = document.getElementById('editHoraSalida').value;

        if (horaIngreso && horaSalida) {
            const [hhIngreso, mmIngreso] = horaIngreso.split(':').map(Number);
            const [hhSalida, mmSalida] = horaSalida.split(':').map(Number);

            const tiempoIngreso = hhIngreso * 60 + mmIngreso;
            const tiempoSalida = hhSalida * 60 + mmSalida;

            let diff = tiempoSalida - tiempoIngreso;
            if (diff < 0) {
                diff += 24 * 60;
            }

            const horas = Math.floor(diff / 60);
            const minutos = diff % 60;

            document.getElementById('editHorasEfectivas').value = `${horas}:${minutos < 10 ? '0' + minutos : minutos}`;
        } else {
            document.getElementById('editHorasEfectivas').value = '';
        }
    }

    // Guardar los cambios en el registro
    document.getElementById("guardarBtn").addEventListener("click", function () {
        const fotosInput = document.getElementById("editFotos");
        const fotosPrevias = $('#editFotos').data('fotosPrevias') || []; 

        const fotosNuevas = [];

        if (fotosInput.files.length > 0) {
            const fotoPromises = Array.from(fotosInput.files).map(file => {
                return new Promise((resolve, reject) => {
                    if (file.size > 2000000) {
                        alert("Las fotos deben ser menores a 2 MB.");
                        reject("Foto demasiado grande");
                    }

                    const reader = new FileReader();
                    reader.onloadend = function () {
                        fotosNuevas.push(reader.result);  
                        resolve();
                    };
                    reader.onerror = function () {
                        reject("Error al leer la foto");
                    };
                    reader.readAsDataURL(file); 
                });
            });

            Promise.all(fotoPromises)
                .then(() => {
                    const todasLasFotos = [...fotosPrevias, ...fotosNuevas];
                    enviarDatosConFotos(todasLasFotos);
                })
                .catch(error => {
                    console.error('Error al procesar las fotos:', error);
                });
        } else {
            enviarDatosConFotos(fotosPrevias);
        }
    });

    function enviarDatosConFotos(fotos) {
        const data = {
            idinfopractica: $('#editIdInfopractica').val(), 
            cedulaEstudiante: $('#editcedulaestudiante').val(),
            semana: $('#editsemana').val(),
            fecha: $('#editFecha').val(),
            actividades: $('#editActividades').val(),
            detalle: $('#editDetalle').val(),
            horaIngreso: $('#editHoraIngreso').val(),
            horaSalida: $('#editHoraSalida').val(),
            horasEfectivas: $('#editHorasEfectivas').val(),
            fotos: fotos
        };

        fetch('ingreso/consulta.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(data)
        })
        .then(response => response.json())
        .then(result => {
            if (result.status === 'success') {
                Swal.fire({
                    icon: 'success',
                    title: '¡Registro Actualizado exitosamente!',
                    showConfirmButton: false,
                    timer: 1500
                }).then(() => {
                    // Cerrar el modal de manera forzada antes de recargar las tablas
                    const modalElement = document.getElementById('editModal');
                    const modal = bootstrap.Modal.getInstance(modalElement);

                    // Si el modal está abierto, lo cerramos de forma programática
                    if (modal) {
                        modal.hide();
                    }

                    // Limpiar formulario
                    limpiarFormulario();

                    // Recargar los datos de las tablas
                    recargarTabla();

                    // Eliminar el fondo del modal
                    eliminarFondosModal();
                });
            } else {
                alert("Error al guardar el registro");
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert("Error al guardar el registro");
        });
    }

    // Función para eliminar los fondos de los modales
    function eliminarFondosModal() {
        const backdrops = document.querySelectorAll('.modal-backdrop');
        backdrops.forEach(backdrop => {
            backdrop.remove();  // Elimina cada fondo del modal
        });
    }

    // Función para recargar los datos de las semanas y actualizar las tablas
    function recargarTabla() {
        // Hacer una solicitud al servidor para obtener los nuevos datos
        fetch('ingreso/consulta.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            // Llamamos a una función para actualizar el DOM de la tabla con los nuevos datos
            actualizarTabla(data);
        })
        .catch(error => {
            console.error('Error al cargar los datos:', error);
        });
    }

    // Función para actualizar la tabla con los nuevos datos
    function actualizarTabla(data) {
        const contenedor = document.querySelector('.week-container');
        contenedor.innerHTML = '';  // Limpiar el contenedor de las semanas

        // Agrupar los registros por semana
        const semanas = {};
        data.forEach(registro => {
            if (!semanas[registro.idSemana]) {
                semanas[registro.idSemana] = [];
            }
            semanas[registro.idSemana].push(registro);
        });

        // Mostrar los registros de cada semana en la tabla
        Object.keys(semanas).forEach(idSemana => {
            const semana = semanas[idSemana];
            const semanaDiv = document.createElement('div');
            semanaDiv.classList.add('week-box');
            semanaDiv.id = `week${idSemana}`;
            
            // Crear el encabezado de la semana
            const semanaHeader = document.createElement('div');
            semanaHeader.classList.add('week-header', 'd-flex', 'justify-content-between', 'align-items-center', 'mb-3');
            semanaHeader.innerHTML = `<h3>Semana ${idSemana}</h3>`;
            semanaDiv.appendChild(semanaHeader);

            // Crear la tabla para esa semana
            const tabla = document.createElement('div');
            tabla.classList.add('table-responsive');
            tabla.innerHTML = `
                <table id="bitacoraTableWeek${idSemana}" class="table table-bordered table-sm">
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Actividades Realizadas</th>
                            <th>Detalle</th>
                            <th>Hora Ingreso</th>
                            <th>Hora Salida</th>
                            <th>Horas Efectivas</th>
                            <th>Fotos</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        ${semana.map(registro => {
                            const fotos = registro.fotos ? JSON.parse(registro.fotos) : [];
                            return `
                                <tr data-id="${registro.idinfopractica}" data-idSemana="${registro.idSemana}" data-cedula="${registro.cedulaEstudiante}" data-fecha="${registro.fecha}" data-actividades="${registro.actividades}" data-detalle="${registro.detalle}" data-hIngreso="${registro.hIngreso}" data-hSalida="${registro.hSalida}" data-hEfectiva="${registro.hEfectiva}" data-fotos="${JSON.stringify(fotos)}">
                                    <td>${registro.fecha}</td>
                                    <td class="text-wrap text-break small">${registro.actividades}</td>
                                    <td class="text-wrap text-break small">${registro.detalle}</td>
                                    <td>${registro.hIngreso}</td>
                                    <td>${registro.hSalida}</td>
                                    <td>${registro.hEfectiva}</td>
                                    <td>
                                        ${fotos.map(foto => `<img src="ingreso/${foto}" alt="Foto" class="img-thumbnail" style="width: 50px; height: 50px; margin-right: 5px;">`).join('')}
                                    </td>
                                    <td>
                                         <button class="btn btn-warning btn-sm edit-btn" data-toggle="modal" data-target="#editModal">Editar</button>
                                    </td>
                                </tr>
                            `;
                        }).join('')}
                    </tbody>
                </table>
            `;
            semanaDiv.appendChild(tabla);
            contenedor.appendChild(semanaDiv);
        });
    }
</script>


