<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
if (!isset($_SESSION['S_ID'])) {
    header('Location: ../index.php');
}
$id_usuario = $_SESSION['S_ID'];

?>
<link rel="stylesheet" href="css/style.css">
<div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">INGRESO DE BITACORA</h1>
          </div><!-- /.col -->
        </div>
      </div>
    </div>

   <div class="container mt-5">
     <!--   <div class="card-container">
            <div class="card">
                <div class="header text-white">
                    <h3>Datos de Estudiante y Empresa</h3>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-2">
                            <label class="datos form-label">Cedula: <?php echo $cedula ?></label>
                        </div>
                        <div class="mb-3">
                            <label for="nombre" class="datos form-label">Nombre: <?php echo $nombre; ?></label>
                        </div>
                        <div class="mb-3">
                            <label for="carrera" class="datos form-label">Carrera: <?php echo $carrera; ?> </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="entidad" class="datos form-label">Entidad Receptora:</label>
                        </div>
                        <div class="mb-3">
                            <label for="ciudad" class="datos form-label">Ciudad:</label>
                        </div>
                        <div class="mb-3">
                            <label for="direccion" class="datos form-label">Direccion:</label>
                        </div>
                    </div>

                </div>
            </div>
        </div>-->
        <div class="week-container">
            <!-- Semana 1 -->
            <div class="week-box" id="week1">
                <div class="week-header">
                    <h3>Semana 1</h3>
                    <button class="btn btn-primary btn-week" data-bs-toggle="modal" data-bs-target="#modalAgregar" id="addBtnWeek1">Agregar Información</button>
                </div>
                <div id="alertWeek1" class="alert alert-warning" style="display: none;">Has alcanzado el límite de 5 registros.</div>
                <table id="bitacoraTableWeek1">
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Actividades Realizadas</th>
                            <th>Detalle</th>
                            <th>Hora Ingreso</th>
                            <th>Hora Salida</th>
                            <th>Horas Efectivas</th>
                            <th>Fotos</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>

            <!-- Semana 2 -->
            <div class="week-box" id="week2">
                <div class="week-header">
                    <h3>Semana 2</h3>
                    <button class="btn btn-primary btn-week" data-bs-toggle="modal" data-bs-target="#modalAgregar" id="addBtnWeek2">Agregar Información</button>
                </div>
                <div id="alertWeek2" class="alert alert-warning" style="display: none;">Has alcanzado el límite de 5 registros.</div>
                <table id="bitacoraTableWeek2">
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Actividades Realizadas</th>
                            <th>Detalle</th>
                            <th>Hora Ingreso</th>
                            <th>Hora Salida</th>
                            <th>Horas Efectivas</th>
                            <th>Fotos</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>

            <!-- Semana 3 -->
            <div class="week-box" id="week3">
                <div class="week-header">
                    <h3>Semana 3</h3>
                    <button class="btn btn-primary btn-week" data-bs-toggle="modal" data-bs-target="#modalAgregar" id="addBtnWeek3">Agregar Información</button>
                </div>
                <div id="alertWeek3" class="alert alert-warning" style="display: none;">Has alcanzado el límite de 5 registros.</div>
                <table id="bitacoraTableWeek3">
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Actividades Realizadas</th>
                            <th>Detalle</th>
                            <th>Hora Ingreso</th>
                            <th>Hora Salida</th>
                            <th>Horas Efectivas</th>
                            <th>Fotos</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>

            <!-- Semana 4 -->
            <div class="week-box" id="week4">
                <div class="week-header">
                    <h3>Semana 4</h3>
                    <button class="btn btn-primary btn-week" data-bs-toggle="modal" data-bs-target="#modalAgregar" id="addBtnWeek4">Agregar Información</button>
                </div>
                <div id="alertWeek4" class="alert alert-warning" style="display: none;">Has alcanzado el límite de 5 registros.</div>
                <table id="bitacoraTableWeek4">
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Actividades Realizadas</th>
                            <th>Detalle</th>
                            <th>Hora Ingreso</th>
                            <th>Hora Salida</th>
                            <th>Horas Efectivas</th>
                            <th>Fotos</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="modalAgregar" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-body">
                    <form id="formBitacora" enctype="multipart/form-data">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="fecha" class="form-label">Fecha:</label>
                                    <input type="date" class="form-control" id="fecha" name="fecha" required max="<?= date('Y-m-d'); ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label for="actividades" class="form-label">Actividades Realizadas:</label>
                                    <textarea class="form-control" id="actividades" name="actividades" required></textarea>
                                </div>
                                <div class="mb-3">
                                    <label for="detalle" class="form-label">Detalle (Aprendizaje alcanzado):</label>
                                    <textarea class="form-control" id="detalle" name="detalle" required></textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="horaIngreso" class="form-label">Hora de Ingreso:</label>
                                    <input type="time" class="form-control" id="horaIngreso" name="horaIngreso" required>
                                </div>
                                <div class="mb-3">
                                    <label for="horaSalida" class="form-label">Hora de Salida:</label>
                                    <input type="time" class="form-control" id="horaSalida" name="horaSalida" required>
                                </div>
                                <div class="mb-3">
                                    <label for="horasEfectivas" class="form-label">Horas Efectivas:</label>
                                    <input type="text" class="form-control" id="horasEfectivas" name="horasEfectivas" readonly>
                                </div>
                                <div class="mb-3">
                                    <label for="fotos" class="form-label">Seleccionar Fotos:</label>
                                    <input type="file" class="form-control" id="fotos" name="fotos[]" accept="image/*" multiple>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="button" class="btn btn-primary" id="guardarBtn">Guardar</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>


<script>

function limpiarFormulario() {
    document.getElementById('fotos').value = '';
    document.getElementById('fecha').value = '';
    document.getElementById('actividades').value = '';
    document.getElementById('detalle').value = '';
    document.getElementById('horaIngreso').value = '';
    document.getElementById('horaSalida').value = '';
    document.getElementById('horasEfectivas').value = '';
}

function calcularHorasEfectivas() {
    const horaIngreso = document.getElementById('horaIngreso').value;
    const horaSalida = document.getElementById('horaSalida').value;

    if (horaIngreso && horaSalida) {
        const [hhIngreso, mmIngreso] = horaIngreso.split(':').map(Number);
        const [hhSalida, mmSalida] = horaSalida.split(':').map(Number);

        const tiempoIngreso = hhIngreso * 60 + mmIngreso;
        const tiempoSalida = hhSalida * 60 + mmSalida;

        let diff = tiempoSalida - tiempoIngreso;
        if (diff < 0) {
            diff += 24 * 60;
        }

        const horas = Math.floor(diff / 60);
        const minutos = diff % 60;

        document.getElementById('horasEfectivas').value = `${horas}:${minutos < 10 ? '0' + minutos : minutos}`;
    } else {
        document.getElementById('horasEfectivas').value = '';
    }
}

// Asegúrate de que los eventos estén correctamente vinculados
document.getElementById("horaIngreso").addEventListener("change", calcularHorasEfectivas);
document.getElementById("horaSalida").addEventListener("change", calcularHorasEfectivas);

let semanaSeleccionada = 1;

function setSemanaSeleccionada(semana) {
    semanaSeleccionada = semana;
}

document.getElementById("addBtnWeek1").addEventListener("click", () => setSemanaSeleccionada(1));
document.getElementById("addBtnWeek2").addEventListener("click", () => setSemanaSeleccionada(2));
document.getElementById("addBtnWeek3").addEventListener("click", () => setSemanaSeleccionada(3));
document.getElementById("addBtnWeek4").addEventListener("click", () => setSemanaSeleccionada(4));

function agregarBitacora(semana, fecha, actividades, detalle, horaIngreso, horaSalida, horasEfectivas, fotos) {
    const container = document.querySelector(`#bitacoraTableWeek${semana} tbody`);
    const tr = document.createElement('tr');
    tr.innerHTML = `
        <td>${fecha}</td>
        <td>${actividades}</td>
        <td>${detalle}</td>
        <td>${horaIngreso}</td>
        <td>${horaSalida}</td>
        <td>${horasEfectivas}</td>
        <td>${fotos.map(foto => `<img src="${foto}" alt="Foto" class="img-thumbnail" style="width: 50px;">`).join('')}</td>
    `;
    container.appendChild(tr);
}

document.getElementById("guardarBtn").addEventListener("click", function() {
    // Verificar si ya hay 5 ingresos para la semana seleccionada
    const registrosExistentes = document.querySelectorAll(`#bitacoraTableWeek${semanaSeleccionada} tbody tr`).length;
    if (registrosExistentes >= 5) {
        Swal.fire({
            icon: 'error',
            title: 'Límite alcanzado',
            text: 'No se pueden agregar más de 5 registros por semana.',
        });
        return;
    }

    const fecha = document.getElementById("fecha").value;
    const actividades = document.getElementById("actividades").value;
    const detalle = document.getElementById("detalle").value;
    const horaIngreso = document.getElementById("horaIngreso").value;
    const horaSalida = document.getElementById("horaSalida").value;
    const horasEfectivas = document.getElementById("horasEfectivas").value;
    const fotosInput = document.getElementById("fotos");
    const fotos = [];

    if (!fecha || !actividades || !detalle || !horaIngreso || !horaSalida || !horasEfectivas) {
        Swal.fire({
            icon: 'error',
            title: 'Campos obligatorios',
            text: 'Todos los campos son requeridos.',
        });
        return;
    }

    if (fotosInput.files.length > 0) {
        const fotoPromises = Array.from(fotosInput.files).map(file => {
            return new Promise((resolve, reject) => {
                if (file.size > 2000000) {
                    alert("Las fotos deben ser menores a 2 MB.");
                    reject("Foto demasiado grande");
                }

                const reader = new FileReader();
                reader.onloadend = function() {
                    fotos.push(reader.result);
                    resolve();
                };
                reader.onerror = function() {
                    reject("Error al leer la foto");
                };
                reader.readAsDataURL(file);
            });
        });

        Promise.all(fotoPromises)
            .then(() => {
                const data = {
                    idSemana: semanaSeleccionada,
                    cedulaEstudiante: "0951886423",
                    fecha: fecha,
                    actividades: actividades,
                    detalle: detalle,
                    horaIngreso: horaIngreso,
                    horaSalida: horaSalida,
                    horasEfectivas: horasEfectivas,
                    fotos: fotos
                };

                fetch('ingreso/insertar_bitacora.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(data)
                    })
                    .then(response => response.json())
                    .then(result => {
                        if (result.status === 'success') {
                            agregarBitacora(semanaSeleccionada, fecha, actividades, detalle, horaIngreso, horaSalida, horasEfectivas, fotos);
                            $('#modalAgregar').modal('hide');
                            Swal.fire({
                                icon: 'success',
                                title: '¡Registro guardado exitosamente!',
                                showConfirmButton: false,
                                timer: 1500
                            }).then(() => {
                                limpiarFormulario();
                            });
                        } else {
                            alert("Error al guardar el registro");
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert("Error al guardar el registro");
                    });
            })
            .catch(error => {
                console.error('Error al procesar las fotos:', error);
            });
    } else {
        const data = {
            idSemana: semanaSeleccionada,
            cedulaEstudiante: "0951886423",
            fecha: fecha,
            actividades: actividades,
            detalle: detalle,
            horaIngreso: horaIngreso,
            horaSalida: horaSalida,
            horasEfectivas: horasEfectivas,
            fotos: fotos
        };

        fetch('ingreso/insertar_bitacora.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(data)
            })
            .then(response => response.json())
            .then(result => {
                if (result.status === 'success') {
                    agregarBitacora(semanaSeleccionada, fecha, actividades, detalle, horaIngreso, horaSalida, horasEfectivas, fotos);
                    $('#modalAgregar').modal('hide');
                    Swal.fire({
                        icon: 'success',
                        title: '¡Registro guardado exitosamente!',
                        showConfirmButton: false,
                        timer: 1500
                    }).then(() => {
                        limpiarFormulario();
                    });
                } else {
                    alert("Error al guardar el registro");
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert("Error al guardar el registro");
            });
    }
});
</script>
