<?php
session_start();
if (!isset($_SESSION['S_ID'])) {
  header('Location: ../index.php');
}

?>
<!DOCTYPE html>

<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>SYVI | Admin</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="../plantilla/plugins/fontawesome-free/css/all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../plantilla/dist/css/adminlte.min.css">
  <link rel="stylesheet" type="text/css" href="../utilitario/DataTables/datatables.min.css" />
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <link rel="shortcut icon" href="img/cara1.jpeg" type="image/jpeg" />
</head>

<body class="hold-transition sidebar-mini">
  <div class="wrapper">

    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
      <!-- Left navbar links -->
      <ul class="navbar-nav">
        <li class="nav-item">
          <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
        </li>

      </ul>

      <!-- Right navbar links -->
      <ul class="navbar-nav ml-auto">
        <!-- Notifications Dropdown Menu -->
        <!--
      <li class="nav-item dropdown">
        
        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
          <span class="dropdown-header">15 Notifications</span>
          <div class="dropdown-divider"></div>
          <a href="#" class="dropdown-item">
            <i class="fas fa-envelope mr-2"></i> 4 new messages
            <span class="float-right text-muted text-sm">3 mins</span>
          </a>
          <div class="dropdown-divider"></div>
          <a href="#" class="dropdown-item">
            <i class="fas fa-users mr-2"></i> 8 friend requests
            <span class="float-right text-muted text-sm">12 hours</span>
          </a>
          <div class="dropdown-divider"></div>
          <a href="#" class="dropdown-item">
            <i class="fas fa-file mr-2"></i> 3 new reports
            <span class="float-right text-muted text-sm">2 days</span>
          </a>
          <div class="dropdown-divider"></div>
          <a href="#" class="dropdown-item dropdown-footer">See All Notifications</a>
        </div>
      </li>-->
        <!-- Notifications Dropdown Menu -->
        <li class="nav-item dropdown">
          <a class="nav-link" data-toggle="dropdown" href="#">
            <?php echo $_SESSION['S_USU']  ?>
            <i class="fas fa-caret-down"></i>
          </a>
          <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
            <a href="../controller/usuario/controlador_cerrar_sesion.php" class="dropdown-item">
              <i class="fas fa-file mr-2"></i> Cerrar Sesion
            </a>
        </li>
      </ul>
    </nav>
    <!-- /.navbar -->

    <!-- Main Sidebar Container -->
    <aside class="main-sidebar elevation-4" style="background-color:#21376D;font-weight:bold">
      <!-- Brand Logo -->
      <a class="brand-link">
        <img src="img/cara2.png" alt="AdminLTE Logo" class="brand-image elevation-3" style="opacity: .8">
        <span class="brand-text text-white fw-bold">TITULACIÓN</span>
      </a>

      <!-- Sidebar -->
      <div class="sidebar">
        <!-- Sidebar user panel (optional) -->
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
          <!-- <div class="image">
          <img src="../plantilla/dist/img/user2-160x160.jpg" class="img-circle elevation-2" alt="User Image">
        </div>-->
          <div class="info">
            <a href="" class="d-block"></a>
          </div>
        </div>

        <!-- SidebarSearch Form -->
        <div class="form-inline">

        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
          <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">

            <?php if ($_SESSION['S_ROL'] == 'Administrador') { ?>
              <li class="nav-item" style="cursor: pointer;">
                <a onclick="cargar_contenido('contenido_principal','tramite/view_tramite.php')" class="nav-link text-white">
                  <i class="nav-icon fas fa-file-signature"></i>
                  <p>
                    Tramite
                  </p>
                </a>
              </li>
              <li class="nav-item" style="cursor: pointer;">
                <a onclick="cargar_contenido('contenido_principal','usuario/view_usuario.php')" class="nav-link text-white">
                  <i class="nav-icon fas fa-users"></i>
                  <p>
                    Usuarios
                  </p>
                </a>
              </li>
              <li class="nav-item" style="cursor: pointer;">
                <a onclick="cargar_contenido('contenido_principal','empleado/view_empleado.php')" class="nav-link text-white">
                  <i class="nav-icon fas fa-address-card"></i>
                  <p>
                    Empleado
                  </p>
                </a>
              </li>
              <li class="nav-item" style="cursor: pointer;">
                <a onclick="cargar_contenido('contenido_principal','area/view_area.php')" class="nav-link text-white">
                  <i class="nav-icon fas fa-th"></i>
                  <p>
                    Area
                  </p>
                </a>
              </li>
              <li class="nav-item" style="cursor: pointer;">
                <a onclick="cargar_contenido('contenido_principal','tipo_documento/view_tipodocumento.php')" class="nav-link text-white">
                  <i class="nav-icon fas fa-archive"></i>
                  <p>
                    Tipo Documento
                  </p>
                </a>
              </li>
              <li class="nav-item" style="cursor: pointer;">
                <a onclick="cargar_contenido('contenido_principal','solicitud/view_solicitud_todo.php')" class="nav-link text-white">
                  <i class="nav-icon fas fa-archive"></i>
                  <p>
                    Solicitudes
                  </p>
                </a>
              </li>
            <?php
            }
            ?>
            <?php if ($_SESSION['S_ROL'] == 'Secretario (a)' || $_SESSION['S_ROL'] == 'Usuario') { ?>
              <li class="nav-item" style="cursor: pointer;">
                <a onclick="cargar_contenido('contenido_principal','tramite_area/view_tramite.php')" class="nav-link text-white">
                  <i class="nav-icon fas fa-file-signature"></i>
                  <p>
                    Matriculacion
                  </p>
                </a>
              </li>
            <?php
            }
            ?>
            <?php if ($_SESSION['S_ROL'] == 'Estudiante') { ?>
              <li class="nav-item" style="cursor: pointer;">
                <a class="nav-link text-white">
                  <i class="nav-icon fa fa-home"></i>
                  <p>
                    Inicio
                  </p>
                </a>
              </li>
              <li class="nav-item">
                <a href="#" class="nav-link text-white">
                  <i class="nav-icon fa fa-list-alt"></i>
                  <p>
                    Matriculacion
                    <i class="fas fa-angle-left right"></i> <!-- Icono de submenú -->
                  </p>
                </a>
                <ul class="nav nav-treeview">
                <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'solicitud/view_solicitud.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Solicitud</p>
                    </a>
                  </li>
                  <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'solicitud/view_solicitud_registro.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Ver Solicitud</p>
                    </a>
                  </li>
                  <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'solicitud/view_institucion_registro.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Matricula</p>
                    </a>
                  </li>
                </ul>
              </li>
              <li class="nav-item">
                <a href="#" class="nav-link text-white">
                  <i class="nav-icon fa fa-book"></i>
                  <p>
                  Trabajo de Titulación
                    <i class="fas fa-angle-left right"></i> <!-- Icono de submenú -->
                  </p>
                </a>
                <ul class="nav nav-treeview">
                <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'solicitud/view_solicitud.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Ver Solicitud</p>
                    </a>
                  </li>
                  <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'solicitud/view_solicitud_registro.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Solicitud de inicio de Prácticas Profesionales</p>
                    </a>
                  </li>
                  <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'solicitud/view_institucion_registro.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Registro de Institución Receptora</p>
                    </a>
                  </li>
                </ul>
              </li>
              <li class="nav-item">
                <a href="#" class="nav-link text-white">
                  <i class="nav-icon fa fa-check-square"></i>
                  <p>
                    Asistencia de Tutorias
                    <i class="fas fa-angle-left right"></i> <!-- Icono de submenú -->
                  </p>
                </a>
                <ul class="nav nav-treeview">
                <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'solicitud/view_solicitud.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Ver Solicitud</p>
                    </a>
                  </li>
                  <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'solicitud/view_solicitud_registro.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Solicitud de inicio de Prácticas Profesionales</p>
                    </a>
                  </li>
                  <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'solicitud/view_institucion_registro.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Registro de Institución Receptora</p>
                    </a>
                  </li>
                </ul>
              </li>

              <li class="nav-item">
                <a href="#" class="nav-link text-white">
                  <i class="nav-icon fa fa-search"></i>
                  <p>
                    Consulta
                    <i class="fas fa-angle-left right"></i> <!-- Icono de submenú -->
                  </p>
                </a>
                <ul class="nav nav-treeview">
                  <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'bitacora/view_bitacora_registrar.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Registro de Bitacoras de actividades</p>
                    </a>
                  </li>
                </ul>
              </li>

            <?php
            }
            ?>
             <?php if ($_SESSION['S_ROL'] == 'Coordinador (a)') { ?>
              <li class="nav-item">
                <a href="#" class="nav-link text-white">
                  <i class="nav-icon fas fa-file"></i>
                  <p>
                    Solicitudes
                    <i class="fas fa-angle-left right"></i> <!-- Icono de submenú -->
                  </p>
                </a>
                <ul class="nav nav-treeview">
                <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'solicitud/view_solicitud_todo.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Ver Solicitud</p>
                    </a>
                  </li>
                </ul>
              </li>

              <li class="nav-item">
                <a href="#" class="nav-link text-white">
                  <i class="nav-icon fas fa-file"></i>
                  <p>
                    Practicas
                    <i class="fas fa-angle-left right"></i> <!-- Icono de submenú -->
                  </p>
                </a>
                <ul class="nav nav-treeview">
                  <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'bitacora/view_bitacora_tutor.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Consultar Bitacora</p>
                    </a>
                  </li>
                  <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'bitacora/view_bitacora_print.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Imprimir Bitacora</p>
                    </a>
                  </li>
                </ul>
              </li>

              <li class="nav-item">
                <a href="#" class="nav-link text-white">
                  <i class="nav-icon fas fa-file"></i>
                  <p>
                    Tramites
                    <i class="fas fa-angle-left right"></i> 
                  </p>
                </a>
                <ul class="nav nav-treeview">
                <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'docentes/view_solicitud_todo.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Designación de Tutor</p>
                    </a>
                  </li>
                </ul>
              </li>

            <?php
            }
            ?>
              <?php if ($_SESSION['S_ROL'] == 'Tutor') { ?>
              <li class="nav-item">
                <a href="#" class="nav-link text-white">
                  <i class="nav-icon fas fa-file"></i>
                  <p>
                    Solicitudes
                    <i class="fas fa-angle-left right"></i> 
                  </p>
                </a>
                <ul class="nav nav-treeview">
                <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'solicitud/view_solicitud_todo.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Ver Solicitud</p>
                    </a>
                  </li>
                </ul>
              </li>

              <li class="nav-item">
                <a href="#" class="nav-link text-white">
                  <i class="nav-icon fas fa-file"></i>
                  <p>
                    Practicas
                    <i class="fas fa-angle-left right"></i> <!-- Icono de submenú -->
                  </p>
                </a>
                <ul class="nav nav-treeview">
                  <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'bitacora/view_bitacora_tutor.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Consultar Bitacora</p>
                    </a>
                  </li>
                  <li class="nav-item" style="cursor: pointer;">
                    <a onclick="cargar_contenido('contenido_principal', 'bitacora/view_bitacora_print.php')" class="nav-link">
                      <i class="fas fa-angle-right nav-icon"></i>
                      <p>Imprimir Bitacora</p>
                    </a>
                  </li>
                </ul>
              </li>

            <?php
            }
            ?>
          </ul>
        </nav>
        <!-- /.sidebar-menu -->
      </div>
      <!-- /.sidebar -->
    </aside>

    <!-- Content Wrapper. Contains page content -->
    <input type="text" id="txtprincipalid" value="<?php echo $_SESSION['S_ID']; ?>" hidden>
    <input type="text" id="txtprincipalusu" value="<?php echo $_SESSION['S_USU']; ?>" hidden>
    <input type="text" id="txtprincipalrol" value="<?php echo $_SESSION['S_ROL']; ?>" hidden>
    <div class="content-wrapper" id="contenido_principal">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h1 class="m-0">INICIO</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="../">Inicio</a></li>
                <li class="breadcrumb-item active">Portada</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
      <div class="content">
        <div class="container-fluid">
          <div class="row">
            <?php if ($_SESSION['S_ROL'] == 'Administrador') { ?>
              <div class="col-lg-3 col-6">
                <!-- small card -->
                <div class="small-box bg-teal">
                  <div class="inner">
                    <h3 id="lbl_tramite">0</h3>

                    <p>TRAMITES REGISTRADOS</p>
                  </div>
                  <div class="icon">
                    <i class="ion ion-stats-bars"></i>
                  </div>
                  <a onclick="cargar_contenido('contenido_principal','tramite/view_tramite.php')" class="small-box-footer">
                    Ver Tramites <i class="fas fa-arrow-circle-right"></i>
                  </a>
                </div>
              </div>
              <div class="col-lg-3 col-6">
                <!-- small card -->
                <div class="small-box bg-purple">
                  <div class="inner">
                    <h3 id="lbl_tramite_finalizado">0</h3>

                    <p>TRAMITES FINALIZADOS</p>
                  </div>
                  <div class="icon">
                    <i class="ion ion-stats-bars"></i>
                  </div>
                  <a onclick="cargar_contenido('contenido_principal','tramite/view_tramite.php')" class="small-box-footer">
                    Ver Tramites <i class="fas fa-arrow-circle-right"></i>
                  </a>
                </div>
              </div>
            <?php
            }
            ?>
          </div>
          <!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
      <div class="p-3">
        <h5>Title</h5>
        <p>Sidebar content</p>
      </div>
    </aside>
    <!-- /.control-sidebar -->

    <!-- Main Footer -->
    <footer class="main-footer">
      <!-- To the right -->
      <div class="float-right d-none d-sm-inline">

      </div>
      <!-- Default to the left -->
      <strong>Copyright &copy; 2024 <a href="https://itred.edu.ec">ITRED.COM</a>.</strong> All rights reserved.
    </footer>
  </div>
  <!-- ./wrapper -->

  <!-- REQUIRED SCRIPTS -->
  <script>
   function cargar_contenido(id, vista) {
  $("#" + id).load(vista, function(response, status, xhr) {
    if (status == "error") {
      var msg = "Error: " + xhr.status + " " + xhr.statusText;
      alert(msg);
    }
  });
}


    var idioma_espanol = {
      select: {
        rows: "%d fila seleccionada"
      },
      "sProcessing": "Procesando...",
      "sLengthMenu": "Mostrar _MENU_ registros",
      "sZeroRecords": "No se encontraron resultados",
      "sEmptyTable": "Ning&uacute;n dato disponible en esta tabla",
      "sInfo": "Registros del (_START_ al _END_) total de _TOTAL_ registros",
      "sInfoEmpty": "Registros del (0 al 0) total de 0 registros",
      "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
      "sInfoPostFix": "",
      "sSearch": "Buscar:",
      "sUrl": "",
      "sInfoThousands": ",",
      "sLoadingRecords": "<b>No se encontraron datos</b>",
      "oPaginate": {
        "sFirst": "Primero",
        "sLast": "Último",
        "sNext": "Siguiente",
        "sPrevious": "Anterior"
      },
      "oAria": {
        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
      }
    }

    function soloNumeros(e) {
      tecla = (document.all) ? e.keyCode : e.which;
      if (tecla == 8) {
        return true;
      }
      // Patron de entrada, en este caso solo acepta numeros
      patron = /[0-9]/;
      tecla_final = String.fromCharCode(tecla);
      return patron.test(tecla_final);
    }

    function soloLetras(e) {
      key = e.keyCode || e.which;
      tecla = String.fromCharCode(key).toLowerCase();
      letras = " áéíóúabcdefghijklmnñopqrstuvwxyz";
      especiales = "8-37-39-46";
      tecla_especial = false
      for (var i in especiales) {
        if (key == especiales[i]) {
          tecla_especial = true;
          break;
        }
      }
      if (letras.indexOf(tecla) == -1 && !tecla_especial) {
        return false;
      }
    }

    function filterFloat(evt, input) {
      var key = window.Event ? evt.which : evt.keyCode;
      var chark = String.fromCharCode(key);
      var tempValue = input.value + chark;
      if (key >= 48 && key <= 57) {
        if (filter(tempValue) === false) {
          return false;
        } else {
          return true;
        }
      } else {
        if (key == 8 || key == 13 || key == 0) {
          return true;
        } else if (key == 46) {
          if (filter(tempValue) === false) {
            return false;
          } else {
            return true;
          }
        } else {
          return false;
        }
      }
    }

    function filter(__val__) {
      var preg = /^([0-9]+\.?[0-9]{0,2})$/;
      if (preg.test(__val__) === true) {
        return true;
      } else {
        return false;
      }
    }
  </script>
  <!-- jQuery -->
  <script src="../plantilla/plugins/jquery/jquery.min.js"></script>
  <!-- Bootstrap 4 -->
  <script src="../plantilla/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

  <script src="../plantilla/dist/js/adminlte.min.js"></script>
  <script type="text/javascript" src="../utilitario/DataTables/datatables.min.js"></script>
  <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <script type="text/javascript" src="../js/console_webapi.js"></script>
  <script>
    obtener_tokens();
    <?php if ($_SESSION['S_ROL'] == 'Administrador') { ?>
      Traer_Widget();

      function Traer_Widget() {
        $.ajax({
          "url": "../controller/usuario/controlador_traer_widget.php",
          type: 'POST'
        }).done(function(resp) {

          let data = JSON.parse(resp);
          if (data.length > 0) {
            document.getElementById('lbl_tramite').innerHTML = data[0][0];
            document.getElementById('lbl_tramite_finalizado').innerHTML = data[0][1];
          }
        })
      }
    <?php
    }
    ?>
  </script>

</body>

</html>