<?php
// Agregar más imágenes con diferentes temas y categorías
$imagenes = [
    ['ruta_imagen' => 'view/img/cara1.jpeg', 'descripcion' => 'Descripción 1', 'fecha_ingreso' => '2022-01-01', 'tema' => 'Naturaleza', 'categoria' => 'Multitrabajo'],
    ['ruta_imagen' => 'view/img/cara1.jpeg', 'descripcion' => 'Descripción 2', 'fecha_ingreso' => '2021-05-15', 'tema' => 'Tecnología', 'categoria' => 'Computrabajo'],
    ['ruta_imagen' => 'view/img/cara1.jpeg', 'descripcion' => 'Descripción 3', 'fecha_ingreso' => '2020-07-20', 'tema' => 'Arte', 'categoria' => 'Otros'],
    ['ruta_imagen' => 'imagen4.jpg', 'descripcion' => 'Descripción 4', 'fecha_ingreso' => '2022-03-10', 'tema' => 'Naturaleza', 'categoria' => 'Multitrabajo'],
    ['ruta_imagen' => 'imagen5.jpg', 'descripcion' => 'Descripción 5', 'fecha_ingreso' => '2021-11-25', 'tema' => 'Tecnología', 'categoria' => 'Computrabajo'],
    // Agrega más imágenes según sea necesario
];

// Procesar el formulario de búsqueda
$year = isset($_POST['year']) ? $_POST['year'] : '';

// Filtrar las imágenes según el año
$resultados = array_filter($imagenes, function($imagen) use ($year) {
    return empty($year) || strpos($imagen['fecha_ingreso'], $year) === 0;
});

// Separar las imágenes por categorías
$categorias = ['Multitrabajo' => [], 'Computrabajo' => [], 'Otros' => []];
foreach ($resultados as $imagen) {
    $categorias[$imagen['categoria']][] = $imagen;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buscar Imágenes</title>
    <style>
        /* Estilos generales */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f7fc;
            color: #333;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px;
        }
        h1 {
            text-align: center;
            color: #007BFF;
            margin-bottom: 20px;
            font-size: 2em;
        }
        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
            font-size: 1.5em;
        }

        /* Estilos del formulario */
        form {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 20px;
            margin-bottom: 30px;
        }
        form label {
            font-weight: bold;
            width: 100%;
            text-align: center;
        }
        form input[type="text"] {
            padding: 10px;
            width: 250px;
            font-size: 1em;
            border: 1px solid #ccc;
            border-radius: 5px;
            transition: border 0.3s ease;
        }
        form input[type="text"]:focus {
            border: 1px solid #007BFF;
            outline: none;
        }
        form input[type="submit"] {
            padding: 10px 20px;
            background-color: #007BFF;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 1.1em;
        }
        form input[type="submit"]:hover {
            background-color: #0056b3;
        }

        /* Estilos de resultados */
        .categoria {
            margin-bottom: 30px;
        }
        .categoria h3 {
            text-align: center;
            color: #007BFF;
            margin-bottom: 20px;
            font-size: 1.5em;
        }

        /* Estilo de las tarjetas (cards) */
        .resultados {
            display: flex;
            flex-wrap: wrap; /* Las tarjetas se colocan una debajo de otra si es necesario */
            gap: 20px;
            justify-content: center;
        }

        .resultados div {
            flex: 0 0 auto; /* Mantener un tamaño fijo para las tarjetas */
            width: 300px;
            border: 1px solid #ddd;
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            background-color: white;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .resultados div:hover {
            transform: translateY(-5px);
            box-shadow: 0px 6px 12px rgba(0, 0, 0, 0.2);
        }

        /* Imagen dentro de la tarjeta */
        .resultados img {
            max-width: 100%;
            height: auto;
            object-fit: cover;
            border-radius: 8px;
            margin-bottom: 15px;
        }

        /* Descripción de la tarjeta */
        .resultados p {
            font-size: 1em;
            color: #666;
            margin-top: 10px;
        }

        /* Responsividad */
        @media (max-width: 1024px) {
            .resultados div {
                width: 250px; /* Menor tamaño para tablets */
            }
        }

        @media (max-width: 768px) {
            .resultados div {
                width: 200px; /* Aún menor tamaño para pantallas más pequeñas */
            }
        }

        @media (max-width: 480px) {
            .resultados div {
                width: 100%; /* Las tarjetas ocupan todo el ancho en pantallas muy pequeñas */
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Buscar Imágenes</h1>
        <form method="post" action="">
            <label for="year">Año o Mes (YYYY o YYYY-MM):</label>
            <input type="text" id="year" name="year" value="<?php echo htmlspecialchars($year); ?>" placeholder="Ejemplo: 2022 o 2022-01">
            <input type="submit" value="Buscar">
        </form>

        <h2>Resultados de la búsqueda</h2>

        <!-- Mostrar resultados por categorías -->
        <?php foreach ($categorias as $categoria => $imagenes_categoria): ?>
            <?php if (!empty($imagenes_categoria)): ?>
                <div class="categoria">
                    <h3><?php echo htmlspecialchars($categoria); ?></h3>
                    <div class="resultados">
                        <?php foreach ($imagenes_categoria as $imagen): ?>
                            <div>
                                <img src="<?php echo htmlspecialchars($imagen['ruta_imagen']); ?>" alt="<?php echo htmlspecialchars($imagen['descripcion']); ?>">
                                <p><?php echo htmlspecialchars($imagen['descripcion']); ?> <br> <strong>Fecha:</strong> <?php echo htmlspecialchars($imagen['fecha_ingreso']); ?> <br> <strong>Tema:</strong> <?php echo htmlspecialchars($imagen['tema']); ?></p>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
</body>
</html>
