<?php
session_start();
if (isset($_SESSION['S_ID'])) {
  header('Location: view/index.php');
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>PRACTICAS-ISTRED | Login</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <!-- AdminLTE CSS -->
  <link href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css" rel="stylesheet">
  <style>
    /* Estilos generales */
    body {
      background: #f2f2f2;
      font-family: 'Poppins', sans-serif;
      margin: 0;
      padding: 0;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      overflow: hidden;
    }

    /* Contenedor del login */
    .login-container {
      display: flex;
      width: 90%;
      max-width: 900px;
      background: #fff;
      border-radius: 20px;
      box-shadow: 0 15px 30px rgba(0, 0, 0, 0.15);
      overflow: hidden;
    }

    /* Lado derecho (antes estaba a la izquierda) */
    .login-left {
      flex: 1;
      background: #21376D;
      padding: 30px;
      color: #fff;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
    }

    .login-left img {
      width: 100%;
      max-width: 500px;
      margin-bottom: -20px;
    }

    .login-left p {
      font-size: 16px;
      text-align: center;
    }

    /* Lado izquierdo (antes estaba a la derecha) */
    .login-right {
      flex: 1;
      padding: 40px;
      display: flex;
      flex-direction: column;
      justify-content: center;
    }

    /* Campos de entrada */
    .input-group {
      margin-bottom: 20px;
    }

    .input-group-text {
      background-color: #e8f0fe;
      border: none;
      border-radius: 10px 0 0 10px;
      font-size: 18px;
      padding: 4px 10px;
      width: 50px;
      text-align: center;
      justify-content: center;
      margin-left: 55px;
    }

    .form-control {
      border-radius: 0 10px 10px 0 !important;
      background-color: #e8f0fe;
      padding: 15px;
      font-size: 15px;
      transition: border-color 0.3s ease, box-shadow 0.3s ease;
      width: 100%;
      border: none;
      margin: 0 55px 0 0 !important;
    }

    .form-control:focus {
      border-color: #3B82F6;
      box-shadow: 0 0 10px rgba(59, 130, 246, 0.3);
    }

    /* Botón de inicio de sesión */
    .btn-primary {
      background-color: #21376D;
      border: none;
      padding: 8px;
      font-size: 16px;
      border-radius: 10px;
      width: 70%;
      transition: background-color 0.3s ease, transform 0.3s ease;
    }
    header{
      display: none;
    }

    .btn-primary:hover {
      background-color: #2563EB;
      transform: translateY(-2px);
    }

    /* Checkbox "Recordar Datos" */
    .icheck-primary {
      display: flex;
      align-items: center;
      margin: 2px 2px 12px 60px
    }

    .icheck-primary input[type="checkbox"] {
      margin-right: 10px;
    }

    #remember {
      margin-bottom: 10px !important;
      font-weight: normal !important;
    }

    .footer-text {
      margin-top: 20px;
      font-size: 14px;
      color: #6B7280;
      text-align: center;
    }

    .texto {
      text-align: center;
    }

    /* Responsive */
    /* Responsive */
    @media (max-width: 768px) {
  .login-container {
    flex-direction: column; /* Apila los elementos verticalmente */
  }

  .login-left {
    order: -1; /* Mueve el login-left al principio */

    header{
      display: block;
    }
    
  }
  .login-left img {
      width: 75%;
      max-width: 400px;
      margin-bottom: -10%;
    }

  .login-right {
    padding: 40px;
  }
}
  </style>
</head>
<header>
  <img src="view/img/header.png" alt="Logo" class="img-fluid" />
</header>

<body>
  <!-- Contenedor del login -->
  <div class="login-container">
    <!-- Lado derecho (antes estaba a la izquierda) -->
    <div class="login-right">
      <h3 class="text-center font-weight-bold mb-4">INICIO DE SESION</h3>
      <span class="texto d-block mb-4">Ingrese sus credenciales</span>
      <!-- Campo de usuario -->
      <div class="input-group mb-4">
        <span class="input-group-text">
          <i class="bi bi-person"></i>
        </span>
        <input type="text" class="form-control" placeholder="Username" aria-label="Username" id="txt_usuario">
      </div>

      <div class="input-group mb-4">
        <span class="input-group-text">
          <i class="bi bi-shield-lock"></i>
        </span>
        <input type="password" class="form-control" placeholder="Password" aria-label="Password" id="txt_contra">
      </div>

      <div class="row">
        <div class="col-8">
          <div class="icheck-primary">
            <input type="checkbox" id="remember">
            <label class="font-weight-normal" for="remember">Recordar Datos</label>
          </div>
        </div>

        <!-- Contenedor con d-flex y flex-column para organizar el contenido verticalmente -->
        <div class="container d-flex flex-column align-items-center my-1">
          <div class="col-6 text-center">
            <button type="submit" class="btn btn-primary" onclick="Iniciar_Sesion()">Iniciar</button>
          </div>
        </div>
      </div>
      <p class="footer-text">&copy; 2025 <span class="font-weight-bold">ISTRED</span>. Todos los derechos reservados.</p>

    </div>

    <!-- Lado izquierdo (antes estaba a la derecha) -->
    <div class="login-left">
      <img src="view/img/Recurso 5.png" alt="Logo" class="img-fluid" />
    </div>
  </div>

  <!-- Scripts -->
  <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
  <script src="js/console_usuario.js?rev=<?php echo time(); ?>"></script>
  <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script>
    // Recordar datos de usuario
    const rmcheck = document.getElementById('remember'),
      usuarioInput = document.getElementById('txt_usuario'),
      passInput = document.getElementById('txt_contra');
    if (localStorage.checkbox && localStorage.checkbox != "") {
      rmcheck.setAttribute("checked", "checked");
      usuarioInput.value = localStorage.usuario;
      passInput.value = localStorage.pass;
    } else {
      rmcheck.removeAttribute("checked");
      usuarioInput.value = "";
      passInput.value = "";
    }
  </script>
</body>

</html>